/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.xml.XMLDocReader;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.MakeProjectConfigurationProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.configurations.AuxConfigurationXMLCodec;
import org.netbeans.modules.cnd.makeproject.configurations.ConfigurationXMLCodec;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.xml.sax.Attributes;

public class ConfigurationXMLReader
extends XMLDocReader {
    private static int DEPRECATED_VERSIONS = 26;
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.cnd.makeproject");
    private final FileObject projectDirectory;
    private final Project project;
    private static final RequestProcessor REQUEST_PROCESSOR = new RequestProcessor("ConfigurationXMLReader", 10);

    public ConfigurationXMLReader(Project project, FileObject projectDirectory) {
        this.project = project;
        this.projectDirectory = projectDirectory;
    }

    public MakeConfigurationDescriptor read(final String relativeOffset) throws IOException {
        FileObject configurationBaseFO;
        FileObject xml;
        String tag;
        FileObject fo = this.projectDirectory.getFileObject("nbproject/configurations.xml");
        if (fo == null) {
            tag = "projectDescriptor";
            xml = this.projectDirectory.getFileObject("nbproject/projectDescriptor.xml");
        } else {
            tag = "configurationDescriptor";
            xml = fo;
        }
        if (xml == null) {
            this.displayErrorDialog();
            return null;
        }
        FileObject fileObject = configurationBaseFO = this.project == null ? this.projectDirectory : RemoteFileUtil.getProjectSourceBaseFileObject((Project)this.project);
        if (configurationBaseFO == null) {
            throw new FileNotFoundException("File does not exist");
        }
        final MakeConfigurationDescriptor configurationDescriptor = new MakeConfigurationDescriptor(this.projectDirectory, configurationBaseFO);
        RequestProcessor.Task task = REQUEST_PROCESSOR.post((Runnable)new NamedRunnable("Reading project configuraion"){

            protected void runImpl() {
                try {
                    if (MakeProjectConfigurationProvider.ASYNC_LOAD) {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace(System.err);
                        }
                    }
                    if (ConfigurationXMLReader.this._read(relativeOffset, tag, xml, configurationDescriptor) == null) {
                        configurationDescriptor.setState(ConfigurationDescriptor.State.BROKEN);
                    }
                }
                catch (IOException ex) {
                    configurationDescriptor.setState(ConfigurationDescriptor.State.BROKEN);
                }
            }
        });
        configurationDescriptor.setInitTask(task);
        return configurationDescriptor;
    }

    private ConfigurationDescriptor _read(String relativeOffset, String tag, FileObject xml, final MakeConfigurationDescriptor configurationDescriptor) throws IOException {
        int activeIndex;
        ConfigurationXMLCodec decoder = new ConfigurationXMLCodec(tag, this.projectDirectory, configurationDescriptor, relativeOffset);
        this.registerXMLDecoder(decoder);
        InputStream inputStream = xml.getInputStream();
        boolean success = this.read(inputStream, xml.getPath());
        this.deregisterXMLDecoder(decoder);
        if (!success) {
            this.displayErrorDialog();
            return null;
        }
        xml = this.projectDirectory.getFileObject("nbproject/private/configurations.xml");
        if (xml != null) {
            AuxConfigurationXMLCodec auxDecoder = new AuxConfigurationXMLCodec(tag, configurationDescriptor);
            this.registerXMLDecoder(auxDecoder);
            inputStream = xml.getInputStream();
            success = this.read(inputStream, this.projectDirectory.getName());
            this.deregisterXMLDecoder(auxDecoder);
            if (!success) {
                return null;
            }
        }
        if (this.project != null && (activeIndex = ((MakeProject)this.project).getActiveConfigurationIndexFromPrivateXML()) >= 0) {
            configurationDescriptor.getConfs().setActive(activeIndex);
        }
        Item[] projectItems = configurationDescriptor.getProjectItems();
        for (Configuration configuration : configurationDescriptor.getConfs().getConfigurations()) {
            for (Item item : projectItems) {
                if (item.getItemConfiguration(configuration) != null) continue;
                configuration.addAuxObject(new ItemConfiguration(configuration, item));
            }
        }
        this.attachListeners(configurationDescriptor);
        configurationDescriptor.setState(ConfigurationDescriptor.State.READY);
        boolean isMakefileProject = false;
        for (Configuration configuration : configurationDescriptor.getConfs().getConfigurations()) {
            MakeConfiguration makeConfiguration = (MakeConfiguration)configuration;
            if (!makeConfiguration.isMakefileConfiguration()) continue;
            isMakefileProject = true;
            break;
        }
        FileObject makeImpl = this.projectDirectory.getFileObject("nbproject/Makefile-impl.mk");
        configurationDescriptor.setModified(!isMakefileProject && makeImpl == null || relativeOffset != null);
        if (configurationDescriptor.getVersion() >= 0 && configurationDescriptor.getVersion() <= DEPRECATED_VERSIONS) {
            final String message = NbBundle.getMessage(ConfigurationXMLReader.class, (String)"OLD_VERSION_WARNING", (Object)this.projectDirectory.getPath());
            Runnable warning = new Runnable(){

                @Override
                public void run() {
                    NotifyDescriptor nd = new NotifyDescriptor((Object)message, NbBundle.getMessage(ConfigurationXMLReader.class, (String)"CONVERT_DIALOG_TITLE"), 0, 3, null, NotifyDescriptor.YES_OPTION);
                    Object ret = DialogDisplayer.getDefault().notify(nd);
                    if (ret == NotifyDescriptor.YES_OPTION) {
                        configurationDescriptor.setModified();
                    }
                }
            };
            SwingUtilities.invokeLater(warning);
        }
        if (configurationDescriptor.isModified()) {
            configurationDescriptor.setVersion(79);
        }
        ConfigurationDescriptorProvider.recordMetrics("USG_PROJECT_OPEN_CND", configurationDescriptor);
        return configurationDescriptor;
    }

    private void displayErrorDialog() {
    }

    private void attachListeners(final MakeConfigurationDescriptor configurationDescriptor) {
        RequestProcessor.Task task = REQUEST_PROCESSOR.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long time = System.currentTimeMillis();
                LOGGER.log(Level.FINE, "Start attach folder listeners");
                String oldName = Thread.currentThread().getName();
                try {
                    Thread.currentThread().setName("Attach listeners to all disk folders");
                    List<Folder> firstLevelFolders = configurationDescriptor.getLogicalFolders().getFolders();
                    for (Folder f : firstLevelFolders) {
                        if (!f.isDiskFolder()) continue;
                        f.refreshDiskFolder(true);
                        f.attachListeners();
                    }
                    LOGGER.log(Level.FINE, "End attach folder listeners, time {0}ms.", System.currentTimeMillis() - time);
                }
                finally {
                    Thread.currentThread().setName(oldName);
                }
            }
        });
    }

    protected String tag() {
        return null;
    }

    public void start(Attributes atts) {
    }

    public void end() {
    }

    public void startElement(String name, Attributes atts) {
    }

    public void endElement(String name, String currentText) {
    }
}

