/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.actions;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.ui.actions.Bundle;
import org.netbeans.modules.hudson.ui.actions.Hyperlinker;
import org.openide.awt.HtmlBrowser;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ShowFailures
extends AbstractAction
implements Runnable {
    private static final Logger LOG = Logger.getLogger(ShowFailures.class.getName());
    private final HudsonJob job;
    private final String url;
    private final String displayName;

    public ShowFailures(HudsonJobBuild build) {
        this(build.getJob(), build.getUrl(), build.getDisplayName());
    }

    public ShowFailures(HudsonMavenModuleBuild module) {
        this(module.getBuild().getJob(), module.getUrl(), module.getBuildDisplayName());
    }

    private ShowFailures(HudsonJob job, String url, String displayName) {
        this.job = job;
        this.url = url;
        this.displayName = displayName;
        this.putValue("Name", Bundle.ShowFailures_label());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new RequestProcessor(this.url + "testReport").post((Runnable)this);
    }

    @Override
    public void run() {
        try {
            XMLReader parser = XMLUtil.createXMLReader();
            parser.setContentHandler(new DefaultHandler(){
                InputOutput io;
                StringBuilder buf;
                Hyperlinker hyperlinker;
                Stack<Suite> suites;
                boolean firstLine;
                {
                    this.hyperlinker = new Hyperlinker(ShowFailures.this.job);
                    this.suites = new Stack();
                    this.firstLine = true;
                }

                private void prepareOutput() {
                    if (this.io == null) {
                        String title = Bundle.ShowFailures_title(ShowFailures.this.displayName);
                        this.io = IOProvider.getDefault().getIO(title, new Action[0]);
                        this.io.select();
                    }
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (qName.matches("errorStackTrace|stdout|stderr|name|className")) {
                        this.buf = new StringBuilder();
                    } else if (qName.equals("suite")) {
                        this.suites.push(new Suite());
                    } else if (qName.equals("case") && !this.suites.empty()) {
                        this.suites.peek().cases.push(new Case());
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this.buf != null) {
                        this.buf.append(ch, start, length);
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (this.suites.empty()) {
                        return;
                    }
                    Suite s = this.suites.peek();
                    String text = this.buf != null && this.buf.length() > 0 ? this.buf.toString() : null;
                    this.buf = null;
                    if (s.cases.empty()) {
                        if (qName.equals("stdout")) {
                            s.stdout = text;
                        } else if (qName.equals("stderr")) {
                            s.stderr = text;
                        } else if (qName.equals("name")) {
                            s.name = text;
                        }
                    } else {
                        Case c = s.cases.peek();
                        if (qName.equals("errorStackTrace")) {
                            c.errorStackTrace = text;
                        } else if (qName.equals("name")) {
                            c.name = text;
                        } else if (qName.equals("className")) {
                            c.className = text;
                        }
                    }
                    if (qName.equals("suite")) {
                        try {
                            this.show(s);
                        }
                        catch (IOException x) {
                            LOG.log(Level.FINE, null, x);
                        }
                        this.suites.pop();
                    } else if (qName.equals("case")) {
                        s.casesDone.add(s.cases.pop());
                    }
                }

                void show(Suite s) throws IOException {
                    this.prepareOutput();
                    OutputWriter out = this.io.getOut();
                    OutputWriter err = this.io.getErr();
                    for (final Case c : s.casesDone) {
                        if (c.errorStackTrace == null) continue;
                        String name = c.className + "." + c.name;
                        if (s.name != null && !s.name.equals(c.className)) {
                            name = Bundle.ShowFailures_from_suite(name, s.name);
                        }
                        this.println();
                        out.println(name, new OutputListener(){

                            public void outputLineAction(OutputEvent ev) {
                                try {
                                    HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(ShowFailures.this.url + "testReport/" + c.className.replaceFirst("[.][^.]+$", "") + "/" + c.className.replaceFirst(".+[.]", "") + "/" + c.name + "/"));
                                }
                                catch (MalformedURLException x) {
                                    LOG.log(Level.FINE, null, x);
                                }
                            }

                            public void outputLineSelected(OutputEvent ev) {
                            }

                            public void outputLineCleared(OutputEvent ev) {
                            }
                        });
                        this.show(c.errorStackTrace, out);
                    }
                    if (s.stderr != null || s.stdout != null) {
                        this.println();
                        this.show(s.stderr, err);
                        this.show(s.stdout, out);
                    }
                }

                void println() {
                    if (this.firstLine) {
                        this.firstLine = false;
                    } else {
                        this.io.getOut().println();
                    }
                }

                void show(String lines, OutputWriter w) {
                    if (lines == null) {
                        return;
                    }
                    for (String line : lines.split("\r\n?|\n")) {
                        this.hyperlinker.handleLine(line, w);
                    }
                }

                @Override
                public void endDocument() throws SAXException {
                    if (this.io != null) {
                        this.io.getOut().close();
                        this.io.getErr().close();
                    }
                }

                class Case {
                    String className;
                    String name;
                    String errorStackTrace;

                    Case() {
                    }
                }

                class Suite {
                    String name;
                    String stdout;
                    String stderr;
                    Stack<Case> cases = new Stack();
                    List<Case> casesDone = new ArrayList<Case>();

                    Suite() {
                    }
                }
            });
            String u = this.url + "testReport/api/xml?xpath=//suite[case/errorStackTrace]&wrapper=failures";
            InputSource source = new InputSource(new ConnectionBuilder().job(this.job).url(u).connection().getInputStream());
            source.setSystemId(u);
            parser.parse(source);
        }
        catch (FileNotFoundException x) {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (Exception x) {
            Toolkit.getDefaultToolkit().beep();
            LOG.log(Level.INFO, null, x);
        }
    }
}

