/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsstack.jaxrs.glassfish.v3;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.api.WSStackVersion;
import org.netbeans.modules.websvc.wsstack.api.WSTool;
import org.netbeans.modules.websvc.wsstack.jaxrs.JaxRs;
import org.netbeans.modules.websvc.wsstack.spi.WSStackFactory;
import org.netbeans.modules.websvc.wsstack.spi.WSStackImplementation;
import org.netbeans.modules.websvc.wsstack.spi.WSToolImplementation;

public class GlassFishV3EE6JaxRsStack
implements WSStackImplementation<JaxRs> {
    private static final String GFV3_MODULES_DIR_NAME = "modules";
    private String gfRootStr;
    private JaxRs jaxRs;
    private static final Set<String> JAXRS_LIBRARIES_0 = new HashSet<String>();
    private static final Set<String> JAXRS_LIBRARIES_01 = new HashSet<String>();
    private static final Set<String> JAXRS_LIBRARIES_1 = new HashSet<String>();
    private static final Collection<Set<String>> LIB_SET = new ArrayList<Set<String>>(3);

    public GlassFishV3EE6JaxRsStack(String gfRootStr) {
        this.gfRootStr = gfRootStr;
        this.jaxRs = new JaxRs();
    }

    public JaxRs get() {
        return this.jaxRs;
    }

    public WSStackVersion getVersion() {
        return WSStackVersion.valueOf((int)1, (int)1, (int)0, (int)0);
    }

    public WSTool getWSTool(WSStack.Tool toolId) {
        if (toolId == JaxRs.Tool.JAXRS) {
            return WSStackFactory.createWSTool((WSToolImplementation)new JaxRsTool());
        }
        return null;
    }

    public boolean isFeatureSupported(WSStack.Feature feature) {
        WSTool wsTool;
        boolean isFeatureSupported = false;
        if (feature == JaxRs.Feature.JAXRS && (wsTool = this.getWSTool(JaxRs.Tool.JAXRS)) != null) {
            URL[] libs = wsTool.getLibraries();
            if (libs == null) {
                return false;
            }
            for (Set<String> set : LIB_SET) {
                if (libs.length != set.size()) continue;
                isFeatureSupported = true;
                break;
            }
        }
        return isFeatureSupported;
    }

    private File getJarName(String glassfishInstallRoot, String jarNamePrefix) {
        File modulesDir = new File(glassfishInstallRoot + File.separatorChar + GFV3_MODULES_DIR_NAME);
        File[] candidates = modulesDir.listFiles(new VersionFilter(jarNamePrefix));
        if (candidates != null && candidates.length > 0) {
            return candidates[0];
        }
        return null;
    }

    static {
        JAXRS_LIBRARIES_0.add("jackson");
        JAXRS_LIBRARIES_0.add("jersey-gf-bundle");
        JAXRS_LIBRARIES_0.add("jettison");
        JAXRS_LIBRARIES_0.add("jsr311-api");
        JAXRS_LIBRARIES_01.add("jackson-core-asl");
        JAXRS_LIBRARIES_01.add("jersey-gf-bundle");
        JAXRS_LIBRARIES_01.add("jersey-multipart");
        JAXRS_LIBRARIES_01.add("jettison");
        JAXRS_LIBRARIES_01.add("mimepull");
        JAXRS_LIBRARIES_01.add("jsr311-api");
        JAXRS_LIBRARIES_1.add("jackson-core-asl");
        JAXRS_LIBRARIES_1.add("jackson-jaxrs");
        JAXRS_LIBRARIES_1.add("jackson-mapper-asl");
        JAXRS_LIBRARIES_1.add("jersey-client");
        JAXRS_LIBRARIES_1.add("jersey-core");
        JAXRS_LIBRARIES_1.add("jersey-gf-server");
        JAXRS_LIBRARIES_1.add("jersey-json");
        JAXRS_LIBRARIES_1.add("jersey-multipart");
        JAXRS_LIBRARIES_1.add("jettison");
        JAXRS_LIBRARIES_1.add("mimepull");
        LIB_SET.add(JAXRS_LIBRARIES_0);
        LIB_SET.add(JAXRS_LIBRARIES_01);
        LIB_SET.add(JAXRS_LIBRARIES_1);
    }

    protected class JaxRsTool
    implements WSToolImplementation {
        JaxRsTool() {
        }

        public String getName() {
            return JaxRs.Tool.JAXRS.getName();
        }

        public URL[] getLibraries() {
            List<URL> result = Collections.emptyList();
            int patternSize = 0;
            for (Set set : LIB_SET) {
                ArrayList cPath = new ArrayList();
                for (String entry : set) {
                    File f = GlassFishV3EE6JaxRsStack.this.getJarName(GlassFishV3EE6JaxRsStack.this.gfRootStr, entry);
                    if (f == null || !f.exists()) continue;
                    try {
                        cPath.add(f.toURI().toURL());
                    }
                    catch (MalformedURLException ex) {}
                }
                if (patternSize >= set.size() || cPath.size() < set.size()) continue;
                result = cPath;
                patternSize = set.size();
            }
            return result.toArray(new URL[result.size()]);
        }
    }

    private static class VersionFilter
    implements FileFilter {
        private String nameprefix;

        public VersionFilter(String nameprefix) {
            this.nameprefix = nameprefix;
        }

        @Override
        public boolean accept(File file) {
            return file.getName().startsWith(this.nameprefix);
        }
    }
}

