/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.wizards;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.java.j2seproject.ui.wizards.NewJ2SEProjectWizardIterator;
import org.netbeans.modules.java.j2seproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.java.j2seproject.ui.wizards.SettingsPanel;
import org.netbeans.modules.java.j2seproject.ui.wizards.WizardSettings;
import org.netbeans.spi.java.project.support.ui.SharableLibrariesUtils;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class PanelOptionsVisual
extends SettingsPanel
implements ActionListener,
PropertyChangeListener {
    private static boolean lastMainClassCheck = true;
    public static final String SHARED_LIBRARIES = "sharedLibraries";
    public static final String MAIN_CLASS = "mainClass";
    private PanelConfigureProject panel;
    private boolean valid;
    private String currentLibrariesLocation;
    private String projectLocation;
    private final NewJ2SEProjectWizardIterator.WizardType type;
    private JButton btnLibFolder;
    private JCheckBox cbSharable;
    private JCheckBox createMainCheckBox;
    private JLabel lblHint;
    private JLabel lblLibFolder;
    private JTextField mainClassTextField;
    private JCheckBox setAsMainCheckBox;
    private JTextField txtLibFolder;

    PanelOptionsVisual(PanelConfigureProject panel, NewJ2SEProjectWizardIterator.WizardType type) {
        this.initComponents();
        this.panel = panel;
        this.type = type;
        this.currentLibrariesLocation = "." + File.separatorChar + "lib";
        this.txtLibFolder.setText(this.currentLibrariesLocation);
        this.cbSharableActionPerformed(null);
        switch (type) {
            case LIB: {
                this.setAsMainCheckBox.setVisible(false);
                this.createMainCheckBox.setVisible(false);
                this.mainClassTextField.setVisible(false);
                break;
            }
            case APP: {
                this.createMainCheckBox.addActionListener(this);
                this.createMainCheckBox.setSelected(lastMainClassCheck);
                this.mainClassTextField.setEnabled(lastMainClassCheck);
                break;
            }
            case EXT: {
                this.createMainCheckBox.setVisible(false);
                this.mainClassTextField.setVisible(false);
            }
        }
        this.setAsMainCheckBox.setSelected(WizardSettings.getSetAsMain(type));
        this.mainClassTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PanelOptionsVisual.this.mainClassChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PanelOptionsVisual.this.mainClassChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PanelOptionsVisual.this.mainClassChanged();
            }
        });
        this.txtLibFolder.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PanelOptionsVisual.this.librariesLocationChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PanelOptionsVisual.this.librariesLocationChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PanelOptionsVisual.this.librariesLocationChanged();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.createMainCheckBox) {
            lastMainClassCheck = this.createMainCheckBox.isSelected();
            this.mainClassTextField.setEnabled(lastMainClassCheck);
            this.panel.fireChangeEvent();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propName = event.getPropertyName();
        if ("projectName".equals(propName)) {
            String projectName = (String)event.getNewValue();
            this.mainClassTextField.setText(PanelOptionsVisual.createMainClassName(projectName));
        } else if ("projectLocation".equals(propName)) {
            this.projectLocation = (String)event.getNewValue();
        }
    }

    static String createMainClassName(String projectName) {
        String part;
        StringBuilder pkg = new StringBuilder();
        StringBuilder main = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        boolean needsEscape = false;
        for (int i = 0; i < projectName.length(); ++i) {
            char c = projectName.charAt(i);
            if (first) {
                if (!Character.isJavaIdentifierStart(c)) {
                    if (!Character.isJavaIdentifierPart(c)) continue;
                    needsEscape = true;
                    sb.append(c);
                    first = false;
                    continue;
                }
                sb.append(c);
                first = false;
                continue;
            }
            if (Character.isJavaIdentifierPart(c)) {
                sb.append(c);
                continue;
            }
            if (sb.length() <= 0) continue;
            part = sb.toString();
            if (pkg.length() > 0) {
                pkg.append('.');
            }
            if (needsEscape || !Utilities.isJavaIdentifier((String)part.toLowerCase())) {
                pkg.append(NbBundle.getMessage(PanelOptionsVisual.class, (String)"TXT_PackageNamePrefix"));
            }
            pkg.append(part.toLowerCase());
            if (!needsEscape || main.length() > 0) {
                main.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1));
            }
            sb = new StringBuilder();
            first = true;
            needsEscape = false;
        }
        if (sb.length() > 0) {
            part = sb.toString();
            if (pkg.length() > 0) {
                pkg.append('.');
            }
            if (needsEscape || !Utilities.isJavaIdentifier((String)part.toLowerCase())) {
                pkg.append(NbBundle.getMessage(PanelOptionsVisual.class, (String)"TXT_PackageNamePrefix"));
            }
            pkg.append(part.toLowerCase());
            if (!needsEscape || main.length() > 0) {
                main.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1));
            }
        }
        if (main.length() == 0) {
            main.append(NbBundle.getMessage(PanelOptionsVisual.class, (String)"TXT_ClassName"));
        }
        return pkg.length() == 0 ? main.toString() : String.format("%s.%s", pkg.toString(), main.toString());
    }

    private void initComponents() {
        this.cbSharable = new JCheckBox();
        this.lblLibFolder = new JLabel();
        this.txtLibFolder = new JTextField();
        this.btnLibFolder = new JButton();
        this.lblHint = new JLabel();
        this.createMainCheckBox = new JCheckBox();
        this.mainClassTextField = new JTextField();
        this.setAsMainCheckBox = new JCheckBox();
        this.cbSharable.setSelected(SharableLibrariesUtils.isLastProjectSharable());
        Mnemonics.setLocalizedText((AbstractButton)this.cbSharable, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_SharableProject_Checkbox"));
        this.cbSharable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.cbSharableActionPerformed(evt);
            }
        });
        this.lblLibFolder.setLabelFor(this.txtLibFolder);
        Mnemonics.setLocalizedText((JLabel)this.lblLibFolder, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_Location_Label"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLibFolder, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_Browse_Button"));
        this.btnLibFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.btnLibFolderActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblHint, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"HINT_LibrariesFolder"));
        this.createMainCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createMainCheckBox, (String)NbBundle.getBundle(PanelOptionsVisual.class).getString("LBL_createMainCheckBox"));
        this.mainClassTextField.setText("com.myapp.Main");
        Mnemonics.setLocalizedText((AbstractButton)this.setAsMainCheckBox, (String)NbBundle.getBundle(PanelOptionsVisual.class).getString("LBL_setAsMainCheckBox"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbSharable).addGroup(layout.createSequentialGroup().addGap(19, 19, 19).addComponent(this.lblLibFolder).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblHint, -1, 250, Short.MAX_VALUE).addComponent(this.txtLibFolder, -1, 250, Short.MAX_VALUE)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnLibFolder)).addGroup(layout.createSequentialGroup().addComponent(this.setAsMainCheckBox).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.createMainCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mainClassTextField, -1, 357, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.cbSharable).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnLibFolder).addComponent(this.txtLibFolder, -2, -1, -2).addComponent(this.lblLibFolder)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblHint, -2, -1, -2).addGap(30, 30, 30).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.createMainCheckBox).addComponent(this.mainClassTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.setAsMainCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        this.cbSharable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_sharableProject"));
        this.txtLibFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_LibrariesLocation"));
        this.btnLibFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_browseLibraries"));
        this.createMainCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelOptionsVisual.class).getString("ACSN_createMainCheckBox"));
        this.createMainCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelOptionsVisual.class).getString("ACSD_createMainCheckBox"));
        this.mainClassTextField.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelOptionsVisual.class).getString("ASCN_mainClassTextFiled"));
        this.mainClassTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelOptionsVisual.class).getString("ASCD_mainClassTextFiled"));
        this.setAsMainCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelOptionsVisual.class).getString("ACSN_setAsMainCheckBox"));
        this.setAsMainCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelOptionsVisual.class).getString("ACSD_setAsMainCheckBox"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSN_PanelOptionsVisual"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_PanelOptionsVisual"));
    }

    private void cbSharableActionPerformed(ActionEvent evt) {
        this.txtLibFolder.setEnabled(this.cbSharable.isSelected());
        this.btnLibFolder.setEnabled(this.cbSharable.isSelected());
        this.lblHint.setEnabled(this.cbSharable.isSelected());
        this.lblLibFolder.setEnabled(this.cbSharable.isSelected());
        if (this.cbSharable.isSelected()) {
            this.txtLibFolder.setText(this.currentLibrariesLocation);
        } else {
            this.txtLibFolder.setText("");
        }
    }

    private void btnLibFolderActionPerformed(ActionEvent evt) {
        File f = FileUtil.normalizeFile((File)new File(this.projectLocation + File.separatorChar + "project_folder"));
        String curr = SharableLibrariesUtils.browseForLibraryLocation((String)this.txtLibFolder.getText().trim(), (Component)this, (File)f);
        if (curr != null) {
            this.currentLibrariesLocation = curr;
            if (this.cbSharable.isSelected()) {
                this.txtLibFolder.setText(this.currentLibrariesLocation);
            }
        }
    }

    @Override
    boolean valid(WizardDescriptor settings) {
        if (this.cbSharable.isSelected()) {
            String location = this.txtLibFolder.getText();
            if (this.projectLocation != null) {
                if (new File(location).isAbsolute()) {
                    settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"WARN_PanelOptionsVisual.absolutePath"));
                } else {
                    File libLoc;
                    File projectLoc = FileUtil.normalizeFile((File)new File(this.projectLocation));
                    if (!CollocationQuery.areCollocated((File)projectLoc, (File)(libLoc = PropertyUtils.resolveFile((File)projectLoc, (String)location)))) {
                        settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"WARN_PanelOptionsVisual.relativePath"));
                    }
                }
            }
        }
        if (this.mainClassTextField.isVisible() && this.mainClassTextField.isEnabled()) {
            if (!this.valid) {
                settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"ERROR_IllegalMainClassName"));
            }
            return this.valid;
        }
        return true;
    }

    @Override
    void read(WizardDescriptor d) {
        String libFolder;
        String mainClass = (String)d.getProperty(MAIN_CLASS);
        if (mainClass != null) {
            this.mainClassTextField.setText(mainClass);
        }
        if ((libFolder = (String)d.getProperty(SHARED_LIBRARIES)) != null) {
            this.currentLibrariesLocation = libFolder;
            this.txtLibFolder.setText(this.currentLibrariesLocation);
        }
    }

    @Override
    void validate(WizardDescriptor d) throws WizardValidationException {
    }

    @Override
    void store(WizardDescriptor d) {
        Templates.setDefinesMainProject((WizardDescriptor)d, (boolean)this.setAsMainCheckBox.isSelected());
        WizardSettings.setSetAsMain(this.type, this.setAsMainCheckBox.isSelected());
        d.putProperty(MAIN_CLASS, this.createMainCheckBox.isSelected() && this.createMainCheckBox.isVisible() ? this.mainClassTextField.getText() : null);
        d.putProperty(SHARED_LIBRARIES, this.cbSharable.isSelected() ? this.txtLibFolder.getText() : null);
    }

    private void mainClassChanged() {
        String mainClassName = this.mainClassTextField.getText();
        StringTokenizer tk = new StringTokenizer(mainClassName, ".");
        boolean _valid = true;
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken();
            if (token.length() != 0 && Utilities.isJavaIdentifier((String)token)) continue;
            _valid = false;
            break;
        }
        this.valid = _valid;
        this.panel.fireChangeEvent();
    }

    private void librariesLocationChanged() {
        this.panel.fireChangeEvent();
        String libFolder = this.txtLibFolder.getText();
        if (libFolder.length() > 0) {
            this.currentLibrariesLocation = libFolder;
        }
    }
}

