/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.db.h2;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.ForeignKeyConstraint;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.storage.PersistentDataStorageFactory;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.spi.support.SQLDataStorage;
import org.netbeans.modules.dlight.spi.support.SQLExceptions;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.Util;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;

public final class H2DataStorage
extends SQLDataStorage {
    private static final String SQL_QUERY_DELIMETER = ";";
    private static final Logger logger = DLightLogger.getLogger(H2DataStorage.class);
    private static final AtomicInteger dbIndex = new AtomicInteger();
    private final Collection<DataStorageType> supportedStorageTypes = new ArrayList<DataStorageType>();
    private static final String storagesDir;
    private static final String url;
    private static String persistentURL;
    final String dbURL;
    boolean isPersistent = false;

    private void initStorageTypes() {
        this.supportedStorageTypes.add(DataStorageTypeFactory.getInstance().getDataStorageType("db:sql:h2"));
        this.supportedStorageTypes.addAll(super.getStorageTypes());
    }

    H2DataStorage(boolean isPersistent, String storageUniqueKey) throws SQLException {
        this(isPersistent ? persistentURL + "/dlight" + storageUniqueKey : url + dbIndex.incrementAndGet() + "/dlight");
        this.isPersistent = isPersistent;
    }

    H2DataStorage() throws SQLException {
        this(false, null);
    }

    H2DataStorage(String url) throws SQLException {
        super(url);
        this.dbURL = url;
        this.initStorageTypes();
    }

    public boolean shutdown() {
        boolean result = super.shutdown();
        if (this.isPersistent) {
            return result;
        }
        String folderToDelete = this.dbURL.substring(this.dbURL.lastIndexOf(":") + 1, this.dbURL.lastIndexOf("/") + 1);
        result = result && Util.deleteLocalDirectory((File)new File(folderToDelete));
        return result;
    }

    public String toString() {
        return "dburl=" + this.dbURL;
    }

    public String createForeignKeyConstraint(ForeignKeyConstraint fKey) {
        return " FOREIGN KEY (" + fKey.getColumn().getColumnName() + ") REFERENCES " + fKey.getReferenceTable().getName() + "(" + fKey.getReferenceColumn().getColumnName() + ") ";
    }

    public void createTables(List<DataTableMetadata> tableMetadatas) {
        for (DataTableMetadata tdmd : tableMetadatas) {
            if (tdmd == null) continue;
            this.createTable(tdmd);
            this.tables.put(tdmd.getName(), tdmd);
        }
    }

    public Collection<DataStorageType> getStorageTypes() {
        return this.supportedStorageTypes;
    }

    protected final Connection doConnect() throws SQLException {
        return DriverManager.getConnection(this.getDbURL(), "admin", "");
    }

    public String getSQLQueriesDelimeter() {
        return SQL_QUERY_DELIMETER;
    }

    public String getAutoIncrementExpresion() {
        return "AUTO_INCREMENT";
    }

    public String getPrimaryKeyExpression() {
        return "PRIMARY KEY";
    }

    public boolean hasData(DataTableMetadata data) {
        ArrayList toCheck = new ArrayList(this.tables.values());
        return data.isProvidedBy(toCheck);
    }

    public boolean supportsType(DataStorageType storageType) {
        return this.getStorageTypes().contains(storageType);
    }

    public void loadSchema() {
        try {
            ResultSet rs = this.select("INFORMATION_SCHEMA.TABLES", null, "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_TYPE LIKE 'TABLE'");
            if (rs == null) {
                return;
            }
            while (rs.next()) {
                String tableName = rs.getString(1);
                this.loadTable(tableName);
            }
        }
        catch (SQLException ex) {
            SQLExceptions.printStackTrace((SQLDataStorage)this, (SQLException)ex);
        }
    }

    private void loadTable(String tableName) {
        try {
            ResultSet rs = this.select("INFORMATION_SCHEMA.COLUMNS", null, "SELECT COLUMN_NAME, TYPE_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME LIKE '" + tableName + "'");
            ArrayList<DataTableMetadata.Column> columns = new ArrayList<DataTableMetadata.Column>();
            while (rs.next()) {
                DataTableMetadata.Column c = new DataTableMetadata.Column(rs.getString("COLUMN_NAME"), this.typeToClass(rs.getString("TYPE_NAME")));
                columns.add(c);
            }
            DataTableMetadata result = new DataTableMetadata(tableName, columns, null);
            super.loadTable(result);
            this.tables.put(result.getName(), result);
        }
        catch (SQLException ex) {
            SQLExceptions.printStackTrace((SQLDataStorage)this, (SQLException)ex);
        }
    }

    static {
        try {
            Class<?> driver = Class.forName("org.h2.Driver");
            logger.log(Level.FINE, "Driver for H2DB ({0}) Loaded ", driver.getName());
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        String tempDir = null;
        try {
            HostInfo hi = HostInfoUtils.getHostInfo((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
            tempDir = hi.getTempDir();
            if (hi.getOSFamily() == HostInfo.OSFamily.WINDOWS) {
                tempDir = WindowsSupport.getInstance().convertToWindowsPath(tempDir);
            }
        }
        catch (IOException ex) {
        }
        catch (ConnectionManager.CancellationException ex) {
            // empty catch block
        }
        if (tempDir == null || tempDir.trim().equals("")) {
            tempDir = System.getProperty("java.io.tmpdir");
        }
        storagesDir = PersistentDataStorageFactory.PERSISTENT_DATA_STORAGE_FOLDER == null ? tempDir : PersistentDataStorageFactory.PERSISTENT_DATA_STORAGE_FOLDER;
        url = "jdbc:h2:" + storagesDir + "/h2_db_dlight";
        persistentURL = PersistentDataStorageFactory.PERSISTENT_DATA_STORAGE_HOST != null ? "jdbc:h2:tcp://" + PersistentDataStorageFactory.PERSISTENT_DATA_STORAGE_HOST + storagesDir : url;
        CommonTasksSupport.mkDir((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal(), (String)storagesDir, (Writer)new StringWriter());
        File tmpDirFile = new File(storagesDir);
        if (tmpDirFile.exists()) {
            final File[] files = tmpDirFile.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return dir.isDirectory() && name.startsWith("h2_db_dlight");
                }
            });
            int generalNameLength = "h2_db_dlight".length();
            int newValue = 0;
            for (int i = 0; i < files.length; ++i) {
                String suffix = files[i].getName().substring(generalNameLength);
                try {
                    newValue = Math.max(newValue, Integer.valueOf(suffix));
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            dbIndex.getAndSet(newValue);
            if (PersistentDataStorageFactory.PERSISTENT_DATA_STORAGE_FOLDER == null) {
                DLightExecutorService.submit((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        for (File file : files) {
                            Util.deleteLocalDirectory((File)file);
                        }
                    }
                }, (String)"H2DataStorage removing old data bases");
            }
        }
    }
}

