/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.source.ui.ScanDialog;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class GroovyActionProvider
implements ActionProvider {
    public static final String BUILD_SCRIPT = "buildfile";
    public static final String PROP_CONFIG = "config";
    private static final String[] supportedActions = new String[]{"run.single", "debug.single"};
    private static final String[] platformSensitiveActions = new String[]{"run.single", "debug.single"};
    Map<String, String[]> commands;
    private final Project project;
    final Set<String> bkgScanSensitiveActions;

    public GroovyActionProvider(Project project) {
        this.project = project;
        this.commands = new HashMap<String, String[]>();
        this.commands.put("run.single", new String[]{"run-single"});
        this.commands.put("debug.single", new String[]{"debug-single"});
        this.bkgScanSensitiveActions = new HashSet<String>(Arrays.asList("run.single", "debug.single"));
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    public void invokeAction(final String command, final Lookup context) throws IllegalArgumentException {
        Runnable action = new Runnable(){

            @Override
            public void run() {
                Properties p = new Properties();
                String[] targetNames = GroovyActionProvider.this.getTargetNames(command, context, p);
                if (targetNames == null) {
                    return;
                }
                if (targetNames.length == 0) {
                    targetNames = null;
                }
                if (p.keySet().size() == 0) {
                    p = null;
                }
                try {
                    FileObject buildFo = GroovyActionProvider.this.findBuildXml();
                    if (buildFo == null || !buildFo.isValid()) {
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(GroovyActionProvider.class, (String)"LBL_No_Build_XML_Found"), 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    } else {
                        ActionUtils.runTarget((FileObject)buildFo, (String[])targetNames, (Properties)p);
                    }
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        };
        if (this.bkgScanSensitiveActions.contains(command)) {
            ScanDialog.runWhenScanFinished((Runnable)action, (String)NbBundle.getMessage(GroovyActionProvider.class, (String)("ACTION_" + command)));
        } else {
            action.run();
        }
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        if (command.equals("run.single")) {
            FileObject[] fos = this.findSources(context);
            return fos != null && fos.length == 1;
        }
        return false;
    }

    private String[] getTargetNames(String command, Lookup context, Properties p) throws IllegalArgumentException {
        HashMap<String, String[]> targetsFromConfig = this.loadTargetsFromConfig();
        String[] targetNames = new String[]{};
        if (command.equals("run.single") || command.equals("debug.single")) {
            FileObject[] files = this.findTestSources(context, false);
            if (files != null) {
                targetNames = command.equals("run.single") ? this.setupTestSingle(p, files) : this.setupDebugTestSingle(p, files);
            } else {
                FileObject file = this.findSources(context)[0];
                Sources sources = ProjectUtils.getSources((Project)this.project);
                SourceGroup[] sourceGroups = sources.getSourceGroups("java");
                String clazz = FileUtil.getRelativePath((FileObject)this.getRoot(sourceGroups, file), (FileObject)file);
                p.setProperty("javac.includes", clazz);
                if (clazz.endsWith(".groovy")) {
                    clazz = clazz.substring(0, clazz.length() - 7);
                }
                clazz = clazz.replace('/', '.');
                if (command.equals("run.single")) {
                    p.setProperty("run.class", clazz);
                    String[] targets = (String[])targetsFromConfig.get(command);
                    targetNames = targets != null ? targets : this.commands.get("run.single");
                } else {
                    p.setProperty("debug.class", clazz);
                    String[] targets = (String[])targetsFromConfig.get(command);
                    targetNames = targets != null ? targets : this.commands.get("debug.single");
                }
            }
        }
        return targetNames;
    }

    private FileObject getRoot(SourceGroup[] groups, FileObject file) {
        assert (file != null) : "File can't be null";
        FileObject srcDir = null;
        for (int i = 0; i < groups.length; ++i) {
            FileObject root = groups[i].getRootFolder();
            assert (root != null) : "Source Path Root can't be null";
            if (!FileUtil.isParentOf((FileObject)root, (FileObject)file) && !root.equals(file)) continue;
            srcDir = root;
            break;
        }
        return srcDir;
    }

    private FileObject getRoot(FileObject[] groups, FileObject file) {
        assert (file != null) : "File can't be null";
        FileObject srcDir = null;
        for (FileObject root : groups) {
            assert (root != null) : "Source Path Root can't be null";
            if (!FileUtil.isParentOf((FileObject)root, (FileObject)file) && !root.equals(file)) continue;
            srcDir = root;
            break;
        }
        return srcDir;
    }

    private FileObject[] findSources(Lookup context) {
        Sources sources = ProjectUtils.getSources((Project)this.project);
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        for (int i = 0; i < sourceGroups.length; ++i) {
            FileObject[] files = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)sourceGroups[i].getRootFolder(), (String)".groovy", (boolean)true);
            if (files == null) continue;
            return files;
        }
        return null;
    }

    private FileObject[] findTestSources(Lookup context, boolean checkInSrcDir) {
        FileObject[] testSrcPath = GroovyActionProvider.getTestSourceRoots(this.project);
        for (int i = 0; i < testSrcPath.length; ++i) {
            FileObject[] files = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)testSrcPath[i], (String)".groovy", (boolean)true);
            if (files == null) continue;
            return files;
        }
        return null;
    }

    private FileObject findBuildXml() {
        return GroovyActionProvider.getBuildXml(this.project);
    }

    public static String getBuildXmlName(Project project) {
        assert (project != null);
        String buildScriptPath = GroovyActionProvider.evaluateProperty(project, BUILD_SCRIPT);
        if (buildScriptPath == null) {
            buildScriptPath = "build.xml";
        }
        return buildScriptPath;
    }

    public static FileObject getBuildXml(Project project) {
        return project.getProjectDirectory().getFileObject(GroovyActionProvider.getBuildXmlName(project));
    }

    private static FileObject[] getTestSourceRoots(Project project) {
        List<String> names = GroovyActionProvider.getTestRootsNames(project);
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        for (String name : names) {
            FileObject root = project.getProjectDirectory().getFileObject(name);
            if (root == null) continue;
            result.add(root);
        }
        return result.toArray(new FileObject[result.size()]);
    }

    private static List<String> getTestRootsNames(Project project) {
        File propFile = FileUtil.toFile((FileObject)project.getProjectDirectory().getFileObject("nbproject/project.properties"));
        Map map = PropertyUtils.propertiesFilePropertyProvider((File)propFile).getProperties();
        ArrayList<String> result = new ArrayList<String>();
        for (String key : map.keySet()) {
            if (!key.startsWith("test.") || !key.endsWith(".dir")) continue;
            result.add((String)map.get(key));
        }
        return result;
    }

    private static String evaluateProperty(Project project, String key) {
        File propFile = FileUtil.toFile((FileObject)project.getProjectDirectory().getFileObject("nbproject/project.properties"));
        Map map = PropertyUtils.propertiesFilePropertyProvider((File)propFile).getProperties();
        return (String)map.get(key);
    }

    private String[] setupTestSingle(Properties p, FileObject[] files) {
        FileObject[] testSrcPath = GroovyActionProvider.getTestSourceRoots(this.project);
        FileObject root = this.getRoot(testSrcPath, files[0]);
        p.setProperty("test.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)root));
        p.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)root));
        return new String[]{"test-single"};
    }

    private String[] setupDebugTestSingle(Properties p, FileObject[] files) {
        FileObject[] testSrcPath = GroovyActionProvider.getTestSourceRoots(this.project);
        FileObject root = this.getRoot(testSrcPath, files[0]);
        String path = FileUtil.getRelativePath((FileObject)root, (FileObject)files[0]);
        p.setProperty("test.class", path.substring(0, path.length() - 5).replace('/', '.'));
        p.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)root));
        return new String[]{"debug-test"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, String[]> loadTargetsFromConfig() {
        HashMap<String, String[]> targets = new HashMap<String, String[]>(6);
        String config = GroovyActionProvider.evaluateProperty(this.project, PROP_CONFIG);
        FileObject propFO = this.project.getProjectDirectory().getFileObject("nbproject/configs/" + config + ".properties");
        if (propFO == null) {
            return targets;
        }
        Properties props = new Properties();
        try {
            InputStream is = propFO.getInputStream();
            try {
                props.load(is);
            }
            finally {
                is.close();
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return targets;
        }
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            if (!propName.startsWith("$target.")) continue;
            String tNameVal = props.getProperty(propName);
            String cmdNameKey = null;
            if (tNameVal == null || tNameVal.equals("")) continue;
            cmdNameKey = propName.substring("$target.".length());
            StringTokenizer stok = new StringTokenizer(tNameVal.trim(), " ");
            ArrayList<String> targetNames = new ArrayList<String>(3);
            while (stok.hasMoreTokens()) {
                targetNames.add(stok.nextToken());
            }
            targets.put(cmdNameKey, targetNames.toArray(new String[targetNames.size()]));
        }
        return targets;
    }

    private static final class MainClassChooser {
        private static Boolean unitTestingSupport_hasMainMethodResult;

        private MainClassChooser() {
        }
    }
}

