/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring.ui;

import java.util.Collection;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.AstPath;
import org.netbeans.modules.groovy.editor.api.AstUtilities;
import org.netbeans.modules.groovy.editor.api.lexer.LexUtilities;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.groovy.editor.api.parser.SourceUtils;
import org.netbeans.modules.groovy.refactoring.GroovyRefactoringElement;
import org.netbeans.modules.groovy.refactoring.Utils;
import org.netbeans.modules.groovy.refactoring.ui.WhereUsedQueryUI;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class GroovyRefactoringActionsProvider
extends ActionsImplementationProvider {
    private static boolean isFindUsages;

    public boolean canFindUsages(Lookup lookup) {
        Collection nodes = lookup.lookupAll(Node.class);
        if (nodes.size() != 1) {
            return false;
        }
        Node n = (Node)nodes.iterator().next();
        DataObject dob = (DataObject)n.getCookie(DataObject.class);
        if (dob == null) {
            return false;
        }
        FileObject fo = dob.getPrimaryFile();
        if (GroovyRefactoringActionsProvider.isOutsideGroovy(lookup, fo)) {
            return false;
        }
        return dob != null && Utils.isGroovyOrGspFile(fo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFindUsages(Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        FileObject fileObject = (FileObject)lookup.lookup(FileObject.class);
        UserTask task = GroovyRefactoringActionsProvider.isFromEditor(ec) ? new TextComponentTask(ec, fileObject){

            @Override
            protected RefactoringUI createRefactoringUI(GroovyRefactoringElement selectedElement, int startOffset, int endOffset, GroovyParserResult result) {
                return new WhereUsedQueryUI(selectedElement);
            }
        } : new NodeToElementTask(lookup.lookupAll(Node.class), fileObject){

            @Override
            protected RefactoringUI createRefactoringUI(GroovyRefactoringElement selectedElement, GroovyParserResult result) {
                return new WhereUsedQueryUI(selectedElement);
            }
        };
        try {
            isFindUsages = true;
            task.run();
        }
        finally {
            isFindUsages = false;
        }
    }

    private static boolean isOutsideGroovy(Lookup lookup, FileObject fo) {
        EditorCookie ec;
        if (Utils.isGspFile(fo) && GroovyRefactoringActionsProvider.isFromEditor(ec = (EditorCookie)lookup.lookup(EditorCookie.class))) {
            JEditorPane textC = ec.getOpenedPanes()[0];
            Document d = textC.getDocument();
            if (!(d instanceof BaseDocument)) {
                return true;
            }
            int caret = textC.getCaretPosition();
            if (LexUtilities.getToken((BaseDocument)((BaseDocument)d), (int)caret) == null) {
                return true;
            }
        }
        return false;
    }

    private static boolean isFromEditor(EditorCookie ec) {
        return ec != null && ec.getOpenedPanes() != null;
    }

    public static abstract class NodeToElementTask
    extends UserTask
    implements Runnable {
        private Node node;
        private RefactoringUI ui;
        private final FileObject fileObject;

        public NodeToElementTask(Collection<? extends Node> nodes, FileObject fileObject) {
            assert (nodes.size() == 1);
            this.node = nodes.iterator().next();
            this.fileObject = fileObject;
        }

        public void run(ResultIterator resultIterator) throws Exception {
            GroovyParserResult info = AstUtilities.getParseResult((Parser.Result)resultIterator.getParserResult());
            ModuleNode root = AstUtilities.getRoot((ParserResult)info);
            if (root != null) {
                GroovyRefactoringElement fileCtx = new GroovyRefactoringElement(info, root, (ASTNode)root, info.getSnapshot().getSource().getFileObject());
                this.ui = this.createRefactoringUI(fileCtx, info);
            }
        }

        @Override
        public final void run() {
            DataObject o = (DataObject)this.node.getCookie(DataObject.class);
            try {
                SourceUtils.runUserActionTask((FileObject)this.fileObject, (UserTask)this);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            UI.openRefactoringUI((RefactoringUI)this.ui);
        }

        protected abstract RefactoringUI createRefactoringUI(GroovyRefactoringElement var1, GroovyParserResult var2);
    }

    public static abstract class TextComponentTask
    extends UserTask
    implements Runnable {
        private JTextComponent textC;
        private int caret;
        private int start;
        private int end;
        private RefactoringUI ui;
        private final FileObject fileObject;

        public TextComponentTask(EditorCookie ec, FileObject fileObject) {
            this.textC = ec.getOpenedPanes()[0];
            this.caret = this.textC.getCaretPosition();
            this.start = this.textC.getSelectionStart();
            this.end = this.textC.getSelectionEnd();
            this.fileObject = fileObject;
            assert (this.caret != -1);
            assert (this.start != -1);
            assert (this.end != -1);
        }

        public void run(ResultIterator resultIterator) throws Exception {
            GroovyParserResult cc = AstUtilities.getParseResult((Parser.Result)resultIterator.getParserResult());
            ModuleNode root = AstUtilities.getRoot((ParserResult)cc);
            if (root == null) {
                System.out.println("FAILURE - can't refactor uncompileable sources");
                return;
            }
            BaseDocument doc = Utils.getDocument((ParserResult)cc, this.fileObject);
            AstPath path = new AstPath((ASTNode)root, this.caret, doc);
            GroovyRefactoringElement ctx = new GroovyRefactoringElement(cc, root, path.leaf(), this.fileObject);
            if (ctx.getSimpleName() == null) {
                return;
            }
            this.ui = this.createRefactoringUI(ctx, this.start, this.end, cc);
        }

        @Override
        public final void run() {
            try {
                SourceUtils.runUserActionTask((FileObject)this.fileObject, (UserTask)this);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            TopComponent activetc = TopComponent.getRegistry().getActivated();
            if (this.ui != null) {
                UI.openRefactoringUI((RefactoringUI)this.ui, (TopComponent)activetc);
            } else {
                String key = "ERR_CannotRenameLoc";
                if (isFindUsages) {
                    key = "ERR_CannotFindUsages";
                }
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(GroovyRefactoringActionsProvider.class, (String)key));
            }
        }

        protected abstract RefactoringUI createRefactoringUI(GroovyRefactoringElement var1, int var2, int var3, GroovyParserResult var4);
    }
}

