/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.annotationsupport;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.dlight.annotationsupport.AnnotationMark;
import org.netbeans.modules.dlight.annotationsupport.AnnotationMarkInstaller;
import org.netbeans.modules.dlight.annotationsupport.AnnotationMarkProvider;
import org.netbeans.modules.dlight.annotationsupport.FileAnnotationInfo;
import org.netbeans.modules.dlight.annotationsupport.LineAnnotationInfo;
import org.netbeans.modules.dlight.annotationsupport.ShowTextAnnotationsAction;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.openide.text.NbDocument;
import org.openide.util.actions.SystemAction;

public class AnnotationBar
extends JComponent
implements Accessible,
PropertyChangeListener,
DocumentListener,
ChangeListener,
ActionListener,
ComponentListener,
MouseMotionListener {
    private FileAnnotationInfo fileAnnotationInfo;
    private final JTextComponent textComponent;
    private final EditorUI editorUI;
    private final FoldHierarchy foldHierarchy;
    private final BaseDocument doc;
    private final Caret caret;
    private boolean annotated;
    private Color backgroundColor = Color.WHITE;
    private Color foregroundColor = Color.BLACK;
    private Color metricsFG = null;
    private Color metricsBG = null;
    private Color navigationBarFG = null;
    private Color navigationBarBG = null;
    private Font barFont = null;

    public AnnotationBar(JTextComponent target) {
        this.textComponent = target;
        this.editorUI = Utilities.getEditorUI((JTextComponent)target);
        this.foldHierarchy = FoldHierarchy.get((JTextComponent)this.editorUI.getComponent());
        this.doc = this.editorUI.getDocument();
        this.caret = this.textComponent.getCaret();
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.addMouseListener(new PopupMenuListener());
    }

    private FileAnnotationInfo getFileAnnotationInfo() {
        return this.fileAnnotationInfo;
    }

    private void getColors() {
        EditorSettings editorSettings = EditorSettings.getDefault();
        Map map = editorSettings.getHighlightings(editorSettings.getCurrentFontColorProfile());
        AttributeSet aSet = (AttributeSet)map.get("dlight-metrics-annotations");
        this.metricsFG = (Color)aSet.getAttribute(StyleConstants.Foreground);
        this.metricsBG = (Color)aSet.getAttribute(StyleConstants.Background);
        aSet = (AttributeSet)map.get("dlight-metrics-text-highlighting");
        this.navigationBarFG = (Color)aSet.getAttribute(StyleConstants.Foreground);
        this.navigationBarBG = (Color)aSet.getAttribute(StyleConstants.Background);
    }

    private Color getMetricsFGColor() {
        if (this.metricsFG == null) {
            this.getColors();
        }
        return this.metricsFG;
    }

    private Color getMetricsBGColor() {
        if (this.metricsBG == null) {
            this.getColors();
        }
        return this.metricsBG;
    }

    private Color getNavigationBarFGColor() {
        if (this.navigationBarFG == null) {
            this.getColors();
        }
        return this.navigationBarFG;
    }

    private Color getTextHighlightBGColor() {
        if (this.navigationBarBG == null) {
            this.getColors();
        }
        return this.navigationBarBG;
    }

    private Color backgroundColor() {
        if (this.getMetricsBGColor() != null) {
            return this.getMetricsBGColor();
        }
        if (this.textComponent != null) {
            return this.textComponent.getBackground();
        }
        return this.backgroundColor;
    }

    private Color foregroundColor() {
        if (this.getMetricsFGColor() != null) {
            return this.getMetricsFGColor();
        }
        if (this.textComponent != null) {
            return this.textComponent.getForeground();
        }
        return this.foregroundColor;
    }

    private Color defaultBackground() {
        if (this.textComponent != null) {
            return this.textComponent.getBackground();
        }
        return this.backgroundColor;
    }

    private Font getBarFont() {
        if (this.barFont == null) {
            this.barFont = new Font("Monospaced", 0, this.editorUI.getComponent().getFont().getSize() - 1);
        }
        return this.barFont;
    }

    private Font getBarBoldFont() {
        Font font = this.getBarFont().deriveFont(1);
        return font;
    }

    @Override
    public Dimension getPreferredSize() {
        int width;
        if (!this.annotated || this.getFileAnnotationInfo() == null) {
            return new Dimension(0, 0);
        }
        Dimension dim = this.textComponent.getSize();
        dim.width = width = this.getBarWidth();
        dim.height *= 2;
        return dim;
    }

    private int getBarWidth() {
        int annotationLength = this.getFileAnnotationInfo().getAnnotationLength();
        if (annotationLength == 0) {
            return 0;
        }
        Graphics graphics = this.getGraphics();
        graphics.setFont(this.getBarFont());
        int cwidth = graphics.getFontMetrics().charWidth('X');
        graphics.setFont(this.getBarBoldFont());
        cwidth = graphics.getFontMetrics().charWidth('X');
        return (1 + annotationLength) * cwidth;
    }

    public void annotate(FileAnnotationInfo fileAnnotationInfo) {
        if (fileAnnotationInfo == null) {
            return;
        }
        this.fileAnnotationInfo = fileAnnotationInfo;
        this.setToolTipText(fileAnnotationInfo.getTooltip());
        this.annotated = true;
        this.doc.addDocumentListener((DocumentListener)this);
        this.textComponent.addComponentListener(this);
        this.editorUI.addPropertyChangeListener((PropertyChangeListener)this);
        EditorSettings.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        this.addMouseMotionListener(this);
        ArrayList<AnnotationMark> marks = new ArrayList<AnnotationMark>();
        for (LineAnnotationInfo lineAnnotationInfo : fileAnnotationInfo.getLineAnnotationInfo()) {
            marks.add(new AnnotationMark(lineAnnotationInfo.getLine() - 1, lineAnnotationInfo.getTooltip(), this.getNavigationBarFGColor()));
        }
        for (LineAnnotationInfo lineAnnotationInfo : fileAnnotationInfo.getBlockAnnotationInfo()) {
            marks.add(new AnnotationMark(lineAnnotationInfo.getLine() - 1, lineAnnotationInfo.getTooltip(), this.getNavigationBarFGColor()));
        }
        AnnotationMarkProvider amp = AnnotationMarkInstaller.getMarkProvider(this.textComponent);
        if (amp != null) {
            amp.setMarks(marks);
        }
        this.revalidate();
    }

    public void hideAnnotate() {
        this.annotated = false;
        if (this.getFileAnnotationInfo() == null || this.getFileAnnotationInfo().getLineAnnotationInfo() == null) {
            return;
        }
        for (LineAnnotationInfo lineAnnotationInfo : this.getFileAnnotationInfo().getLineAnnotationInfo()) {
            this.setHighlight((StyledDocument)this.doc, lineAnnotationInfo.getLine(), lineAnnotationInfo.getLine(), new Color(255, 255, 255), null);
        }
        ArrayList<AnnotationMark> marks = new ArrayList<AnnotationMark>();
        AnnotationMarkProvider amp = AnnotationMarkInstaller.getMarkProvider(this.textComponent);
        if (amp != null) {
            amp.setMarks(marks);
        }
        this.doc.removeDocumentListener((DocumentListener)this);
        this.textComponent.removeComponentListener(this);
        this.editorUI.removePropertyChangeListener((PropertyChangeListener)this);
        EditorSettings.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
        this.removeMouseMotionListener(this);
        this.revalidate();
    }

    public void unAnnotate() {
        this.hideAnnotate();
        this.fileAnnotationInfo = null;
    }

    public boolean hasAnnotations() {
        return this.fileAnnotationInfo != null;
    }

    private void setHighlight(StyledDocument doc, int line1, int line2, Color bgColor, Color fgColor) {
        if (bgColor == null) {
            return;
        }
        for (int line = line1 - 1; line < line2; ++line) {
            int offset;
            if (line < 0 || (offset = NbDocument.findLineOffset((StyledDocument)doc, (int)line)) < 0) continue;
            Style s = doc.getLogicalStyle(offset);
            if (s == null) {
                s = doc.addStyle("gizmo-style(" + bgColor + "):1000", null);
            }
            if (bgColor != null) {
                s.addAttribute(StyleConstants.ColorConstants.Background, bgColor);
            }
            doc.setLogicalStyle(offset, s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        block14: {
            super.paintComponent(g);
            if (!this.annotated || this.getFileAnnotationInfo() == null) {
                return;
            }
            Rectangle clip = g.getClipBounds();
            JTextComponent component = this.editorUI.getComponent();
            if (component == null) {
                return;
            }
            BaseTextUI textUI = (BaseTextUI)component.getUI();
            View rootView = Utilities.getDocumentView((JTextComponent)component);
            if (rootView == null) {
                return;
            }
            g.setColor(this.defaultBackground());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            AbstractDocument adoc = (AbstractDocument)component.getDocument();
            adoc.readLock();
            try {
                this.foldHierarchy.lock();
                try {
                    int startPos = textUI.getPosFromY(clip.y);
                    int startViewIndex = rootView.getViewIndex(startPos, Position.Bias.Forward);
                    int rootViewCount = rootView.getViewCount();
                    if (startViewIndex < 0 || startViewIndex >= rootViewCount) break block14;
                    int clipEndY = clip.y + clip.height;
                    for (int i = startViewIndex; i < rootViewCount; ++i) {
                        View view = rootView.getView(i);
                        Rectangle rec = component.modelToView(view.getStartOffset());
                        if (rec == null) {
                        } else {
                            int y = rec.y;
                            this.paintView(view, g, y);
                            if (y < clipEndY) continue;
                        }
                        break;
                    }
                }
                finally {
                    this.foldHierarchy.unlock();
                }
            }
            catch (BadLocationException ble) {
            }
            finally {
                adoc.readUnlock();
            }
        }
    }

    private void drawAnnotation(Graphics2D g2d, int x, int y, LineAnnotationInfo annotationInfo) {
        if (annotationInfo == null) {
            return;
        }
        Shape clip = g2d.getClip();
        g2d.setColor(this.backgroundColor());
        g2d.fill(clip);
        String annotation = annotationInfo.getAnnotation();
        g2d.setFont(this.getBarFont());
        g2d.setColor(this.foregroundColor());
        g2d.drawString(annotation, x, y);
        annotationInfo.setBounds(clip.getBounds());
    }

    private void paintView(View view, Graphics g, int yBase) {
        JTextComponent component = this.editorUI.getComponent();
        if (component == null) {
            return;
        }
        FileAnnotationInfo info = this.getFileAnnotationInfo();
        if (info == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle bounds = g.getClipBounds();
        int y = yBase + this.editorUI.getLineAscent();
        g.setClip(bounds.x, yBase, bounds.width - 1, this.editorUI.getLineHeight() - 1);
        this.drawAnnotation(g2d, 2, y, info.getLineAnnotationInfoByLineOffset(view.getStartOffset()));
        this.drawAnnotation(g2d, 2, y, info.getBlockAnnotationInfoByLineOffset(view.getStartOffset()));
        g.setClip(bounds);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt == null) {
            return;
        }
        String id = evt.getPropertyName();
        if ("component".equals(id) && evt.getNewValue() == null) {
            this.release();
        }
        if ("editorFontColors".equals(id) && evt.getNewValue() != null && ((String)evt.getNewValue()).equals("NetBeans")) {
            this.metricsFG = null;
            this.metricsBG = null;
            this.navigationBarFG = null;
            this.navigationBarBG = null;
            if (this.annotated) {
                this.hideAnnotate();
                this.annotate(this.getFileAnnotationInfo());
            }
        }
    }

    private void release() {
        this.editorUI.removePropertyChangeListener((PropertyChangeListener)this);
        this.textComponent.removeComponentListener(this);
        this.doc.removeDocumentListener((DocumentListener)this);
        this.caret.removeChangeListener(this);
        AnnotationMarkProvider amp = AnnotationMarkInstaller.getMarkProvider(this.textComponent);
        if (amp != null) {
            amp.setMarks(Collections.<AnnotationMark>emptyList());
        }
        this.clearRecentFeedback();
    }

    private void clearRecentFeedback() {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.revalidate();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        String tooltip = this.getFileAnnotationInfo().getTooltip();
        LineAnnotationInfo lineAnnotationInfo = this.getFileAnnotationInfo().getLineAnnotationInfoByYCoordinate(e.getY());
        if (lineAnnotationInfo == null) {
            lineAnnotationInfo = this.getFileAnnotationInfo().getBlockAnnotationInfoByYCoordinate(e.getY());
        }
        if (lineAnnotationInfo != null) {
            tooltip = lineAnnotationInfo.getTooltip();
        }
        this.setToolTipText(tooltip);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    private static class PopupMenuListener
    extends MouseAdapter
    implements MouseListener {
        private JPopupMenu pm;
        JCheckBoxMenuItem checkBoxMenuItem;

        public PopupMenuListener() {
            SystemAction action = SystemAction.get(ShowTextAnnotationsAction.class);
            this.pm = new JPopupMenu();
            this.checkBoxMenuItem = new JCheckBoxMenuItem((Action)action);
            this.checkBoxMenuItem.setIcon(null);
            this.checkBoxMenuItem.setState(true);
            this.pm.add(this.checkBoxMenuItem);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.checkBoxMenuItem.setState(true);
                this.pm.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

