/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.storage.impl;

import java.util.Map;
import org.netbeans.modules.dlight.core.stack.api.Function;
import org.netbeans.modules.dlight.core.stack.api.FunctionCallWithMetric;
import org.netbeans.modules.dlight.core.stack.api.FunctionMetric;
import org.netbeans.modules.dlight.core.stack.utils.FunctionNameUtils;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;

class FunctionCallImpl
extends FunctionCallWithMetric {
    private final Map<FunctionMetric, Object> metrics;
    private final int lineNumber;

    FunctionCallImpl(Function function, long offset, Map<FunctionMetric, Object> metrics) {
        super(function, offset);
        this.metrics = metrics;
        SourceFileInfoProvider.SourceFileInfo sourceFileInfo = null;
        try {
            sourceFileInfo = FunctionNameUtils.getSourceFileInfo(function.getSignature());
        }
        catch (Throwable e) {
            System.err.println(e);
        }
        this.lineNumber = sourceFileInfo == null ? -1 : sourceFileInfo.getLine();
        this.setLineNumber(this.lineNumber);
    }

    FunctionCallImpl(Function function, Map<FunctionMetric, Object> metrics) {
        this(function, 0L, metrics);
    }

    @Override
    public String getDisplayedName() {
        if (this.hasLineNumber()) {
            return FunctionNameUtils.getFunctionName(this.getFunction().getSignature());
        }
        return this.getFunction().getName() + (this.hasOffset() ? "+0x" + Long.toHexString(this.getOffset()) : "");
    }

    @Override
    public Object getMetricValue(FunctionMetric metric) {
        return this.metrics.get(metric);
    }

    @Override
    public Object getMetricValue(String metric_id) {
        for (FunctionMetric metric : this.metrics.keySet()) {
            if (!metric.getMetricID().equals(metric_id)) continue;
            return this.metrics.get(metric);
        }
        return null;
    }

    @Override
    public boolean hasMetric(String metric_id) {
        for (FunctionMetric metric : this.metrics.keySet()) {
            if (!metric.getMetricID().equals(metric_id)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("FunctionCall{ function=").append(this.getFunction());
        buf.append(", metrics=").append(this.metrics).append(" }");
        return buf.toString();
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }
}

