/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.storage.impl;

import org.netbeans.modules.dlight.core.stack.api.Function;
import org.netbeans.modules.dlight.core.stack.utils.FunctionNameUtils;

class FunctionImpl
implements Function {
    private final long context_id;
    private final long id;
    private String name;
    private final String quilifiedName;
    private final String module_name;
    private final String module_offset;
    private final String source_file;

    public FunctionImpl(long id, long context_id, String name, String qualifiedName) {
        this(id, context_id, name, qualifiedName, FunctionNameUtils.getFunctionModule(qualifiedName), FunctionNameUtils.getFunctionModuleOffset(qualifiedName), FunctionNameUtils.getSourceFileInfo(qualifiedName) == null ? null : FunctionNameUtils.getSourceFileInfo(qualifiedName).getFileName());
    }

    public FunctionImpl(long id, long context_id, String name, String qualifiedName, String source_file) {
        this(id, context_id, name, qualifiedName, FunctionNameUtils.getFunctionModule(qualifiedName), FunctionNameUtils.getFunctionModuleOffset(qualifiedName), source_file);
    }

    public FunctionImpl(long id, long context_id, String name, String qualifiedName, String module_name, String module_offset, String source_file) {
        this.id = id;
        try {
            this.name = FunctionNameUtils.getFunctionName(qualifiedName);
        }
        catch (Throwable e) {
            System.err.println(e);
            this.name = qualifiedName;
        }
        this.quilifiedName = qualifiedName;
        this.module_name = module_name;
        this.module_offset = module_offset;
        this.source_file = source_file;
        this.context_id = context_id;
    }

    @Override
    public long getContextID() {
        return this.context_id;
    }

    public long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    @Override
    public String getSignature() {
        return this.quilifiedName;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getQuilifiedName() {
        return FunctionNameUtils.getFunctionQName(this.name);
    }

    @Override
    public String getModuleName() {
        return FunctionNameUtils.getFunctionModule(this.name);
    }

    String getFullName() {
        return FunctionNameUtils.getFullFunctionName(this.quilifiedName);
    }

    @Override
    public String getModuleOffset() {
        return this.module_offset;
    }

    @Override
    public String getSourceFile() {
        return this.source_file;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FunctionImpl)) {
            return false;
        }
        FunctionImpl that = (FunctionImpl)obj;
        return this.id == that.id && this.getFullName().equals(that.getFullName());
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + (this.getFullName() != null ? this.getFullName().hashCode() : 0);
        hash = 29 * hash + (int)(this.id ^ this.id >>> 32);
        return hash;
    }
}

