/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.storage.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.DataTableMetadataFilterSupport;
import org.netbeans.modules.dlight.api.storage.types.Time;
import org.netbeans.modules.dlight.core.stack.api.CallStackEntry;
import org.netbeans.modules.dlight.core.stack.api.CallStackEntryParser;
import org.netbeans.modules.dlight.core.stack.api.Function;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.FunctionCallWithMetric;
import org.netbeans.modules.dlight.core.stack.api.FunctionMetric;
import org.netbeans.modules.dlight.core.stack.api.ThreadDump;
import org.netbeans.modules.dlight.core.stack.api.ThreadDumpProvider;
import org.netbeans.modules.dlight.core.stack.api.ThreadDumpQuery;
import org.netbeans.modules.dlight.core.stack.api.ThreadSnapshot;
import org.netbeans.modules.dlight.core.stack.api.ThreadSnapshotQuery;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.core.stack.api.impl.DefaultStackParserImpl;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionDatatableDescription;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionMetricsFactory;
import org.netbeans.modules.dlight.core.stack.storage.StackDataStorage2;
import org.netbeans.modules.dlight.core.stack.storage.impl.DBProxy;
import org.netbeans.modules.dlight.core.stack.storage.impl.FunctionCallImpl;
import org.netbeans.modules.dlight.core.stack.storage.impl.FunctionImpl;
import org.netbeans.modules.dlight.core.stack.storage.impl.SQLStackRequestsProvider;
import org.netbeans.modules.dlight.core.stack.storage.impl.SnapshotImpl;
import org.netbeans.modules.dlight.core.stack.storage.impl.ThreadDumpImpl;
import org.netbeans.modules.dlight.spi.CppSymbolDemangler;
import org.netbeans.modules.dlight.spi.CppSymbolDemanglerFactory;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.storage.ProxyDataStorage;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.spi.support.SQLDataStorage;
import org.netbeans.modules.dlight.spi.support.SQLExceptions;
import org.netbeans.modules.dlight.spi.support.SQLRequestsProcessor;
import org.netbeans.modules.dlight.spi.support.SQLStatementsCache;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.Range;
import org.netbeans.modules.dlight.util.Util;
import org.openide.util.Lookup;
import org.openide.util.NotImplementedException;

public class SQLStackDataStorage
implements ProxyDataStorage,
StackDataStorage2,
ThreadDumpProvider {
    private static final Logger LOG = DLightLogger.getLogger(SQLStackDataStorage.class);
    private static final CallStackEntryParser defaultParser = new DefaultStackParserImpl();
    private final List<DataTableMetadata> tableMetadatas;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private DBProxy dbProxy;
    private SQLRequestsProcessor requestsProcessor;
    private SQLStackRequestsProvider requestsProvider;
    private SQLStatementsCache stmtCache;
    private SQLDataStorage sqlStorage;
    private CppSymbolDemangler demangler;
    private ServiceInfoDataStorage serviceInfoDataStorage;

    public SQLStackDataStorage() {
        this.tableMetadatas = new ArrayList<DataTableMetadata>();
    }

    public void syncAddData(String tableName, List<DataRow> data) {
        this.addData(tableName, data);
    }

    public final void attachTo(ServiceInfoDataStorage serviceInfoStorage) {
        this.serviceInfoDataStorage = serviceInfoStorage;
        CppSymbolDemanglerFactory factory = (CppSymbolDemanglerFactory)Lookup.getDefault().lookup(CppSymbolDemanglerFactory.class);
        this.demangler = factory == null ? null : factory.getForCurrentSession(serviceInfoStorage.getInfo());
    }

    public DataStorageType getBackendDataStorageType() {
        return DataStorageTypeFactory.getInstance().getDataStorageType("db:sql");
    }

    public List<DataTableMetadata> getBackendTablesMetadata() {
        return Collections.emptyList();
    }

    public synchronized void attachTo(DataStorage storage) {
        if (this.sqlStorage != null) {
            throw new IllegalStateException("Already attached");
        }
        this.sqlStorage = (SQLDataStorage)storage;
        this.stmtCache = SQLStatementsCache.getFor((SQLDataStorage)this.sqlStorage);
        this.requestsProvider = new SQLStackRequestsProvider(this.stmtCache);
        this.requestsProcessor = this.sqlStorage.getRequestsProcessor();
        this.dbProxy = new DBProxy(this.requestsProcessor, this.requestsProvider);
        this.initTables();
    }

    private <T extends DataFilter> Collection<T> getDataFilters(List<DataFilter> filters, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        for (DataFilter f : filters) {
            if (f.getClass() != clazz) continue;
            result.add(clazz.cast(f));
        }
        return result;
    }

    public boolean hasData(DataTableMetadata data) {
        return data.isProvidedBy(this.tableMetadatas);
    }

    public void addData(String tableName, List<DataRow> data) {
    }

    public Collection<DataStorageType> getStorageTypes() {
        return Collections.singletonList(DataStorageTypeFactory.getInstance().getDataStorageType("stack"));
    }

    public boolean supportsType(DataStorageType storageType) {
        return this.getStorageTypes().contains(storageType);
    }

    public void createTables(List<DataTableMetadata> tableMetadatas) {
        this.tableMetadatas.addAll(tableMetadatas);
    }

    public boolean shutdown(boolean shutdownSqlStorage) {
        boolean result = this.shutdown();
        if (shutdownSqlStorage) {
            result = this.sqlStorage.shutdown() && result;
        }
        return result;
    }

    public boolean shutdown() {
        if (this.closed.compareAndSet(false, true)) {
            this.dbProxy.shutdown();
            this.requestsProvider = null;
            try {
                this.stmtCache.close();
            }
            catch (SQLException ex) {
                SQLExceptions.printStackTrace((SQLDataStorage)this.sqlStorage, (SQLException)ex);
            }
            this.stmtCache = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTables() {
        InputStream is = SQLStackDataStorage.class.getClassLoader().getResourceAsStream("org/netbeans/modules/dlight/core/stack/resources/schema.sql");
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            String line;
            Pattern autoIncrementPattern = Pattern.compile("\\{AUTO_INCREMENT\\}");
            StringBuilder buf = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("-- ")) continue;
                line = autoIncrementPattern.matcher(line).replaceAll(this.sqlStorage.getAutoIncrementExpresion());
                buf.append(line);
                if (!line.endsWith(";")) continue;
                String sql = buf.toString();
                buf.setLength(0);
                String sqlToExecute = sql.substring(0, sql.length() - 1);
                try {
                    this.sqlStorage.executeUpdate(sqlToExecute);
                }
                catch (SQLException e) {
                    if (!LOG.isLoggable(Level.WARNING)) continue;
                    LOG.log(Level.WARNING, "Exception while tables initialization: {0}", e.getMessage());
                }
            }
        }
        catch (IOException e) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Exception while tables initialization: {0}", e.getMessage());
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public long putStack(long contextID, List<CharSequence> stack) {
        return this.putSample(contextID, stack, 0L, 0L);
    }

    @Override
    public long putStack(long contextID, List<CharSequence> stack, CallStackEntryParser parser) {
        return this.putSample(contextID, stack, 0L, 0L);
    }

    @Override
    public long putSample(long contextID, List<CharSequence> stack, long timestamp, long duration) {
        return this.putSample(contextID, stack, timestamp, duration, null);
    }

    @Override
    public synchronized long putSample(long contextID, List<CharSequence> stack, long timestamp, long duration, CallStackEntryParser parser) {
        if (parser == null) {
            parser = defaultParser;
        }
        long callerId = 0L;
        HashSet<Long> funcs = new HashSet<Long>();
        AtomicBoolean isNewNode = new AtomicBoolean();
        for (int i = stack.size() - 1; i >= 0; --i) {
            String stackEntry = ((Object)stack.get(i)).toString();
            CallStackEntry entry = parser.parseEntry(stackEntry);
            DBProxy.StackNode node = this.dbProxy.getNodeID(entry, callerId, isNewNode);
            if (isNewNode.get()) {
                SourceFileInfoProvider.SourceFileInfo sourceFileInfo;
                CharSequence module = entry.getModulePath();
                if (module != null) {
                    this.dbProxy.addModuleInfo(node, contextID, module, entry.getOffsetInModule());
                }
                if ((sourceFileInfo = entry.getSourceFileInfo()) != null) {
                    this.dbProxy.addSourceInfo(node, contextID, sourceFileInfo);
                }
            }
            if (duration > 0L) {
                this.dbProxy.updateFuncMetrics(node.funcID, contextID, timestamp, duration, !funcs.contains(node.funcID), i == 0);
            }
            funcs.add(node.funcID);
            callerId = node.nodeID;
        }
        if (duration > 0L) {
            this.dbProxy.updateNodeMetrics(callerId, contextID, timestamp, duration);
        }
        return callerId;
    }

    public void flush() {
        this.requestsProcessor.flush();
    }

    @Override
    public List<FunctionMetric> getMetricsList() {
        return METRICS;
    }

    @Override
    public List<FunctionCallWithMetric> getCallers(List<FunctionCallWithMetric> path, List<DataTableMetadata.Column> columns, List<DataTableMetadata.Column> orderBy, boolean aggregate) {
        throw new NotImplementedException();
    }

    @Override
    public List<FunctionCallWithMetric> getCallees(List<FunctionCallWithMetric> path, List<DataTableMetadata.Column> columns, List<DataTableMetadata.Column> orderBy, boolean aggregate) {
        throw new NotImplementedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FunctionCallWithMetric> getHotSpotFunctions(FunctionMetric metric, List<DataFilter> filters, int limit) {
        ArrayList<FunctionCallWithMetric> result = new ArrayList<FunctionCallWithMetric>();
        try {
            TimeIntervalDataFilter timeFilter = (TimeIntervalDataFilter)Util.firstInstanceOf(TimeIntervalDataFilter.class, filters);
            StringBuilder sqlQuery = new StringBuilder();
            sqlQuery.append("select func_id, fname, context_id, sum(time_incl) as time_incl, sum(time_excl) as time_excl ");
            sqlQuery.append("from funcmetrics left join funcnames on funcnames.id = funcmetrics.func_id ");
            if (timeFilter != null) {
                Range interval = timeFilter.getInterval();
                sqlQuery.append("where bucket >= ").append(DBProxy.timeToBucket((Long)interval.getStart()));
                sqlQuery.append(" and bucket <= ").append(DBProxy.timeToBucket((Long)interval.getEnd()));
            }
            sqlQuery.append(" group by func_id, fname, context_id");
            sqlQuery.append(" order by ").append(metric.getMetricID()).append(" desc");
            PreparedStatement select = this.stmtCache.getPreparedStatement(sqlQuery.toString());
            select.setMaxRows(limit);
            ResultSet rs = select.executeQuery();
            try {
                while (rs.next()) {
                    long func_id = rs.getLong(1);
                    String name = rs.getString(2);
                    long context_id = rs.getLong(3);
                    HashMap<FunctionMetric, Object> metrics = new HashMap<FunctionMetric, Object>();
                    metrics.put(FunctionMetric.CpuTimeInclusiveMetric, new Time(rs.getLong(4)));
                    metrics.put(FunctionMetric.CpuTimeExclusiveMetric, new Time(rs.getLong(5)));
                    FunctionImpl func = new FunctionImpl(func_id, context_id, name, name);
                    result.add(new FunctionCallImpl((Function)func, metrics));
                }
            }
            finally {
                rs.close();
            }
            this.demangle(result);
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FunctionCallWithMetric> getFunctionsList(DataTableMetadata metadata, List<DataTableMetadata.Column> metricsColumn, FunctionDatatableDescription functionDescription, List<DataFilter> filters) {
        ArrayList<FunctionCallWithMetric> result = new ArrayList<FunctionCallWithMetric>();
        try {
            ArrayList<FunctionMetric> metrics = new ArrayList<FunctionMetric>();
            for (DataTableMetadata.Column metricColumn : metricsColumn) {
                FunctionMetric metric = FunctionMetricsFactory.getInstance().getFunctionMetric(new FunctionMetric.FunctionMetricConfiguration(metricColumn.getColumnName(), metricColumn.getColumnUName(), metricColumn.getColumnClass()));
                metrics.add(metric);
            }
            String cFuncID = functionDescription.getFunctionIDColumnName();
            String cFuncName = functionDescription.getFunctionNameColumnName();
            String cFuncContext = functionDescription.getContextIDColumnName();
            String cOffset = functionDescription.getOffsetColumnName();
            Collection<TimeIntervalDataFilter> timeFilters = this.getDataFilters(filters, TimeIntervalDataFilter.class);
            ArrayList tableFilters = new ArrayList();
            DataTableMetadataFilterSupport filtersSupport = DataTableMetadataFilterSupport.getInstance();
            for (TimeIntervalDataFilter timeFilter : timeFilters) {
                tableFilters.addAll(filtersSupport.createFilters(metadata, timeFilter));
            }
            ResultSet rs = this.sqlStorage.select(metadata, tableFilters);
            try {
                while (rs.next()) {
                    HashMap<FunctionMetric, Object> metricValues = new HashMap<FunctionMetric, Object>();
                    for (FunctionMetric m : metrics) {
                        try {
                            rs.findColumn(m.getMetricID());
                            Object value = rs.getObject(m.getMetricID());
                            if (m.getMetricValueClass() == Time.class && value != null) {
                                value = new Time(Long.valueOf(value.toString()).longValue());
                            }
                            metricValues.put(m, value);
                        }
                        catch (SQLException ex) {
                            SQLExceptions.printStackTrace((SQLDataStorage)this.sqlStorage, (SQLException)ex);
                        }
                    }
                    long funcID = rs.getLong(cFuncID);
                    long contextID = cFuncContext == null ? -1L : rs.getLong(cFuncContext);
                    String funcName = rs.getString(cFuncName);
                    long offset = cOffset == null ? -1L : rs.getLong(cOffset);
                    FunctionImpl func = new FunctionImpl(funcID, contextID, funcName, funcName);
                    result.add(new FunctionCallImpl((Function)func, offset, metricValues));
                }
            }
            finally {
                rs.close();
            }
            this.demangle(result);
        }
        catch (SQLException ex) {
            SQLExceptions.printStackTrace((SQLDataStorage)this.sqlStorage, (SQLException)ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadSnapshot fetchSnapshot(int threadId, long timestamp, boolean fullMsa) throws SQLException {
        PreparedStatement s = this.stmtCache.getPreparedStatement("SELECT stack_id, mstate FROM CallStack WHERE thread_id = ? AND timestamp = ?");
        s.setInt(1, threadId);
        s.setLong(2, timestamp);
        ResultSet rs = s.executeQuery();
        try {
            if (rs.next()) {
                SnapshotImpl snapshotImpl = new SnapshotImpl(this, timestamp, threadId, rs.getInt(1), ThreadState.MSAState.fromCode(rs.getInt(2), fullMsa));
                return snapshotImpl;
            }
            ThreadSnapshot threadSnapshot = null;
            return threadSnapshot;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ThreadSnapshot> getThreadSnapshots(ThreadSnapshotQuery query) {
        ThreadSnapshotQuery.TimeFilter timeFilter;
        ArrayList<String> conditions = new ArrayList<String>(3);
        ThreadSnapshotQuery.ThreadFilter threadFilter = (ThreadSnapshotQuery.ThreadFilter)Util.firstInstanceOf(ThreadSnapshotQuery.ThreadFilter.class, query.getFilters());
        if (threadFilter != null) {
            StringBuilder where = new StringBuilder("thread_id IN (");
            boolean first = true;
            for (int threadId : threadFilter.getThreadIds()) {
                if (first) {
                    first = false;
                } else {
                    where.append(',');
                }
                where.append(threadId);
            }
            where.append(')');
            conditions.add(where.toString());
        }
        if ((timeFilter = (ThreadSnapshotQuery.TimeFilter)Util.firstInstanceOf(ThreadSnapshotQuery.TimeFilter.class, query.getFilters())) != null) {
            if (0L <= timeFilter.getStartTime()) {
                conditions.add(timeFilter.getStartTime() + " <= timestamp");
            }
            if (0L <= timeFilter.getEndTime()) {
                conditions.add("timestamp <= " + timeFilter.getEndTime());
            }
        }
        StringBuilder select = new StringBuilder("SELECT thread_id, ");
        if (timeFilter != null) {
            switch (timeFilter.getMode()) {
                case FIRST: {
                    select.append("MIN(timestamp) ");
                    break;
                }
                case LAST: {
                    select.append("MAX(timestamp) ");
                    break;
                }
                default: {
                    select.append("timestamp ");
                    break;
                }
            }
        } else {
            select.append("timestamp ");
        }
        select.append("FROM CallStack ");
        if (!conditions.isEmpty()) {
            select.append("WHERE ");
            boolean first = true;
            for (String condition : conditions) {
                if (first) {
                    first = false;
                } else {
                    select.append("AND ");
                }
                select.append(condition).append(' ');
            }
        }
        if (timeFilter != null && timeFilter.getMode() != ThreadSnapshotQuery.TimeFilter.Mode.ALL) {
            select.append("GROUP BY thread_id");
        }
        try {
            ArrayList<ThreadSnapshot> snapshots = new ArrayList<ThreadSnapshot>();
            ResultSet rs = this.sqlStorage.select(null, null, select.toString());
            try {
                if (rs != null) {
                    while (rs.next()) {
                        ThreadSnapshot snapshot = this.fetchSnapshot(rs.getInt(1), rs.getLong(2), query.isFullMSA());
                        if (snapshot == null) continue;
                        snapshots.add(snapshot);
                    }
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            return snapshots;
        }
        catch (SQLException ex) {
            SQLExceptions.printStackTrace((SQLDataStorage)this.sqlStorage, (SQLException)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public ThreadDump getThreadDump(ThreadDumpQuery query) {
        ThreadDump res = this._getThreadDump(query);
        if (res == null) {
            return null;
        }
        ThreadDumpImpl result = new ThreadDumpImpl(res.getTimestamp());
        block0: for (Integer i : query.getShowThreads()) {
            for (ThreadSnapshot dump : res.getThreadStates()) {
                if (dump.getThreadInfo().getThreadId() != i.intValue()) continue;
                result.addStack(dump);
                continue block0;
            }
        }
        return result;
    }

    private ThreadState.MSAState getTrueState(ThreadSnapshot dump, ThreadDumpQuery query) {
        ThreadState.MSAState state = dump.getState();
        return state;
    }

    private ThreadDump _getThreadDump(ThreadDumpQuery query) {
        long start = query.getThreadState().getTimeStamp();
        long middle = query.getThreadState().getTimeStamp() + query.getThreadState().getMSASamplePeriod() / 2L;
        long end = query.getThreadState().getTimeStamp() + query.getThreadState().getMSASamplePeriod();
        ThreadSnapshotQuery.TimeFilter time = new ThreadSnapshotQuery.TimeFilter(start, end, ThreadSnapshotQuery.TimeFilter.Mode.ALL);
        ThreadSnapshotQuery.ThreadFilter threads = new ThreadSnapshotQuery.ThreadFilter(query.getShowThreads());
        Collection res = this.getThreadSnapshots(new ThreadSnapshotQuery(query.isFullMode(), time, threads));
        ThreadSnapshot found = null;
        long foundTimeSamp = -1L;
        for (ThreadSnapshot dump : res) {
            if (query.getThreadID() != (long)dump.getThreadInfo().getThreadId() || query.getPreferredState() != this.getTrueState(dump, query)) continue;
            found = dump;
            foundTimeSamp = found.getTimestamp();
            break;
        }
        if (found == null) {
            time = new ThreadSnapshotQuery.TimeFilter(0L, middle, ThreadSnapshotQuery.TimeFilter.Mode.LAST);
            threads = new ThreadSnapshotQuery.ThreadFilter(Collections.singletonList((int)query.getThreadID()));
            Collection res2 = this.getThreadSnapshots(new ThreadSnapshotQuery(query.isFullMode(), time, threads));
            long foundAny = -1L;
            for (ThreadSnapshot dump : res2) {
                foundAny = dump.getTimestamp();
                if (query.getThreadID() != (long)dump.getThreadInfo().getThreadId() || query.getPreferredState() != this.getTrueState(dump, query)) continue;
                found = dump;
                foundTimeSamp = middle;
                break;
            }
            if (found == null && foundAny > 0L) {
                time = new ThreadSnapshotQuery.TimeFilter(foundAny - 1000000L, foundAny + 1L, ThreadSnapshotQuery.TimeFilter.Mode.ALL);
                threads = new ThreadSnapshotQuery.ThreadFilter(Collections.singletonList((int)query.getThreadID()));
                res2 = this.getThreadSnapshots(new ThreadSnapshotQuery(query.isFullMode(), time, threads));
                for (ThreadSnapshot dump : res2) {
                    foundAny = dump.getTimestamp();
                    if (query.getThreadID() != (long)dump.getThreadInfo().getThreadId() || query.getPreferredState() != this.getTrueState(dump, query)) continue;
                    found = dump;
                    foundTimeSamp = middle;
                    break;
                }
                if (found == null) {
                    for (ThreadSnapshot dump : res2) {
                        foundAny = dump.getTimestamp();
                        if (query.getThreadID() != (long)dump.getThreadInfo().getThreadId()) continue;
                        found = dump;
                        foundTimeSamp = middle;
                        break;
                    }
                }
            }
        }
        if (found != null) {
            HashMap<Integer, ThreadSnapshot> map = new HashMap<Integer, ThreadSnapshot>();
            map.put(found.getThreadInfo().getThreadId(), found);
            for (ThreadSnapshot dump : res) {
                if (dump.getThreadInfo().getThreadId() == found.getThreadInfo().getThreadId()) continue;
                int id = dump.getThreadInfo().getThreadId();
                ThreadSnapshot prev = (ThreadSnapshot)map.get(id);
                if (prev == null) {
                    map.put(id, dump);
                    continue;
                }
                if (Math.abs(prev.getTimestamp() - foundTimeSamp) <= Math.abs(dump.getTimestamp() - foundTimeSamp)) continue;
                map.put(id, dump);
            }
            HashSet<Integer> toAdd = new HashSet<Integer>(query.getShowThreads());
            ThreadDumpImpl result = new ThreadDumpImpl(foundTimeSamp);
            for (ThreadSnapshot dump : map.values()) {
                toAdd.remove(dump.getThreadInfo().getThreadId());
                result.addStack(dump);
            }
            if (!toAdd.isEmpty()) {
                time = new ThreadSnapshotQuery.TimeFilter(0L, foundTimeSamp, ThreadSnapshotQuery.TimeFilter.Mode.LAST);
                threads = new ThreadSnapshotQuery.ThreadFilter(toAdd);
                res = this.getThreadSnapshots(new ThreadSnapshotQuery(query.isFullMode(), time, threads));
                for (ThreadSnapshot dump : res) {
                    result.addStack(dump);
                }
            }
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Function getLeafFunction(long stackId) {
        StringBuilder qname = new StringBuilder();
        long nodeID = stackId;
        Function func = null;
        try {
            PreparedStatement ps = this.stmtCache.getPreparedStatement("select caller_id, func_id, offset, fname, modules.path, module_offset, sourcefiles.path, sourceinfo.fline, sourceinfo.fcolumn from stacknode left join funcnames on funcnames.id = stacknode.func_id left join moduleinfo on moduleinfo.node_id = stacknode.id left join modules on modules.id = moduleinfo.module_id left join sourceinfo on sourceinfo.node_id = stacknode.id left join sourcefiles on sourcefiles.id = sourceinfo.file_id where stacknode.id = ?");
            ps.setLong(1, nodeID);
            ResultSet rs = ps.executeQuery();
            try {
                if (rs.next()) {
                    String moduleOffset;
                    nodeID = rs.getLong(1);
                    long funcID = rs.getLong(2);
                    long offset = rs.getLong(3);
                    String funcName = rs.getString(4);
                    String module = rs.getString(5);
                    long offsetInModule = rs.getLong(6);
                    String srcFile = rs.getString(7);
                    long srcLine = rs.getLong(8);
                    long srcColumn = rs.getLong(9);
                    String string = moduleOffset = offsetInModule < 0L ? null : "0x" + Long.toHexString(offsetInModule);
                    if (module != null) {
                        qname.append(module);
                        if (moduleOffset != null) {
                            qname.append('+').append(moduleOffset);
                        }
                        qname.append('`');
                    }
                    qname.append(funcName);
                    if (offset > 0L) {
                        qname.append("+0x").append(Long.toHexString(offset));
                    }
                    if (srcFile != null) {
                        qname.append(':').append(srcFile);
                        if (srcLine > 0L) {
                            qname.append(':').append(srcLine);
                            if (srcColumn > 0L) {
                                qname.append(':').append(srcColumn);
                            }
                        }
                    }
                    func = new FunctionImpl(funcID, -1L, funcName, qname.toString(), module, moduleOffset, srcFile);
                } else {
                    func = this.dbProxy.getLeafFunction(stackId);
                }
            }
            finally {
                qname.setLength(0);
                rs.close();
            }
        }
        catch (SQLException ex) {
            SQLExceptions.printStackTrace((SQLDataStorage)this.sqlStorage, (SQLException)ex);
        }
        if (func != null) {
            this.demangle(func);
        }
        return func;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<FunctionCall> getCallStack(long stackId) {
        StringBuilder qname = new StringBuilder();
        ArrayList<FunctionCall> result = new ArrayList<FunctionCall>();
        try {
            long nodeID = stackId;
            while (0L < nodeID) {
                PreparedStatement ps = this.stmtCache.getPreparedStatement("select caller_id, func_id, offset, fname, modules.path, module_offset, sourcefiles.path, sourceinfo.fline, sourceinfo.fcolumn from stacknode left join funcnames on funcnames.id = stacknode.func_id left join moduleinfo on moduleinfo.node_id = stacknode.id left join modules on modules.id = moduleinfo.module_id left join sourceinfo on sourceinfo.node_id = stacknode.id left join sourcefiles on sourcefiles.id = sourceinfo.file_id where stacknode.id = ?");
                ps.setLong(1, nodeID);
                ResultSet rs = ps.executeQuery();
                try {
                    if (rs.next()) {
                        String moduleOffset;
                        nodeID = rs.getLong(1);
                        long funcID = rs.getLong(2);
                        long offset = rs.getLong(3);
                        String funcName = rs.getString(4);
                        String module = rs.getString(5);
                        long offsetInModule = rs.getLong(6);
                        String srcFile = rs.getString(7);
                        long srcLine = rs.getLong(8);
                        long srcColumn = rs.getLong(9);
                        String string = moduleOffset = offsetInModule < 0L ? null : "0x" + Long.toHexString(offsetInModule);
                        if (module != null) {
                            qname.append(module);
                            if (moduleOffset != null) {
                                qname.append('+').append(moduleOffset);
                            } else {
                                qname.append('+').append("0x0");
                            }
                            qname.append('`');
                        }
                        qname.append(funcName);
                        if (offset > 0L) {
                            qname.append("+0x").append(Long.toHexString(offset));
                        } else {
                            qname.append('+').append("0x0");
                        }
                        if (srcFile != null) {
                            qname.append(':').append(srcFile);
                            if (srcLine >= 0L) {
                                qname.append(':').append(srcLine);
                                if (srcColumn >= 0L) {
                                    qname.append(':').append(srcColumn);
                                }
                            }
                        }
                        FunctionImpl func = new FunctionImpl(funcID, -1L, funcName, qname.toString(), module, moduleOffset, srcFile);
                        result.add(new FunctionCallImpl((Function)func, offset, Collections.<FunctionMetric, Object>emptyMap()));
                        continue;
                    }
                    break;
                }
                finally {
                    qname.setLength(0);
                    rs.close();
                }
            }
        }
        catch (SQLException ex) {
            SQLExceptions.printStackTrace((SQLDataStorage)this.sqlStorage, (SQLException)ex);
        }
        this.demangle(result);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void demangle(List<? extends FunctionCall> calls) {
        if (this.demangler != null) {
            void var4_6;
            ArrayList<String> mangled = new ArrayList<String>(calls.size());
            for (FunctionCall functionCall : calls) {
                mangled.add(functionCall.getFunction().getName());
            }
            List demangled = this.demangler.demangle(mangled);
            boolean bl = false;
            while (var4_6 < calls.size()) {
                ((FunctionImpl)calls.get((int)var4_6).getFunction()).setName((String)demangled.get((int)var4_6));
                ++var4_6;
            }
        }
    }

    private void demangle(Function f) {
        if (this.demangler != null) {
            String demangled = this.demangler.demangle(f.getName());
            ((FunctionImpl)f).setName(demangled);
        }
    }
}

