/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.storage.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.netbeans.modules.dlight.core.stack.storage.impl.MetricsCache;
import org.netbeans.modules.dlight.spi.support.SQLRequest;
import org.netbeans.modules.dlight.spi.support.SQLStatementsCache;

final class SQLStackRequestsProvider {
    private static final int MAX_STRING_LENGTH = 16384;
    private final SQLStatementsCache cache;
    private final MetricsCache metricsCache;

    public SQLStackRequestsProvider(SQLStatementsCache cache) {
        this.cache = cache;
        this.metricsCache = new MetricsCache();
    }

    public SQLRequest addNode(long nodeID, long callerID, long funcID, long offset) {
        return new AddNodeRequest(nodeID, callerID, funcID, offset);
    }

    SQLRequest updateNodeMetrics(long nodeID, long contextID, long bucket, long duration) {
        this.metricsCache.updateNodeMetrics(nodeID, contextID, bucket, duration, false, true);
        return new UpdateNodeMetricsRequest(nodeID, contextID, bucket);
    }

    SQLRequest updateFunctionMetrics(long funcID, long contextID, long bucket, long duration, boolean addInclusive, boolean addExclusive) {
        this.metricsCache.updateFunctionMetrics(funcID, contextID, bucket, duration, addInclusive, addExclusive);
        return new UpdateFuncMetricsRequest(funcID, contextID, bucket);
    }

    SQLRequest addFunction(long funcID, CharSequence funcName) {
        return new AddFunctionRequest(funcID, funcName);
    }

    SQLRequest addFile(Long fileID, CharSequence path) {
        return new AddFileRequest(fileID, path);
    }

    SQLRequest addSourceInfo(long nodeID, long contextID, long fileID, int line, int column, long fileOffset) {
        return new AddSourceInfoRequest(nodeID, contextID, fileID, line, column, fileOffset);
    }

    SQLRequest addModule(Long moduleID, CharSequence module) {
        return new AddModuleRequest(moduleID, module);
    }

    SQLRequest addModuleInfo(long nodeID, long contextID, long moduleID, long offsetInModule) {
        return new AddModuleInfoRequest(nodeID, contextID, moduleID, offsetInModule);
    }

    private static CharSequence truncate(CharSequence str) {
        if (str.length() <= 16384) {
            return str;
        }
        return str.subSequence(0, 16381) + "...";
    }

    private class UpdateFuncMetricsRequest
    implements SQLRequest {
        private final long funcID;
        private final long contextID;
        private final long bucket;

        private UpdateFuncMetricsRequest(long funcID, long contextID, long bucket) {
            this.funcID = funcID;
            this.contextID = contextID;
            this.bucket = bucket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() throws SQLException {
            MetricsCache.Metrics metrics = SQLStackRequestsProvider.this.metricsCache.getAndResetFunctionMetrics(this.funcID, this.contextID, this.bucket);
            if (metrics == null || metrics.incl == 0L && metrics.excl == 0L) {
                return;
            }
            PreparedStatement stmt = SQLStackRequestsProvider.this.cache.getPreparedStatement("select func_id, context_id, bucket, time_incl, time_excl from FuncMetrics where func_id = ? and context_id = ? and bucket = ? for update");
            stmt.setLong(1, this.funcID);
            stmt.setLong(2, this.contextID);
            stmt.setLong(3, this.bucket);
            ResultSet rs = stmt.executeQuery();
            try {
                if (rs.next()) {
                    rs.updateLong(4, rs.getLong(4) + metrics.incl);
                    rs.updateLong(5, rs.getLong(5) + metrics.excl);
                    rs.updateRow();
                } else {
                    rs.moveToInsertRow();
                    rs.updateLong(1, this.funcID);
                    rs.updateLong(2, this.contextID);
                    rs.updateLong(3, this.bucket);
                    rs.updateLong(4, metrics.incl);
                    rs.updateLong(5, metrics.excl);
                    rs.insertRow();
                }
            }
            finally {
                rs.close();
            }
        }
    }

    private class UpdateNodeMetricsRequest
    implements SQLRequest {
        private final long nodeID;
        private final long contextID;
        private final long bucket;

        private UpdateNodeMetricsRequest(long nodeID, long contextID, long bucket) {
            this.nodeID = nodeID;
            this.contextID = contextID;
            this.bucket = bucket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() throws SQLException {
            MetricsCache.Metrics metrics = SQLStackRequestsProvider.this.metricsCache.getAndResetNodeMetrics(this.nodeID, this.contextID, this.bucket);
            if (metrics == null || metrics.incl == 0L && metrics.excl == 0L) {
                return;
            }
            PreparedStatement stmt = SQLStackRequestsProvider.this.cache.getPreparedStatement("select node_id, context_id, bucket, time_excl from NodeMetrics where node_id = ? and context_id = ? and bucket = ? for update");
            stmt.setLong(1, this.nodeID);
            stmt.setLong(2, this.contextID);
            stmt.setLong(3, this.bucket);
            ResultSet rs = stmt.executeQuery();
            try {
                if (rs.next()) {
                    rs.updateLong(4, rs.getLong(4) + metrics.excl);
                    rs.updateRow();
                } else {
                    rs.moveToInsertRow();
                    rs.updateLong(1, this.nodeID);
                    rs.updateLong(2, this.contextID);
                    rs.updateLong(3, this.bucket);
                    rs.updateLong(4, metrics.excl);
                    rs.insertRow();
                }
            }
            finally {
                rs.close();
            }
        }
    }

    private class AddFunctionRequest
    implements SQLRequest {
        public final long funcID;
        public final CharSequence name;

        private AddFunctionRequest(long funcID, CharSequence name) {
            this.funcID = funcID;
            this.name = name;
        }

        public void execute() throws SQLException {
            PreparedStatement stmt = SQLStackRequestsProvider.this.cache.getPreparedStatement("insert into funcnames (id, fname) values (?, ?)");
            stmt.setLong(1, this.funcID);
            stmt.setString(2, ((Object)SQLStackRequestsProvider.truncate(this.name)).toString());
            stmt.executeUpdate();
        }
    }

    private class AddNodeRequest
    implements SQLRequest {
        public final long nodeID;
        public final long callerId;
        public final long funcID;
        public final long offset;

        public AddNodeRequest(long nodeID, long callerId, long funcID, long offset) {
            this.nodeID = nodeID;
            this.callerId = callerId;
            this.funcID = funcID;
            this.offset = offset;
        }

        public void execute() throws SQLException {
            PreparedStatement stmt = SQLStackRequestsProvider.this.cache.getPreparedStatement("insert into StackNode (id, caller_id, func_id, offset) values (?, ?, ?, ?)");
            stmt.setLong(1, this.nodeID);
            stmt.setLong(2, this.callerId);
            stmt.setLong(3, this.funcID);
            stmt.setLong(4, this.offset);
            stmt.executeUpdate();
        }
    }

    private class AddModuleRequest
    implements SQLRequest {
        private final Long moduleID;
        private final CharSequence module;

        private AddModuleRequest(Long moduleID, CharSequence module) {
            this.moduleID = moduleID;
            this.module = module;
        }

        public void execute() throws SQLException {
            PreparedStatement stmt = SQLStackRequestsProvider.this.cache.getPreparedStatement("insert into modules (id, path) values (?, ?)");
            stmt.setLong(1, this.moduleID);
            stmt.setString(2, ((Object)SQLStackRequestsProvider.truncate(this.module)).toString());
            stmt.executeUpdate();
        }
    }

    private class AddFileRequest
    implements SQLRequest {
        private final Long fileID;
        private final CharSequence path;

        private AddFileRequest(Long fileID, CharSequence path) {
            this.fileID = fileID;
            this.path = path;
        }

        public void execute() throws SQLException {
            PreparedStatement stmt = SQLStackRequestsProvider.this.cache.getPreparedStatement("insert into sourcefiles (id, path) values (?, ?)");
            stmt.setLong(1, this.fileID);
            stmt.setString(2, ((Object)SQLStackRequestsProvider.truncate(this.path)).toString());
            stmt.executeUpdate();
        }
    }

    private class AddModuleInfoRequest
    implements SQLRequest {
        private final long nodeID;
        private final long contextID;
        private final long moduleID;
        private final long offsetInModule;

        private AddModuleInfoRequest(long nodeID, long contextID, long moduleID, long offsetInModule) {
            this.nodeID = nodeID;
            this.contextID = contextID;
            this.moduleID = moduleID;
            this.offsetInModule = offsetInModule;
        }

        public void execute() throws SQLException {
            PreparedStatement stmt = SQLStackRequestsProvider.this.cache.getPreparedStatement("insert into moduleinfo (node_id, context_id, module_id, module_offset) values (?,?,?,?)");
            stmt.setLong(1, this.nodeID);
            stmt.setLong(2, this.contextID);
            stmt.setLong(3, this.moduleID);
            stmt.setLong(4, this.offsetInModule);
            stmt.executeUpdate();
        }
    }

    private class AddSourceInfoRequest
    implements SQLRequest {
        private final long nodeID;
        private final long contextID;
        private final long fileID;
        private final int line;
        private final int column;
        private final long fileOffset;

        private AddSourceInfoRequest(long nodeID, long contextID, long fileID, int line, int column, long fileOffset) {
            this.nodeID = nodeID;
            this.contextID = contextID;
            this.fileID = fileID;
            this.line = line;
            this.column = column;
            this.fileOffset = fileOffset;
        }

        public void execute() throws SQLException {
            PreparedStatement stmt = SQLStackRequestsProvider.this.cache.getPreparedStatement("insert into sourceinfo (node_id, context_id, file_id, fline, fcolumn, file_offset) values (?,?,?,?,?,?)");
            stmt.setLong(1, this.nodeID);
            stmt.setLong(2, this.contextID);
            stmt.setLong(3, this.fileID);
            stmt.setInt(4, this.line);
            stmt.setInt(5, this.column);
            stmt.setLong(6, this.fileOffset);
            stmt.executeUpdate();
        }
    }
}

