/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.refactoring.spi.BackupFacility;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public abstract class RenameTransaction
implements Transaction {
    private final Set<FileObject> files;
    protected final String origName;
    protected final String newName;
    private final List<BackupFacility.Handle> handles = new ArrayList<BackupFacility.Handle>();
    private boolean committed;

    public RenameTransaction(Set<FileObject> fileObjects, String oldName, String newName) {
        this.files = fileObjects;
        this.origName = oldName;
        this.newName = newName;
    }

    public Set<FileObject> getToBeModifiedFiles() {
        return this.files;
    }

    public String getOriginalName() {
        return this.origName;
    }

    public String getNewName() {
        return this.newName;
    }

    public void commit() {
        if (this.committed) {
            this.restore();
        } else {
            try {
                this.handles.add(BackupFacility.getDefault().backup(this.files));
                this.doChanges();
                this.committed = true;
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    public void rollback() {
        this.restore();
    }

    private void restore() {
        for (BackupFacility.Handle handle : this.handles) {
            try {
                handle.restore();
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    public abstract void doChanges();
}

