/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.simpleunit.codegeneration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.services.CsmIncludeResolver;
import org.netbeans.modules.cnd.simpleunit.utils.CodeGenerationUtils;
import org.netbeans.modules.cnd.utils.FSPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeGenerator {
    private CodeGenerator() {
    }

    public static Map<String, Object> generateTemplateParamsForFunctions(String testName, FSPath testFilePath, List<CsmFunction> functions, Language lang) {
        HashMap<String, Object> templateParams = new HashMap<String, Object>();
        if (functions != null) {
            StringBuilder testFunctions = new StringBuilder("");
            StringBuilder testCalls = new StringBuilder("");
            StringBuilder testIncludes = new StringBuilder("");
            ArrayList<String> testFunctionsNames = new ArrayList<String>();
            ArrayList<String> addedTestIncludes = new ArrayList<String>();
            for (CsmFunction fun : functions) {
                CsmIncludeResolver inclResolver = CsmIncludeResolver.getDefault();
                String include = inclResolver.getLocalIncludeDerectiveByFilePath(testFilePath, (CsmObject)fun);
                if (!include.isEmpty()) {
                    if (!addedTestIncludes.contains(include)) {
                        testIncludes.append(include);
                        testIncludes.append("\n");
                    }
                    addedTestIncludes.add(include);
                } else {
                    testFunctions.append(CodeGenerationUtils.generateFunctionDeclaration(fun));
                    testFunctions.append("\n\n");
                }
                String funName = ((Object)fun.getName()).toString();
                String testFunctionName = "test" + Character.toUpperCase(funName.charAt(0)) + funName.substring(1);
                if (testFunctionsNames.contains(testFunctionName)) {
                    int i = 2;
                    while (testFunctionsNames.contains(testFunctionName + i)) {
                        ++i;
                    }
                    testFunctionName = testFunctionName + i;
                }
                testFunctionsNames.add(testFunctionName);
                testFunctions.append("void ").append(testFunctionName).append("() {\n");
                Collection params = fun.getParameters();
                int i = 0;
                for (CsmParameter param : params) {
                    testFunctions.append("    ");
                    testFunctions.append(CodeGenerationUtils.generateParameterDeclaration(param, i));
                    testFunctions.append("\n");
                    ++i;
                }
                testFunctions.append(CodeGenerationUtils.generateFunctionCall(fun));
                if (lang == Language.CPP) {
                    testFunctions.append("    if(true /*check result*/) {\n");
                    testFunctions.append("        std::cout << \"%TEST_FAILED% time=0 testname=").append(testFunctionName).append(" (").append(testName).append(") message=error message sample\" << std::endl;\n");
                } else {
                    testFunctions.append("    if(1 /*check result*/) {\n");
                    testFunctions.append("        printf(\"%%TEST_FAILED%% time=0 testname=").append(testFunctionName).append(" (").append(testName).append(") message=error message sample\\n\");\n");
                }
                testFunctions.append("    }\n");
                testFunctions.append("}\n\n");
                if (lang == Language.CPP) {
                    testCalls.append("    std::cout << \"%TEST_STARTED% " + testFunctionName + " (" + testName + ")\" << std::endl;\n");
                    testCalls.append("    " + testFunctionName + "();\n");
                    testCalls.append("    std::cout << \"%TEST_FINISHED% time=0 " + testFunctionName + " (" + testName + ")\" << std::endl;\n");
                    testCalls.append("    \n");
                    continue;
                }
                testCalls.append("    printf(\"%%TEST_STARTED%%  " + testFunctionName + " (" + testName + ")\\n\");\n");
                testCalls.append("    " + testFunctionName + "();\n");
                testCalls.append("    printf(\"%%TEST_FINISHED%% time=0 " + testFunctionName + " (" + testName + ")\\n\");\n");
                testCalls.append("    \n");
            }
            templateParams.put("testFunctions", testFunctions.toString());
            templateParams.put("testCalls", testCalls.toString());
            templateParams.put("testIncludes", testIncludes.toString());
        }
        return templateParams;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Language {
        C,
        CPP;

    }
}

