/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Color;
import java.awt.font.TextLayout;
import java.util.logging.Logger;
import org.netbeans.modules.editor.lib2.view.TextLayoutUtils;
import org.netbeans.modules.editor.lib2.view.TextLayoutWrapper;
import org.netbeans.modules.editor.lib2.view.ViewUtils;

final class TextLayoutPart {
    private static final Logger LOG = Logger.getLogger(TextLayoutPart.class.getName());
    private final TextLayoutWrapper wrapper;
    private final int index;
    private final int offsetShift;
    private final Color foreground;
    private final Color background;

    TextLayoutPart(TextLayoutWrapper wrapper, int index, int offsetShift, Color foreground, Color background) {
        this.wrapper = wrapper;
        this.index = index;
        this.offsetShift = offsetShift;
        this.foreground = foreground;
        this.background = background;
    }

    TextLayout textLayout() {
        return this.wrapper.textLayout();
    }

    int viewCount() {
        return this.wrapper.viewCount();
    }

    Color textLayoutForeground() {
        return this.wrapper.foreground();
    }

    Color textLayoutBackground() {
        return this.wrapper.background();
    }

    float textLayoutWidth() {
        return Math.abs(TextLayoutUtils.getWidth(this.textLayout()));
    }

    Color foreground() {
        return this.foreground;
    }

    Color background() {
        return this.background;
    }

    Color realBackground() {
        return this.background != null ? this.background : this.wrapper.background();
    }

    int index() {
        return this.index;
    }

    int offsetShift() {
        return this.offsetShift;
    }

    boolean isLast() {
        return this.index() == this.viewCount() - 1;
    }

    public String toStringShort() {
        return "[" + this.index + "#" + this.viewCount() + "]<" + this.offsetShift + ">;fC=" + ViewUtils.toString(this.foreground) + ";bC=" + ViewUtils.toString(this.background);
    }

    public String toString() {
        return this.toStringShort() + " in " + this.wrapper;
    }
}

