/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelui.trace;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Action;
import javax.swing.text.Document;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelui.trace.TestProjectActionBase;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class TestErrorHighlightingAction
extends TestProjectActionBase {
    @Override
    protected void performAction(Collection<CsmProject> projects) {
        if (projects != null) {
            for (CsmProject p : projects) {
                try {
                    this.testProject(p);
                }
                catch (Exception e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        }
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_TestErrorHighlighting");
    }

    public static Action getInstance() {
        return (Action)SharedClassObject.findObject(TestErrorHighlightingAction.class, (boolean)true);
    }

    private void testProject(CsmProject csmProject) {
        String taskName = "Testing Error Highlighting - " + csmProject.getName();
        InputOutput io = IOProvider.getDefault().getIO(taskName, false);
        io.select();
        OutputWriter out = io.getOut();
        OutputWriter err = io.getErr();
        final AtomicBoolean canceled = new AtomicBoolean(false);
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)taskName, (Cancellable)new Cancellable(){

            public boolean cancel() {
                canceled.set(true);
                return true;
            }
        });
        handle.start();
        long time = System.currentTimeMillis();
        BaseStatistics[] statistics = new BaseStatistics[]{new MessageStatistics(), new FileStatistics(csmProject)};
        if (!csmProject.isStable(null)) {
            out.printf("Waiting until the project is parsed", new Object[0]);
            csmProject.waitParse();
        }
        Collection files = csmProject.getAllFiles();
        handle.switchToDeterminate(files.size());
        int processed = 0;
        for (CsmFile file : files) {
            handle.progress(((Object)file.getName()).toString(), processed++);
            if (canceled.get()) break;
            this.testFile(file, out, err, canceled, statistics);
        }
        handle.finish();
        out.printf("%s\n", new Object[]{canceled.get() ? "Cancelled" : "Done"});
        out.printf("%s took %d ms\n", new Object[]{taskName, System.currentTimeMillis() - time});
        for (int i = 0; i < statistics.length; ++i) {
            statistics[i].print(out);
        }
        err.flush();
        out.flush();
        err.close();
        out.close();
    }

    private void testFile(final CsmFile file, OutputWriter out, final OutputWriter err, AtomicBoolean cancelled, final BaseStatistics[] statistics) {
        for (int i = 0; i < statistics.length; ++i) {
            statistics[i].startFile(file);
        }
        RequestImpl request = new RequestImpl(file, cancelled);
        final LineConverter lineConv = new LineConverter(file);
        long time = System.currentTimeMillis();
        out.printf("\nChecking file %s    %s\n", new Object[]{file.getName(), file.getAbsolutePath()});
        final AtomicInteger cnt = new AtomicInteger(0);
        CsmErrorProvider.Response response = new CsmErrorProvider.Response(){

            public void addError(CsmErrorInfo errorInfo) {
                if (errorInfo.getSeverity() == CsmErrorInfo.Severity.ERROR) {
                    TestErrorHighlightingAction.this.reportError(file, errorInfo, err, lineConv);
                    for (int i = 0; i < statistics.length; ++i) {
                        statistics[i].consume(file, errorInfo);
                    }
                    cnt.incrementAndGet();
                }
            }

            public void done() {
            }
        };
        CsmErrorProvider.getDefault().getErrors((CsmErrorProvider.Request)request, response);
        out.printf("Error count %d for file %s. The check took %d ms\n", new Object[]{cnt.get(), file.getName(), System.currentTimeMillis() - time});
    }

    private static OutputListener getOutputListener(CsmFile file, CsmErrorInfo errorInfo) {
        final OffsetableImpl dummyCsmObject = new OffsetableImpl(file, errorInfo);
        return new OutputAdapter(){

            @Override
            public void outputLineAction(OutputEvent ev) {
                CsmUtilities.openSource((CsmObject)dummyCsmObject);
            }
        };
    }

    private void reportError(CsmFile file, CsmErrorInfo errorInfo, OutputWriter err, LineConverter lineConv) {
        LineColumn lc = lineConv.getLineColumn(errorInfo.getStartOffset());
        String text = String.format("%s: %s %d:%d in %s", errorInfo.getSeverity(), errorInfo.getMessage(), lc.line, lc.column, file.getName());
        try {
            err.println(text, TestErrorHighlightingAction.getOutputListener(file, errorInfo));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static int getLineCount(CsmFile file) {
        try {
            char[] charBuffer = ((FileImpl)file).getBuffer().getCharBuffer();
            return ((FileImpl)file).getBuffer().getLineColumnByOffset(charBuffer.length)[0];
        }
        catch (IOException ex) {
            return 1;
        }
    }

    private static class FileStatistics
    extends BaseStatistics {
        private CsmProject project;
        private int totalLineCount = 0;

        public FileStatistics(CsmProject project) {
            this.project = project;
        }

        @Override
        protected String getTitle() {
            return "Statistics by file\n  Errors    %    Lines   Per 1K lines";
        }

        @Override
        protected CharSequence getId(CsmFile file, CsmErrorInfo info) {
            return file.getAbsolutePath();
        }

        @Override
        protected BaseStatistics.Element createEntry(CsmFile file, CsmErrorInfo info) {
            return new FileElement(file);
        }

        @Override
        public void startFile(CsmFile file) {
            this.getCreateEntry(file, null);
        }

        @Override
        protected void printTotal(OutputWriter out) {
            float ratio = (float)this.total * 1000.0f / (float)this.totalLineCount;
            out.printf("%8d      %8d %8.2f \n", new Object[]{this.total, this.totalLineCount, Float.valueOf(ratio)});
            out.printf("TOTAL for %s:\n%d errors    %d lines    %d files    %.2f errors per 1K lines \n\n", new Object[]{this.project.getName(), this.total, this.totalLineCount, this.data.size(), Float.valueOf(ratio)});
        }

        private class FileElement
        extends BaseStatistics.Element {
            private int lineCount;

            public FileElement(CsmFile file) {
                super(file);
                this.lineCount = TestErrorHighlightingAction.getLineCount(file);
                FileStatistics.this.totalLineCount += this.lineCount;
            }

            @Override
            protected OutputListener getOutputListener() {
                return new OutputAdapter(){

                    @Override
                    public void outputLineAction(OutputEvent ev) {
                        CsmFile file = FileElement.this.getFile();
                        if (file != null) {
                            CsmUtilities.openSource((CsmFile)file, (int)0, (int)0);
                        }
                    }
                };
            }

            @Override
            protected String formatMessage(CharSequence key) {
                int percent = this.cnt * 100 / FileStatistics.this.total;
                float ratio = (float)this.cnt * 1000.0f / (float)this.lineCount;
                String text = String.format("%8d  %2d%% %8d %8.2f  %s", this.cnt, percent, this.lineCount, Float.valueOf(ratio), key);
                return text;
            }
        }
    }

    private static class MessageStatistics
    extends BaseStatistics {
        private MessageStatistics() {
        }

        @Override
        protected String getTitle() {
            return "Statistics by message";
        }

        @Override
        protected CharSequence getId(CsmFile file, CsmErrorInfo info) {
            return info.getMessage();
        }

        @Override
        protected BaseStatistics.Element createEntry(CsmFile file, CsmErrorInfo info) {
            return new MessageElement(file, info);
        }

        private class MessageElement
        extends BaseStatistics.Element {
            private CsmErrorInfo info;

            public MessageElement(CsmFile file, CsmErrorInfo info) {
                super(file);
                this.info = info;
            }

            @Override
            public OutputListener getOutputListener() {
                return TestErrorHighlightingAction.getOutputListener(this.getFile(), this.info);
            }
        }
    }

    private static abstract class BaseStatistics {
        protected Map<CharSequence, Element> data = new HashMap<CharSequence, Element>();
        protected int total = 0;

        private BaseStatistics() {
        }

        protected abstract String getTitle();

        protected abstract CharSequence getId(CsmFile var1, CsmErrorInfo var2);

        protected abstract Element createEntry(CsmFile var1, CsmErrorInfo var2);

        public void startFile(CsmFile file) {
        }

        public void consume(CsmFile file, CsmErrorInfo info) {
            this.getCreateEntry(file, info).consume();
        }

        protected Element getCreateEntry(CsmFile file, CsmErrorInfo info) {
            CharSequence id = this.getId(file, info);
            Element entry = this.data.get(id);
            if (entry == null) {
                entry = this.createEntry(file, info);
                this.data.put(id, entry);
            }
            return entry;
        }

        public void print(OutputWriter out) {
            Map.Entry entry;
            Element element;
            out.printf("\n%s\n", new Object[]{this.getTitle()});
            ArrayList<Map.Entry<CharSequence, Element>> entries = new ArrayList<Map.Entry<CharSequence, Element>>(this.data.entrySet());
            Collections.sort(entries, new Comparator<Map.Entry<CharSequence, Element>>(){

                @Override
                public int compare(Map.Entry<CharSequence, Element> o1, Map.Entry<CharSequence, Element> o2) {
                    return o2.getValue().getCount() - o1.getValue().getCount();
                }
            });
            Iterator i$ = entries.iterator();
            while (i$.hasNext() && (element = (Element)(entry = (Map.Entry)i$.next()).getValue()).getCount() > 0) {
                element.print(out, this.total, (CharSequence)entry.getKey());
            }
            this.printTotal(out);
        }

        protected void printTotal(OutputWriter out) {
            out.printf("%8d TOTAL\n", new Object[]{this.total});
        }

        protected abstract class Element {
            protected int cnt;
            private CsmUID<CsmFile> fileUID;

            protected Element(CsmFile file) {
                this.fileUID = UIDs.get((Object)file);
            }

            protected abstract OutputListener getOutputListener();

            protected CsmFile getFile() {
                return (CsmFile)this.fileUID.getObject();
            }

            public void consume() {
                ++this.cnt;
                ++BaseStatistics.this.total;
            }

            public int getCount() {
                return this.cnt;
            }

            public void print(OutputWriter out, int total, CharSequence key) {
                try {
                    out.println(this.formatMessage(key), this.getOutputListener());
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }

            protected String formatMessage(CharSequence key) {
                int percent = this.cnt * 100 / BaseStatistics.this.total;
                String text = String.format("%8d  %2d%%  %s", this.cnt, percent, key);
                return text;
            }
        }
    }

    private static class LineConverter {
        private final CsmFile file;

        public LineConverter(CsmFile file) {
            this.file = file;
        }

        public LineColumn getLineColumn(int offset) {
            try {
                int[] lineColumnByOffset = ((FileImpl)this.file).getBuffer().getLineColumnByOffset(offset);
                return new LineColumn(lineColumnByOffset[0], lineColumnByOffset[1]);
            }
            catch (IOException ex) {
                return new LineColumn(1, 1);
            }
        }
    }

    private static class LineColumn {
        public final int line;
        public final int column;

        public LineColumn(int line, int column) {
            this.line = line;
            this.column = column;
        }
    }

    private static class RequestImpl
    implements CsmErrorProvider.Request {
        private CsmFile file;
        private AtomicBoolean cancelled;

        public RequestImpl(CsmFile file, AtomicBoolean cancelled) {
            this.file = file;
            this.cancelled = cancelled;
        }

        public CsmFile getFile() {
            return this.file;
        }

        public boolean isCancelled() {
            return this.cancelled.get();
        }

        public Document getDocument() {
            return null;
        }
    }

    private static class OffsetableImpl
    implements CsmOffsetable {
        private CsmUID<CsmFile> fileUID;
        private CsmErrorInfo errorInfo;

        public OffsetableImpl(CsmFile file, CsmErrorInfo errorInfo) {
            this.fileUID = UIDs.get((Object)file);
            this.errorInfo = errorInfo;
        }

        public CsmFile getContainingFile() {
            return (CsmFile)this.fileUID.getObject();
        }

        public int getEndOffset() {
            return this.errorInfo.getEndOffset();
        }

        public CsmOffsetable.Position getEndPosition() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getStartOffset() {
            return this.errorInfo.getEndOffset();
        }

        public CsmOffsetable.Position getStartPosition() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public CharSequence getText() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class OutputAdapter
    implements OutputListener {
        private OutputAdapter() {
        }

        public void outputLineAction(OutputEvent ev) {
        }

        public void outputLineCleared(OutputEvent ev) {
        }

        public void outputLineSelected(OutputEvent ev) {
        }
    }
}

