/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class InstancePropertiesImpl
extends InstanceProperties
implements InstanceListener {
    private final String url;
    private transient FileObject fo;

    public InstancePropertiesImpl(ServerInstance instance) {
        this(instance.getUrl());
    }

    public InstancePropertiesImpl(String url) {
        this.url = url;
    }

    private FileObject getFO() {
        if (this.fo == null) {
            ServerInstance instance = ServerRegistry.getInstance().getServerInstance(this.url);
            if (instance == null) {
                throw new IllegalStateException(NbBundle.getMessage(InstancePropertiesImpl.class, (String)"MSG_InstanceNotExists", (Object)this.url));
            }
            ServerRegistry.getInstance();
            this.fo = ServerRegistry.getInstanceFileObject(this.url);
            if (this.fo == null) {
                throw new IllegalStateException(NbBundle.getMessage(InstancePropertiesImpl.class, (String)"MSG_InstanceNotExists", (Object)this.url));
            }
        }
        return this.fo;
    }

    @Override
    public void instanceRemoved(String instance) {
        if (instance != null && this.url.equals(instance)) {
            this.fo = null;
        }
    }

    @Override
    public void instanceAdded(String instance) {
    }

    public void changeDefaultInstance(String oldInstance, String newInstance) {
    }

    @Override
    public String getProperty(String propname) throws IllegalStateException {
        String propString;
        Object propValue = this.getFO().getAttribute(propname);
        String string = propString = propValue == null ? null : propValue.toString();
        if ("password".equals(propname) && propValue == null) {
            propString = ServerRegistry.readPassword(this.url);
        }
        return propString;
    }

    @Override
    public Enumeration propertyNames() throws IllegalStateException {
        return this.getFO().getAttributes();
    }

    @Override
    public void setProperty(String propname, String value) throws IllegalStateException {
        try {
            String oldValue = this.getProperty(propname);
            if ("password".equals(propname)) {
                ServerRegistry.savePassword(this.url, value, NbBundle.getMessage(InstancePropertiesImpl.class, (String)"MSG_KeyringDefaultDisplayName"));
                this.getFO().setAttribute(propname, null);
            } else {
                this.getFO().setAttribute(propname, (Object)value);
            }
            this.firePropertyChange(new PropertyChangeEvent(this, propname, oldValue, value));
        }
        catch (IOException ioe) {
            String message = NbBundle.getMessage(InstancePropertiesImpl.class, (String)"MSG_InstanceNotExists", (Object)this.url);
            throw new IllegalStateException(Exceptions.attachLocalizedMessage((Throwable)ioe, (String)message));
        }
    }

    @Override
    public void setProperties(Properties props) throws IllegalStateException {
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            String propValue = props.getProperty(propName);
            this.setProperty(propName, propValue);
        }
    }

    @Override
    public javax.enterprise.deploy.spi.DeploymentManager getDeploymentManager() {
        boolean assertsEnabled = false;
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertsEnabled) {
            return new DeploymentManager();
        }
        return InstancePropertiesImpl.getDeploymentManager(this.url);
    }

    @Override
    public void refreshServerInstance() {
        ServerRegistry registry = ServerRegistry.getInstance();
        ServerInstance inst = registry.getServerInstance(this.url);
        if (inst != null) {
            inst.refresh();
        }
    }

    private static javax.enterprise.deploy.spi.DeploymentManager getDeploymentManager(String url) {
        ServerRegistry registry = ServerRegistry.getInstance();
        ServerInstance inst = registry.getServerInstance(url);
        return inst.getDeploymentManager();
    }

    private class DeploymentManager
    implements javax.enterprise.deploy.spi.DeploymentManager {
        private javax.enterprise.deploy.spi.DeploymentManager dm;

        private DeploymentManager() {
        }

        public ProgressObject undeploy(TargetModuleID[] tmids) throws IllegalStateException {
            return this.getDeploymentManager().undeploy(tmids);
        }

        public ProgressObject stop(TargetModuleID[] tmids) throws IllegalStateException {
            return this.getDeploymentManager().stop(tmids);
        }

        public ProgressObject start(TargetModuleID[] tmids) throws IllegalStateException {
            return this.getDeploymentManager().start(tmids);
        }

        public void setLocale(Locale locale) throws UnsupportedOperationException {
            this.getDeploymentManager().setLocale(locale);
        }

        public void setDConfigBeanVersion(DConfigBeanVersionType dcbvt) throws DConfigBeanVersionUnsupportedException {
            this.getDeploymentManager().setDConfigBeanVersion(dcbvt);
        }

        public void release() {
            this.getDeploymentManager().release();
        }

        public ProgressObject redeploy(TargetModuleID[] tmids, InputStream in, InputStream in1) throws UnsupportedOperationException, IllegalStateException {
            return this.getDeploymentManager().redeploy(tmids, in, in1);
        }

        public ProgressObject redeploy(TargetModuleID[] tmids, File file, File file1) throws UnsupportedOperationException, IllegalStateException {
            return this.getDeploymentManager().redeploy(tmids, file, file1);
        }

        public boolean isRedeploySupported() {
            return this.getDeploymentManager().isRedeploySupported();
        }

        public boolean isLocaleSupported(Locale locale) {
            return this.getDeploymentManager().isLocaleSupported(locale);
        }

        public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType dcbvt) {
            return this.getDeploymentManager().isDConfigBeanVersionSupported(dcbvt);
        }

        public Target[] getTargets() throws IllegalStateException {
            return this.getDeploymentManager().getTargets();
        }

        public Locale[] getSupportedLocales() {
            return this.getDeploymentManager().getSupportedLocales();
        }

        public TargetModuleID[] getRunningModules(ModuleType mt, Target[] targets) throws TargetException, IllegalStateException {
            return this.getDeploymentManager().getRunningModules(mt, targets);
        }

        public TargetModuleID[] getNonRunningModules(ModuleType mt, Target[] targets) throws TargetException, IllegalStateException {
            return this.getDeploymentManager().getNonRunningModules(mt, targets);
        }

        public Locale getDefaultLocale() {
            return this.getDeploymentManager().getDefaultLocale();
        }

        public DConfigBeanVersionType getDConfigBeanVersion() {
            return this.getDeploymentManager().getDConfigBeanVersion();
        }

        public Locale getCurrentLocale() {
            return this.getDeploymentManager().getCurrentLocale();
        }

        public TargetModuleID[] getAvailableModules(ModuleType mt, Target[] targets) throws TargetException, IllegalStateException {
            return this.getDeploymentManager().getAvailableModules(mt, targets);
        }

        public ProgressObject distribute(Target[] targets, ModuleType mt, InputStream in, InputStream in1) throws IllegalStateException {
            return this.getDeploymentManager().distribute(targets, mt, in, in1);
        }

        public ProgressObject distribute(Target[] targets, InputStream in, InputStream in1) throws IllegalStateException {
            return this.getDeploymentManager().distribute(targets, in, in1);
        }

        public ProgressObject distribute(Target[] targets, File file, File file1) throws IllegalStateException {
            return this.getDeploymentManager().distribute(targets, file, file1);
        }

        public DeploymentConfiguration createConfiguration(DeployableObject d) throws InvalidModuleException {
            return this.getDeploymentManager().createConfiguration(d);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private javax.enterprise.deploy.spi.DeploymentManager getDeploymentManager() {
            DeploymentManager deploymentManager = this;
            synchronized (deploymentManager) {
                if (this.dm != null) {
                    return this.dm;
                }
                this.dm = InstancePropertiesImpl.getDeploymentManager(InstancePropertiesImpl.this.url);
                return this.dm;
            }
        }
    }
}

