/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.php.editor.PHPCompletionItem;
import org.netbeans.modules.php.editor.PHPCompletionResult;
import org.netbeans.modules.php.editor.index.PHPDOCTagElement;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPDocCommentTokenId;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;

public class PHPDOCCodeCompletion {
    private static final Logger LOGGER = Logger.getLogger(PHPDOCCodeCompletion.class.getName());
    private static final String TAG_PREFIX = "@";
    private static final String[] TAGS = new String[]{"abstract", "access", "author", "category", "copyright", "deprecated", "example", "final", "filesource", "global", "ignore", "internal", "license", "link", "method", "name", "package", "param", "property", "property-read", "property-write", "return", "see", "since", "static", "staticvar", "subpackage", "todo", "tutorial", "uses", "var", "version"};
    private static final Map<String, String> CUSTOM_TEMPLATES = new TreeMap<String, String>();
    private static String docURLBase;
    private static Collection<PHPDocCommentTokenId> TYPE_TOKENS;

    static boolean isTypeCtx(PHPCompletionItem.CompletionRequest request) {
        TokenSequence<PHPTokenId> phpTS;
        TokenHierarchy th = request.info.getSnapshot().getTokenHierarchy();
        TokenSequence<PHPTokenId> tokenSequence = phpTS = th != null ? LexUtilities.getPHPTokenSequence(th, request.anchor) : null;
        if (phpTS != null) {
            TokenSequence tokenSequence2;
            phpTS.move(request.anchor);
            TokenSequence tokenSequence3 = tokenSequence2 = phpTS.moveNext() ? phpTS.embedded(PHPDocCommentTokenId.language()) : null;
            if (tokenSequence2 == null) {
                return false;
            }
            tokenSequence2.move(request.anchor);
            if (tokenSequence2.movePrevious() && TYPE_TOKENS.contains(tokenSequence2.token().id())) {
                int offset = tokenSequence2.offset() + tokenSequence2.token().length();
                if (tokenSequence2.moveNext()) {
                    CharSequence text = tokenSequence2.token().text();
                    String txt = ((Object)text.subSequence(0, request.anchor - offset)).toString();
                    if (txt.charAt(txt.length() - 1) == '|') {
                        txt = txt.trim();
                        for (int i = 0; i < txt.length(); ++i) {
                            if (!Character.isWhitespace(txt.charAt(i))) continue;
                            return false;
                        }
                        return true;
                    }
                    for (int i = 0; i < txt.length(); ++i) {
                        if (Character.isWhitespace(txt.charAt(i))) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static void complete(PHPCompletionResult completionResult, PHPCompletionItem.CompletionRequest request) {
        if (!request.prefix.startsWith(TAG_PREFIX)) {
            return;
        }
        String prefix = request.prefix.startsWith(TAG_PREFIX) ? request.prefix.substring(1) : request.prefix;
        for (String tag : TAGS) {
            if (!tag.startsWith(prefix)) continue;
            PHPDOCCodeCompletionItem item = new PHPDOCCodeCompletionItem(request, tag);
            completionResult.add(item);
        }
    }

    public static String getDoc(String tag) {
        if (docURLBase != null) {
            String resPath = String.format("%s%s.desc", docURLBase, tag);
            try {
                URL url = new URL(resPath);
                InputStream is = url.openStream();
                byte[] buffer = new byte[1000];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int count = 0;
                do {
                    if ((count = is.read(buffer)) <= 0) continue;
                    baos.write(buffer, 0, count);
                } while (count > 0);
                is.close();
                String text = baos.toString();
                baos.close();
                return text;
            }
            catch (IOException e) {
                return null;
            }
        }
        File file = InstalledFileLocator.getDefault().locate("docs/phpdocdesc.zip", null, true);
        if (file != null) {
            try {
                URL urll = file.toURL();
                urll = FileUtil.getArchiveRoot((URL)urll);
                docURLBase = urll.toString();
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.INFO, "Is not possible to obtain documentation for PHP Documentor.", e);
            }
        }
        if (docURLBase != null) {
            return PHPDOCCodeCompletion.getDoc(tag);
        }
        return NbBundle.getMessage(PHPDOCCodeCompletion.class, (String)"MSG_DOWNLOAD_PHPDOC_DOCUMENTATION");
    }

    static {
        TYPE_TOKENS = Arrays.asList(PHPDocCommentTokenId.PHPDOC_RETURN, PHPDocCommentTokenId.PHPDOC_VAR, PHPDocCommentTokenId.PHPDOC_PARAM, PHPDocCommentTokenId.PHPDOC_METHOD, PHPDocCommentTokenId.PHPDOC_GLOBAL, PHPDocCommentTokenId.PHPDOC_PROPERTY, PHPDocCommentTokenId.PHPDOC_PROPERTY_READ, PHPDocCommentTokenId.PHPDOC_PROPERTY_WRITE);
        File file = InstalledFileLocator.getDefault().locate("docs/phpdocdesc.zip", null, true);
        if (file != null) {
            try {
                URL urll = file.toURL();
                urll = FileUtil.getArchiveRoot((URL)urll);
                docURLBase = urll.toString();
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.INFO, "Is not possible to obtain documentation for PHP Documentor.", e);
            }
        } else {
            docURLBase = null;
        }
    }

    public static class PHPDOCCodeCompletionItem
    implements CompletionProposal {
        private String tag;
        private PHPCompletionItem.CompletionRequest request;
        private PHPDOCTagElement elem;

        public PHPDOCCodeCompletionItem(PHPCompletionItem.CompletionRequest request, String tag) {
            this.tag = tag;
            this.request = request;
            this.elem = new PHPDOCTagElement(tag);
        }

        public int getAnchorOffset() {
            return this.request.anchor;
        }

        public ElementHandle getElement() {
            return this.elem;
        }

        public String getName() {
            return PHPDOCCodeCompletion.TAG_PREFIX + this.tag;
        }

        public String getInsertPrefix() {
            return this.getName();
        }

        public String getSortText() {
            return this.getName();
        }

        public int getSortPrioOverride() {
            return 0;
        }

        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.appendText(this.getName());
            return formatter.getText();
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return "";
        }

        public ElementKind getKind() {
            return ElementKind.KEYWORD;
        }

        public ImageIcon getIcon() {
            return null;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isSmart() {
            return false;
        }

        public String getCustomInsertTemplate() {
            return (String)CUSTOM_TEMPLATES.get(this.tag);
        }
    }
}

