/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateInsertRequest;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateParameter;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessor;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessorFactory;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.codegen.ASTNodeUtilities;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class PHPCodeTemplateProcessor
implements CodeTemplateProcessor {
    private static final String NEW_VAR_NAME = "newVarName";
    private static final String VARIABLE_FROM_NEXT_ASSIGNMENT_NAME = "variableFromNextAssignmentName";
    private static final String VARIABLE_FROM_NEXT_ASSIGNMENT_TYPE = "variableFromNextAssignmentType";
    private static final String VARIABLE_FROM_PREVIOUS_ASSIGNMENT = "variableFromPreviousAssignment";
    private static final String INSTANCE_OF = "instanceof";
    private final CodeTemplateInsertRequest request;
    private ParserResult info;

    public PHPCodeTemplateProcessor(CodeTemplateInsertRequest request) {
        this.request = request;
    }

    public void updateDefaultValues() {
        for (CodeTemplateParameter param : this.request.getMasterParameters()) {
            String value = this.getProposedValue(param);
            if (value == null || value.equals(param.getValue())) continue;
            param.setValue(value);
        }
    }

    public void parameterValueChanged(CodeTemplateParameter masterParameter, boolean typingChange) {
    }

    public void release() {
    }

    private String getNextVariableType() {
        List<? extends VariableName> variables;
        VariableName first;
        int offset = this.request.getComponent().getCaretPosition();
        Collection<? extends VariableName> declaredVariables = this.getDeclaredVariables(offset);
        String varName = this.getNextVariableName();
        if (varName == null || declaredVariables == null) {
            return null;
        }
        if (varName.charAt(0) != '$') {
            varName = "$" + varName;
        }
        if ((first = ModelUtils.getFirst(variables = ModelUtils.filter(declaredVariables, varName))) != null) {
            String typeNames = StringUtils.implode(this.getUniqueTypeNames(first, offset), (String)"|");
            if (!StringUtils.hasText((String)typeNames)) {
                return null;
            }
            return typeNames;
        }
        return null;
    }

    private String getProposedValue(CodeTemplateParameter param) {
        String def = null;
        boolean newVarName = false;
        boolean previousVariable = false;
        String type = null;
        for (Map.Entry entry : param.getHints().entrySet()) {
            String hintName = (String)entry.getKey();
            if ("default".equals(hintName)) {
                assert (def == null) : "default already set to " + def;
                def = param.getValue();
                continue;
            }
            if (NEW_VAR_NAME.equals(hintName)) {
                assert (!newVarName) : "newVarName already set";
                newVarName = true;
                continue;
            }
            if (VARIABLE_FROM_NEXT_ASSIGNMENT_NAME.equals(hintName)) {
                return this.getNextVariableName();
            }
            if (VARIABLE_FROM_NEXT_ASSIGNMENT_TYPE.equals(hintName)) {
                return this.getNextVariableType();
            }
            if (VARIABLE_FROM_PREVIOUS_ASSIGNMENT.equals(hintName)) {
                assert (!previousVariable) : "previousVariable already set";
                previousVariable = true;
                continue;
            }
            if (!INSTANCE_OF.equals(hintName)) continue;
            assert (type == null) : "type already set to " + type;
            type = (String)entry.getValue();
        }
        if (newVarName) {
            return this.newVarName(def);
        }
        if (previousVariable) {
            return this.getPreviousVariable(type);
        }
        return null;
    }

    private String getNextVariableName() {
        if (!this.initParsing()) {
            return null;
        }
        int caretOffset = this.request.getComponent().getCaretPosition();
        VariableName var = null;
        Collection<? extends VariableName> allVariables = this.getDeclaredVariables(caretOffset);
        if (allVariables != null) {
            for (VariableName variableName : allVariables) {
                int oldDiff;
                if (var == null) {
                    var = variableName;
                    continue;
                }
                int newDiff = Math.abs(variableName.getNameRange().getStart() - caretOffset);
                if (newDiff >= (oldDiff = Math.abs(var.getNameRange().getStart() - caretOffset))) continue;
                var = variableName;
            }
        }
        return var != null ? var.getName().substring(1) : null;
    }

    private String getPreviousVariable(String type) {
        if (!this.initParsing()) {
            return null;
        }
        int caretOffset = this.request.getComponent().getCaretPosition();
        VariableName var = null;
        Collection<? extends VariableName> allVariables = this.getDeclaredVariables(caretOffset);
        if (allVariables != null) {
            for (VariableName variableName : allVariables) {
                int newDiff = variableName.getNameRange().getStart() - caretOffset;
                if (newDiff >= 0 || !this.hasType(variableName, caretOffset, type)) continue;
                if (var == null) {
                    var = variableName;
                    continue;
                }
                int oldDiff = var.getNameRange().getStart() - caretOffset;
                assert (oldDiff < 0);
                if (newDiff <= oldDiff) continue;
                var = variableName;
            }
        }
        return var != null ? var.getName() : null;
    }

    private boolean hasType(VariableName variableName, int offset, String type) {
        if (type == null) {
            return true;
        }
        return variableName.getTypeNames(offset).contains(type);
    }

    private List<String> getUniqueTypeNames(VariableName variableName, int offset) {
        ArrayList<String> uniqueTypeNames = new ArrayList<String>();
        for (TypeScope type : variableName.getTypes(offset)) {
            if (uniqueTypeNames.contains(type.getName())) continue;
            uniqueTypeNames.add(type.getName());
        }
        return uniqueTypeNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String newVarName(String proposed) {
        if (!this.initParsing()) {
            return null;
        }
        int caretOffset = this.request.getComponent().getCaretPosition();
        int suffix = 0;
        final String[] nue = new String[]{null};
        PHPCodeTemplateProcessor pHPCodeTemplateProcessor = this;
        synchronized (pHPCodeTemplateProcessor) {
            while (true) {
                nue[0] = proposed + (suffix > 0 ? String.valueOf(suffix) : "");
                Set<String> varInScope = ASTNodeUtilities.getVariablesInScope(this.info, caretOffset, new ASTNodeUtilities.VariableAcceptor(){

                    @Override
                    public boolean acceptVariable(String variableName) {
                        return nue[0].equals(variableName);
                    }
                });
                if (varInScope.isEmpty()) break;
                ++suffix;
            }
        }
        return nue[0];
    }

    private synchronized boolean initParsing() {
        if (this.info != null) {
            return true;
        }
        Document doc = this.request.getComponent().getDocument();
        FileObject file = NavUtils.getFile(doc);
        if (file == null) {
            return false;
        }
        try {
            ParserManager.parse(Collections.singleton(Source.create((Document)doc)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    PHPCodeTemplateProcessor.this.info = (PHPParseResult)resultIterator.getParserResult();
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            this.info = null;
            return false;
        }
        return true;
    }

    private Collection<? extends VariableName> getDeclaredVariables(int caretOffset) {
        Model model = ((PHPParseResult)this.info).getModel();
        VariableScope varScope = model.getVariableScope(caretOffset);
        if (varScope != null) {
            return varScope.getDeclaredVariables();
        }
        return null;
    }

    private static final class AssignmentLocator
    extends DefaultVisitor {
        private int offset;
        protected Assignment node = null;

        private AssignmentLocator() {
        }

        public Assignment locate(ASTNode beginNode, int astOffset) {
            this.offset = astOffset;
            this.scan(beginNode);
            return this.node;
        }

        @Override
        public void scan(ASTNode current) {
            if (this.node == null && current != null) {
                current.accept(this);
            }
        }

        @Override
        public void visit(Assignment node) {
            if (node != null && node.getStartOffset() > this.offset) {
                this.node = node;
            }
        }
    }

    public static final class Factory
    implements CodeTemplateProcessorFactory {
        public CodeTemplateProcessor createProcessor(CodeTemplateInsertRequest request) {
            return new PHPCodeTemplateProcessor(request);
        }
    }
}

