/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.actions;

import javax.swing.text.JTextComponent;
import org.netbeans.modules.websvc.api.support.InvokeOperationCookie;
import org.netbeans.modules.websvc.core.jaxws.actions.JaxWsCodeGenerator;
import org.netbeans.modules.websvc.core.webservices.ui.panels.ClientExplorerPanel;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;

public class JaxWsInvokeOperation
implements InvokeOperationCookie {
    private FileObject targetSource;

    public JaxWsInvokeOperation(FileObject fileObject) {
        this.targetSource = fileObject;
    }

    public void invokeOperation(Lookup lookup, JTextComponent jTextComponent) {
        try {
            DataObject dataObject = DataObject.find((FileObject)this.targetSource);
            JaxWsCodeGenerator.insertMethodCall(this.getTargetSourceType(dataObject), dataObject, lookup);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace();
        }
    }

    public InvokeOperationCookie.ClientSelectionPanel getDialogDescriptorPanel() {
        return new ClientExplorerPanel(this.targetSource);
    }

    private InvokeOperationCookie.TargetSourceType getTargetSourceType(DataObject dataObject) {
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie != null && "text/x-jsp".equals(editorCookie.getDocument().getProperty("mimeType"))) {
            return InvokeOperationCookie.TargetSourceType.JSP;
        }
        if (editorCookie != null && "text/x-java".equals(editorCookie.getDocument().getProperty("mimeType"))) {
            return InvokeOperationCookie.TargetSourceType.JAVA;
        }
        return InvokeOperationCookie.TargetSourceType.UNKNOWN;
    }
}

