/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.java.nodes;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.utils.formatting.DefaultMethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatterFactory;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.selector.spi.nodes.ConstructorNode;
import org.netbeans.modules.profiler.selector.spi.nodes.ConstructorsNode;
import org.openide.filesystems.FileObject;

public class JavaConstructorNode
extends ConstructorNode {
    private ExecutableElement method;
    private ClientUtils.SourceCodeSelection signature;
    private Set<String> modifiers;
    private static MethodNameFormatterFactory formatterFactory = MethodNameFormatterFactory.getDefault((MethodNameFormatter)new DefaultMethodNameFormatter(2));

    public JavaConstructorNode(ClasspathInfo cpInfo, final ExecutableElement method, String methodName, ConstructorsNode parent) {
        super(methodName, parent);
        this.method = method;
        final String[] signatureString = new String[1];
        JavaSource js = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]);
        try {
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController controller) throws Exception {
                    signatureString[0] = SourceUtils.getVMMethodSignature((ExecutableElement)method, (CompilationInfo)controller);
                }
            }, true);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (signatureString[0] != null) {
            this.signature = new ClientUtils.SourceCodeSelection(this.getEnclosingClass(method).getQualifiedName().toString(), method.getSimpleName().toString(), signatureString[0]);
            this.updateDisplayName(formatterFactory.getFormatter().formatMethodName(this.signature).toFormatted());
            this.modifiers = new HashSet<String>();
            for (Modifier modifier : method.getModifiers()) {
                this.modifiers.add(modifier.name());
            }
        }
    }

    protected Set<String> getModifiers() {
        return this.modifiers;
    }

    public ClientUtils.SourceCodeSelection getSignature() {
        return this.signature;
    }

    private TypeElement getEnclosingClass(Element element) {
        Element parent = element.getEnclosingElement();
        if (parent != null) {
            if (parent.getKind() == ElementKind.CLASS || parent.getKind() == ElementKind.ENUM) {
                return (TypeElement)parent;
            }
            return this.getEnclosingClass(parent);
        }
        return null;
    }
}

