/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.syntaxerr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.netbeans.modules.cnd.api.model.xref.CsmIncludeHierarchyResolver;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.modelutil.NamedEntity;
import org.netbeans.modules.cnd.modelutil.NamedEntityOptions;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public abstract class CsmErrorProvider
implements NamedEntity {
    private static final boolean TRACE_TASKS = false;
    private static final boolean ENABLE = CndUtils.getBoolean((String)"cnd.csm.errors", (boolean)true);
    private static final boolean ASYNC = CndUtils.getBoolean((String)"cnd.csm.errors.async", (boolean)true);
    private static final RequestProcessor RP = new RequestProcessor("ErrorsProvider", CndUtils.getConcurrencyLevel() * 2);
    private static CsmErrorProvider DEFAULT = ASYNC ? new AsynchronousMerger() : new SynchronousMerger();

    public final void getErrors(Request request, Response response) {
        if (this.validate(request)) {
            this.doGetErrors(request, response);
        }
        response.done();
    }

    protected boolean validate(Request request) {
        return NamedEntityOptions.instance().isEnabled((NamedEntity)this) && !request.isCancelled();
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public boolean hasHintControlPanel() {
        return false;
    }

    protected abstract void doGetErrors(Request var1, Response var2);

    public static boolean disableAsLibraryHeaderFile(CsmFile file) {
        return CndUtils.isReleaseMode() && file != null && file.isHeaderFile() && file.getProject() != null && file.getProject().isArtificial();
    }

    public String toString() {
        return this.getName();
    }

    public static synchronized CsmErrorProvider getDefault() {
        return DEFAULT;
    }

    private static boolean isPartial(CsmFile isIncluded, Set<CsmFile> antiLoop) {
        if (antiLoop.contains(isIncluded)) {
            return false;
        }
        antiLoop.add(isIncluded);
        Collection<CsmReference> directives = CsmIncludeHierarchyResolver.getDefault().getIncludes(isIncluded);
        for (CsmReference directive : directives) {
            CsmSelect.CsmFilter filter;
            Iterator<CsmOffsetableDeclaration> declarations;
            if (directive == null) continue;
            int offset = directive.getStartOffset();
            CsmFile containingFile = directive.getContainingFile();
            if (containingFile == null || !(CsmSelect.hasDeclarations(containingFile) ? (declarations = CsmSelect.getDeclarations(containingFile, filter = CsmSelect.getFilterBuilder().createOffsetFilter(offset))).hasNext() : CsmErrorProvider.isPartial(containingFile, antiLoop))) continue;
            return true;
        }
        return false;
    }

    private static class AsynchronousMerger
    extends BaseMerger {
        private AsynchronousMerger() {
        }

        @Override
        public void getErrorsImpl(final Request request, final Response response) {
            ArrayList<RequestProcessor.Task> tasks = new ArrayList<RequestProcessor.Task>();
            for (final CsmErrorProvider provider : this.res.allInstances()) {
                if (request.isCancelled()) break;
                RequestProcessor.Task task = RP.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!request.isCancelled()) {
                            try {
                                provider.getErrors(request, response);
                            }
                            catch (AssertionError ex) {
                                ((Throwable)((Object)ex)).printStackTrace();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                });
                tasks.add(task);
            }
            for (RequestProcessor.Task task : tasks) {
                task.waitFinished();
            }
        }

        public String getName() {
            return "asynchronous-merger";
        }
    }

    private static class SynchronousMerger
    extends BaseMerger {
        private SynchronousMerger() {
        }

        @Override
        public void getErrorsImpl(Request request, Response response) {
            for (CsmErrorProvider provider : this.res.allInstances()) {
                if (request.isCancelled()) break;
                provider.getErrors(request, response);
            }
        }

        public String getName() {
            return "synchronous-merger";
        }
    }

    private static abstract class BaseMerger
    extends CsmErrorProvider {
        protected final Lookup.Result<CsmErrorProvider> res = Lookup.getDefault().lookupResult(CsmErrorProvider.class);

        protected abstract void getErrorsImpl(Request var1, Response var2);

        @Override
        protected boolean validate(Request request) {
            return ENABLE;
        }

        @Override
        public void doGetErrors(Request request, Response response) {
            if (!CsmErrorProvider.isPartial(request.getFile(), new HashSet())) {
                Thread currentThread = Thread.currentThread();
                currentThread.setName("Provider " + this.getName() + " prosess " + request.getFile().getAbsolutePath());
                this.getErrorsImpl(request, response);
            }
        }
    }

    public static interface RequestValidator {
        public boolean isValid(CsmErrorProvider var1, Request var2);
    }

    public static interface Response {
        public void addError(CsmErrorInfo var1);

        public void done();
    }

    public static interface Request {
        public CsmFile getFile();

        public boolean isCancelled();

        public Document getDocument();
    }
}

