/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.util;

import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.dlight.util.DLightMath;

public final class Range<T extends Number> {
    public static final String STRING_DELIMITER = "..";
    private final T start;
    private final T end;

    public Range(T start, T end) {
        if (start != null && end != null && 0 < ((Comparable)start).compareTo(end)) {
            throw new IllegalArgumentException(start + " > " + end);
        }
        this.start = start;
        this.end = end;
    }

    public T getStart() {
        return this.start;
    }

    public T getEnd() {
        return this.end;
    }

    public boolean contains(T value) {
        return !(this.start != null && ((Number)this.start).longValue() > ((Number)value).longValue() || this.end != null && ((Number)value).longValue() > ((Number)this.end).longValue());
    }

    public boolean intersects(Range<T> timeInterval) {
        return ((Number)timeInterval.end).longValue() >= ((Number)this.start).longValue() && ((Number)timeInterval.start).longValue() <= ((Number)this.end).longValue();
    }

    public void union(List<Range<T>> intervals) {
        int idx = 0;
        boolean consumed = false;
        Range interval = this;
        T start_time = interval.start;
        T end_time = interval.end;
        int size = intervals.size();
        while (idx < size && !consumed) {
            Range<T> i = intervals.get(idx);
            if (((Number)i.start).longValue() <= ((Number)start_time).longValue() && ((Number)i.end).longValue() >= ((Number)end_time).longValue()) {
                return;
            }
            if (((Number)i.start).longValue() > ((Number)end_time).longValue()) {
                intervals.add(idx, new Range<T>(start_time, end_time));
                return;
            }
            if (((Number)i.start).longValue() >= ((Number)start_time).longValue() && ((Number)i.end).longValue() <= ((Number)end_time).longValue()) {
                intervals.remove(idx);
                --size;
                continue;
            }
            if (((Number)i.end).longValue() > ((Number)end_time).longValue()) {
                intervals.set(idx, new Range<T>(start_time, i.end));
                return;
            }
            if (((Number)i.end).longValue() < ((Number)start_time).longValue()) {
                ++idx;
                continue;
            }
            if (((Number)i.start).longValue() > ((Number)end_time).longValue()) {
                consumed = true;
                intervals.add(idx, new Range<T>(start_time, end_time));
                break;
            }
            int idx2 = idx + 1;
            while (idx2 < size && ((Number)intervals.get((int)idx2).end).longValue() <= ((Number)end_time).longValue()) {
                intervals.remove(idx2);
                --size;
            }
            if (idx2 < size && ((Number)intervals.get((int)idx2).start).longValue() <= ((Number)interval.end).longValue()) {
                end_time = intervals.get((int)idx2).end;
                intervals.remove(idx2);
                --size;
            }
            if (idx < size) {
                intervals.set(idx, new Range<T>(i.start, end_time));
            } else {
                intervals.add(new Range<T>(i.start, end_time));
            }
            consumed = true;
        }
        if (!consumed) {
            intervals.add(new Range<T>(start_time, end_time));
        }
    }

    public List<Range<T>> subtract(List<Range<T>> intervals_subtract_from) {
        int idx = 0;
        Range interval_param = this;
        T intervalStart = interval_param.start;
        T intervalEnd = interval_param.end;
        LinkedList<Range<T>> result = new LinkedList<Range<T>>();
        boolean consumed = false;
        while (idx < intervals_subtract_from.size()) {
            Range<T> i = intervals_subtract_from.get(idx);
            if (((Number)i.start).longValue() <= ((Number)intervalStart).longValue() && ((Number)i.end).longValue() >= ((Number)intervalEnd).longValue()) {
                consumed = true;
                break;
            }
            if (((Number)i.start).longValue() > ((Number)intervalEnd).longValue()) {
                consumed = true;
                result.add(new Range<T>(intervalStart, intervalEnd));
                break;
            }
            if (((Number)i.start).longValue() > ((Number)intervalStart).longValue()) {
                result.add(new Range<T>(intervalStart, i.start));
                intervalStart = i.start;
                continue;
            }
            if (((Number)i.end).longValue() <= ((Number)intervalStart).longValue()) {
                ++idx;
                continue;
            }
            if (((Number)i.start).longValue() >= ((Number)intervalEnd).longValue()) {
                result.add(new Range<T>(intervalStart, intervalEnd));
                consumed = true;
                break;
            }
            if (((Number)i.end).longValue() >= ((Number)intervalEnd).longValue()) {
                intervalEnd = i.start;
                result.add(new Range<T>(intervalStart, intervalEnd));
                consumed = true;
                break;
            }
            if (((Number)i.end).longValue() > ((Number)intervalStart).longValue()) {
                intervalStart = i.end;
                ++idx;
                continue;
            }
            result.add(new Range<T>(intervalStart, i.start));
            intervalStart = i.end;
            ++idx;
        }
        if (!consumed) {
            result.addLast(new Range<T>(intervalStart, intervalEnd));
        }
        return result;
    }

    public Range<T> extend(Range<T> range) {
        return new Range<Number>((Number)((Object)DLightMath.min((Comparable)this.start, (Comparable)range.getStart())), (Number)((Object)DLightMath.max((Comparable)this.end, (Comparable)range.getEnd())));
    }

    public String toString() {
        return String.valueOf(this.start) + STRING_DELIMITER + String.valueOf(this.end);
    }

    public String toString(String prefix, String startFormat, String glue, String endFormat, String suffix) {
        if (this.start != null || this.end != null) {
            StringBuilder buf = new StringBuilder();
            if (prefix != null) {
                buf.append(prefix);
            }
            if (this.start != null) {
                buf.append(String.format(startFormat, this.start));
            }
            if (this.start != null && this.end != null && glue != null) {
                buf.append(glue);
            }
            if (this.end != null) {
                buf.append(String.format(endFormat, this.end));
            }
            if (suffix != null) {
                buf.append(suffix);
            }
            return buf.toString();
        }
        return "";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Range)) {
            return false;
        }
        Range other = (Range)obj;
        if (!(this.start == other.start || this.start != null && this.start.equals(other.start))) {
            return false;
        }
        return this.end == other.end || this.end != null && this.end.equals(other.end);
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + (this.start != null ? this.start.hashCode() : 0);
        hash = 53 * hash + (this.end != null ? this.end.hashCode() : 0);
        return hash;
    }
}

