/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.java.TokenBalance;

class BraceCompletion {
    private static Set<JavaTokenId> STOP_TOKENS_FOR_SKIP_CLOSING_BRACKET = EnumSet.of(JavaTokenId.LBRACE, JavaTokenId.RBRACE, JavaTokenId.SEMICOLON);

    BraceCompletion() {
    }

    static void charInserted(BaseDocument doc, int caretOffset, Caret caret, char ch) throws BadLocationException {
        TokenSequence<JavaTokenId> javaTS;
        if (!BraceCompletion.completionSettingEnabled()) {
            return;
        }
        if ((ch == ')' || ch == ']' || ch == '(' || ch == '[' || ch == ';') && (javaTS = BraceCompletion.javaTokenSequence((Document)doc, caretOffset, false)) != null) {
            switch ((JavaTokenId)javaTS.token().id()) {
                case RPAREN: 
                case RBRACKET: {
                    BraceCompletion.skipClosingBracket(doc, caret, ch, javaTS);
                    break;
                }
                case LPAREN: 
                case LBRACKET: {
                    BraceCompletion.completeOpeningBracket(doc, caretOffset, caret, ch, javaTS);
                    break;
                }
                case SEMICOLON: {
                    BraceCompletion.moveSemicolon(doc, caretOffset, caret, javaTS);
                }
            }
        }
    }

    private static void moveSemicolon(BaseDocument doc, int caretOffset, Caret caret, TokenSequence<JavaTokenId> ts) throws BadLocationException {
        int eolOffset = Utilities.getRowEnd((BaseDocument)doc, (int)caretOffset);
        int lastParenPos = caretOffset;
        int index = ts.index();
        block4: while (ts.moveNext() && ts.offset() <= eolOffset) {
            Token token = ts.token();
            switch ((JavaTokenId)token.id()) {
                case RPAREN: {
                    lastParenPos = ts.offset();
                    continue block4;
                }
                case WHITESPACE: {
                    continue block4;
                }
            }
            return;
        }
        ts.moveIndex(index);
        ts.moveNext();
        if (BraceCompletion.isForLoopSemicolon(ts) || BraceCompletion.posWithinAnyQuote(doc, caretOffset)) {
            return;
        }
        doc.remove(caretOffset, 1);
        doc.insertString(lastParenPos, ";", null);
        caret.setDot(lastParenPos + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isForLoopSemicolon(TokenSequence<JavaTokenId> ts) {
        Token token = ts.token();
        if (token == null || token.id() != JavaTokenId.SEMICOLON) {
            return false;
        }
        int parenDepth = 0;
        int braceDepth = 0;
        boolean semicolonFound = false;
        int tsOrigIndex = ts.index();
        try {
            while (ts.movePrevious()) {
                token = ts.token();
                switch ((JavaTokenId)token.id()) {
                    case LPAREN: {
                        if (parenDepth == 0) {
                            block20: while (ts.movePrevious()) {
                                token = ts.token();
                                switch ((JavaTokenId)token.id()) {
                                    case WHITESPACE: 
                                    case BLOCK_COMMENT: 
                                    case JAVADOC_COMMENT: 
                                    case LINE_COMMENT: {
                                        continue block20;
                                    }
                                    case FOR: {
                                        boolean bl = true;
                                        return bl;
                                    }
                                }
                                boolean bl = false;
                                return bl;
                            }
                            boolean bl = false;
                            return bl;
                        }
                        --parenDepth;
                        break;
                    }
                    case RPAREN: {
                        ++parenDepth;
                        break;
                    }
                    case LBRACE: {
                        if (braceDepth == 0) {
                            boolean bl = false;
                            return bl;
                        }
                        --braceDepth;
                        break;
                    }
                    case RBRACE: {
                        ++braceDepth;
                        break;
                    }
                    case SEMICOLON: {
                        if (semicolonFound) {
                            boolean bl = false;
                            return bl;
                        }
                        semicolonFound = true;
                    }
                }
            }
        }
        finally {
            ts.moveIndex(tsOrigIndex);
            ts.moveNext();
        }
        return false;
    }

    static void charBackspaced(BaseDocument doc, int caretOffset, Caret caret, char ch) throws BadLocationException {
        if (!BraceCompletion.completionSettingEnabled()) {
            return;
        }
        TokenSequence<JavaTokenId> ts = BraceCompletion.javaTokenSequence((Document)doc, caretOffset, false);
        if (ts == null) {
            return;
        }
        if (ch == '(' || ch == '[') {
            switch ((JavaTokenId)ts.token().id()) {
                case RPAREN: {
                    if (BraceCompletion.tokenBalance(doc, JavaTokenId.LPAREN) == 0) break;
                    doc.remove(caretOffset, 1);
                    break;
                }
                case RBRACKET: {
                    if (BraceCompletion.tokenBalance(doc, JavaTokenId.LBRACKET) == 0) break;
                    doc.remove(caretOffset, 1);
                }
            }
        } else if (ch == '\"') {
            if (ts.token().id() == JavaTokenId.STRING_LITERAL && ts.offset() == caretOffset) {
                doc.remove(caretOffset, 1);
            }
        } else if (ch == '\'' && ts.token().id() == JavaTokenId.CHAR_LITERAL && ts.offset() == caretOffset) {
            doc.remove(caretOffset, 1);
        }
    }

    static int tokenBalance(BaseDocument doc, JavaTokenId leftTokenId) {
        TokenBalance tb = TokenBalance.get((Document)doc);
        if (!tb.isTracked(JavaTokenId.language())) {
            tb.addTokenPair(JavaTokenId.language(), JavaTokenId.LPAREN, JavaTokenId.RPAREN);
            tb.addTokenPair(JavaTokenId.language(), JavaTokenId.LBRACKET, JavaTokenId.RBRACKET);
            tb.addTokenPair(JavaTokenId.language(), JavaTokenId.LBRACE, JavaTokenId.RBRACE);
        }
        int balance = tb.balance(JavaTokenId.language(), leftTokenId);
        assert (balance != Integer.MAX_VALUE);
        return balance;
    }

    static boolean isAddRightBrace(BaseDocument doc, int caretOffset) throws BadLocationException {
        if (!BraceCompletion.completionSettingEnabled()) {
            return false;
        }
        if (BraceCompletion.tokenBalance(doc, JavaTokenId.LBRACE) <= 0) {
            return false;
        }
        int caretRowStartOffset = Utilities.getRowStart((BaseDocument)doc, (int)caretOffset);
        TokenSequence<JavaTokenId> ts = BraceCompletion.javaTokenSequence((Document)doc, caretOffset, true);
        if (ts == null) {
            return false;
        }
        boolean first = true;
        do {
            if (ts.offset() < caretRowStartOffset) {
                return false;
            }
            switch ((JavaTokenId)ts.token().id()) {
                case WHITESPACE: 
                case LINE_COMMENT: {
                    break;
                }
                case BLOCK_COMMENT: 
                case JAVADOC_COMMENT: {
                    if (!first || caretOffset <= ts.offset() || caretOffset >= ts.offset() + ts.token().length()) break;
                    return false;
                }
                case LBRACE: {
                    return true;
                }
            }
            first = false;
        } while (ts.movePrevious());
        return false;
    }

    static int getRowOrBlockEnd(BaseDocument doc, int caretOffset, boolean[] insert) throws BadLocationException {
        int rowEnd = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)caretOffset);
        if (rowEnd == -1 || caretOffset >= rowEnd) {
            return caretOffset;
        }
        ++rowEnd;
        int parenBalance = 0;
        int braceBalance = 0;
        int bracketBalance = 0;
        TokenSequence<JavaTokenId> ts = BraceCompletion.javaTokenSequence((Document)doc, caretOffset, false);
        if (ts == null) {
            return caretOffset;
        }
        while (ts.offset() < rowEnd) {
            switch ((JavaTokenId)ts.token().id()) {
                case SEMICOLON: {
                    return ts.offset() + 1;
                }
                case LPAREN: {
                    ++parenBalance;
                    break;
                }
                case RPAREN: {
                    if (parenBalance-- == 0) {
                        return ts.offset();
                    }
                }
                case LBRACE: {
                    ++braceBalance;
                    break;
                }
                case RBRACE: {
                    if (braceBalance-- == 0) {
                        return ts.offset();
                    }
                }
                case LBRACKET: {
                    ++bracketBalance;
                    break;
                }
                case RBRACKET: {
                    if (bracketBalance-- != 0) break;
                    return ts.offset();
                }
            }
            if (ts.moveNext()) continue;
        }
        insert[0] = false;
        return rowEnd;
    }

    private static TokenSequence<JavaTokenId> javaTokenSequence(Document doc, int offset, boolean backwardBias) {
        TokenHierarchy hi = TokenHierarchy.get((Document)doc);
        List tsList = hi.embeddedTokenSequences(offset, backwardBias);
        for (int i = tsList.size() - 1; i >= 0; --i) {
            TokenSequence ts = (TokenSequence)tsList.get(i);
            if (ts.languagePath().innerLanguage() != JavaTokenId.language()) continue;
            TokenSequence javaInnerTS = ts;
            return javaInnerTS;
        }
        return null;
    }

    private static int braceBalance(BaseDocument doc) throws BadLocationException {
        return BraceCompletion.tokenBalance(doc, JavaTokenId.LBRACE);
    }

    private static void skipClosingBracket(BaseDocument doc, Caret caret, char rightBracketChar, TokenSequence<JavaTokenId> innerTS) throws BadLocationException {
        JavaTokenId bracketId = BraceCompletion.bracketCharToId(rightBracketChar);
        int caretOffset = caret.getDot();
        if (BraceCompletion.isSkipClosingBracket(doc, caretOffset, bracketId)) {
            doc.remove(caretOffset - 1, 1);
            caret.setDot(caretOffset);
        }
    }

    static boolean isSkipClosingBracket(BaseDocument doc, int caretOffset, JavaTokenId rightBracketId) throws BadLocationException {
        if (caretOffset == doc.getLength()) {
            return false;
        }
        boolean skipClosingBracket = false;
        TokenSequence<JavaTokenId> javaTS = BraceCompletion.javaTokenSequence((Document)doc, caretOffset, false);
        if (javaTS != null && javaTS.token().id() == rightBracketId) {
            JavaTokenId leftBracketId = BraceCompletion.matching(rightBracketId);
            do {
                if (!STOP_TOKENS_FOR_SKIP_CLOSING_BRACKET.contains(javaTS.token().id()) && (javaTS.token().id() != JavaTokenId.WHITESPACE || !((Object)javaTS.token().text()).toString().contains("\n"))) continue;
                while (javaTS.token().id() != rightBracketId && javaTS.movePrevious()) {
                }
                break;
            } while (javaTS.moveNext());
            int braceBalance = 0;
            int bracketBalance = -1;
            int numOfSemi = 0;
            boolean finished = false;
            while (!finished && javaTS.movePrevious()) {
                JavaTokenId id = (JavaTokenId)javaTS.token().id();
                switch (id) {
                    case LPAREN: 
                    case LBRACKET: {
                        if (id != leftBracketId || ++bracketBalance != 0) break;
                        if (braceBalance != 0) {
                            bracketBalance = 1;
                        }
                        finished = javaTS.offset() < caretOffset;
                        break;
                    }
                    case RPAREN: 
                    case RBRACKET: {
                        if (id != rightBracketId) break;
                        --bracketBalance;
                        break;
                    }
                    case LBRACE: {
                        if (++braceBalance <= 0) break;
                        finished = true;
                        break;
                    }
                    case RBRACE: {
                        --braceBalance;
                        break;
                    }
                    case SEMICOLON: {
                        ++numOfSemi;
                    }
                }
            }
            if (bracketBalance == 0 && numOfSemi < 2) {
                finished = false;
                block14: while (!finished && javaTS.movePrevious()) {
                    switch ((JavaTokenId)javaTS.token().id()) {
                        case WHITESPACE: 
                        case BLOCK_COMMENT: 
                        case JAVADOC_COMMENT: 
                        case LINE_COMMENT: {
                            continue block14;
                        }
                        case FOR: {
                            --bracketBalance;
                        }
                    }
                    finished = true;
                }
            }
            skipClosingBracket = bracketBalance != 0;
        }
        return skipClosingBracket;
    }

    private static void completeOpeningBracket(BaseDocument doc, int caretOffset, Caret caret, char bracketChar, TokenSequence<JavaTokenId> innerTS) throws BadLocationException {
        if (BraceCompletion.isCompletablePosition(doc, caretOffset + 1)) {
            doc.insertString(caretOffset + 1, String.valueOf(BraceCompletion.matching(bracketChar)), null);
            caret.setDot(caretOffset + 1);
        }
    }

    private static boolean isEscapeSequence(BaseDocument doc, int caretOffset) throws BadLocationException {
        if (caretOffset <= 0) {
            return false;
        }
        int i = 2;
        while (caretOffset - i >= 0) {
            char[] previousChars = doc.getChars(caretOffset - i, 2);
            if (previousChars[1] != '\\') {
                return false;
            }
            if (previousChars[0] != '\\') {
                return true;
            }
            i += 2;
        }
        char previousChar = doc.getChars(caretOffset - 1, 1)[0];
        return previousChar == '\\';
    }

    static boolean completeQuote(BaseDocument doc, int caretOffset, Caret caret, char bracket) throws BadLocationException {
        boolean insideString;
        boolean caretInsideToken;
        if (!BraceCompletion.completionSettingEnabled()) {
            return false;
        }
        if (BraceCompletion.isEscapeSequence(doc, caretOffset)) {
            return false;
        }
        TokenSequence<JavaTokenId> javaTS = BraceCompletion.javaTokenSequence((Document)doc, caretOffset, true);
        JavaTokenId id = javaTS != null ? (JavaTokenId)javaTS.token().id() : null;
        int lastNonWhite = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)caretOffset);
        boolean eol = lastNonWhite < caretOffset;
        boolean bl = caretInsideToken = id != null && (javaTS.offset() + javaTS.token().length() > caretOffset || javaTS.token().partType() == PartType.START);
        if (caretInsideToken && (id == JavaTokenId.BLOCK_COMMENT || id == JavaTokenId.JAVADOC_COMMENT || id == JavaTokenId.LINE_COMMENT)) {
            return false;
        }
        boolean completablePosition = BraceCompletion.isQuoteCompletablePosition(doc, caretOffset);
        boolean bl2 = insideString = caretInsideToken && (id == JavaTokenId.STRING_LITERAL || id == JavaTokenId.CHAR_LITERAL);
        if (insideString) {
            if (eol) {
                return false;
            }
            char chr = doc.getChars(caretOffset, 1)[0];
            if (chr == bracket && caretOffset > 0) {
                javaTS.move(caretOffset - 1);
                if (javaTS.moveNext() && ((id = (JavaTokenId)javaTS.token().id()) == JavaTokenId.STRING_LITERAL || id == JavaTokenId.CHAR_LITERAL)) {
                    doc.insertString(caretOffset, String.valueOf(bracket), null);
                    doc.remove(caretOffset, 1);
                    return true;
                }
            }
        }
        if (completablePosition && !insideString || eol) {
            doc.insertString(caretOffset, String.valueOf(bracket) + bracket, null);
            return true;
        }
        return false;
    }

    private static boolean isCompletablePosition(BaseDocument doc, int caretOffset) throws BadLocationException {
        if (caretOffset == doc.getLength()) {
            return true;
        }
        char chr = doc.getChars(caretOffset, 1)[0];
        return chr == ')' || chr == ',' || chr == '\"' || chr == '\'' || chr == ' ' || chr == ']' || chr == '}' || chr == '\n' || chr == '\t' || chr == ';';
    }

    private static boolean isQuoteCompletablePosition(BaseDocument doc, int caretOffset) throws BadLocationException {
        if (caretOffset == doc.getLength()) {
            return true;
        }
        int eolOffset = Utilities.getRowEnd((BaseDocument)doc, (int)caretOffset);
        if (caretOffset == eolOffset || eolOffset == -1) {
            return false;
        }
        int firstNonWhiteFwdOffset = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)caretOffset, (int)eolOffset);
        if (firstNonWhiteFwdOffset == -1) {
            return false;
        }
        char chr = doc.getChars(firstNonWhiteFwdOffset, 1)[0];
        return chr == ')' || chr == ',' || chr == '+' || chr == '}' || chr == ';';
    }

    static boolean completionSettingEnabled() {
        Preferences prefs = (Preferences)MimeLookup.getLookup((String)"text/x-java").lookup(Preferences.class);
        return prefs.getBoolean("pair-characters-completion", false);
    }

    private static char matching(char bracket) {
        switch (bracket) {
            case '(': {
                return ')';
            }
            case '[': {
                return ']';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
        }
        return ' ';
    }

    private static JavaTokenId matching(JavaTokenId id) {
        switch (id) {
            case LPAREN: {
                return JavaTokenId.RPAREN;
            }
            case LBRACKET: {
                return JavaTokenId.RBRACKET;
            }
            case RPAREN: {
                return JavaTokenId.LPAREN;
            }
            case RBRACKET: {
                return JavaTokenId.LBRACKET;
            }
        }
        return null;
    }

    private static JavaTokenId bracketCharToId(char bracket) {
        switch (bracket) {
            case '(': {
                return JavaTokenId.LPAREN;
            }
            case ')': {
                return JavaTokenId.RPAREN;
            }
            case '[': {
                return JavaTokenId.LBRACKET;
            }
            case ']': {
                return JavaTokenId.RBRACKET;
            }
            case '{': {
                return JavaTokenId.LBRACE;
            }
            case '}': {
                return JavaTokenId.RBRACE;
            }
        }
        throw new IllegalArgumentException("Not a bracket char '" + bracket + '\'');
    }

    static boolean posWithinString(Document doc, int caretOffset) {
        return BraceCompletion.posWithinQuotes(doc, caretOffset, '\"', JavaTokenId.STRING_LITERAL);
    }

    static boolean posWithinQuotes(Document doc, int caretOffset, char quote, JavaTokenId tokenId) {
        TokenSequence<JavaTokenId> javaTS = BraceCompletion.javaTokenSequence(doc, caretOffset, false);
        if (javaTS != null) {
            if (javaTS.token().id() != tokenId) {
                return false;
            }
            return caretOffset > javaTS.offset() && caretOffset < javaTS.offset() + javaTS.token().length();
        }
        return false;
    }

    static boolean posWithinAnyQuote(BaseDocument doc, int caretOffset) {
        JavaTokenId id;
        TokenSequence<JavaTokenId> javaTS = BraceCompletion.javaTokenSequence((Document)doc, caretOffset - 1, false);
        if (javaTS != null && ((id = (JavaTokenId)javaTS.token().id()) == JavaTokenId.STRING_LITERAL || id == JavaTokenId.CHAR_LITERAL)) {
            char ch = DocumentUtilities.getText((Document)doc).charAt(caretOffset - 1);
            return caretOffset - javaTS.offset() == 1 || ch != '\"' && ch != '\'';
        }
        return false;
    }

    static boolean isUnclosedStringAtLineEnd(BaseDocument doc, int caretOffset) {
        int lastNonWhiteOffset;
        try {
            lastNonWhiteOffset = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)caretOffset);
        }
        catch (BadLocationException e) {
            return false;
        }
        TokenSequence<JavaTokenId> javaTS = BraceCompletion.javaTokenSequence((Document)doc, lastNonWhiteOffset, true);
        if (javaTS != null) {
            return javaTS.token().id() == JavaTokenId.STRING_LITERAL;
        }
        return false;
    }
}

