/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.List;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYChartContext;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.PointsComputer;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineXYPainter;

final class ContinuousXYPainter
extends TimelineXYPainter {
    private static final Polygon POLYGON = new Polygon();
    protected final int lineWidth;
    protected final Color lineColor;
    protected final Color fillColor;
    protected final Color definingColor;
    protected final Stroke lineStroke;
    private final PointsComputer computer;

    ContinuousXYPainter(float lineWidth, Color lineColor, Color fillColor, double dataFactor, PointsComputer computer) {
        super((int)Math.ceil(lineWidth), fillColor != null, dataFactor);
        if (lineColor == null && fillColor == null) {
            throw new IllegalArgumentException("lineColor or fillColor must not be null");
        }
        this.lineWidth = (int)Math.ceil(lineWidth);
        this.lineColor = Utils.checkedColor((Color)lineColor);
        this.fillColor = Utils.checkedColor((Color)fillColor);
        this.definingColor = lineColor != null ? lineColor : fillColor;
        this.lineStroke = new BasicStroke(lineWidth, 1, 1);
        this.computer = computer;
    }

    @Override
    protected Color getDefiningColor() {
        return this.definingColor;
    }

    @Override
    protected void paint(XYItem item, List<ItemSelection> highlighted, List<ItemSelection> selected, Graphics2D g, Rectangle dirtyArea, SynchronousXYChartContext context) {
        int valuesCount = item.getValuesCount();
        int extraTrailing = this.fillColor != null ? 2 : 0;
        Rectangle dirtyExtended = new Rectangle(dirtyArea);
        dirtyExtended.x -= this.lineWidth;
        dirtyExtended.width += this.lineWidth * 2;
        int[][] idxs = this.computer.getVisible(dirtyExtended, valuesCount, context, 1, extraTrailing);
        if (idxs == null) {
            return;
        }
        int[] visibleIndexes = idxs[0];
        int npoints = idxs[1][0];
        int[][] points = this.computer.createPoints(visibleIndexes, npoints, item, this.dataFactor, context);
        if (this.fillColor != null) {
            points[0][npoints - 2] = points[0][npoints - 3];
            points[1][npoints - 2] = this.computer.getZeroY(context);
            points[0][npoints - 1] = points[0][0];
            points[1][npoints - 1] = points[1][npoints - 2];
            ContinuousXYPainter.POLYGON.xpoints = points[0];
            ContinuousXYPainter.POLYGON.ypoints = points[1];
            ContinuousXYPainter.POLYGON.npoints = npoints;
            g.setPaint(this.fillColor);
            g.fill(POLYGON);
        }
        if (this.lineColor != null) {
            g.setPaint(this.lineColor);
            g.setStroke(this.lineStroke);
            g.drawPolyline(points[0], points[1], npoints - extraTrailing);
        }
    }
}

