/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.parser.Keywords;
import com.sun.tools.javac.parser.Lexer;
import com.sun.tools.javac.parser.Parser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.parser.Token;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.CancelService;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavacParser
implements Parser {
    private static final int infixPrecedenceLevels = 10;
    protected Lexer S;
    protected TreeMaker F;
    private Log log;
    private Keywords keywords;
    private Source source;
    private Names names;
    private final CancelService cancelService;
    boolean allowGenerics;
    boolean allowDiamond;
    boolean allowMulticatch;
    boolean allowVarargs;
    boolean allowAsserts;
    boolean allowEnums;
    boolean allowForeach;
    boolean allowStaticImport;
    boolean allowAnnotations;
    boolean allowTWR;
    boolean allowStringFolding;
    boolean keepDocComments;
    boolean keepLineMap;
    static final int EXPR = 1;
    static final int TYPE = 2;
    static final int NOPARAMS = 4;
    static final int TYPEARG = 8;
    static final int DIAMOND = 16;
    private int mode = 0;
    private int lastmode = 0;
    private JCTree.JCErroneous errorTree;
    private final Map<JCTree, String> docComments;
    private int errorEndPos = -1;
    ListBuffer<JCTree.JCExpression[]> odStackSupply = new ListBuffer();
    ListBuffer<Token[]> opStackSupply = new ListBuffer();
    ListBuffer<int[]> posStackSupply = new ListBuffer();

    protected JavacParser(ParserFactory fac, Lexer S, boolean keepDocComments, boolean keepLineMap, CancelService cancelService) {
        this.S = S;
        S.nextToken();
        this.F = fac.F;
        this.log = fac.log;
        this.names = fac.names;
        this.keywords = fac.keywords;
        this.source = fac.source;
        this.allowGenerics = this.source.allowGenerics();
        this.allowVarargs = this.source.allowVarargs();
        this.allowAsserts = this.source.allowAsserts();
        this.allowEnums = this.source.allowEnums();
        this.allowForeach = this.source.allowForeach();
        this.allowStaticImport = this.source.allowStaticImport();
        this.allowAnnotations = this.source.allowAnnotations();
        this.allowTWR = this.source.allowTryWithResources();
        this.allowDiamond = this.source.allowDiamond();
        this.allowMulticatch = this.source.allowMulticatch();
        this.allowStringFolding = fac.options.get("disableStringFolding") == null;
        this.keepDocComments = keepDocComments;
        this.docComments = keepDocComments ? new HashMap() : null;
        this.keepLineMap = keepLineMap;
        this.errorTree = this.F.Erroneous();
        this.cancelService = cancelService;
    }

    private void skip(boolean stopAtImport, boolean stopAtMemberDecl, boolean stopAtIdentifier, boolean stopAtStatement) {
        while (true) {
            switch (this.S.token()) {
                case SEMI: {
                    this.S.nextToken();
                    return;
                }
                case PUBLIC: 
                case FINAL: 
                case ABSTRACT: 
                case MONKEYS_AT: 
                case EOF: 
                case CLASS: 
                case INTERFACE: 
                case ENUM: {
                    return;
                }
                case IMPORT: 
                case PACKAGE: {
                    if (!stopAtImport) break;
                    return;
                }
                case LBRACE: 
                case RBRACE: 
                case PRIVATE: 
                case PROTECTED: 
                case STATIC: 
                case TRANSIENT: 
                case NATIVE: 
                case VOLATILE: 
                case SYNCHRONIZED: 
                case STRICTFP: 
                case BYTE: 
                case SHORT: 
                case CHAR: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case VOID: {
                    if (!stopAtMemberDecl) break;
                    return;
                }
                case IDENTIFIER: {
                    if (!stopAtIdentifier) break;
                    return;
                }
                case CASE: 
                case DEFAULT: 
                case IF: 
                case FOR: 
                case WHILE: 
                case DO: 
                case TRY: 
                case SWITCH: 
                case RETURN: 
                case THROW: 
                case BREAK: 
                case CONTINUE: 
                case ELSE: 
                case FINALLY: 
                case CATCH: 
                case THIS: 
                case SUPER: {
                    if (!stopAtStatement) break;
                    return;
                }
            }
            this.S.nextToken();
        }
    }

    private JCTree.JCErroneous syntaxError(int pos, String key, Token ... args) {
        return this.syntaxError(pos, List.<JCTree>nil(), key, args);
    }

    private JCTree.JCErroneous syntaxError(int pos, List<JCTree> errs, String key, Token ... args) {
        JCTree last;
        this.setErrorEndPos(pos);
        JCTree.JCErroneous err = this.F.at(pos).Erroneous(errs);
        this.reportSyntaxError(err, pos, key, args);
        if (errs != null && (last = errs.last()) != null) {
            this.storeEnd(last, pos);
        }
        return this.toP(err);
    }

    private void reportSyntaxError(JCDiagnostic.DiagnosticPosition diag, int pos, String key, Object ... args) {
        if (diag != null) {
            pos = diag.getPreferredPosition();
            if (pos > this.S.errPos() || pos == -1) {
                if (this.S.token() == Token.EOF) {
                    this.error(diag, "premature.eof", new Object[0]);
                } else {
                    this.error(diag, key, args);
                }
            }
        } else if (pos > this.S.errPos() || pos == -1) {
            if (this.S.token() == Token.EOF) {
                this.error(pos, "premature.eof", new Object[0]);
            } else {
                this.error(pos, key, args);
            }
        }
        this.S.errPos(pos);
    }

    private JCTree.JCErroneous syntaxError(String key) {
        return this.syntaxError(this.S.pos(), key, new Token[0]);
    }

    private JCTree.JCErroneous syntaxError(String key, Token arg) {
        return this.syntaxError(this.S.pos(), key, arg);
    }

    public void accept(Token token) {
        if (this.S.token() == token) {
            this.S.nextToken();
        } else {
            this.setErrorEndPos(this.S.pos());
            this.reportSyntaxError(null, this.S.prevEndPos(), "expected", token);
        }
    }

    JCTree.JCExpression illegal(int pos) {
        this.setErrorEndPos(pos);
        if ((this.mode & 1) != 0) {
            return this.syntaxError(pos, "illegal.start.of.expr", new Token[0]);
        }
        return this.syntaxError(pos, "illegal.start.of.type", new Token[0]);
    }

    JCTree.JCExpression illegal() {
        return this.illegal(this.S.pos());
    }

    void checkNoMods(long mods) {
        if (mods != 0L) {
            long lowestMod = mods & -mods;
            this.error(this.S.pos(), "mod.not.allowed.here", Flags.asFlagSet(lowestMod));
        }
    }

    void attach(JCTree tree, String dc) {
        if (this.keepDocComments && dc != null) {
            this.docComments.put(tree, dc);
        }
    }

    public Map<JCTree, String> getDocComments() {
        return this.docComments == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.docComments);
    }

    private void setErrorEndPos(int errPos) {
        if (errPos > this.errorEndPos) {
            this.errorEndPos = errPos;
        }
    }

    protected int getErrorEndPos() {
        return this.errorEndPos;
    }

    protected void storeEnd(JCTree tree, int endpos) {
    }

    protected <T extends JCTree> T to(T t) {
        return t;
    }

    protected <T extends JCTree> T toP(T t) {
        return t;
    }

    public int getStartPos(JCTree tree) {
        return TreeInfo.getStartPos(tree);
    }

    public int getEndPos(JCTree tree) {
        return -1;
    }

    Name ident() {
        if (this.S.token() == Token.IDENTIFIER) {
            Name name = this.S.name();
            this.S.nextToken();
            return name;
        }
        if (this.S.token() == Token.ASSERT) {
            if (this.allowAsserts) {
                this.error(this.S.pos(), "assert.as.identifier", new Object[0]);
                this.S.nextToken();
                return this.names.error;
            }
            this.warning(this.S.pos(), "assert.as.identifier", new Object[0]);
            Name name = this.S.name();
            this.S.nextToken();
            return name;
        }
        if (this.S.token() == Token.ENUM) {
            if (this.allowEnums) {
                this.error(this.S.pos(), "enum.as.identifier", new Object[0]);
                this.S.nextToken();
                return this.names.error;
            }
            this.warning(this.S.pos(), "enum.as.identifier", new Object[0]);
            Name name = this.S.name();
            this.S.nextToken();
            return name;
        }
        this.accept(Token.IDENTIFIER);
        return this.names.error;
    }

    public JCTree.JCExpression qualident() {
        JCTree.JCExpression t = this.toP(this.F.at(this.S.pos()).Ident(this.ident()));
        while (this.S.token() == Token.DOT) {
            int pos = this.S.pos();
            this.S.nextToken();
            t = this.toP(this.F.at(pos).Select(t, this.ident()));
        }
        return t;
    }

    JCTree.JCExpression literal(Name prefix, int pos) {
        JCTree.JCExpression t = this.errorTree;
        switch (this.S.token()) {
            case INTLITERAL: {
                try {
                    t = this.F.at(pos).Literal(4, Convert.string2int(this.strval(prefix), this.S.radix()));
                }
                catch (NumberFormatException ex) {
                    this.error(this.S.pos(), "int.number.too.large", this.strval(prefix));
                }
                break;
            }
            case LONGLITERAL: {
                try {
                    t = this.F.at(pos).Literal(5, new Long(Convert.string2long(this.strval(prefix), this.S.radix())));
                }
                catch (NumberFormatException ex) {
                    this.error(this.S.pos(), "int.number.too.large", this.strval(prefix));
                }
                break;
            }
            case FLOATLITERAL: {
                Float n;
                String proper = this.S.radix() == 16 ? "0x" + this.S.stringVal() : this.S.stringVal();
                try {
                    n = Float.valueOf(proper);
                }
                catch (NumberFormatException ex) {
                    n = Float.valueOf(Float.NaN);
                }
                if (n.floatValue() == 0.0f && !this.isZero(proper)) {
                    this.error(this.S.pos(), "fp.number.too.small", new Object[0]);
                    break;
                }
                if (n.floatValue() == Float.POSITIVE_INFINITY) {
                    this.error(this.S.pos(), "fp.number.too.large", new Object[0]);
                    break;
                }
                t = this.F.at(pos).Literal(6, n);
                break;
            }
            case DOUBLELITERAL: {
                Double n;
                String proper = this.S.radix() == 16 ? "0x" + this.S.stringVal() : this.S.stringVal();
                try {
                    n = Double.valueOf(proper);
                }
                catch (NumberFormatException ex) {
                    n = Double.NaN;
                }
                if (n == 0.0 && !this.isZero(proper)) {
                    this.error(this.S.pos(), "fp.number.too.small", new Object[0]);
                    break;
                }
                if (n == Double.POSITIVE_INFINITY) {
                    this.error(this.S.pos(), "fp.number.too.large", new Object[0]);
                    break;
                }
                t = this.F.at(pos).Literal(7, n);
                break;
            }
            case CHARLITERAL: {
                t = this.F.at(pos).Literal(2, this.S.stringVal().charAt(0) + '\u0000');
                break;
            }
            case STRINGLITERAL: {
                t = this.F.at(pos).Literal(10, this.S.stringVal());
                break;
            }
            case TRUE: 
            case FALSE: {
                t = this.F.at(pos).Literal(8, this.S.token() == Token.TRUE ? 1 : 0);
                break;
            }
            case NULL: {
                t = this.F.at(pos).Literal(17, null);
                break;
            }
            default: {
                Assert.error();
            }
        }
        if (t == this.errorTree) {
            t = this.F.at(pos).Erroneous();
        }
        this.storeEnd(t, this.S.endPos());
        this.S.nextToken();
        return t;
    }

    boolean isZero(String s) {
        int i;
        char[] cs = s.toCharArray();
        int base = cs.length > 1 && Character.toLowerCase(cs[1]) == 'x' ? 16 : 10;
        int n = i = base == 16 ? 2 : 0;
        while (i < cs.length && (cs[i] == '0' || cs[i] == '.')) {
            ++i;
        }
        return i >= cs.length || Character.digit(cs[i], base) <= 0;
    }

    String strval(Name prefix) {
        String s = this.S.stringVal();
        return prefix.isEmpty() ? s : prefix + s;
    }

    @Override
    public JCTree.JCExpression parseExpression() {
        return this.term(1);
    }

    @Override
    public JCTree.JCExpression parseType() {
        return this.term(2);
    }

    JCTree.JCExpression term(int newmode) {
        int prevmode = this.mode;
        this.mode = newmode;
        JCTree.JCExpression t = this.term();
        this.lastmode = this.mode;
        this.mode = prevmode;
        return t;
    }

    JCTree.JCExpression term() {
        JCTree.JCExpression t = this.term1();
        if ((this.mode & 1) != 0 && this.S.token() == Token.EQ || Token.PLUSEQ.compareTo(this.S.token()) <= 0 && this.S.token().compareTo(Token.GTGTGTEQ) <= 0) {
            return this.termRest(t);
        }
        return t;
    }

    JCTree.JCExpression termRest(JCTree.JCExpression t) {
        switch (this.S.token()) {
            case EQ: {
                int pos = this.S.pos();
                this.S.nextToken();
                this.mode = 1;
                JCTree.JCExpression t1 = this.term();
                return this.toP(this.F.at(pos).Assign(t, t1));
            }
            case PLUSEQ: 
            case SUBEQ: 
            case STAREQ: 
            case SLASHEQ: 
            case PERCENTEQ: 
            case AMPEQ: 
            case BAREQ: 
            case CARETEQ: 
            case LTLTEQ: 
            case GTGTEQ: 
            case GTGTGTEQ: {
                int pos = this.S.pos();
                Token token = this.S.token();
                this.S.nextToken();
                this.mode = 1;
                JCTree.JCExpression t1 = this.term();
                return this.F.at(pos).Assignop(JavacParser.optag(token), t, t1);
            }
        }
        return t;
    }

    JCTree.JCExpression term1() {
        JCTree.JCExpression t = this.term2();
        if ((this.mode & 1) != 0 && this.S.token() == Token.QUES) {
            this.mode = 1;
            return this.term1Rest(t);
        }
        return t;
    }

    JCTree.JCExpression term1Rest(JCTree.JCExpression t) {
        if (this.S.token() == Token.QUES) {
            int pos = this.S.pos();
            this.S.nextToken();
            JCTree.JCExpression t1 = this.term();
            this.accept(Token.COLON);
            JCTree.JCExpression t2 = this.term1();
            return this.F.at(pos).Conditional(t, t1, t2);
        }
        return t;
    }

    JCTree.JCExpression term2() {
        JCTree.JCExpression t = this.term3();
        if ((this.mode & 1) != 0 && JavacParser.prec(this.S.token()) >= 4) {
            this.mode = 1;
            return this.term2Rest(t, 4);
        }
        return t;
    }

    JCTree.JCExpression term2Rest(JCTree.JCExpression t, int minprec) {
        StringBuffer buf;
        List savedOd = this.odStackSupply.elems;
        JCTree.JCExpression[] odStack = this.newOdStack();
        List savedOp = this.opStackSupply.elems;
        Token[] opStack = this.newOpStack();
        List savedPos = this.posStackSupply.elems;
        int[] posStack = this.newPosStack();
        int top = 0;
        odStack[0] = t;
        int startPos = this.S.pos();
        Token topOp = Token.ERROR;
        int topOpPos = -1;
        while (JavacParser.prec(this.S.token()) >= minprec) {
            posStack[top] = topOpPos;
            opStack[top] = topOp;
            topOp = this.S.token();
            topOpPos = this.S.pos();
            this.S.nextToken();
            JCTree.JCExpression jCExpression = odStack[++top] = topOp == Token.INSTANCEOF ? this.parseType() : this.term3();
            while (top > 0 && JavacParser.prec(topOp) >= JavacParser.prec(this.S.token())) {
                odStack[top - 1] = this.makeOp(topOpPos, topOp, odStack[top - 1], odStack[top]);
                topOp = opStack[--top];
                topOpPos = posStack[top];
            }
        }
        Assert.check(top == 0);
        t = odStack[0];
        if (t.getTag() == 69 && (buf = this.foldStrings(t)) != null) {
            t = this.toP(this.F.at(startPos).Literal(10, buf.toString()));
        }
        this.odStackSupply.elems = savedOd;
        this.posStackSupply.elems = savedPos;
        this.opStackSupply.elems = savedOp;
        this.posStackSupply.elems = savedPos;
        return t;
    }

    private JCTree.JCExpression makeOp(int pos, Token topOp, JCTree.JCExpression od1, JCTree.JCExpression od2) {
        if (topOp == Token.INSTANCEOF) {
            return this.F.at(pos).TypeTest(od1, od2);
        }
        return this.F.at(pos).Binary(JavacParser.optag(topOp), od1, od2);
    }

    protected StringBuffer foldStrings(JCTree tree) {
        if (!this.allowStringFolding) {
            return null;
        }
        List<String> buf = List.nil();
        while (true) {
            if (tree.getTag() == 36) {
                JCTree.JCLiteral lit = (JCTree.JCLiteral)tree;
                if (lit.typetag != 10) break;
                StringBuffer sbuf = new StringBuffer((String)lit.value);
                while (buf.nonEmpty()) {
                    sbuf.append((String)buf.head);
                    buf = buf.tail;
                }
                return sbuf;
            }
            if (tree.getTag() != 69) break;
            JCTree.JCBinary op = (JCTree.JCBinary)tree;
            if (op.rhs.getTag() != 36) break;
            JCTree.JCLiteral lit = (JCTree.JCLiteral)op.rhs;
            if (lit.typetag != 10) break;
            buf = buf.prepend((String)lit.value);
            tree = op.lhs;
        }
        return null;
    }

    private JCTree.JCExpression[] newOdStack() {
        if (this.odStackSupply.elems == this.odStackSupply.last) {
            this.odStackSupply.append(new JCTree.JCExpression[11]);
        }
        JCTree.JCExpression[] odStack = (JCTree.JCExpression[])this.odStackSupply.elems.head;
        this.odStackSupply.elems = this.odStackSupply.elems.tail;
        return odStack;
    }

    private Token[] newOpStack() {
        if (this.opStackSupply.elems == this.opStackSupply.last) {
            this.opStackSupply.append(new Token[11]);
        }
        Token[] opStack = (Token[])this.opStackSupply.elems.head;
        this.opStackSupply.elems = this.opStackSupply.elems.tail;
        return opStack;
    }

    private int[] newPosStack() {
        if (this.posStackSupply.elems == this.posStackSupply.last) {
            this.posStackSupply.append(new int[11]);
        }
        int[] posStack = (int[])this.posStackSupply.elems.head;
        this.posStackSupply.elems = this.posStackSupply.elems.tail;
        return posStack;
    }

    protected JCTree.JCExpression term3() {
        JCTree.JCExpression t;
        int pos = this.S.pos();
        int prevmode = this.mode;
        List<JCTree.JCExpression> typeArgs = this.typeArgumentsOpt(1);
        if (typeArgs != null && this.S.pos() <= this.errorEndPos) {
            this.mode = prevmode;
            return this.F.at(pos).Erroneous(typeArgs);
        }
        switch (this.S.token()) {
            case QUES: {
                if ((this.mode & 2) != 0 && (this.mode & 0xC) == 8) {
                    this.mode = 2;
                    return this.typeArgument();
                }
                return this.illegal();
            }
            case BANG: 
            case TILDE: 
            case PLUSPLUS: 
            case SUBSUB: 
            case PLUS: 
            case SUB: {
                if (typeArgs == null && (this.mode & 1) != 0) {
                    Token token = this.S.token();
                    this.S.nextToken();
                    this.mode = 1;
                    if (token == Token.SUB && (this.S.token() == Token.INTLITERAL || this.S.token() == Token.LONGLITERAL) && this.S.radix() == 10) {
                        this.mode = 1;
                        t = this.literal(this.names.hyphen, pos);
                        break;
                    }
                    JCTree.JCExpression t2 = this.term3();
                    return this.F.at(pos).Unary(JavacParser.unoptag(token), t2);
                }
                return this.illegal();
            }
            case LPAREN: {
                int pos1;
                if (typeArgs == null && (this.mode & 1) != 0) {
                    this.S.nextToken();
                    this.mode = 7;
                    t = this.term3();
                    if ((this.mode & 2) != 0 && this.S.token() == Token.LT) {
                        int op = 62;
                        pos1 = this.S.pos();
                        this.S.nextToken();
                        this.mode &= 3;
                        this.mode |= 8;
                        JCTree.JCExpression t1 = this.term3();
                        if ((this.mode & 2) != 0 && (this.S.token() == Token.COMMA || this.S.token() == Token.GT)) {
                            this.mode = 2;
                            ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
                            args.append(t1);
                            while (this.S.token() == Token.COMMA) {
                                this.S.nextToken();
                                args.append(this.typeArgument());
                            }
                            this.accept(Token.GT);
                            t = this.toP(this.F.at(pos1).TypeApply(t, args.toList()));
                            this.checkGenerics();
                            while (this.S.token() == Token.DOT) {
                                this.S.nextToken();
                                this.mode = 2;
                                t = this.toP(this.F.at(this.S.pos()).Select(t, this.ident()));
                                t = this.typeArgumentsOpt(t);
                            }
                            t = this.bracketsOpt(this.toP(t));
                        } else if ((this.mode & 1) != 0) {
                            this.mode = 1;
                            JCTree.JCExpression e = this.term2Rest(t1, 11);
                            t = this.F.at(pos1).Binary(op, t, e);
                            t = this.termRest(this.term1Rest(this.term2Rest(t, 4)));
                        } else {
                            this.accept(Token.GT);
                        }
                    } else {
                        t = this.termRest(this.term1Rest(this.term2Rest(t, 4)));
                    }
                    this.accept(Token.RPAREN);
                    this.lastmode = this.mode;
                    this.mode = 1;
                    if ((this.lastmode & 1) == 0) {
                        JCTree.JCExpression t1 = this.term3();
                        return this.F.at(pos).TypeCast(t, t1);
                    }
                    if ((this.lastmode & 2) != 0) {
                        switch (this.S.token()) {
                            case ENUM: 
                            case BYTE: 
                            case SHORT: 
                            case CHAR: 
                            case INT: 
                            case LONG: 
                            case FLOAT: 
                            case DOUBLE: 
                            case BOOLEAN: 
                            case VOID: 
                            case IDENTIFIER: 
                            case THIS: 
                            case SUPER: 
                            case INTLITERAL: 
                            case LONGLITERAL: 
                            case FLOATLITERAL: 
                            case DOUBLELITERAL: 
                            case CHARLITERAL: 
                            case STRINGLITERAL: 
                            case TRUE: 
                            case FALSE: 
                            case NULL: 
                            case BANG: 
                            case TILDE: 
                            case LPAREN: 
                            case NEW: 
                            case ASSERT: {
                                JCTree.JCExpression t1 = this.term3();
                                return this.F.at(pos).TypeCast(t, t1);
                            }
                        }
                    }
                } else {
                    return this.illegal();
                }
                t = this.toP(this.F.at(pos).Parens(t));
                break;
            }
            case THIS: {
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    t = this.to(this.F.at(pos).Ident(this.names._this));
                    this.S.nextToken();
                    t = typeArgs == null ? this.argumentsOpt(null, t) : this.arguments(typeArgs, t);
                    typeArgs = null;
                    break;
                }
                return this.illegal();
            }
            case SUPER: {
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    t = this.to(this.F.at(pos).Ident(this.names._super));
                    t = this.superSuffix(typeArgs, t);
                    typeArgs = null;
                    break;
                }
                return this.illegal();
            }
            case INTLITERAL: 
            case LONGLITERAL: 
            case FLOATLITERAL: 
            case DOUBLELITERAL: 
            case CHARLITERAL: 
            case STRINGLITERAL: 
            case TRUE: 
            case FALSE: 
            case NULL: {
                if (typeArgs == null && (this.mode & 1) != 0) {
                    this.mode = 1;
                    t = this.literal(this.names.empty, this.S.pos());
                    break;
                }
                return this.illegal();
            }
            case NEW: {
                if (typeArgs != null) {
                    return this.illegal();
                }
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    this.S.nextToken();
                    if (this.S.token() == Token.LT) {
                        typeArgs = this.typeArguments(false);
                    }
                    t = this.creator(pos, typeArgs);
                    typeArgs = null;
                    break;
                }
                return this.illegal();
            }
            case ENUM: 
            case IDENTIFIER: 
            case ASSERT: {
                int pos1;
                if (typeArgs != null) {
                    return this.illegal();
                }
                t = this.toP(this.F.at(this.S.pos()).Ident(this.ident()));
                block28: while (true) {
                    pos = this.S.pos();
                    switch (this.S.token()) {
                        case LBRACKET: {
                            this.S.nextToken();
                            if (this.S.token() == Token.RBRACKET) {
                                this.S.nextToken();
                                t = this.bracketsOpt(t);
                                t = this.toP(this.F.at(pos).TypeArray(t));
                                t = this.bracketsSuffix(t);
                                break block28;
                            }
                            if ((this.mode & 1) != 0) {
                                this.mode = 1;
                                JCTree.JCExpression t1 = this.term();
                                t = this.to(this.F.at(pos).Indexed(t, t1));
                            }
                            this.accept(Token.RBRACKET);
                            break block28;
                        }
                        case LPAREN: {
                            if ((this.mode & 1) != 0) {
                                this.mode = 1;
                                t = this.arguments(typeArgs, t);
                                typeArgs = null;
                            }
                            break block28;
                        }
                        case DOT: {
                            this.S.nextToken();
                            int oldmode = this.mode;
                            this.mode &= 0xFFFFFFFB;
                            typeArgs = this.typeArgumentsOpt(1);
                            this.mode = oldmode;
                            if ((this.mode & 1) != 0) {
                                switch (this.S.token()) {
                                    case CLASS: {
                                        if (typeArgs != null) {
                                            return this.illegal();
                                        }
                                        this.mode = 1;
                                        t = this.to(this.F.at(pos).Select(t, this.names._class));
                                        this.S.nextToken();
                                        break block28;
                                    }
                                    case THIS: {
                                        if (typeArgs != null) {
                                            return this.illegal();
                                        }
                                        this.mode = 1;
                                        t = this.to(this.F.at(pos).Select(t, this.names._this));
                                        this.S.nextToken();
                                        break block28;
                                    }
                                    case SUPER: {
                                        this.mode = 1;
                                        t = this.to(this.F.at(pos).Select(t, this.names._super));
                                        t = this.superSuffix(typeArgs, t);
                                        typeArgs = null;
                                        break block28;
                                    }
                                    case NEW: {
                                        if (typeArgs != null) {
                                            return this.illegal();
                                        }
                                        this.mode = 1;
                                        pos1 = this.S.pos();
                                        this.S.nextToken();
                                        if (this.S.token() == Token.LT) {
                                            typeArgs = this.typeArguments(false);
                                        }
                                        t = this.innerCreator(pos1, typeArgs, t);
                                        typeArgs = null;
                                        break block28;
                                    }
                                }
                            }
                            t = this.toP(this.F.at(pos).Select(t, this.ident()));
                            continue block28;
                        }
                    }
                    break;
                }
                if (typeArgs != null) {
                    this.illegal();
                }
                t = this.typeArgumentsOpt(t);
                break;
            }
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                if (typeArgs != null) {
                    this.illegal();
                }
                t = this.bracketsSuffix(this.bracketsOpt(this.basicType()));
                break;
            }
            case VOID: {
                if (typeArgs != null) {
                    this.illegal();
                }
                if ((this.mode & 1) != 0) {
                    this.S.nextToken();
                    if (this.S.token() == Token.DOT) {
                        JCTree.JCPrimitiveTypeTree ti = this.toP(this.F.at(pos).TypeIdent(9));
                        t = this.bracketsSuffix(ti);
                        break;
                    }
                    return this.illegal(pos);
                }
                JCTree.JCPrimitiveTypeTree ti = this.to(this.F.at(pos).TypeIdent(9));
                this.S.nextToken();
                return ti;
            }
            default: {
                return this.illegal();
            }
        }
        if (typeArgs != null) {
            this.illegal();
        }
        while (true) {
            int pos1 = this.S.pos();
            if (this.S.token() == Token.LBRACKET) {
                this.S.nextToken();
                if ((this.mode & 2) != 0) {
                    int oldmode = this.mode;
                    this.mode = 2;
                    if (this.S.token() == Token.RBRACKET) {
                        this.S.nextToken();
                        t = this.bracketsOpt(t);
                        t = this.toP(this.F.at(pos1).TypeArray(t));
                        return t;
                    }
                    this.mode = oldmode;
                }
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    JCTree.JCExpression t1 = this.term();
                    t = this.to(this.F.at(pos1).Indexed(t, t1));
                }
                this.accept(Token.RBRACKET);
                continue;
            }
            if (this.S.token() != Token.DOT) break;
            this.S.nextToken();
            typeArgs = this.typeArgumentsOpt(1);
            if (this.S.token() == Token.SUPER && (this.mode & 1) != 0) {
                this.mode = 1;
                t = this.to(this.F.at(pos1).Select(t, this.names._super));
                this.S.nextToken();
                t = this.arguments(typeArgs, t);
                typeArgs = null;
                continue;
            }
            if (this.S.token() == Token.NEW && (this.mode & 1) != 0) {
                if (typeArgs != null) {
                    return this.illegal();
                }
                this.mode = 1;
                int pos2 = this.S.pos();
                this.S.nextToken();
                if (this.S.token() == Token.LT) {
                    typeArgs = this.typeArguments(false);
                }
                t = this.innerCreator(pos2, typeArgs, t);
                typeArgs = null;
                continue;
            }
            t = this.toP(this.F.at(pos1).Select(t, this.ident()));
            t = this.argumentsOpt(typeArgs, this.typeArgumentsOpt(t));
            typeArgs = null;
        }
        while ((this.S.token() == Token.PLUSPLUS || this.S.token() == Token.SUBSUB) && (this.mode & 1) != 0) {
            this.mode = 1;
            t = this.to(this.F.at(this.S.pos()).Unary(this.S.token() == Token.PLUSPLUS ? 52 : 53, t));
            this.S.nextToken();
        }
        return this.toP(t);
    }

    JCTree.JCExpression superSuffix(List<JCTree.JCExpression> typeArgs, JCTree.JCExpression t) {
        this.S.nextToken();
        if (this.S.token() == Token.LPAREN || typeArgs != null) {
            t = this.arguments(typeArgs, t);
        } else {
            int pos = this.S.pos();
            this.accept(Token.DOT);
            typeArgs = this.S.token() == Token.LT ? this.typeArguments(false) : null;
            t = this.toP(this.F.at(pos).Select(t, this.ident()));
            t = this.argumentsOpt(typeArgs, t);
        }
        return t;
    }

    JCTree.JCPrimitiveTypeTree basicType() {
        JCTree.JCPrimitiveTypeTree t = this.to(this.F.at(this.S.pos()).TypeIdent(JavacParser.typetag(this.S.token())));
        this.S.nextToken();
        return t;
    }

    JCTree.JCExpression argumentsOpt(List<JCTree.JCExpression> typeArgs, JCTree.JCExpression t) {
        if ((this.mode & 1) != 0 && this.S.token() == Token.LPAREN || typeArgs != null) {
            this.mode = 1;
            return this.arguments(typeArgs, t);
        }
        return t;
    }

    List<JCTree.JCExpression> arguments() {
        ListBuffer args = ListBuffer.lb();
        if (this.S.token() == Token.LPAREN) {
            this.S.nextToken();
            if (this.S.token() != Token.RPAREN) {
                args.append(this.parseExpression());
                while (this.S.token() == Token.COMMA) {
                    this.S.nextToken();
                    args.append(this.parseExpression());
                }
            }
            this.accept(Token.RPAREN);
        } else {
            this.syntaxError(this.S.pos(), "expected", Token.LPAREN);
        }
        return args.toList();
    }

    JCTree.JCMethodInvocation arguments(List<JCTree.JCExpression> typeArgs, JCTree.JCExpression t) {
        int pos = this.S.pos();
        List<JCTree.JCExpression> args = this.arguments();
        return this.toP(this.F.at(pos).Apply(typeArgs, t, args));
    }

    JCTree.JCExpression typeArgumentsOpt(JCTree.JCExpression t) {
        if (this.S.token() == Token.LT && (this.mode & 2) != 0 && (this.mode & 4) == 0) {
            this.mode = 2;
            this.checkGenerics();
            return this.typeArguments(t, false);
        }
        return t;
    }

    List<JCTree.JCExpression> typeArgumentsOpt() {
        return this.typeArgumentsOpt(2);
    }

    List<JCTree.JCExpression> typeArgumentsOpt(int useMode) {
        if (this.S.token() == Token.LT) {
            this.checkGenerics();
            if ((this.mode & useMode) == 0 || (this.mode & 4) != 0) {
                this.illegal();
            }
            this.mode = useMode;
            return this.typeArguments(false);
        }
        return null;
    }

    List<JCTree.JCExpression> typeArguments(boolean diamondAllowed) {
        if (this.S.token() == Token.LT) {
            this.S.nextToken();
            if (this.S.token() == Token.GT && diamondAllowed) {
                this.checkDiamond();
                this.mode |= 0x10;
                this.S.nextToken();
                return List.nil();
            }
            ListBuffer args = ListBuffer.lb();
            args.append((this.mode & 1) == 0 ? this.typeArgument() : this.parseType());
            while (this.S.token() == Token.COMMA) {
                this.S.nextToken();
                args.append((this.mode & 1) == 0 ? this.typeArgument() : this.parseType());
            }
            switch (this.S.token()) {
                case GTGTGTEQ: {
                    this.S.token(Token.GTGTEQ);
                    break;
                }
                case GTGTEQ: {
                    this.S.token(Token.GTEQ);
                    break;
                }
                case GTEQ: {
                    this.S.token(Token.EQ);
                    break;
                }
                case GTGTGT: {
                    this.S.token(Token.GTGT);
                    break;
                }
                case GTGT: {
                    this.S.token(Token.GT);
                    break;
                }
                case GT: {
                    this.S.nextToken();
                    break;
                }
                default: {
                    args.append(this.syntaxError(this.S.pos(), "expected", Token.GT));
                }
            }
            return args.toList();
        }
        return List.of(this.syntaxError(this.S.pos(), "expected", Token.LT));
    }

    JCTree.JCExpression typeArgument() {
        if (this.S.token() != Token.QUES) {
            return this.parseType();
        }
        int pos = this.S.pos();
        this.S.nextToken();
        if (this.S.token() == Token.EXTENDS) {
            JCTree.TypeBoundKind t = this.to(this.F.at(pos).TypeBoundKind(BoundKind.EXTENDS));
            this.S.nextToken();
            JCTree.JCExpression bound = this.parseType();
            return this.F.at(pos).Wildcard(t, bound);
        }
        if (this.S.token() == Token.SUPER) {
            JCTree.TypeBoundKind t = this.to(this.F.at(pos).TypeBoundKind(BoundKind.SUPER));
            this.S.nextToken();
            JCTree.JCExpression bound = this.parseType();
            return this.F.at(pos).Wildcard(t, bound);
        }
        if (this.S.token() == Token.IDENTIFIER) {
            JCTree.TypeBoundKind t = this.F.at(-1).TypeBoundKind(BoundKind.UNBOUND);
            JCTree.JCExpression wc = this.toP(this.F.at(pos).Wildcard(t, null));
            JCTree.JCIdent id = this.toP(this.F.at(this.S.pos()).Ident(this.ident()));
            JCTree.JCErroneous err = this.F.at(pos).Erroneous(List.of(wc, id));
            this.reportSyntaxError(err, this.S.prevEndPos(), "expected3", Token.GT, Token.EXTENDS, Token.SUPER);
            return err;
        }
        JCTree.TypeBoundKind t = this.toP(this.F.at(pos).TypeBoundKind(BoundKind.UNBOUND));
        return this.toP(this.F.at(pos).Wildcard(t, null));
    }

    JCTree.JCTypeApply typeArguments(JCTree.JCExpression t, boolean diamondAllowed) {
        int pos = this.S.pos();
        List<JCTree.JCExpression> args = this.typeArguments(diamondAllowed);
        return this.toP(this.F.at(pos).TypeApply(t, args));
    }

    private JCTree.JCExpression bracketsOpt(JCTree.JCExpression t) {
        if (this.S.token() == Token.LBRACKET) {
            int pos = this.S.pos();
            this.S.nextToken();
            t = this.bracketsOptCont(t, pos);
            this.F.at(pos);
        }
        return t;
    }

    private JCTree.JCArrayTypeTree bracketsOptCont(JCTree.JCExpression t, int pos) {
        this.accept(Token.RBRACKET);
        t = this.bracketsOpt(t);
        return this.toP(this.F.at(pos).TypeArray(t));
    }

    JCTree.JCExpression bracketsSuffix(JCTree.JCExpression t) {
        if ((this.mode & 1) != 0 && this.S.token() == Token.DOT) {
            this.mode = 1;
            int pos = this.S.pos();
            this.S.nextToken();
            this.accept(Token.CLASS);
            if (this.S.pos() == this.errorEndPos) {
                Name name = null;
                if (this.S.token() == Token.IDENTIFIER) {
                    name = this.S.name();
                    this.S.nextToken();
                } else {
                    name = this.names.error;
                }
                t = this.F.at(pos).Erroneous(List.of(this.toP(this.F.at(pos).Select(t, name))));
            } else {
                t = this.toP(this.F.at(pos).Select(t, this.names._class));
            }
        } else if ((this.mode & 2) != 0) {
            this.mode = 2;
        } else {
            this.syntaxError(this.S.pos(), "dot.class.expected", new Token[0]);
        }
        return t;
    }

    JCTree.JCExpression creator(int newpos, List<JCTree.JCExpression> typeArgs) {
        switch (this.S.token()) {
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                if (typeArgs != null) break;
                return this.arrayCreatorRest(newpos, this.basicType());
            }
        }
        JCTree.JCExpression t = this.qualident();
        int oldmode = this.mode;
        this.mode = 2;
        boolean diamondFound = false;
        if (this.S.token() == Token.LT) {
            this.checkGenerics();
            t = this.typeArguments(t, true);
            boolean bl = diamondFound = (this.mode & 0x10) != 0;
        }
        while (this.S.token() == Token.DOT) {
            if (diamondFound) {
                this.illegal(this.S.pos());
            }
            int pos = this.S.pos();
            this.S.nextToken();
            t = this.toP(this.F.at(pos).Select(t, this.ident()));
            if (this.S.token() != Token.LT) continue;
            this.checkGenerics();
            t = this.typeArguments(t, true);
            diamondFound = (this.mode & 0x10) != 0;
        }
        this.mode = oldmode;
        if (this.S.token() == Token.LBRACKET) {
            JCTree.JCExpression e = this.arrayCreatorRest(newpos, t);
            if (typeArgs != null) {
                int pos = newpos;
                if (!typeArgs.isEmpty() && ((JCTree.JCExpression)typeArgs.head).pos != -1) {
                    pos = ((JCTree.JCExpression)typeArgs.head).pos;
                }
                this.setErrorEndPos(this.S.prevEndPos());
                JCTree.JCErroneous err = this.F.at(pos).Erroneous(typeArgs.prepend(e));
                this.reportSyntaxError(err, pos, "cannot.create.array.with.type.arguments", new Object[0]);
                return this.toP(err);
            }
            return e;
        }
        if (this.S.token() == Token.LPAREN) {
            return this.classCreatorRest(newpos, null, typeArgs, t);
        }
        this.errorEndPos = this.S.pos();
        t = this.toP(this.F.at(newpos).NewClass(null, typeArgs, t, List.<JCTree.JCExpression>nil(), null));
        JCTree.JCErroneous err = this.F.at(newpos).Erroneous(List.of(t));
        this.reportSyntaxError(err, this.S.pos(), "expected2", Token.LPAREN, Token.LBRACKET);
        return this.toP(err);
    }

    JCTree.JCExpression innerCreator(int newpos, List<JCTree.JCExpression> typeArgs, JCTree.JCExpression encl) {
        JCTree.JCExpression t = this.toP(this.F.at(this.S.pos()).Ident(this.ident()));
        if (this.S.token() == Token.LT) {
            int oldmode = this.mode;
            this.checkGenerics();
            t = this.typeArguments(t, true);
            this.mode = oldmode;
        }
        return this.classCreatorRest(newpos, encl, typeArgs, t);
    }

    JCTree.JCExpression arrayCreatorRest(int newpos, JCTree.JCExpression elemtype) {
        this.accept(Token.LBRACKET);
        if (this.S.token() == Token.RBRACKET) {
            this.accept(Token.RBRACKET);
            elemtype = this.bracketsOpt(elemtype);
            if (this.S.token() == Token.LBRACE) {
                return this.arrayInitializer(newpos, elemtype);
            }
            return this.syntaxError(this.S.pos(), List.of(this.toP(this.F.at(newpos).NewArray(elemtype, List.<JCTree.JCExpression>nil(), null))), "array.dimension.missing", new Token[0]);
        }
        ListBuffer<JCTree.JCExpression> dims = new ListBuffer<JCTree.JCExpression>();
        dims.append(this.parseExpression());
        this.accept(Token.RBRACKET);
        while (this.S.token() == Token.LBRACKET) {
            int pos = this.S.pos();
            this.S.nextToken();
            if (this.S.token() == Token.RBRACKET) {
                elemtype = this.bracketsOptCont(elemtype, pos);
                continue;
            }
            dims.append(this.parseExpression());
            this.accept(Token.RBRACKET);
        }
        return this.toP(this.F.at(newpos).NewArray(elemtype, dims.toList(), null));
    }

    JCTree.JCNewClass classCreatorRest(int newpos, JCTree.JCExpression encl, List<JCTree.JCExpression> typeArgs, JCTree.JCExpression t) {
        List<JCTree.JCExpression> args = this.arguments();
        JCTree.JCClassDecl body = null;
        if (this.S.token() == Token.LBRACE) {
            int pos = 0;
            List<JCTree> defs = null;
            JCTree.JCModifiers mods = null;
            pos = this.S.pos();
            defs = this.classOrInterfaceBody(this.names.empty, false);
            mods = this.F.at(-1).Modifiers(0L);
            body = this.toP(this.F.at(pos).AnonymousClassDef(mods, defs));
        }
        return this.toP(this.F.at(newpos).NewClass(encl, typeArgs, t, args, body));
    }

    JCTree.JCExpression arrayInitializer(int newpos, JCTree.JCExpression t) {
        this.accept(Token.LBRACE);
        ListBuffer<JCTree.JCExpression> elems = new ListBuffer<JCTree.JCExpression>();
        if (this.S.token() == Token.COMMA) {
            this.S.nextToken();
        } else if (this.S.token() != Token.RBRACE) {
            elems.append(this.variableInitializer());
            while (this.S.token() == Token.COMMA) {
                this.S.nextToken();
                if (this.S.token() == Token.RBRACE) break;
                elems.append(this.variableInitializer());
            }
            if (this.S.pos() <= this.errorEndPos) {
                this.skip(false, true, true, true);
            }
        }
        this.accept(Token.RBRACE);
        return this.toP(this.F.at(newpos).NewArray(t, List.<JCTree.JCExpression>nil(), elems.toList()));
    }

    public JCTree.JCExpression variableInitializer() {
        return this.S.token() == Token.LBRACE ? this.arrayInitializer(this.S.pos(), null) : this.parseExpression();
    }

    JCTree.JCExpression parExpression() {
        this.accept(Token.LPAREN);
        JCTree.JCExpression t = this.parseExpression();
        this.accept(Token.RPAREN);
        return t;
    }

    JCTree.JCBlock block(int pos, long flags) {
        this.accept(Token.LBRACE);
        List<JCTree.JCStatement> stats = this.blockStatements();
        JCTree.JCBlock t = this.F.at(pos).Block(flags, stats);
        while (this.S.token() == Token.CASE || this.S.token() == Token.DEFAULT) {
            this.syntaxError("orphaned", this.S.token());
            this.switchBlockStatementGroups();
        }
        t.endpos = this.S.pos();
        this.accept(Token.RBRACE);
        return this.toP(t);
    }

    public JCTree.JCBlock block() {
        return this.block(this.S.pos(), 0L);
    }

    List<JCTree.JCStatement> blockStatements() {
        int lastErrPos = -1;
        ListBuffer<JCTree.JCStatement> stats = new ListBuffer<JCTree.JCStatement>();
        while (true) {
            switch (this.S.token()) {
                case EOF: 
                case RBRACE: 
                case CASE: 
                case DEFAULT: {
                    return stats.toList();
                }
            }
            stats.appendList(this.blockStatement());
            if (this.S.pos() == lastErrPos) {
                return stats.toList();
            }
            if (this.S.pos() <= this.errorEndPos) {
                this.skip(false, true, true, true);
                lastErrPos = this.S.pos();
            }
            this.S.resetDeprecatedFlag();
        }
    }

    List<JCTree.JCStatement> blockStatement() {
        ListBuffer<JCTree.JCStatement> stats = new ListBuffer<JCTree.JCStatement>();
        int pos = this.S.pos();
        switch (this.S.token()) {
            case LBRACE: {
                stats.add(this.block());
                break;
            }
            case IF: {
                this.S.nextToken();
                JCTree.JCExpression cond = this.parExpression();
                JCTree.JCStatement thenpart = this.parseStatement();
                JCTree.JCStatement elsepart = null;
                if (this.S.token() == Token.ELSE) {
                    this.S.nextToken();
                    elsepart = this.parseStatement();
                }
                stats.add(this.F.at(pos).If(cond, thenpart, elsepart));
                break;
            }
            case FOR: {
                List<Object> inits;
                this.S.nextToken();
                this.accept(Token.LPAREN);
                List<Object> list = inits = this.S.token() == Token.SEMI ? List.nil() : this.forInit();
                if (inits.length() == 1 && ((JCTree.JCStatement)inits.head).getTag() == 5 && ((JCTree.JCVariableDecl)inits.head).init == null && this.S.token() == Token.COLON) {
                    this.checkForeach();
                    JCTree.JCVariableDecl var = (JCTree.JCVariableDecl)inits.head;
                    this.accept(Token.COLON);
                    JCTree.JCExpression expr = this.parseExpression();
                    this.accept(Token.RPAREN);
                    if (this.errorEndPos >= this.S.pos()) {
                        this.storeEnd(expr, this.errorEndPos);
                    }
                    JCTree.JCStatement body = this.parseStatement();
                    stats.add(this.F.at(pos).ForeachLoop(var, expr, body));
                    break;
                }
                this.accept(Token.SEMI);
                if (this.errorEndPos >= this.S.pos() && inits.length() > 0) {
                    this.storeEnd((JCTree)inits.last(), this.errorEndPos);
                }
                JCTree.JCExpression cond = this.S.token() == Token.SEMI ? null : this.parseExpression();
                this.accept(Token.SEMI);
                if (this.errorEndPos >= this.S.pos()) {
                    this.storeEnd(cond, this.errorEndPos);
                }
                List<Object> steps = this.S.token() == Token.RPAREN ? List.nil() : this.forUpdate();
                this.accept(Token.RPAREN);
                if (this.errorEndPos >= this.S.pos() && steps.length() > 0) {
                    this.storeEnd((JCTree)steps.last(), this.errorEndPos);
                }
                JCTree.JCStatement body = this.parseStatement();
                stats.add(this.F.at(pos).ForLoop(inits, cond, steps, body));
                break;
            }
            case WHILE: {
                this.S.nextToken();
                JCTree.JCExpression cond = this.parExpression();
                JCTree.JCStatement body = this.parseStatement();
                stats.add(this.F.at(pos).WhileLoop(cond, body));
                break;
            }
            case DO: {
                this.S.nextToken();
                JCTree.JCStatement body = this.parseStatement();
                this.accept(Token.WHILE);
                JCTree.JCExpression cond = this.parExpression();
                this.accept(Token.SEMI);
                JCTree.JCDoWhileLoop t = this.toP(this.F.at(pos).DoLoop(body, cond));
                stats.add(t);
                break;
            }
            case TRY: {
                this.S.nextToken();
                List<Object> resources = List.nil();
                if (this.S.token() == Token.LPAREN) {
                    this.checkTryWithResources();
                    this.S.nextToken();
                    resources = this.resources();
                    this.accept(Token.RPAREN);
                }
                JCTree.JCBlock body = this.block();
                ListBuffer<JCTree.JCCatch> catchers = new ListBuffer<JCTree.JCCatch>();
                JCTree.JCBlock finalizer = null;
                String err = null;
                if (this.S.token() == Token.CATCH || this.S.token() == Token.FINALLY) {
                    while (this.S.token() == Token.CATCH) {
                        catchers.append(this.catchClause());
                    }
                    if (this.S.token() == Token.FINALLY) {
                        this.S.nextToken();
                        finalizer = this.block();
                    }
                } else if (this.allowTWR) {
                    if (resources.isEmpty()) {
                        err = "try.without.catch.finally.or.resource.decls";
                    }
                } else {
                    err = "try.without.catch.or.finally";
                }
                JCTree.JCTry t = this.F.at(pos).Try(resources, body, catchers.toList(), finalizer);
                if (err != null) {
                    this.error(t, err, new Object[0]);
                }
                stats.add(t);
                break;
            }
            case SWITCH: {
                this.S.nextToken();
                JCTree.JCExpression selector = this.parExpression();
                this.accept(Token.LBRACE);
                List<JCTree.JCCase> cases = this.switchBlockStatementGroups();
                JCTree.JCSwitch t = this.to(this.F.at(pos).Switch(selector, cases));
                this.accept(Token.RBRACE);
                stats.add(t);
                break;
            }
            case SYNCHRONIZED: {
                this.S.nextToken();
                JCTree.JCExpression lock = this.parExpression();
                JCTree.JCBlock body = this.block();
                stats.add(this.F.at(pos).Synchronized(lock, body));
                break;
            }
            case RETURN: {
                this.S.nextToken();
                JCTree.JCExpression result = this.S.token() == Token.SEMI ? null : this.parseExpression();
                this.accept(Token.SEMI);
                JCTree.JCReturn t = this.toP(this.F.at(pos).Return(result));
                stats.add(t);
                break;
            }
            case THROW: {
                this.S.nextToken();
                JCTree.JCExpression exc = this.parseExpression();
                this.accept(Token.SEMI);
                JCTree.JCThrow t = this.toP(this.F.at(pos).Throw(exc));
                stats.add(t);
                break;
            }
            case BREAK: {
                this.S.nextToken();
                Name label = this.S.token() == Token.IDENTIFIER || this.S.token() == Token.ASSERT || this.S.token() == Token.ENUM ? this.ident() : null;
                this.accept(Token.SEMI);
                JCTree.JCBreak t = this.toP(this.F.at(pos).Break(label));
                stats.add(t);
                break;
            }
            case CONTINUE: {
                this.S.nextToken();
                Name label = this.S.token() == Token.IDENTIFIER || this.S.token() == Token.ASSERT || this.S.token() == Token.ENUM ? this.ident() : null;
                this.accept(Token.SEMI);
                JCTree.JCContinue t = this.toP(this.F.at(pos).Continue(label));
                stats.add(t);
                break;
            }
            case SEMI: {
                this.S.nextToken();
                stats.add(this.toP(this.F.at(pos).Skip()));
                break;
            }
            case ELSE: {
                stats.add(this.toP(this.F.Exec(this.syntaxError("else.without.if"))));
                break;
            }
            case FINALLY: {
                stats.add(this.toP(this.F.Exec(this.syntaxError("finally.without.try"))));
                break;
            }
            case CATCH: {
                stats.add(this.toP(this.F.Exec(this.syntaxError("catch.without.try"))));
                break;
            }
            case FINAL: 
            case MONKEYS_AT: {
                String dc = this.S.docComment();
                JCTree.JCModifiers mods = this.modifiersOpt();
                if (this.S.token() == Token.INTERFACE || this.S.token() == Token.CLASS || this.allowEnums && this.S.token() == Token.ENUM) {
                    stats.append(this.classOrInterfaceOrEnumDeclaration(mods, dc));
                    break;
                }
                JCTree.JCExpression t = this.parseType();
                stats.appendList(this.variableDeclarators(mods, t, new ListBuffer()));
                this.storeEnd((JCTree)stats.elems.last(), this.S.endPos());
                this.accept(Token.SEMI);
                break;
            }
            case ABSTRACT: 
            case STRICTFP: {
                String dc = this.S.docComment();
                JCTree.JCModifiers mods = this.modifiersOpt();
                if (this.S.token() == Token.INTERFACE || this.S.token() == Token.CLASS || this.allowEnums && this.S.token() == Token.ENUM) {
                    stats.append(this.classOrInterfaceOrEnumDeclaration(mods, dc));
                    break;
                }
                this.mode = 1;
                stats.append(this.to(this.F.at(pos).Exec(this.illegal(pos))));
                break;
            }
            case CLASS: 
            case INTERFACE: {
                stats.append(this.classOrInterfaceOrEnumDeclaration(this.modifiersOpt(), this.S.docComment()));
                break;
            }
            case ENUM: 
            case ASSERT: {
                if (this.allowEnums && this.S.token() == Token.ENUM) {
                    this.error(this.S.pos(), "local.enum", new Object[0]);
                    stats.append(this.classOrInterfaceOrEnumDeclaration(this.modifiersOpt(), this.S.docComment()));
                    break;
                }
                if (this.allowAsserts && this.S.token() == Token.ASSERT) {
                    this.S.nextToken();
                    JCTree.JCExpression assertion = this.parseExpression();
                    JCTree.JCExpression message = null;
                    if (this.S.token() == Token.COLON) {
                        this.S.nextToken();
                        message = this.parseExpression();
                    }
                    this.accept(Token.SEMI);
                    JCTree.JCAssert t = this.toP(this.F.at(pos).Assert(assertion, message));
                    stats.append(t);
                    break;
                }
            }
            default: {
                Name name = this.S.name();
                JCTree.JCExpression t = this.term(3);
                if (this.S.token() == Token.COLON && t.getTag() == 35) {
                    this.S.nextToken();
                    JCTree.JCStatement stat = this.parseStatement();
                    stats.append(this.F.at(pos).Labelled(name, stat));
                    break;
                }
                if ((this.lastmode & 2) != 0 && (this.S.token() == Token.IDENTIFIER || this.S.token() == Token.ASSERT || this.S.token() == Token.ENUM)) {
                    pos = this.S.pos();
                    JCTree.JCModifiers mods = this.F.at(-1).Modifiers(0L);
                    this.F.at(pos);
                    stats.appendList(this.variableDeclarators(mods, t, new ListBuffer()));
                    this.accept(Token.SEMI);
                    this.storeEnd((JCTree)stats.elems.last(), this.S.prevEndPos());
                    break;
                }
                this.accept(Token.SEMI);
                stats.append(this.toP(this.F.at(pos).Exec(this.checkExprStat(t))));
            }
        }
        return stats.toList();
    }

    @Override
    public JCTree.JCStatement parseStatement() {
        int pos = this.S.pos();
        List<JCTree.JCStatement> statements = this.blockStatement();
        JCTree.JCStatement first = (JCTree.JCStatement)statements.head;
        String error = null;
        switch (first.getTag()) {
            case 3: {
                error = "class.not.allowed";
                break;
            }
            case 5: {
                error = "variable.not.allowed";
            }
        }
        if (error != null) {
            this.error(first, error, new Object[0]);
            statements = List.of(this.toP(this.F.at(pos).Exec(this.F.at(first.pos).Erroneous(List.of(this.F.at(first.pos).Block(0L, statements))))));
        }
        assert (statements.size() == 1) : statements.toString();
        return (JCTree.JCStatement)statements.head;
    }

    protected JCTree.JCCatch catchClause() {
        int pos = this.S.pos();
        this.accept(Token.CATCH);
        this.accept(Token.LPAREN);
        JCTree.JCModifiers mods = this.optFinal(0x200000000L);
        List<JCTree.JCExpression> catchTypes = this.catchTypes();
        JCTree.JCExpression paramType = catchTypes.size() > 1 ? (JCTree.JCExpression)this.toP(this.F.at(((JCTree.JCExpression)catchTypes.head).getStartPosition()).TypeUnion(catchTypes)) : (JCTree.JCExpression)catchTypes.head;
        JCTree.JCVariableDecl formal = this.variableDeclaratorId(mods, paramType);
        this.accept(Token.RPAREN);
        JCTree.JCBlock body = this.block();
        return this.F.at(pos).Catch(formal, body);
    }

    List<JCTree.JCExpression> catchTypes() {
        ListBuffer catchTypes = ListBuffer.lb();
        catchTypes.add(this.parseType());
        while (this.S.token() == Token.BAR) {
            this.checkMulticatch();
            this.S.nextToken();
            catchTypes.add(this.qualident());
        }
        return catchTypes.toList();
    }

    List<JCTree.JCCase> switchBlockStatementGroups() {
        ListBuffer<JCTree.JCCase> cases = new ListBuffer<JCTree.JCCase>();
        block4: while (true) {
            switch (this.S.token()) {
                case CASE: 
                case DEFAULT: {
                    cases.append(this.switchBlockStatementGroup());
                    continue block4;
                }
                case EOF: 
                case RBRACE: {
                    return cases.toList();
                }
            }
            int pos = this.S.pos();
            this.S.nextToken();
            this.syntaxError(pos, "expected3", Token.CASE, Token.DEFAULT, Token.RBRACE);
        }
    }

    protected JCTree.JCCase switchBlockStatementGroup() {
        int pos = this.S.pos();
        switch (this.S.token()) {
            case CASE: {
                this.S.nextToken();
                JCTree.JCExpression pat = this.parseExpression();
                this.accept(Token.COLON);
                List<JCTree.JCStatement> stats = this.blockStatements();
                JCTree.JCCase c = this.F.at(pos).Case(pat, stats);
                if (stats.isEmpty()) {
                    this.storeEnd(c, this.S.prevEndPos());
                }
                return c;
            }
            case DEFAULT: {
                this.S.nextToken();
                this.accept(Token.COLON);
                List<JCTree.JCStatement> stats = this.blockStatements();
                JCTree.JCCase c = this.F.at(pos).Case(null, stats);
                if (stats.isEmpty()) {
                    this.storeEnd(c, this.S.prevEndPos());
                }
                return c;
            }
        }
        throw new AssertionError((Object)this.S.token().toString());
    }

    <T extends ListBuffer<? super JCTree.JCExpressionStatement>> T moreStatementExpressions(int pos, JCTree.JCExpression first, T stats) {
        stats.append((JCTree.JCExpressionStatement)this.toP(this.F.at(pos).Exec(this.checkExprStat(first))));
        while (this.S.token() == Token.COMMA) {
            this.S.nextToken();
            pos = this.S.pos();
            JCTree.JCExpression t = this.parseExpression();
            stats.append((JCTree.JCExpressionStatement)this.toP(this.F.at(pos).Exec(this.checkExprStat(t))));
        }
        return stats;
    }

    List<JCTree.JCStatement> forInit() {
        ListBuffer stats = ListBuffer.lb();
        int pos = this.S.pos();
        if (this.S.token() == Token.FINAL || this.S.token() == Token.MONKEYS_AT) {
            return this.variableDeclarators(this.optFinal(0L), this.parseType(), stats).toList();
        }
        JCTree.JCExpression t = this.term(3);
        if ((this.lastmode & 2) != 0 && (this.S.token() == Token.IDENTIFIER || this.S.token() == Token.ASSERT || this.S.token() == Token.ENUM || this.S.token() == Token.COLON)) {
            return this.variableDeclarators(this.modifiersOpt(), t, stats).toList();
        }
        return this.moreStatementExpressions(pos, t, stats).toList();
    }

    List<JCTree.JCExpressionStatement> forUpdate() {
        return this.moreStatementExpressions(this.S.pos(), this.parseExpression(), new ListBuffer()).toList();
    }

    List<JCTree.JCAnnotation> annotationsOpt() {
        if (this.S.token() != Token.MONKEYS_AT) {
            return List.nil();
        }
        ListBuffer<JCTree.JCAnnotation> buf = new ListBuffer<JCTree.JCAnnotation>();
        while (this.S.token() == Token.MONKEYS_AT) {
            int pos = this.S.pos();
            this.S.nextToken();
            buf.append(this.annotation(pos));
        }
        return buf.toList();
    }

    JCTree.JCModifiers modifiersOpt() {
        return this.modifiersOpt(null);
    }

    protected JCTree.JCModifiers modifiersOpt(JCTree.JCModifiers partial) {
        int pos;
        long flags;
        ListBuffer<JCTree.JCAnnotation> annotations = new ListBuffer<JCTree.JCAnnotation>();
        if (partial == null) {
            flags = 0L;
            pos = this.S.pos();
        } else {
            flags = partial.flags;
            annotations.appendList(partial.annotations);
            pos = partial.pos;
        }
        if (this.S.deprecatedFlag()) {
            flags |= 0x20000L;
            this.S.resetDeprecatedFlag();
        }
        int lastPos = -1;
        block19: while (true) {
            long flag = 0L;
            switch (this.S.token()) {
                case PRIVATE: {
                    flag = 2L;
                    break;
                }
                case PROTECTED: {
                    flag = 4L;
                    break;
                }
                case PUBLIC: {
                    flag = 1L;
                    break;
                }
                case STATIC: {
                    flag = 8L;
                    break;
                }
                case TRANSIENT: {
                    flag = 128L;
                    break;
                }
                case FINAL: {
                    flag = 16L;
                    break;
                }
                case ABSTRACT: {
                    flag = 1024L;
                    break;
                }
                case NATIVE: {
                    flag = 256L;
                    break;
                }
                case VOLATILE: {
                    flag = 64L;
                    break;
                }
                case SYNCHRONIZED: {
                    flag = 32L;
                    break;
                }
                case STRICTFP: {
                    flag = 2048L;
                    break;
                }
                case MONKEYS_AT: {
                    flag = 8192L;
                    break;
                }
                case ERROR: {
                    this.S.nextToken();
                    break;
                }
                default: {
                    break block19;
                }
            }
            if ((flags & flag) != 0L) {
                this.error(this.S.pos(), "repeated.modifier", new Object[0]);
            }
            lastPos = this.S.pos();
            this.S.nextToken();
            if (flag == 8192L) {
                this.checkAnnotations();
                if (this.S.token() != Token.INTERFACE) {
                    JCTree.JCAnnotation ann = this.annotation(lastPos);
                    if (flags == 0L && annotations.isEmpty()) {
                        pos = ann.pos;
                    }
                    annotations.append(ann);
                    lastPos = ann.pos;
                    flag = 0L;
                }
            }
            flags |= flag;
        }
        switch (this.S.token()) {
            case ENUM: {
                if (!this.allowEnums) break;
                flags |= 0x4000L;
                break;
            }
            case INTERFACE: {
                flags |= 0x200L;
                break;
            }
        }
        if ((flags & 0x2DFFL) == 0L && annotations.isEmpty()) {
            pos = -1;
        }
        JCTree.JCModifiers mods = this.F.at(pos).Modifiers(flags, annotations.toList());
        if (pos != -1) {
            this.storeEnd(mods, this.S.prevEndPos());
        }
        return mods;
    }

    JCTree.JCAnnotation annotation(int pos) {
        this.checkAnnotations();
        JCTree.JCExpression ident = this.qualident();
        int identEndPos = this.S.prevEndPos();
        boolean hasParens = this.S.token() == Token.LPAREN;
        List<JCTree.JCExpression> fieldValues = this.annotationFieldValuesOpt();
        JCTree.JCAnnotation ann = this.F.at(pos).Annotation(ident, fieldValues);
        this.storeEnd(ann, hasParens ? this.S.prevEndPos() : identEndPos);
        return ann;
    }

    List<JCTree.JCExpression> annotationFieldValuesOpt() {
        return this.S.token() == Token.LPAREN ? this.annotationFieldValues() : List.nil();
    }

    List<JCTree.JCExpression> annotationFieldValues() {
        this.accept(Token.LPAREN);
        ListBuffer<JCTree.JCExpression> buf = new ListBuffer<JCTree.JCExpression>();
        if (this.S.token() != Token.RPAREN) {
            buf.append(this.annotationFieldValue());
            while (this.S.token() == Token.COMMA) {
                this.S.nextToken();
                buf.append(this.annotationFieldValue());
            }
        }
        this.accept(Token.RPAREN);
        return buf.toList();
    }

    JCTree.JCExpression annotationFieldValue() {
        if (this.S.token() == Token.IDENTIFIER) {
            this.mode = 1;
            JCTree.JCExpression t1 = this.term1();
            if (t1.getTag() == 35 && this.S.token() == Token.EQ) {
                int pos = this.S.pos();
                this.accept(Token.EQ);
                JCTree.JCExpression v = this.annotationValue();
                return this.toP(this.F.at(pos).Assign(t1, v));
            }
            return t1;
        }
        return this.annotationValue();
    }

    JCTree.JCExpression annotationValue() {
        switch (this.S.token()) {
            case MONKEYS_AT: {
                int pos = this.S.pos();
                this.S.nextToken();
                return this.annotation(pos);
            }
            case LBRACE: {
                int pos = this.S.pos();
                this.accept(Token.LBRACE);
                ListBuffer<JCTree.JCExpression> buf = new ListBuffer<JCTree.JCExpression>();
                if (this.S.token() != Token.RBRACE) {
                    buf.append(this.annotationValue());
                    while (this.S.token() == Token.COMMA) {
                        this.S.nextToken();
                        if (this.S.token() == Token.RBRACE) break;
                        buf.append(this.annotationValue());
                    }
                }
                this.accept(Token.RBRACE);
                return this.toP(this.F.at(pos).NewArray(null, List.<JCTree.JCExpression>nil(), buf.toList()));
            }
        }
        this.mode = 1;
        return this.term1();
    }

    public <T extends ListBuffer<? super JCTree.JCVariableDecl>> T variableDeclarators(JCTree.JCModifiers mods, JCTree.JCExpression type, T vdefs) {
        return this.variableDeclaratorsRest(this.S.pos(), mods, type, this.ident(), false, null, vdefs);
    }

    <T extends ListBuffer<? super JCTree.JCVariableDecl>> T variableDeclaratorsRest(int pos, JCTree.JCModifiers mods, JCTree.JCExpression type, Name name, boolean reqInit, String dc, T vdefs) {
        vdefs.append((JCTree.JCVariableDecl)this.variableDeclaratorRest(pos, mods, type, name, reqInit, dc));
        while (this.S.token() == Token.COMMA) {
            this.storeEnd((JCTree)vdefs.elems.last(), this.S.endPos());
            this.S.nextToken();
            vdefs.append((JCTree.JCVariableDecl)this.variableDeclarator(mods, type, reqInit, dc));
        }
        return vdefs;
    }

    JCTree.JCVariableDecl variableDeclarator(JCTree.JCModifiers mods, JCTree.JCExpression type, boolean reqInit, String dc) {
        return this.variableDeclaratorRest(this.S.pos(), mods, type, this.ident(), reqInit, dc);
    }

    JCTree.JCVariableDecl variableDeclaratorRest(int pos, JCTree.JCModifiers mods, JCTree.JCExpression type, Name name, boolean reqInit, String dc) {
        type = this.bracketsOpt(type);
        JCTree.JCExpression init = null;
        if (this.S.token() == Token.EQ) {
            this.S.nextToken();
            init = this.variableInitializer();
            if (init.getTag() == 45 && ((JCTree.JCErroneous)init).errs.isEmpty() && this.S.prevEndPos() < init.pos) {
                init.pos = this.S.prevEndPos();
            }
        } else if (reqInit) {
            this.syntaxError(this.S.pos(), "expected", Token.EQ);
        }
        JCTree.JCVariableDecl result = this.toP(this.F.at(pos).VarDef(mods, name, type, init));
        this.attach(result, dc);
        return result;
    }

    JCTree.JCVariableDecl variableDeclaratorId(JCTree.JCModifiers mods, JCTree.JCExpression type) {
        int pos = this.S.pos();
        Name name = this.ident();
        if ((mods.flags & 0x400000000L) != 0L && this.S.token() == Token.LBRACKET) {
            this.log.error(this.S.pos(), "varargs.and.old.array.syntax", new Object[0]);
        }
        type = this.bracketsOpt(type);
        return this.toP(this.F.at(pos).VarDef(mods, name, type, null));
    }

    List<JCTree> resources() {
        ListBuffer<JCTree> defs = new ListBuffer<JCTree>();
        defs.append(this.resource());
        while (this.S.token() == Token.SEMI) {
            int semiColonPos = this.S.pos();
            this.S.nextToken();
            if (this.S.token() == Token.RPAREN) break;
            defs.append(this.resource());
        }
        return defs.toList();
    }

    protected JCTree resource() {
        JCTree.JCModifiers optFinal = this.optFinal(16L);
        JCTree.JCExpression type = this.parseType();
        return this.variableDeclaratorRest(this.S.pos(), optFinal, type, this.ident(), true, null);
    }

    @Override
    public JCTree.JCCompilationUnit parseCompilationUnit() {
        int pos = this.S.pos();
        JCTree.JCExpression pid = null;
        String toplevel_dc = this.S.docComment();
        String dc = this.S.docComment();
        JCTree.JCModifiers mods = null;
        List<JCTree.JCAnnotation> packageAnnotations = List.nil();
        ListBuffer<JCTree> defs = new ListBuffer<JCTree>();
        boolean checkForPackage = true;
        boolean checkForImports = true;
        while (this.S.token() != Token.EOF) {
            if (this.S.pos() <= this.errorEndPos) {
                this.skip(checkForImports, false, false, false);
                if (this.S.token() == Token.EOF) break;
            }
            if (checkForPackage && this.S.token() == Token.MONKEYS_AT) {
                mods = this.modifiersOpt();
                continue;
            }
            if (this.S.token() == Token.PACKAGE) {
                if (checkForPackage) {
                    if (mods != null) {
                        this.checkNoMods(mods.flags);
                        packageAnnotations = mods.annotations;
                        mods = null;
                    }
                    this.S.nextToken();
                    pid = this.qualident();
                    this.accept(Token.SEMI);
                    checkForPackage = false;
                } else {
                    if (this.allowEnums) {
                        this.reportSyntaxError(null, this.S.pos(), "expected3", Token.CLASS, Token.INTERFACE, Token.ENUM);
                    } else {
                        this.reportSyntaxError(null, this.S.pos(), "expected2", Token.CLASS, Token.INTERFACE);
                    }
                    this.S.nextToken();
                }
                dc = null;
                continue;
            }
            if (checkForImports && mods == null && this.S.token() == Token.IMPORT) {
                defs.append(this.importDeclaration());
                checkForPackage = false;
                dc = null;
                continue;
            }
            JCTree def = this.typeDeclaration(mods, dc);
            if (this.keepDocComments && dc != null && this.docComments.get(def) == dc) {
                dc = null;
            }
            defs.append(def);
            if (def instanceof JCTree.JCClassDecl) {
                checkForPackage = false;
                checkForImports = false;
            }
            mods = null;
            dc = null;
        }
        JCTree.JCCompilationUnit toplevel = this.F.at(pos).TopLevel(packageAnnotations, pid, defs.toList());
        this.attach(toplevel, toplevel_dc);
        if (defs.elems.isEmpty()) {
            this.storeEnd(toplevel, this.S.prevEndPos());
        }
        if (this.keepDocComments) {
            toplevel.docComments = this.docComments;
        }
        if (this.keepLineMap) {
            toplevel.lineMap = this.S.getLineMap();
        }
        JavacParser.assignAnonymousClassIndices(this.names, toplevel, null, -1);
        return toplevel;
    }

    JCTree importDeclaration() {
        int pos = this.S.pos();
        this.S.nextToken();
        boolean importStatic = false;
        if (this.S.token() == Token.STATIC) {
            this.checkStaticImports();
            importStatic = true;
            this.S.nextToken();
        }
        JCTree.JCExpression pid = this.toP(this.F.at(this.S.pos()).Ident(this.ident()));
        do {
            int pos1 = this.S.pos();
            this.accept(Token.DOT);
            if (this.S.token() == Token.STAR) {
                pid = this.to(this.F.at(pos1).Select(pid, this.names.asterisk));
                this.S.nextToken();
                break;
            }
            pid = this.toP(this.F.at(pos1).Select(pid, this.ident()));
        } while (this.S.token() == Token.DOT);
        this.accept(Token.SEMI);
        return this.toP(this.F.at(pos).Import(pid, importStatic));
    }

    JCTree typeDeclaration(JCTree.JCModifiers mods, String comment) {
        int pos = this.S.pos();
        if (mods == null && this.S.token() == Token.SEMI) {
            this.S.nextToken();
            return this.toP(this.F.at(pos).Skip());
        }
        String dc = this.S.docComment();
        return this.classOrInterfaceOrEnumDeclaration(this.modifiersOpt(mods), dc != null ? dc : comment);
    }

    JCTree.JCStatement classOrInterfaceOrEnumDeclaration(JCTree.JCModifiers mods, String dc) {
        List<JCTree> errs;
        if (this.S.token() == Token.CLASS) {
            return this.classDeclaration(mods, dc);
        }
        if (this.S.token() == Token.INTERFACE) {
            return this.interfaceDeclaration(mods, dc);
        }
        if (this.allowEnums) {
            List<JCTree> errs2;
            if (this.S.token() == Token.ENUM) {
                return this.enumDeclaration(mods, dc);
            }
            int pos = this.S.pos();
            if (this.S.token() == Token.IDENTIFIER) {
                errs2 = List.of(mods, this.toP(this.F.at(pos).Ident(this.ident())));
                this.setErrorEndPos(this.S.pos());
            } else {
                errs2 = List.of(mods);
            }
            return this.toP(this.F.Exec(this.syntaxError(pos, errs2, "expected3", Token.CLASS, Token.INTERFACE, Token.ENUM)));
        }
        if (this.S.token() == Token.ENUM) {
            this.error(this.S.pos(), "enums.not.supported.in.source", this.source.name);
            this.allowEnums = true;
            mods.flags |= 0x4000L;
            return this.enumDeclaration(mods, dc);
        }
        int pos = this.S.pos();
        if (this.S.token() == Token.IDENTIFIER) {
            errs = List.of(mods, this.toP(this.F.at(pos).Ident(this.ident())));
            this.setErrorEndPos(this.S.pos());
        } else {
            errs = List.of(mods);
        }
        return this.toP(this.F.Exec(this.syntaxError(pos, errs, "expected2", Token.CLASS, Token.INTERFACE)));
    }

    JCTree.JCClassDecl classDeclaration(JCTree.JCModifiers mods, String dc) {
        if (this.cancelService != null) {
            this.cancelService.abortIfCanceled();
        }
        int pos = this.S.pos();
        this.accept(Token.CLASS);
        Name name = this.ident();
        List<JCTree.JCTypeParameter> typarams = this.typeParametersOpt();
        JCTree.JCExpression extending = null;
        if (this.S.token() == Token.EXTENDS) {
            this.S.nextToken();
            extending = this.parseType();
        }
        List<JCTree.JCExpression> implementing = List.nil();
        if (this.S.token() == Token.IMPLEMENTS) {
            this.S.nextToken();
            implementing = this.typeList();
        }
        List<JCTree> defs = this.classOrInterfaceBody(name, false);
        JCTree.JCClassDecl result = this.toP(this.F.at(pos).ClassDef(mods, name, typarams, extending, implementing, defs));
        this.attach(result, dc);
        return result;
    }

    JCTree.JCClassDecl interfaceDeclaration(JCTree.JCModifiers mods, String dc) {
        if (this.cancelService != null) {
            this.cancelService.abortIfCanceled();
        }
        int pos = this.S.pos();
        this.accept(Token.INTERFACE);
        Name name = this.ident();
        List<JCTree.JCTypeParameter> typarams = this.typeParametersOpt();
        List<JCTree.JCExpression> extending = List.nil();
        if (this.S.token() == Token.EXTENDS) {
            this.S.nextToken();
            extending = this.typeList();
        }
        List<JCTree> defs = this.classOrInterfaceBody(name, true);
        JCTree.JCClassDecl result = this.toP(this.F.at(pos).ClassDef(mods, name, typarams, null, extending, defs));
        this.attach(result, dc);
        return result;
    }

    JCTree.JCClassDecl enumDeclaration(JCTree.JCModifiers mods, String dc) {
        if (this.cancelService != null) {
            this.cancelService.abortIfCanceled();
        }
        int pos = this.S.pos();
        this.accept(Token.ENUM);
        JCTree.JCModifiers newMods = this.F.at(mods.pos).Modifiers(mods.flags | 0x4000L, mods.annotations);
        this.storeEnd(newMods, this.getEndPos(mods));
        Name name = this.ident();
        return this.enumDeclaration(newMods, dc, pos, name);
    }

    JCTree.JCClassDecl enumDeclaration(JCTree.JCModifiers mods, String dc, int pos, Name name) {
        List<JCTree.JCExpression> implementing = List.nil();
        if (this.S.token() == Token.IMPLEMENTS) {
            this.S.nextToken();
            implementing = this.typeList();
        }
        List<JCTree> defs = this.enumBody(name);
        mods.flags |= 0x4000L;
        JCTree.JCClassDecl result = this.toP(this.F.at(pos).ClassDef(mods, name, List.<JCTree.JCTypeParameter>nil(), null, implementing, defs));
        this.attach(result, dc);
        return result;
    }

    List<JCTree> enumBody(Name enumName) {
        this.accept(Token.LBRACE);
        if (this.S.pos() <= this.errorEndPos) {
            this.skip(false, true, false, false);
            if (this.S.token() == Token.LBRACE) {
                this.S.nextToken();
            }
        }
        ListBuffer<JCTree> defs = new ListBuffer<JCTree>();
        if (this.S.token() == Token.COMMA) {
            this.S.nextToken();
        } else if (this.S.token() != Token.RBRACE && this.S.token() != Token.SEMI) {
            boolean hasError = false;
            List<JCTree> decl = this.enumeratorDeclaration(enumName);
            defs.appendList(decl);
            if (((JCTree)decl.head).getTag() != 5 || (((JCTree.JCVariableDecl)decl.head).getModifiers().flags & 0x4000L) == 0L) {
                hasError = true;
            }
            while (this.S.token() != Token.RBRACE && this.S.token() != Token.SEMI && !hasError) {
                if (this.S.token() == Token.COMMA) {
                    this.S.nextToken();
                } else {
                    this.syntaxError(this.S.pos(), "expected3", Token.COMMA, Token.RBRACE, Token.SEMI);
                }
                if (this.S.token() == Token.RBRACE || this.S.token() == Token.SEMI) break;
                decl = this.enumeratorDeclaration(enumName);
                defs.appendList(decl);
                if (((JCTree)decl.head).getTag() == 5 && (((JCTree.JCVariableDecl)decl.head).getModifiers().flags & 0x4000L) != 0L) continue;
                hasError = true;
            }
        }
        if (this.S.token() == Token.SEMI) {
            this.S.nextToken();
        }
        while (this.S.token() != Token.RBRACE && this.S.token() != Token.EOF) {
            defs.appendList(this.classOrInterfaceBodyDeclaration(enumName, false));
            if (this.S.pos() > this.errorEndPos) continue;
            this.skip(false, true, true, false);
        }
        this.accept(Token.RBRACE);
        return defs.toList();
    }

    List<JCTree> enumeratorDeclaration(Name enumName) {
        JCTree.JCExpression type;
        boolean isVoid;
        String dc = this.S.docComment();
        int flags = 16409;
        if (this.S.deprecatedFlag()) {
            flags |= 0x20000;
            this.S.resetDeprecatedFlag();
        }
        int pos = this.S.pos();
        List<JCTree.JCAnnotation> annotations = this.annotationsOpt();
        JCTree.JCModifiers mods = this.F.at(annotations.isEmpty() ? -1 : pos).Modifiers(flags, annotations);
        List<JCTree.JCExpression> typeArgs = this.typeArgumentsOpt();
        int identPos = this.S.pos();
        Name name = this.ident();
        if (name != this.names.error) {
            int createPos = this.S.pos();
            List<Object> args = this.S.token() == Token.LPAREN ? this.arguments() : List.nil();
            JCTree.JCClassDecl body = null;
            if (this.S.token() == Token.LBRACE) {
                JCTree.JCModifiers mods1 = this.F.at(-1).Modifiers(16392L);
                List<JCTree> defs = this.classOrInterfaceBody(this.names.empty, false);
                body = this.toP(this.F.at(identPos).AnonymousClassDef(mods1, defs));
            }
            if (args.isEmpty() && body == null) {
                createPos = -1;
            }
            JCTree.JCIdent ident = this.F.at(-1).Ident(enumName);
            JCTree.JCNewClass create = this.F.at(createPos).NewClass(null, typeArgs, ident, args, body);
            if (createPos != -1) {
                this.storeEnd(create, this.S.prevEndPos());
            }
            ident = this.F.at(-1).Ident(enumName);
            JCTree.JCVariableDecl result = this.toP(this.F.at(identPos).VarDef(mods, name, ident, create));
            this.attach(result, dc);
            return List.of(result);
        }
        JCTree.JCModifiers jCModifiers = mods = annotations.isEmpty() ? this.modifiersOpt() : this.modifiersOpt(this.F.at(pos).Modifiers(0L, annotations));
        if (this.S.token() == Token.CLASS || this.S.token() == Token.INTERFACE || this.allowEnums && this.S.token() == Token.ENUM) {
            return List.of(this.classOrInterfaceOrEnumDeclaration(mods, dc));
        }
        if (this.S.token() == Token.LBRACE && (mods.flags & 0xFFFL & 0xFFFFFFFFFFFFFFF7L) == 0L && mods.annotations.isEmpty()) {
            return List.of(this.block(pos, mods.flags));
        }
        pos = this.S.pos();
        List<JCTree.JCTypeParameter> typarams = this.typeParametersOpt();
        if (typarams.length() > 0 && mods.pos == -1) {
            mods.pos = pos;
        }
        Token token = this.S.token();
        name = this.S.name();
        pos = this.S.pos();
        boolean bl = isVoid = token == Token.VOID;
        if (isVoid) {
            type = this.to(this.F.at(pos).TypeIdent(9));
            this.S.nextToken();
        } else {
            type = this.parseType();
        }
        if (this.S.token() == Token.LPAREN && type.getTag() == 35) {
            if (name != enumName) {
                this.log.error(pos, "invalid.meth.decl.ret.type.req", new Object[0]);
                return List.of(this.methodDeclaratorRest(pos, mods, null, name, typarams, false, true, dc));
            }
            return List.of(this.methodDeclaratorRest(pos, mods, null, this.names.init, typarams, false, true, dc));
        }
        pos = this.S.pos();
        name = this.ident();
        if (this.S.token() == Token.LPAREN) {
            return List.of(this.methodDeclaratorRest(pos, mods, type, name, typarams, false, isVoid, dc));
        }
        if (token == Token.ENUM && typarams.isEmpty() && (this.S.token() == Token.LBRACE || this.S.token() == Token.IMPLEMENTS)) {
            this.log.error(pos, "enums.not.supported.in.source", this.source.name);
            this.allowEnums = true;
            JCTree.JCModifiers newMods = this.F.at(mods.pos).Modifiers(mods.flags | 0x4000L, mods.annotations);
            this.storeEnd(newMods, this.getEndPos(mods));
            return List.of(this.enumDeclaration(newMods, dc, pos, name));
        }
        if (!isVoid && typarams.isEmpty()) {
            List<JCTree> defs = this.variableDeclaratorsRest(pos, mods, type, name, false, dc, new ListBuffer()).toList();
            this.accept(Token.SEMI);
            this.storeEnd((JCTree)defs.last(), this.S.prevEndPos());
            return defs;
        }
        pos = this.S.pos();
        List<JCTree> err = isVoid ? List.of(this.toP(this.F.at(pos).MethodDef(mods, name, type, typarams, List.<JCTree.JCVariableDecl>nil(), List.<JCTree.JCExpression>nil(), null, null))) : List.nil();
        return List.of(this.syntaxError(this.S.pos(), err, "expected", Token.LPAREN));
    }

    List<JCTree.JCExpression> typeList() {
        ListBuffer<JCTree.JCExpression> ts = new ListBuffer<JCTree.JCExpression>();
        ts.append(this.parseType());
        while (this.S.token() == Token.COMMA) {
            this.S.nextToken();
            ts.append(this.parseType());
        }
        return ts.toList();
    }

    List<JCTree> classOrInterfaceBody(Name className, boolean isInterface) {
        this.accept(Token.LBRACE);
        if (this.S.pos() <= this.errorEndPos) {
            this.skip(false, true, false, false);
            if (this.S.token() == Token.LBRACE) {
                this.S.nextToken();
            }
        }
        ListBuffer<JCTree> defs = new ListBuffer<JCTree>();
        while (this.S.token() != Token.RBRACE && this.S.token() != Token.EOF) {
            defs.appendList(this.classOrInterfaceBodyDeclaration(className, isInterface));
            if (this.S.pos() > this.errorEndPos) continue;
            if (this.S.token() == Token.LBRACE && isInterface) {
                this.S.nextToken();
            }
            this.skip(false, true, true, false);
        }
        this.accept(Token.RBRACE);
        return defs.toList();
    }

    public List<JCTree> classOrInterfaceBodyDeclaration(Name className, boolean isInterface) {
        List<JCTree> err;
        JCTree.JCExpression type;
        boolean isVoid;
        if (this.S.token() == Token.SEMI) {
            this.S.nextToken();
            return List.nil();
        }
        String dc = this.S.docComment();
        int pos = this.S.pos();
        JCTree.JCModifiers mods = this.modifiersOpt();
        if (this.S.token() == Token.CLASS || this.S.token() == Token.INTERFACE || this.allowEnums && this.S.token() == Token.ENUM) {
            return List.of(this.classOrInterfaceOrEnumDeclaration(mods, dc));
        }
        if (this.S.token() == Token.LBRACE && !isInterface && (mods.flags & 0xFFFL & 0xFFFFFFFFFFFFFFF7L) == 0L && mods.annotations.isEmpty()) {
            return List.of(this.block(pos, mods.flags));
        }
        pos = this.S.pos();
        List<JCTree.JCTypeParameter> typarams = this.typeParametersOpt();
        if (typarams.nonEmpty() && mods.pos == -1) {
            mods.pos = pos;
            this.storeEnd(mods, pos);
        }
        Name name = this.S.name();
        pos = this.S.pos();
        boolean bl = isVoid = this.S.token() == Token.VOID;
        if (isVoid) {
            type = this.to(this.F.at(pos).TypeIdent(9));
            this.S.nextToken();
        } else {
            type = this.parseType();
        }
        if (this.S.token() == Token.LPAREN && !isInterface && type.getTag() == 35) {
            if (isInterface || name != className) {
                this.error(pos, "invalid.meth.decl.ret.type.req", new Object[0]);
                return List.of(this.methodDeclaratorRest(pos, mods, null, name, typarams, isInterface, true, dc));
            }
            return List.of(this.methodDeclaratorRest(pos, mods, null, this.names.init, typarams, isInterface, true, dc));
        }
        pos = this.S.pos();
        name = this.ident();
        if (this.S.token() == Token.LPAREN) {
            return List.of(this.methodDeclaratorRest(pos, mods, type, name, typarams, isInterface, isVoid, dc));
        }
        if (this.S.token() == Token.ENUM && typarams.isEmpty() && (this.S.token() == Token.LBRACE || this.S.token() == Token.IMPLEMENTS)) {
            this.log.error(pos, "enums.not.supported.in.source", this.source.name);
            this.allowEnums = true;
            JCTree.JCModifiers newMods = this.F.at(mods.pos).Modifiers(mods.flags | 0x4000L, mods.annotations);
            this.storeEnd(newMods, this.getEndPos(mods));
            return List.of(this.enumDeclaration(newMods, dc, pos, name));
        }
        if (!isVoid && typarams.isEmpty()) {
            List<JCTree> defs = this.variableDeclaratorsRest(pos, mods, type, name, isInterface, dc, new ListBuffer()).toList();
            this.accept(Token.SEMI);
            this.storeEnd((JCTree)defs.last(), this.S.prevEndPos());
            return defs;
        }
        pos = this.S.pos();
        if (isVoid || typarams.nonEmpty()) {
            JCTree.JCMethodDecl meth = this.toP(this.F.at(pos).MethodDef(mods, name, type, typarams, List.<JCTree.JCVariableDecl>nil(), List.<JCTree.JCExpression>nil(), null, null));
            this.attach(meth, dc);
            err = List.of(meth);
        } else {
            err = List.nil();
        }
        return List.of(this.syntaxError(this.S.pos(), err, "expected", Token.LPAREN));
    }

    JCTree methodDeclaratorRest(int pos, JCTree.JCModifiers mods, JCTree.JCExpression type, Name name, List<JCTree.JCTypeParameter> typarams, boolean isInterface, boolean isVoid, String dc) {
        JCTree.JCExpression defaultValue;
        if (this.cancelService != null) {
            this.cancelService.abortIfCanceled();
        }
        List<JCTree.JCVariableDecl> params = this.formalParameters();
        if (!isVoid) {
            type = this.bracketsOpt(type);
        }
        List<JCTree.JCExpression> thrown = List.nil();
        if (this.S.token() == Token.THROWS) {
            this.S.nextToken();
            thrown = this.qualidentList();
        }
        JCTree.JCBlock body = null;
        if (this.S.token() == Token.LBRACE) {
            body = this.block();
            defaultValue = null;
        } else {
            if (this.S.token() == Token.DEFAULT) {
                this.accept(Token.DEFAULT);
                defaultValue = this.annotationValue();
            } else {
                defaultValue = null;
            }
            this.accept(Token.SEMI);
            if (this.S.pos() <= this.errorEndPos) {
                this.skip(false, true, false, false);
                if (this.S.token() == Token.LBRACE) {
                    body = this.block();
                }
            }
        }
        JCTree.JCMethodDecl result = this.toP(this.F.at(pos).MethodDef(mods, name, type, typarams, params, thrown, body, defaultValue));
        this.attach(result, dc);
        return result;
    }

    List<JCTree.JCExpression> qualidentList() {
        ListBuffer<JCTree.JCExpression> ts = new ListBuffer<JCTree.JCExpression>();
        ts.append(this.qualident());
        while (this.S.token() == Token.COMMA) {
            this.S.nextToken();
            ts.append(this.qualident());
        }
        return ts.toList();
    }

    List<JCTree.JCTypeParameter> typeParametersOpt() {
        if (this.S.token() == Token.LT) {
            this.checkGenerics();
            ListBuffer<JCTree.JCTypeParameter> typarams = new ListBuffer<JCTree.JCTypeParameter>();
            this.S.nextToken();
            typarams.append(this.typeParameter());
            while (this.S.token() == Token.COMMA) {
                this.S.nextToken();
                typarams.append(this.typeParameter());
            }
            this.accept(Token.GT);
            return typarams.toList();
        }
        return List.nil();
    }

    JCTree.JCTypeParameter typeParameter() {
        int pos = this.S.pos();
        Name name = this.ident();
        ListBuffer<JCTree.JCExpression> bounds = new ListBuffer<JCTree.JCExpression>();
        if (this.S.token() == Token.EXTENDS) {
            this.S.nextToken();
            bounds.append(this.parseType());
            while (this.S.token() == Token.AMP) {
                this.S.nextToken();
                bounds.append(this.parseType());
            }
        }
        return this.toP(this.F.at(pos).TypeParameter(name, bounds.toList()));
    }

    List<JCTree.JCVariableDecl> formalParameters() {
        ListBuffer<JCTree.JCVariableDecl> params = new ListBuffer<JCTree.JCVariableDecl>();
        JCTree.JCVariableDecl lastParam = null;
        this.accept(Token.LPAREN);
        if (this.S.token() != Token.RPAREN) {
            lastParam = this.formalParameter();
            params.append(lastParam);
            while ((lastParam.mods.flags & 0x400000000L) == 0L && this.S.token() == Token.COMMA) {
                this.S.nextToken();
                lastParam = this.formalParameter();
                params.append(lastParam);
            }
        }
        this.accept(Token.RPAREN);
        return params.toList();
    }

    JCTree.JCModifiers optFinal(long flags) {
        JCTree.JCModifiers mods = this.modifiersOpt();
        this.checkNoMods(mods.flags & 0xFFFFFFFFFFFDFFEFL);
        mods.flags |= flags;
        return mods;
    }

    protected JCTree.JCVariableDecl formalParameter() {
        JCTree.JCModifiers mods = this.optFinal(0x200000000L);
        JCTree.JCExpression type = this.parseType();
        if (this.S.token() == Token.ELLIPSIS) {
            this.checkVarargs();
            mods.flags |= 0x400000000L;
            type = this.to(this.F.at(this.S.pos()).TypeArray(type));
            this.S.nextToken();
        }
        return this.variableDeclaratorId(mods, type);
    }

    void error(int pos, String key, Object ... args) {
        this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, pos, key, args);
    }

    void error(JCDiagnostic.DiagnosticPosition pos, String key, Object ... args) {
        this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, pos, key, args);
    }

    void warning(int pos, String key, Object ... args) {
        this.log.warning(pos, key, args);
    }

    protected JCTree.JCExpression checkExprStat(JCTree.JCExpression t) {
        switch (t.getTag()) {
            case 26: 
            case 27: 
            case 30: 
            case 45: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return t;
            }
        }
        JCTree.JCErroneous ret = this.F.at(t.pos).Erroneous(List.of(t));
        this.error(ret, "not.stmt", new Object[0]);
        return ret;
    }

    static int prec(Token token) {
        int oc = JavacParser.optag(token);
        return oc >= 0 ? TreeInfo.opPrec(oc) : -1;
    }

    static int earlier(int pos1, int pos2) {
        if (pos1 == -1) {
            return pos2;
        }
        if (pos2 == -1) {
            return pos1;
        }
        return pos1 < pos2 ? pos1 : pos2;
    }

    static int optag(Token token) {
        switch (token) {
            case BARBAR: {
                return 55;
            }
            case AMPAMP: {
                return 56;
            }
            case BAR: {
                return 57;
            }
            case BAREQ: {
                return 74;
            }
            case CARET: {
                return 58;
            }
            case CARETEQ: {
                return 75;
            }
            case AMP: {
                return 59;
            }
            case AMPEQ: {
                return 76;
            }
            case EQEQ: {
                return 60;
            }
            case BANGEQ: {
                return 61;
            }
            case LT: {
                return 62;
            }
            case GT: {
                return 63;
            }
            case LTEQ: {
                return 64;
            }
            case GTEQ: {
                return 65;
            }
            case LTLT: {
                return 66;
            }
            case LTLTEQ: {
                return 83;
            }
            case GTGT: {
                return 67;
            }
            case GTGTEQ: {
                return 84;
            }
            case GTGTGT: {
                return 68;
            }
            case GTGTGTEQ: {
                return 85;
            }
            case PLUS: {
                return 69;
            }
            case PLUSEQ: {
                return 86;
            }
            case SUB: {
                return 70;
            }
            case SUBEQ: {
                return 87;
            }
            case STAR: {
                return 71;
            }
            case STAREQ: {
                return 88;
            }
            case SLASH: {
                return 72;
            }
            case SLASHEQ: {
                return 89;
            }
            case PERCENT: {
                return 73;
            }
            case PERCENTEQ: {
                return 90;
            }
            case INSTANCEOF: {
                return 32;
            }
        }
        return -1;
    }

    static int unoptag(Token token) {
        switch (token) {
            case PLUS: {
                return 46;
            }
            case SUB: {
                return 47;
            }
            case BANG: {
                return 48;
            }
            case TILDE: {
                return 49;
            }
            case PLUSPLUS: {
                return 50;
            }
            case SUBSUB: {
                return 51;
            }
        }
        return -1;
    }

    static int typetag(Token token) {
        switch (token) {
            case BYTE: {
                return 1;
            }
            case CHAR: {
                return 2;
            }
            case SHORT: {
                return 3;
            }
            case INT: {
                return 4;
            }
            case LONG: {
                return 5;
            }
            case FLOAT: {
                return 6;
            }
            case DOUBLE: {
                return 7;
            }
            case BOOLEAN: {
                return 8;
            }
        }
        return -1;
    }

    void checkGenerics() {
        if (!this.allowGenerics) {
            this.error(this.S.pos(), "generics.not.supported.in.source", this.source.name);
            this.allowGenerics = true;
        }
    }

    void checkVarargs() {
        if (!this.allowVarargs) {
            this.error(this.S.pos(), "varargs.not.supported.in.source", this.source.name);
            this.allowVarargs = true;
        }
    }

    void checkForeach() {
        if (!this.allowForeach) {
            this.error(this.S.pos(), "foreach.not.supported.in.source", this.source.name);
            this.allowForeach = true;
        }
    }

    void checkStaticImports() {
        if (!this.allowStaticImport) {
            this.error(this.S.pos(), "static.import.not.supported.in.source", this.source.name);
            this.allowStaticImport = true;
        }
    }

    void checkAnnotations() {
        if (!this.allowAnnotations) {
            this.error(this.S.pos(), "annotations.not.supported.in.source", this.source.name);
            this.allowAnnotations = true;
        }
    }

    void checkDiamond() {
        if (!this.allowDiamond) {
            this.error(this.S.pos(), "diamond.not.supported.in.source", this.source.name);
            this.allowDiamond = true;
        }
    }

    void checkMulticatch() {
        if (!this.allowMulticatch) {
            this.error(this.S.pos(), "multicatch.not.supported.in.source", this.source.name);
            this.allowMulticatch = true;
        }
    }

    void checkTryWithResources() {
        if (!this.allowTWR) {
            this.error(this.S.pos(), "try.with.resources.not.supported.in.source", this.source.name);
            this.allowTWR = true;
        }
    }

    @Deprecated
    protected final void newAnonScope(Name n, int i) {
    }

    public static void assignAnonymousClassIndices(Names names, JCTree tree, Name name, int startNumber) {
        AssignAnonymousIndices aai = new AssignAnonymousIndices(names);
        if (name != null) {
            aai.newAnonScope(name, startNumber);
        }
        aai.scan(tree);
    }

    private static final class AssignAnonymousIndices
    extends TreeScanner {
        private final Names names;
        private final Map<Name, AnonScope> anonScopeMap = new HashMap<Name, AnonScope>();
        private final Stack<AnonScope> anonScopes = new Stack();

        public AssignAnonymousIndices(Names names) {
            this.names = names;
        }

        void newAnonScope(Name name) {
            this.newAnonScope(name, 1);
        }

        public void newAnonScope(Name name, int startNumber) {
            AnonScope parent = this.anonScopes.isEmpty() ? null : this.anonScopes.peek();
            Name fqn = parent != null && parent.parentDecl != this.names.empty ? parent.parentDecl.append('.', name) : name;
            AnonScope scope = this.anonScopeMap.get(fqn);
            if (scope == null) {
                scope = new AnonScope(name, startNumber);
                this.anonScopeMap.put(fqn, scope);
            }
            this.anonScopes.push(scope);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitClassDef(JCTree.JCClassDecl tree) {
            if (tree.name == this.names.empty) {
                tree.index = this.anonScopes.peek().assignNumber();
            }
            this.newAnonScope(tree.name);
            try {
                super.visitClassDef(tree);
                Object var3_2 = null;
                this.anonScopes.pop();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.anonScopes.pop();
                throw throwable;
            }
            if (!this.anonScopes.isEmpty() && this.anonScopes.peek().localClass && tree.name != this.names.empty) {
                tree.index = this.anonScopes.peek().assignLocalNumber(tree.name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitBlock(JCTree.JCBlock tree) {
            AnonScope as = this.anonScopes.peek();
            boolean old = as.localClass;
            as.localClass = true;
            try {
                super.visitBlock(tree);
                Object var5_4 = null;
                as.localClass = old;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                as.localClass = old;
                throw throwable;
            }
        }

        public void visitApply(JCTree.JCMethodInvocation tree) {
            this.scan(tree.args);
            this.scan(tree.meth);
        }

        private static class AnonScope {
            public boolean localClass;
            private final Name parentDecl;
            private int currentNumber;
            private Map<Name, Integer> localClasses;

            private AnonScope(Name name, int startNumber) {
                assert (name != null);
                this.parentDecl = name;
                this.currentNumber = startNumber;
            }

            public int assignNumber() {
                int ret = this.currentNumber;
                if (this.currentNumber != -1) {
                    ++this.currentNumber;
                }
                return ret;
            }

            public int assignLocalNumber(Name name) {
                Integer num;
                if (this.localClasses == null) {
                    this.localClasses = new HashMap<Name, Integer>();
                }
                num = (num = this.localClasses.get(name)) == null ? Integer.valueOf(1) : Integer.valueOf(num + 1);
                this.localClasses.put(name, num);
                return num;
            }

            public String toString() {
                return String.format("%s : %d", this.parentDecl.toString(), this.currentNumber);
            }
        }
    }
}

