/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.lang.ref.WeakReference;

public class UnsharedNameTable
extends Name.Table {
    private HashEntry[] hashes = null;
    private int hashMask;
    public int index;

    public static Name.Table create(Names names, Context context) {
        return new UnsharedNameTable(names, context);
    }

    public UnsharedNameTable(Names names, Context context, int hashSize) {
        super(names, context);
        this.hashMask = hashSize - 1;
        this.hashes = new HashEntry[hashSize];
    }

    public UnsharedNameTable(Names names, Context context) {
        this(names, context, 32768);
    }

    public Name fromChars(char[] cs, int start, int len) {
        byte[] name = new byte[len * 3];
        int nbytes = Convert.chars2utf(cs, start, name, 0, len);
        return this.fromUtf(name, 0, nbytes);
    }

    public Name fromUtf(byte[] cs, int start, int len) {
        int h = UnsharedNameTable.hashValue(cs, start, len) & this.hashMask;
        HashEntry element = this.hashes[h];
        NameImpl n = null;
        HashEntry previousNonNullTableEntry = null;
        HashEntry firstTableEntry = element;
        while (element != null && element != null) {
            n = (NameImpl)element.get();
            if (n == null) {
                if (firstTableEntry == element) {
                    this.hashes[h] = firstTableEntry = element.next;
                } else {
                    Assert.checkNonNull(previousNonNullTableEntry, "previousNonNullTableEntry cannot be null here.");
                    previousNonNullTableEntry.next = element.next;
                }
            } else {
                if (n.getByteLength() == len && UnsharedNameTable.equals(n.bytes, 0, cs, start, len)) {
                    return n;
                }
                previousNonNullTableEntry = element;
            }
            element = element.next;
        }
        byte[] bytes = new byte[len];
        System.arraycopy(cs, start, bytes, 0, len);
        n = new NameImpl(this, bytes, this.index++);
        System.arraycopy(cs, start, n.bytes, 0, len);
        HashEntry newEntry = new HashEntry(n);
        if (previousNonNullTableEntry == null) {
            this.hashes[h] = newEntry;
        } else {
            Assert.checkNull((Object)previousNonNullTableEntry.next, "previousNonNullTableEntry.next must be null.");
            previousNonNullTableEntry.next = newEntry;
        }
        return n;
    }

    public void dispose() {
        this.hashes = null;
    }

    static class NameImpl
    extends Name {
        final byte[] bytes;
        final int index;

        NameImpl(UnsharedNameTable table, byte[] bytes, int index) {
            super(table);
            this.bytes = bytes;
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public int getByteLength() {
            return this.bytes.length;
        }

        public byte getByteAt(int i) {
            return this.bytes[i];
        }

        public byte[] getByteArray() {
            return this.bytes;
        }

        public int getByteOffset() {
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HashEntry
    extends WeakReference<NameImpl> {
        HashEntry next;

        HashEntry(NameImpl referent) {
            super(referent);
        }
    }
}

