/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.context;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNameFilter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.artifact.GavCalculator;
import org.apache.maven.index.artifact.M2GavCalculator;
import org.apache.maven.index.context.AbstractIndexingContext;
import org.apache.maven.index.context.DocumentFilter;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexUtils;
import org.apache.maven.index.context.NexusAnalyzer;
import org.apache.maven.index.context.NexusIndexSearcher;
import org.apache.maven.index.context.NexusIndexWriter;
import org.apache.maven.index.context.UnsupportedExistingLuceneIndexException;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIndexingContext
extends AbstractIndexingContext {
    private static final String INDEX_DIRECTORY = ".index";
    public static final String FLD_DESCRIPTOR = "DESCRIPTOR";
    private static final String FLD_DESCRIPTOR_CONTENTS = "NexusIndex";
    private static final String FLD_IDXINFO = "IDXINFO";
    private static final String VERSION = "1.0";
    private static final Term DESCRIPTOR_TERM = new Term("DESCRIPTOR", "NexusIndex");
    private Directory indexDirectory;
    private File indexDirectoryFile;
    private String id;
    private boolean searchable;
    private String repositoryId;
    private File repository;
    private String repositoryUrl;
    private String indexUpdateUrl;
    private IndexReader indexReader;
    private NexusIndexSearcher indexSearcher;
    private NexusIndexWriter indexWriter;
    private Date timestamp;
    private List<? extends IndexCreator> indexCreators;
    private GavCalculator gavCalculator;
    private ReadWriteLock indexMaintenanceLock = new ReentrantReadWriteLock();
    private Thread bottleWarmerThread;
    private volatile boolean needsReaderReopen = false;
    public static boolean BLOCKING_COMMIT = false;

    private DefaultIndexingContext(String id, String repositoryId, File repository, String repositoryUrl, String indexUpdateUrl, List<? extends IndexCreator> indexCreators, Directory indexDirectory, boolean reclaimIndex) throws UnsupportedExistingLuceneIndexException, IOException {
        this.id = id;
        this.searchable = true;
        this.repositoryId = repositoryId;
        this.repository = repository;
        this.repositoryUrl = repositoryUrl;
        this.indexUpdateUrl = indexUpdateUrl;
        this.indexReader = null;
        this.indexWriter = null;
        this.indexCreators = indexCreators;
        this.indexDirectory = indexDirectory;
        for (IndexCreator indexCreator : indexCreators) {
            indexCreator.getIndexerFields();
        }
        this.gavCalculator = new M2GavCalculator();
        this.prepareIndex(reclaimIndex);
        this.installBottleWarmer();
    }

    public DefaultIndexingContext(String id, String repositoryId, File repository, File indexDirectoryFile, String repositoryUrl, String indexUpdateUrl, List<? extends IndexCreator> indexCreators, boolean reclaimIndex) throws IOException, UnsupportedExistingLuceneIndexException {
        this(id, repositoryId, repository, repositoryUrl, indexUpdateUrl, indexCreators, (Directory)FSDirectory.open((File)indexDirectoryFile), reclaimIndex);
        this.indexDirectoryFile = indexDirectoryFile;
    }

    public DefaultIndexingContext(String id, String repositoryId, File repository, Directory indexDirectory, String repositoryUrl, String indexUpdateUrl, List<? extends IndexCreator> indexCreators, boolean reclaimIndex) throws IOException, UnsupportedExistingLuceneIndexException {
        this(id, repositoryId, repository, repositoryUrl, indexUpdateUrl, indexCreators, indexDirectory, reclaimIndex);
        if (indexDirectory instanceof FSDirectory) {
            this.indexDirectoryFile = ((FSDirectory)indexDirectory).getFile();
        }
    }

    @Override
    public void lock() {
        this.indexMaintenanceLock.readLock().lock();
    }

    @Override
    public void unlock() {
        this.indexMaintenanceLock.readLock().unlock();
    }

    public void lockExclusively() {
        this.indexMaintenanceLock.writeLock().lock();
    }

    public void unlockExclusively() {
        this.indexMaintenanceLock.writeLock().unlock();
    }

    @Override
    public Directory getIndexDirectory() {
        return this.indexDirectory;
    }

    @Override
    public File getIndexDirectoryFile() {
        return this.indexDirectoryFile;
    }

    private void prepareIndex(boolean reclaimIndex) throws IOException, UnsupportedExistingLuceneIndexException {
        if (IndexReader.indexExists((Directory)this.indexDirectory)) {
            try {
                if (IndexWriter.isLocked((Directory)this.indexDirectory)) {
                    IndexWriter.unlock((Directory)this.indexDirectory);
                }
                this.openAndWarmup();
                this.checkAndUpdateIndexDescriptor(reclaimIndex);
            }
            catch (IOException e) {
                if (reclaimIndex) {
                    this.prepareCleanIndex(true);
                }
                throw e;
            }
        } else {
            this.prepareCleanIndex(false);
        }
        this.timestamp = IndexUtils.getTimestamp(this.indexDirectory);
    }

    private void prepareCleanIndex(boolean deleteExisting) throws IOException {
        if (deleteExisting) {
            this.closeReaders();
            if (IndexWriter.isLocked((Directory)this.indexDirectory)) {
                IndexWriter.unlock((Directory)this.indexDirectory);
            }
            this.deleteIndexFiles(true);
        }
        this.openAndWarmup();
        if (StringUtils.isEmpty((String)this.getRepositoryId())) {
            throw new IllegalArgumentException("The repositoryId cannot be null when creating new repository!");
        }
        this.storeDescriptor();
    }

    private void checkAndUpdateIndexDescriptor(boolean reclaimIndex) throws IOException, UnsupportedExistingLuceneIndexException {
        if (reclaimIndex) {
            this.storeDescriptor();
            return;
        }
        if (this.getIndexReader().numDocs() > 0) {
            TopScoreDocCollector collector = TopScoreDocCollector.create((int)1, (boolean)false);
            this.getIndexSearcher().search((Query)new TermQuery(DESCRIPTOR_TERM), (Collector)collector);
            if (collector.getTotalHits() == 0) {
                throw new UnsupportedExistingLuceneIndexException("The existing index has no NexusIndexer descriptor");
            }
            if (collector.getTotalHits() > 1) {
                this.storeDescriptor();
                return;
            }
            Document descriptor = this.getIndexSearcher().doc(collector.topDocs().scoreDocs[0].doc);
            String[] h = StringUtils.split((String)descriptor.get(FLD_IDXINFO), (String)"|");
            String repoId = h[1];
            if (this.getRepositoryId() == null) {
                this.repositoryId = repoId;
            } else if (!this.getRepositoryId().equals(repoId)) {
                throw new UnsupportedExistingLuceneIndexException("The existing index is for repository [" + repoId + "] and not for repository [" + this.getRepositoryId() + "]");
            }
        }
    }

    private void storeDescriptor() throws IOException {
        Document hdr = new Document();
        hdr.add((Fieldable)new Field(FLD_DESCRIPTOR, FLD_DESCRIPTOR_CONTENTS, Field.Store.YES, Field.Index.NOT_ANALYZED));
        hdr.add((Fieldable)new Field(FLD_IDXINFO, "1.0|" + this.getRepositoryId(), Field.Store.YES, Field.Index.NO));
        IndexWriter w = this.getIndexWriter();
        w.updateDocument(DESCRIPTOR_TERM, hdr);
        w.commit();
    }

    private void deleteIndexFiles(boolean full) throws IOException {
        String[] names = this.indexDirectory.listAll();
        if (names != null) {
            IndexFileNameFilter filter = IndexFileNameFilter.getFilter();
            for (int i = 0; i < names.length; ++i) {
                if (!filter.accept(null, names[i])) continue;
                this.indexDirectory.deleteFile(names[i]);
            }
        }
        if (full) {
            if (this.indexDirectory.fileExists("nexus-maven-repository-index-packer.properties")) {
                this.indexDirectory.deleteFile("nexus-maven-repository-index-packer.properties");
            }
            if (this.indexDirectory.fileExists("nexus-maven-repository-index-updater.properties")) {
                this.indexDirectory.deleteFile("nexus-maven-repository-index-updater.properties");
            }
        }
        IndexUtils.deleteTimestamp(this.indexDirectory);
    }

    @Override
    public boolean isSearchable() {
        return this.searchable;
    }

    @Override
    public void setSearchable(boolean searchable) {
        this.searchable = searchable;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void updateTimestamp() throws IOException {
        this.updateTimestamp(false);
    }

    @Override
    public void updateTimestamp(boolean save) throws IOException {
        this.updateTimestamp(save, new Date());
    }

    @Override
    public void updateTimestamp(boolean save, Date timestamp) throws IOException {
        this.timestamp = timestamp;
        if (save) {
            IndexUtils.updateTimestamp(this.indexDirectory, this.getTimestamp());
        }
    }

    @Override
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    public int getSize() throws IOException {
        return this.getIndexReader().numDocs();
    }

    @Override
    public String getRepositoryId() {
        return this.repositoryId;
    }

    @Override
    public File getRepository() {
        return this.repository;
    }

    @Override
    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    @Override
    public String getIndexUpdateUrl() {
        if (this.repositoryUrl != null && (this.indexUpdateUrl == null || this.indexUpdateUrl.trim().length() == 0)) {
            return this.repositoryUrl + (this.repositoryUrl.endsWith("/") ? "" : "/") + INDEX_DIRECTORY;
        }
        return this.indexUpdateUrl;
    }

    @Override
    public Analyzer getAnalyzer() {
        return new NexusAnalyzer();
    }

    protected void openAndWarmup() throws IOException {
        if (this.indexWriter != null) {
            this.indexWriter.close();
            this.indexWriter = null;
        }
        if (this.indexSearcher != null) {
            this.indexSearcher.close();
            this.indexSearcher = null;
        }
        if (this.indexReader != null) {
            this.indexReader.close();
            this.indexReader = null;
        }
        boolean create = !IndexReader.indexExists((Directory)this.indexDirectory);
        this.indexWriter = new NexusIndexWriter(this.getIndexDirectory(), new NexusAnalyzer(), create);
        this.indexWriter.setRAMBufferSizeMB(2.0);
        this.indexWriter.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
        this.openAndWarmupReaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openAndWarmupReaders() throws IOException {
        if (this.indexReader != null && this.indexReader.isCurrent()) {
            return;
        }
        IndexReader newIndexReader = IndexReader.open((Directory)this.indexDirectory, (boolean)true);
        NexusIndexSearcher newIndexSearcher = new NexusIndexSearcher(this, newIndexReader);
        this.warmUp(newIndexSearcher);
        this.lockExclusively();
        try {
            if (this.indexSearcher != null) {
                this.indexSearcher.close();
            }
            if (this.indexReader != null) {
                this.indexReader.close();
            }
            this.indexReader = newIndexReader;
            this.indexSearcher = newIndexSearcher;
        }
        finally {
            this.unlockExclusively();
        }
    }

    protected void warmUp(NexusIndexSearcher searcher) throws IOException {
        try {
            searcher.search((Query)new TermQuery(new Term("g", "org.apache")), 1000);
        }
        catch (IOException e) {
            this.close(false);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexWriter getIndexWriter() throws IOException {
        this.lock();
        try {
            NexusIndexWriter nexusIndexWriter = this.indexWriter;
            return nexusIndexWriter;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexReader getIndexReader() throws IOException {
        this.lock();
        try {
            IndexReader indexReader = this.indexReader;
            return indexReader;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexSearcher getIndexSearcher() throws IOException {
        this.lock();
        try {
            NexusIndexSearcher nexusIndexSearcher = this.indexSearcher;
            return nexusIndexSearcher;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws IOException {
        if (BLOCKING_COMMIT) {
            this.lockExclusively();
        } else {
            this.lock();
        }
        try {
            this.doCommit(BLOCKING_COMMIT);
        }
        finally {
            if (BLOCKING_COMMIT) {
                this.unlockExclusively();
            } else {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCommit(boolean blocking) throws IOException {
        try {
            DefaultIndexingContext defaultIndexingContext = this;
            synchronized (defaultIndexingContext) {
                this.getIndexWriter().commit();
            }
            if (blocking) {
                this.openAndWarmupReaders();
            } else {
                this.flagNeedsReopen();
            }
        }
        catch (CorruptIndexException e) {
            this.close(false);
            throw e;
        }
        catch (IOException e) {
            this.close(false);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws IOException {
        this.lock();
        try {
            IndexWriter w = this.getIndexWriter();
            try {
                DefaultIndexingContext defaultIndexingContext = this;
                synchronized (defaultIndexingContext) {
                    w.rollback();
                }
            }
            catch (CorruptIndexException e) {
                this.close(false);
                throw e;
            }
            catch (IOException e) {
                this.close(false);
                throw e;
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void optimize() throws CorruptIndexException, IOException {
        this.lockExclusively();
        try {
            IndexWriter w = this.getIndexWriter();
            try {
                w.optimize();
                this.doCommit(true);
            }
            catch (CorruptIndexException e) {
                this.close(false);
                throw e;
            }
            catch (IOException e) {
                this.close(false);
                throw e;
            }
        }
        finally {
            this.unlockExclusively();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean deleteFiles) throws IOException {
        this.lockExclusively();
        try {
            if (this.indexDirectory != null) {
                IndexUtils.updateTimestamp(this.indexDirectory, this.getTimestamp());
                this.closeReaders();
                if (deleteFiles) {
                    this.deleteIndexFiles(true);
                }
                this.indexDirectory.close();
            }
            this.indexDirectory = null;
        }
        finally {
            this.unlockExclusively();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge() throws IOException {
        this.lockExclusively();
        try {
            this.closeReaders();
            this.deleteIndexFiles(true);
            this.openAndWarmup();
            try {
                this.prepareIndex(true);
            }
            catch (UnsupportedExistingLuceneIndexException unsupportedExistingLuceneIndexException) {
                // empty catch block
            }
            this.rebuildGroups();
            this.updateTimestamp(true, null);
        }
        finally {
            this.unlockExclusively();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replace(Directory directory) throws IOException {
        this.lockExclusively();
        try {
            Date ts = IndexUtils.getTimestamp(directory);
            this.closeReaders();
            this.deleteIndexFiles(false);
            IndexUtils.copyDirectory(directory, this.indexDirectory);
            this.openAndWarmup();
            this.storeDescriptor();
            this.updateTimestamp(true, ts);
            this.optimize();
        }
        finally {
            this.unlockExclusively();
        }
    }

    @Override
    public void merge(Directory directory) throws IOException {
        this.merge(directory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(Directory directory, DocumentFilter filter) throws IOException {
        this.lockExclusively();
        try {
            IndexWriter w = this.getIndexWriter();
            IndexSearcher s = this.getIndexSearcher();
            IndexReader directoryReader = IndexReader.open((Directory)directory, (boolean)true);
            TopScoreDocCollector collector = null;
            try {
                int numDocs = directoryReader.maxDoc();
                for (int i = 0; i < numDocs; ++i) {
                    if (directoryReader.isDeleted(i)) continue;
                    Document d = directoryReader.document(i);
                    if (filter != null && !filter.accept(d)) continue;
                    String uinfo = d.get(ArtifactInfo.UINFO);
                    if (uinfo != null) {
                        collector = TopScoreDocCollector.create((int)1, (boolean)false);
                        s.search((Query)new TermQuery(new Term(ArtifactInfo.UINFO, uinfo)), (Collector)collector);
                        if (collector.getTotalHits() != 0) continue;
                        w.addDocument(IndexUtils.updateDocument(d, this, false));
                        continue;
                    }
                    String deleted = d.get(ArtifactInfo.DELETED);
                    if (deleted == null) continue;
                    w.deleteDocuments(new Term(ArtifactInfo.UINFO, deleted));
                    w.addDocument(d);
                }
            }
            finally {
                directoryReader.close();
                this.doCommit(true);
            }
            this.rebuildGroups();
            Date mergedTimestamp = IndexUtils.getTimestamp(directory);
            if (this.getTimestamp() != null && mergedTimestamp != null && mergedTimestamp.after(this.getTimestamp())) {
                this.updateTimestamp(true, mergedTimestamp);
            } else {
                this.updateTimestamp(true);
            }
            this.optimize();
        }
        finally {
            this.unlockExclusively();
        }
    }

    private void closeReaders() throws CorruptIndexException, IOException {
        if (this.indexWriter != null) {
            this.indexWriter.close();
            this.indexWriter = null;
        }
        if (this.indexSearcher != null) {
            this.indexSearcher.close();
            this.indexSearcher = null;
        }
        if (this.indexReader != null) {
            this.indexReader.close();
            this.indexReader = null;
        }
    }

    @Override
    public GavCalculator getGavCalculator() {
        return this.gavCalculator;
    }

    @Override
    public List<IndexCreator> getIndexCreators() {
        return Collections.unmodifiableList(this.indexCreators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebuildGroups() throws IOException {
        this.lockExclusively();
        try {
            IndexReader r = this.getIndexReader();
            LinkedHashSet<String> rootGroups = new LinkedHashSet<String>();
            LinkedHashSet<String> allGroups = new LinkedHashSet<String>();
            int numDocs = r.maxDoc();
            for (int i = 0; i < numDocs; ++i) {
                Document d;
                String uinfo;
                if (r.isDeleted(i) || (uinfo = (d = r.document(i)).get(ArtifactInfo.UINFO)) == null) continue;
                ArtifactInfo info = IndexUtils.constructArtifactInfo(d, this);
                rootGroups.add(info.getRootGroup());
                allGroups.add(info.groupId);
            }
            this.setRootGroups(rootGroups);
            this.setAllGroups(allGroups);
            this.optimize();
        }
        finally {
            this.unlockExclusively();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getAllGroups() throws IOException {
        this.lock();
        try {
            Set<String> set = this.getGroups("allGroups", "allGroups", "allGroupsList");
            return set;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAllGroups(Collection<String> groups) throws IOException {
        this.lockExclusively();
        try {
            this.setGroups(groups, "allGroups", "allGroups", "allGroupsList");
            this.doCommit(true);
        }
        finally {
            this.unlockExclusively();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getRootGroups() throws IOException {
        this.lock();
        try {
            Set<String> set = this.getGroups("rootGroups", "rootGroups", "rootGroupsList");
            return set;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRootGroups(Collection<String> groups) throws IOException {
        this.lockExclusively();
        try {
            this.setGroups(groups, "rootGroups", "rootGroups", "rootGroupsList");
            this.doCommit(true);
        }
        finally {
            this.unlockExclusively();
        }
    }

    protected Set<String> getGroups(String field, String filedValue, String listField) throws IOException, CorruptIndexException {
        Document doc;
        String groupList;
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)1, (boolean)false);
        this.getIndexSearcher().search((Query)new TermQuery(new Term(field, filedValue)), (Collector)collector);
        TopDocs topDocs = collector.topDocs();
        LinkedHashSet<String> groups = new LinkedHashSet<String>(Math.max(10, topDocs.totalHits));
        if (topDocs.totalHits > 0 && (groupList = (doc = this.getIndexSearcher().doc(topDocs.scoreDocs[0].doc)).get(listField)) != null) {
            groups.addAll(Arrays.asList(groupList.split("\\|")));
        }
        return groups;
    }

    protected void setGroups(Collection<String> groups, String groupField, String groupFieldValue, String groupListField) throws IOException, CorruptIndexException {
        IndexWriter w = this.getIndexWriter();
        w.updateDocument(new Term(groupField, groupFieldValue), this.createGroupsDocument(groups, groupField, groupFieldValue, groupListField));
    }

    protected Document createGroupsDocument(Collection<String> groups, String field, String fieldValue, String listField) {
        Document groupDoc = new Document();
        groupDoc.add((Fieldable)new Field(field, fieldValue, Field.Store.YES, Field.Index.NOT_ANALYZED));
        groupDoc.add((Fieldable)new Field(listField, ArtifactInfo.lst2str(groups), Field.Store.YES, Field.Index.NO));
        return groupDoc;
    }

    public String toString() {
        return this.id + " : " + this.timestamp;
    }

    protected void flagNeedsReopen() {
        this.needsReaderReopen = true;
    }

    protected void unflagNeedsReopen() {
        this.needsReaderReopen = false;
    }

    protected boolean isReopenNeeded() {
        return this.needsReaderReopen;
    }

    protected void installBottleWarmer() {
        if (BLOCKING_COMMIT) {
            return;
        }
        Runnable bottleWarmer = new Runnable(){

            public void run() {
                while (DefaultIndexingContext.this.indexDirectory != null) {
                    try {
                        if (DefaultIndexingContext.this.isReopenNeeded()) {
                            DefaultIndexingContext.this.openAndWarmupReaders();
                            DefaultIndexingContext.this.unflagNeedsReopen();
                        }
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.bottleWarmerThread = new Thread(bottleWarmer, "Index-BottleWarmer-" + this.id);
        this.bottleWarmerThread.setDaemon(true);
        this.bottleWarmerThread.start();
    }
}

