/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.chart.pie;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.chart.BaseChartRenderer;
import org.primefaces.component.chart.UIChart;
import org.primefaces.component.chart.pie.PieChart;
import org.primefaces.model.chart.PieChartModel;

public class PieChartRenderer
extends BaseChartRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        PieChart chart = (PieChart)component;
        if (chart.isLiveDataRequest(context)) {
            this.encodeData(context, chart, true);
        } else {
            this.encodeResources(context);
            this.encodeMarkup(context, chart);
            this.encodeScript(context, chart);
        }
    }

    protected void encodeScript(FacesContext context, UIChart uichart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        PieChart chart = (PieChart)uichart;
        String clientId = chart.getClientId(context);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("jQuery(function(){");
        writer.write(chart.resolveWidgetVar() + " = new PrimeFaces.widget.PieChart('" + clientId + "', {");
        this.encodeCommonConfig(context, chart);
        writer.write(",categoryField:'category'");
        writer.write(",dataField:'data'");
        if (chart.getSeriesStyle() != null) {
            writer.write(",series: [{style:" + chart.getSeriesStyle() + "}]");
        }
        this.encodeData(context, chart, false);
        writer.write("});});");
        writer.endElement("script");
    }

    protected void encodeData(FacesContext context, PieChart chart, boolean remote) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (remote) {
            writer.write("{");
        } else {
            writer.write(",");
        }
        writer.write("\"data\":[");
        if (chart.hasModel()) {
            PieChartModel model = (PieChartModel)chart.getModel();
            Iterator<String> it = model.getData().keySet().iterator();
            while (it.hasNext()) {
                String category = it.next();
                writer.write("{\"category\":\"" + category + "\",\"data\":" + model.getData().get(category) + "}");
                if (!it.hasNext()) continue;
                writer.write(",");
            }
        } else {
            Collection value = (Collection)chart.getValue();
            Iterator iterator = value.iterator();
            while (iterator.hasNext()) {
                context.getExternalContext().getRequestMap().put(chart.getVar(), iterator.next());
                writer.write("{\"category\":\"" + chart.getCategoryField() + "\",\"data\":" + chart.getDataField() + "}");
                if (!iterator.hasNext()) continue;
                writer.write(",");
            }
            context.getExternalContext().getRequestMap().remove(chart.getVar());
        }
        writer.write("]");
        if (remote) {
            writer.write("}");
        }
    }
}

