/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.graphictext;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.graphictext.GraphicText;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.HTML;

public class GraphicTextRenderer
extends CoreRenderer {
    public static final String KEY_FONTNAME = "fontname";
    public static final String KEY_FONTSTYLE = "fontstyle";
    public static final String KEY_FONTSIZE = "fontsize";
    public static final String KEY_GRAPHICTEXT = "graphictext";

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        GraphicText graphicText = (GraphicText)component;
        String clientId = graphicText.getClientId(facesContext);
        writer.startElement("img", (UIComponent)graphicText);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("src", (Object)this.constructDynaImgUrl(facesContext, graphicText), null);
        if (graphicText.getAlt() == null) {
            writer.writeAttribute("alt", (Object)"", null);
        }
        this.renderPassThruAttributes(facesContext, (UIComponent)graphicText, HTML.IMG_ATTRS);
        if (graphicText.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)graphicText.getStyleClass(), "styleClass");
        }
        writer.endElement("img");
    }

    private String constructDynaImgUrl(FacesContext facesContext, GraphicText graphicText) {
        Object value = graphicText.getValue();
        if (value instanceof String) {
            StringBuilder builder = new StringBuilder();
            builder.append("?").append("primefacesGraphicText").append("=").append("true").append("&").append(KEY_FONTNAME).append("=").append(graphicText.getFontName()).append("&").append(KEY_FONTSTYLE).append("=").append(graphicText.getFontStyle()).append("&").append(KEY_FONTSIZE).append("=").append(graphicText.getFontSize()).append("&").append(KEY_GRAPHICTEXT).append("=").append(value);
            return builder.toString();
        }
        return "";
    }
}

