/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.ProfilingEventListener;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.client.AppStatusHandler;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.client.ProfilingPointsProcessor;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.GlobalProfilingSettings;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.lib.profiler.common.filters.DefinedFilterSets;
import org.netbeans.lib.profiler.common.filters.GlobalFilters;
import org.netbeans.lib.profiler.global.CalibrationDataFileIO;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.instrumentation.BadLocationException;
import org.netbeans.lib.profiler.instrumentation.InstrumentationException;
import org.netbeans.lib.profiler.results.CCTProvider;
import org.netbeans.lib.profiler.results.ProfilingResultsDispatcher;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.CPUProfilingResultListener;
import org.netbeans.lib.profiler.results.cpu.FlatProfileBuilder;
import org.netbeans.lib.profiler.results.cpu.cct.CCTResultsFilter;
import org.netbeans.lib.profiler.results.cpu.cct.TimeCollector;
import org.netbeans.lib.profiler.results.cpu.marking.MarkingEngine;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.results.memory.MemoryProfilingResultsListener;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.results.threads.ThreadsDataManager;
import org.netbeans.lib.profiler.ui.cpu.statistics.StatisticalModule;
import org.netbeans.lib.profiler.ui.cpu.statistics.StatisticalModuleContainer;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryModels;
import org.netbeans.lib.profiler.wireprotocol.Response;
import org.netbeans.lib.profiler.wireprotocol.WireIO;
import org.netbeans.modules.profiler.GestureSubmitter;
import org.netbeans.modules.profiler.LiveResultsWindow;
import org.netbeans.modules.profiler.ProfilerControlPanel2;
import org.netbeans.modules.profiler.ProfilerControlPanel2Support;
import org.netbeans.modules.profiler.ProfilerIDESettings;
import org.netbeans.modules.profiler.ProfilerModule;
import org.netbeans.modules.profiler.ProfilingMonitor;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.TelemetryOverviewPanel;
import org.netbeans.modules.profiler.ThreadsWindow;
import org.netbeans.modules.profiler.actions.RerunAction;
import org.netbeans.modules.profiler.heapwalk.HeapDumpWatch;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.ui.ProfilingPointsWindow;
import org.netbeans.modules.profiler.spi.LoadGenPlugin;
import org.netbeans.modules.profiler.ui.NBSwingWorker;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.stats.ProjectAwareStatisticalModule;
import org.netbeans.modules.profiler.utils.GoToSourceHelper;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.netbeans.modules.profiler.utils.JavaSourceLocation;
import org.netbeans.modules.profiler.utils.OutputParameter;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.WindowManager;

public final class NetBeansProfiler
extends Profiler {
    private static final Logger LOGGER = Logger.getLogger(NetBeansProfiler.class.getName());
    private static final String CALIBRATION_FAILED_MESSAGE;
    private static final String CALIBRATION_MISSING_MESSAGE;
    private static final String CALIBRATION_MISSING_SHORT_MESSAGE;
    private static final String PROGRESS_DIALOG_CAPTION;
    private static final String ENTIRE_APPLICATION_PROFILING_WARNING;
    private static final String DIRECTORY_DOES_NOT_EXIST_MESSAGE;
    private static final String DIRECTORY_IS_WRITE_PROTECTED_MESSAGE;
    private static final String ERROR_LOADING_PROFILING_SETTINGS_MESSAGE;
    private static final String ERROR_SAVING_PROFILING_SETTINGS_MESSAGE;
    private static final String ERROR_SAVING_FILTER_SETS_MESSAGE;
    private static final String ERROR_SAVING_ATTACH_SETTINGS_MESSAGE;
    private static final String CANNOT_FIND_LIBS_MSG;
    private static final String ENGINE_INIT_FAILED_MSG;
    private static final String INITIAL_CALIBRATION_MSG;
    private static final String TERMINATE_VM_ON_EXIT_MSG;
    private static final String TAKE_SNAPSHOT_ON_EXIT_MSG;
    private static final String TAKE_SNAPSHOT_ON_EXIT_DIALOG_TITLE;
    private static final String TARGET_APP_NOT_RESPONDING_MSG;
    private static final String TARGET_APP_NOT_RESPONDING_DIALOG_TITLE;
    private static final String MODIFYING_INSTRUMENTATION_MSG;
    static final ErrorManager profilerErrorManager;
    private static final String GLOBAL_FILTERS_FILENAME = "filters";
    private static final String DEFINED_FILTERSETS_FILENAME = "filtersets";
    private static final String DEFAULT_FILE_SUFFIX = "-default";
    private static final String ATTACH_SETTINGS_FILENAME = "attach";
    private static boolean initialized;
    AppStatusHandler.AsyncDialog waitDialog = null;
    boolean shouldDisplayDialog = true;
    private final ProfilerIDESettings ideSettings = ProfilerIDESettings.getInstance();
    private final ProfilingMonitor monitor = new ProfilingMonitor();
    private final TargetAppRunner targetAppRunner;
    private DefinedFilterSets definedFilterSets;
    private FileObject profiledSingleFile;
    private ProfilerControlPanel2Support actionSupport = new ProfilerControlPanel2Support();
    private GlobalFilters globalFilters;
    private final Object setupLock = new Object();
    private ProfilingSettings lastProfilingSettings;
    private Project profiledProject = null;
    private SessionSettings lastSessionSettings;
    private StringBuilder logMsgs = new StringBuilder();
    private ThreadsDataManager threadsManager;
    private VMTelemetryDataManager vmTelemetryManager;
    private VMTelemetryModels vmTelemetryModels;
    private boolean calibrating = false;
    private boolean processesProfilingPoints;
    private boolean silent;
    private boolean threadsMonitoringEnabled = false;
    private boolean waitDialogOpen = false;
    private int lastMode = 1;
    private int profilingMode = 1;
    private int profilingState = 1;
    private final RequestProcessor srcOpenerRP = new RequestProcessor("Profiler Source Opener");

    public NetBeansProfiler() {
        boolean initFailed = false;
        ProfilerEngineSettings sharedSettings = new ProfilerEngineSettings();
        try {
            String libsDir = IDEUtils.getLibsDir();
            if (libsDir == null) {
                throw new IOException(CANNOT_FIND_LIBS_MSG);
            }
            sharedSettings.initialize(libsDir);
            sharedSettings.setSeparateConsole(System.getProperty("org.netbeans.profiler.separateConsole") != null);
            sharedSettings.setTargetWindowRemains(System.getProperty("org.netbeans.profiler.targetWindowRemains") != null);
        }
        catch (RuntimeException e) {
            ProfilerLogger.log((Exception)e);
            ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 0));
            initFailed = true;
        }
        catch (IOException e) {
            ErrorManager.getDefault().annotate((Throwable)e, MessageFormat.format(ENGINE_INIT_FAILED_MSG, e.getLocalizedMessage()));
            ErrorManager.getDefault().notify(65536, (Throwable)e);
            initFailed = true;
        }
        this.targetAppRunner = new TargetAppRunner(sharedSettings, (AppStatusHandler)new IDEAppStatusHandler(), (ProfilingPointsProcessor)ProfilingPointsManager.getDefault());
        this.targetAppRunner.addProfilingEventListener(new ProfilingEventListener(){

            public void targetAppStarted() {
                if (NetBeansProfiler.this.calibrating) {
                    return;
                }
                NetBeansProfiler.this.changeStateTo(4);
            }

            public void targetAppStopped() {
                if (NetBeansProfiler.this.calibrating) {
                    return;
                }
                NetBeansProfiler.this.changeStateTo(16);
            }

            public void targetAppSuspended() {
                if (NetBeansProfiler.this.calibrating) {
                    return;
                }
                NetBeansProfiler.this.changeStateTo(8);
            }

            public void targetAppResumed() {
                if (NetBeansProfiler.this.calibrating) {
                    return;
                }
                NetBeansProfiler.this.changeStateTo(4);
            }

            public void attachedToTarget() {
                if (NetBeansProfiler.this.calibrating) {
                    return;
                }
                NetBeansProfiler.this.changeStateTo(4);
            }

            public void detachedFromTarget() {
                if (NetBeansProfiler.this.calibrating) {
                    return;
                }
                NetBeansProfiler.this.monitor.stopDisplayingVM();
                NetBeansProfiler.this.changeStateTo(1);
            }

            public void targetVMTerminated() {
                if (NetBeansProfiler.this.calibrating) {
                    return;
                }
                NetBeansProfiler.this.monitor.stopDisplayingVM();
                NetBeansProfiler.this.changeStateTo(1);
            }
        });
        if (!initFailed) {
            initialized = true;
        }
    }

    public static NetBeansProfiler getDefaultNB() {
        return (NetBeansProfiler)NetBeansProfiler.getDefault();
    }

    public static boolean isInitialized() {
        NetBeansProfiler.getDefaultNB();
        return initialized;
    }

    public int getAgentState(String host, int port, int agentId) {
        if (this.profilingState == 4 && port == this.targetAppRunner.getProfilerEngineSettings().getPortNo()) {
            if (this.targetAppRunner.getProfilerClient().getCurrentAgentId() == agentId) {
                return 3;
            }
            return 4;
        }
        Properties agentProps = this.getAgentProperties(port);
        if (agentProps == null) {
            return 0;
        }
        try {
            int id = Integer.parseInt(agentProps.getProperty("agent.id"));
            if (id == agentId) {
                String dynamic = agentProps.getProperty("dynamic");
                if (dynamic == null || "false".equals(dynamic)) {
                    return 2;
                }
                return 1;
            }
            return 4;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public Properties getCurrentProfilingProperties() {
        return this.actionSupport.getProperties();
    }

    public SessionSettings getCurrentSessionSettings() {
        return this.lastSessionSettings;
    }

    public synchronized DefinedFilterSets getDefinedFilterSets() {
        if (this.definedFilterSets == null) {
            this.loadGlobalFilters();
        }
        return this.definedFilterSets;
    }

    public synchronized GlobalFilters getGlobalFilters() {
        if (this.globalFilters == null) {
            this.loadGlobalFilters();
        }
        return this.globalFilters;
    }

    public GlobalProfilingSettings getGlobalProfilingSettings() {
        return this.ideSettings;
    }

    public ProfilingSettings getLastProfilingSettings() {
        return this.lastProfilingSettings;
    }

    public String getLibsDir() {
        return IDEUtils.getLibsDir();
    }

    public int getPlatformArchitecture(String platformName) {
        JavaPlatform platform = IDEUtils.getJavaPlatformByName(platformName);
        if (platform == null) {
            return 32;
        }
        return IDEUtils.getPlatformArchitecture(platform);
    }

    public String getPlatformJDKVersion(String platformName) {
        JavaPlatform platform = IDEUtils.getJavaPlatformByName(platformName);
        if (platform == null) {
            return null;
        }
        return IDEUtils.getPlatformJDKVersion(platform);
    }

    public String getPlatformJavaFile(String platformName) {
        JavaPlatform platform = IDEUtils.getJavaPlatformByName(platformName);
        if (platform == null) {
            return null;
        }
        return IDEUtils.getPlatformJavaFile(platform);
    }

    public int getProfilingMode() {
        return this.profilingMode;
    }

    public int getProfilingState() {
        return this.profilingState;
    }

    public TargetAppRunner getTargetAppRunner() {
        return this.targetAppRunner;
    }

    public ThreadsDataManager getThreadsManager() {
        if (this.threadsManager == null) {
            this.threadsManager = new ThreadsDataManager();
        }
        return this.threadsManager;
    }

    public void setThreadsMonitoringEnabled(boolean enabled) {
        this.getThreadsManager().setThreadsMonitoringEnabled(enabled);
        if (this.threadsMonitoringEnabled == enabled) {
            return;
        }
        this.threadsMonitoringEnabled = enabled;
        this.fireThreadsMonitoringChange();
    }

    public boolean getThreadsMonitoringEnabled() {
        return this.threadsMonitoringEnabled;
    }

    public VMTelemetryModels getVMTelemetryModels() {
        if (this.vmTelemetryModels == null) {
            this.vmTelemetryModels = new VMTelemetryModels(this.getVMTelemetryManager());
        }
        return this.vmTelemetryModels;
    }

    public VMTelemetryDataManager getVMTelemetryManager() {
        if (this.vmTelemetryManager == null) {
            this.vmTelemetryManager = new VMTelemetryDataManager();
        }
        return this.vmTelemetryManager;
    }

    public boolean attachToApp(final ProfilingSettings profilingSettings, final AttachSettings attachSettings) {
        this.profilingMode = 0;
        final OutputParameter<Boolean> methodResults = new OutputParameter<Boolean>(Boolean.TRUE);
        new NBSwingWorker(false){
            private ProgressHandle ph;
            {
                super(x0);
                this.ph = null;
            }

            protected void doInBackground() {
                if (NetBeansProfiler.this.getProfilingState() != 1) {
                    if (NetBeansProfiler.this.lastMode == 0) {
                        NetBeansProfiler.this.detachFromApp();
                    } else if (NetBeansProfiler.this.targetAppRunner.targetJVMIsAlive()) {
                        NetBeansProfiler.this.targetAppRunner.terminateTargetJVM();
                    }
                }
                NetBeansProfiler.this.lastProfilingSettings = profilingSettings;
                NetBeansProfiler.this.lastSessionSettings = null;
                NetBeansProfiler.this.lastMode = 0;
                NetBeansProfiler.this.actionSupport.nullAll();
                IDEUtils.runInEventDispatchThread(new Runnable(){

                    @Override
                    public void run() {
                        ((RerunAction)CallableSystemAction.get(RerunAction.class)).updateAction();
                    }
                });
                ProfilerEngineSettings sharedSettings = NetBeansProfiler.this.targetAppRunner.getProfilerEngineSettings();
                profilingSettings.applySettings(sharedSettings);
                attachSettings.applySettings(sharedSettings);
                NetBeansProfiler.this.printDebugMsg("Profiler.attachToApp: ***************************************************", false);
                NetBeansProfiler.this.printDebugMsg("profiling settings --------------------------------", false);
                NetBeansProfiler.this.printDebugMsg(profilingSettings.debug(), false);
                NetBeansProfiler.this.printDebugMsg("attach settings -----------------------------------", false);
                NetBeansProfiler.this.printDebugMsg(attachSettings.debug(), false);
                NetBeansProfiler.this.printDebugMsg("instrumentation filter ----------------------------", false);
                NetBeansProfiler.this.printDebugMsg(sharedSettings.getInstrumentationFilter().debug(), false);
                NetBeansProfiler.this.printDebugMsg("Profiler.attachToApp: ***************************************************", false);
                NetBeansProfiler.this.flushDebugMsgs();
                GestureSubmitter.logAttach(NetBeansProfiler.this.getProfiledProject(), attachSettings);
                GestureSubmitter.logConfig(profilingSettings);
                NetBeansProfiler.this.changeStateTo(2);
                NetBeansProfiler.this.cleanupBeforeProfiling(sharedSettings);
                NetBeansProfiler.this.setThreadsMonitoringEnabled(profilingSettings.getThreadsMonitoringEnabled());
                IDEUtils.runInEventDispatchThread(new Runnable(){

                    @Override
                    public void run() {
                        NetBeansProfiler.this.openWindowsOnProfilingStart();
                    }
                });
                if (attachSettings.isDirect()) {
                    boolean success = false;
                    if (NetBeansProfiler.this.prepareInstrumentation(profilingSettings)) {
                        boolean bl = success = NetBeansProfiler.this.targetAppRunner.initiateSession(1, false) && NetBeansProfiler.this.targetAppRunner.attachToTargetVMOnStartup();
                    }
                    if (!success) {
                        NetBeansProfiler.this.changeStateTo(1);
                        methodResults.setValue(false);
                        return;
                    }
                } else if (attachSettings.isDynamic16()) {
                    String jar = NetBeansProfiler.this.getLibsDir() + "/jfluid-server-15.jar";
                    String pid = String.valueOf(attachSettings.getPid());
                    String options = String.valueOf(attachSettings.getPort());
                    boolean success = false;
                    try {
                        this.loadAgentIntoTargetJVM(jar, options, pid);
                        if (NetBeansProfiler.this.prepareInstrumentation(profilingSettings)) {
                            success = NetBeansProfiler.this.targetAppRunner.initiateSession(2, false) && NetBeansProfiler.this.targetAppRunner.attachToTargetVM();
                        }
                    }
                    catch (Exception ex) {
                        NetBeansProfiler.this.displayError(ex.getMessage());
                        ProfilerLogger.log((Exception)ex);
                    }
                    if (!success) {
                        NetBeansProfiler.this.changeStateTo(1);
                        methodResults.setValue(false);
                        return;
                    }
                } else {
                    throw new IllegalArgumentException("Invalid settings " + attachSettings);
                }
                if (NetBeansProfiler.this.targetAppRunner.targetAppIsRunning()) {
                    NetBeansProfiler.this.getThreadsManager().setSupportsSleepingStateMonitoring(Platform.supportsThreadSleepingStateMonitoring((String)sharedSettings.getTargetJDKVersionString()));
                    NetBeansProfiler.this.monitor.monitorVM(NetBeansProfiler.this.targetAppRunner);
                    if (NetBeansProfiler.this.threadsMonitoringEnabled) {
                        IDEUtils.runInEventDispatchThread(new Runnable(){

                            @Override
                            public void run() {
                                ThreadsWindow.getDefault().showThreads();
                            }
                        });
                    }
                    methodResults.setValue(true);
                    return;
                }
                methodResults.setValue(false);
            }

            private void loadAgentIntoTargetJVM(String jar, String options, String pid) throws AttachNotSupportedException, IOException, AgentLoadException, AgentInitializationException {
                VirtualMachine virtualMachine = VirtualMachine.attach(pid);
                virtualMachine.loadAgent(jar, options);
            }

            protected void nonResponding() {
                this.ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"NetBeansProfiler_StartingSession"));
                this.ph.start();
            }

            protected void done() {
                if (this.ph != null) {
                    this.ph.finish();
                    this.ph = null;
                }
            }
        }.execute();
        return methodResults.getValue();
    }

    public void checkAndUpdateState() {
        boolean targetVMAlive = this.targetAppRunner.targetJVMIsAlive();
        if (!targetVMAlive) {
            this.changeStateTo(1);
            return;
        }
        boolean running = this.targetAppRunner.targetAppIsRunning();
        if (!running) {
            this.changeStateTo(16);
            return;
        }
        boolean suspended = this.targetAppRunner.targetAppSuspended();
        if (suspended) {
            this.changeStateTo(8);
        }
    }

    public boolean cleanForProfilingOnPort(int port) {
        if (this.isProfilingRunningOnPort(port)) {
            ProfilerLogger.severe((String)(">>> Profiling session already running on port " + port + ", will cause collision when starting another agent on the same port."));
            return false;
        }
        if (!this.shutdownAgent("localhost", port)) {
            ProfilerLogger.severe((String)(">>> Profiler agent already profiling on port " + port + " (communicating with another IDE?), will cause collision when starting another agent on the same port."));
            return false;
        }
        File agentFile = NetBeansProfiler.getInfoFile(port);
        if (agentFile.exists()) {
            boolean fileDeleted = this.waitForDeleteAgentFile(agentFile);
            if (!fileDeleted) {
                ProfilerLogger.severe((String)(">>> Profiler agent identification file cannot be deleted for port " + port + ", will cause failure starting a server for profiling on the same port."));
            }
            return fileDeleted;
        }
        return true;
    }

    public boolean connectToStartedApp(final ProfilingSettings profilingSettings, final SessionSettings sessionSettings) {
        this.profilingMode = 1;
        this.lastProfilingSettings = profilingSettings;
        this.lastSessionSettings = sessionSettings;
        this.lastMode = 1;
        final OutputParameter<Boolean> methodResult = new OutputParameter<Boolean>(Boolean.TRUE);
        new NBSwingWorker(false){
            private ProgressHandle ph;
            {
                super(x0);
                this.ph = null;
            }

            protected void doInBackground() {
                if (NetBeansProfiler.this.targetAppRunner.targetJVMIsAlive()) {
                    NetBeansProfiler.this.targetAppRunner.terminateTargetJVM();
                }
                ProfilerEngineSettings sharedSettings = NetBeansProfiler.this.targetAppRunner.getProfilerEngineSettings();
                sessionSettings.applySettings(sharedSettings);
                profilingSettings.applySettings(sharedSettings);
                sharedSettings.setRemoteHost("");
                NetBeansProfiler.this.printDebugMsg("Profiler.connectToStartedApp: **************************************************", false);
                NetBeansProfiler.this.printDebugMsg("profiling settings -------------------------------", false);
                NetBeansProfiler.this.printDebugMsg(profilingSettings.debug(), false);
                NetBeansProfiler.this.printDebugMsg("session settings ---------------------------------", false);
                NetBeansProfiler.this.printDebugMsg(sessionSettings.debug(), false);
                NetBeansProfiler.this.printDebugMsg("instrumentation filter ---------------------------", false);
                NetBeansProfiler.this.printDebugMsg(sharedSettings.getInstrumentationFilter().debug(), false);
                NetBeansProfiler.this.printDebugMsg("Profiler.connectToStartedApp: **************************************************", false);
                NetBeansProfiler.this.flushDebugMsgs();
                GestureSubmitter.logProfileApp(NetBeansProfiler.this.getProfiledProject(), sessionSettings);
                GestureSubmitter.logConfig(profilingSettings);
                NetBeansProfiler.this.changeStateTo(2);
                NetBeansProfiler.this.cleanupBeforeProfiling(sharedSettings);
                NetBeansProfiler.this.setThreadsMonitoringEnabled(profilingSettings.getThreadsMonitoringEnabled());
                IDEUtils.runInEventDispatchThread(new Runnable(){

                    @Override
                    public void run() {
                        NetBeansProfiler.this.openWindowsOnProfilingStart();
                    }
                });
                if (!CalibrationDataFileIO.validateCalibrationInput((String)sessionSettings.getJavaVersionString(), (String)sessionSettings.getJavaExecutable())) {
                    NetBeansProfiler.this.displayErrorWithDetailsAndWait(CALIBRATION_MISSING_SHORT_MESSAGE, CALIBRATION_MISSING_MESSAGE);
                    NetBeansProfiler.this.changeStateTo(1);
                    methodResult.setValue(Boolean.FALSE);
                    return;
                }
                if (!NetBeansProfiler.this.prepareInstrumentation(profilingSettings)) {
                    methodResult.setValue(Boolean.FALSE);
                    return;
                }
                if (!NetBeansProfiler.this.targetAppRunner.initiateSession(0, false) || !NetBeansProfiler.this.targetAppRunner.connectToStartedVMAndStartTA()) {
                    NetBeansProfiler.this.changeStateTo(1);
                    methodResult.setValue(Boolean.FALSE);
                    return;
                }
                if (NetBeansProfiler.this.targetAppRunner.targetAppIsRunning()) {
                    NetBeansProfiler.this.getThreadsManager().setSupportsSleepingStateMonitoring(Platform.supportsThreadSleepingStateMonitoring((String)sharedSettings.getTargetJDKVersionString()));
                    IDEUtils.runInEventDispatchThread(new Runnable(){

                        @Override
                        public void run() {
                            NetBeansProfiler.this.monitor.monitorVM(NetBeansProfiler.this.targetAppRunner);
                        }
                    });
                    methodResult.setValue(Boolean.TRUE);
                    return;
                }
                NetBeansProfiler.this.changeStateTo(1);
                methodResult.setValue(Boolean.FALSE);
            }

            protected void nonResponding() {
                this.ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"NetBeansProfiler_StartingSession"));
                this.ph.start();
            }

            protected void done() {
                if (this.ph != null) {
                    this.ph.finish();
                    this.ph = null;
                }
            }
        }.execute();
        return methodResult.getValue();
    }

    public void detachFromApp() {
        this.setTransitionState();
        if (this.targetAppRunner.getProfilingSessionStatus().currentInstrType != 0) {
            try {
                this.targetAppRunner.getProfilerClient().removeAllInstrumentation(false);
            }
            catch (InstrumentationException e) {
                this.displayError(e.getMessage());
            }
        }
        this.targetAppRunner.detachFromTargetJVM();
    }

    public void displayError(String message) {
        ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
    }

    public void displayErrorAndWait(String message) {
        ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
    }

    public void displayErrorWithDetailsAndWait(String shortMsg, String detailsMsg) {
        ProfilerDialogs.notify((NotifyDescriptor)new ProfilerDialogs.MessageWithDetails(shortMsg, detailsMsg, 0, false));
    }

    public void displayInfo(String message) {
        ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 1));
    }

    public void displayInfoAndWait(String message) {
        ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 1));
    }

    public void displayInfoWithDetailsAndWait(String shortMsg, String detailsMsg) {
        ProfilerDialogs.notify((NotifyDescriptor)new ProfilerDialogs.MessageWithDetails(shortMsg, detailsMsg, 1, false));
    }

    public void displayWarning(String message) {
        ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 2));
    }

    public void displayWarningAndWait(String message) {
        ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 2));
    }

    public void instrumentSelectedRoots(ClientUtils.SourceCodeSelection[] rootMethods) throws ClassNotFoundException, InstrumentationException, BadLocationException, IOException, ClassFormatError, ClientUtils.TargetAppOrVMTerminated {
        ProfilerClient client = this.targetAppRunner.getProfilerClient();
        if (rootMethods.length == 0) {
            ClientUtils.SourceCodeSelection selection = new ClientUtils.SourceCodeSelection(1);
            rootMethods = new ClientUtils.SourceCodeSelection[]{selection};
        }
        client.initiateRecursiveCPUProfInstrumentation(rootMethods);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AttachSettings loadAttachSettings(Project project) throws IOException {
        FileObject folder = IDEUtils.getProjectSettingsFolder(project, false);
        if (folder == null) {
            return null;
        }
        FileObject attachSettingsFile = folder.getFileObject(ATTACH_SETTINGS_FILENAME, "xml");
        if (attachSettingsFile == null) {
            return null;
        }
        InputStream fis = attachSettingsFile.getInputStream();
        BufferedInputStream bis = new BufferedInputStream(fis);
        try {
            Properties props = new Properties();
            props.loadFromXML(bis);
            AttachSettings as = new AttachSettings();
            as.load((Map)props);
            AttachSettings attachSettings = as;
            return attachSettings;
        }
        finally {
            bis.close();
        }
    }

    public void log(int severity, String message) {
        switch (severity) {
            case 1: {
                severity = 1;
                break;
            }
            case 2: {
                severity = 16;
                break;
            }
            case 8: {
                severity = 4096;
                break;
            }
            case 16: {
                severity = 65536;
                break;
            }
            default: {
                severity = 0;
            }
        }
        if (profilerErrorManager.isLoggable(severity)) {
            profilerErrorManager.log(severity, message);
        }
    }

    public void modifyCurrentProfiling(final ProfilingSettings profilingSettings) {
        this.lastProfilingSettings = profilingSettings;
        if (this.actionSupport.getProperties() != null) {
            this.lastProfilingSettings.store((Map)this.actionSupport.getProperties());
        }
        if (!this.targetAppRunner.targetJVMIsAlive()) {
            return;
        }
        ProfilerEngineSettings sharedSettings = this.targetAppRunner.getProfilerEngineSettings();
        profilingSettings.applySettings(sharedSettings);
        this.printDebugMsg("Profiler.modifyCurrentProfiling: ***************************************************", false);
        this.printDebugMsg("profiling settings --------------------------------", false);
        this.printDebugMsg(profilingSettings.debug(), false);
        this.printDebugMsg("instrumentation filter ----------------------------", false);
        this.printDebugMsg(sharedSettings.getInstrumentationFilter().debug(), false);
        this.printDebugMsg("Profiler.modifyCurrentProfiling: ***************************************************", false);
        this.flushDebugMsgs();
        GestureSubmitter.logConfig(profilingSettings);
        this.setThreadsMonitoringEnabled(profilingSettings.getThreadsMonitoringEnabled());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (LiveResultsWindow.hasDefault()) {
                    LiveResultsWindow.getDefault().handleCleanupBeforeProfiling();
                }
            }
        });
        IDEUtils.runInProfilerRequestProcessor(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block12: {
                    AppStatusHandler.AsyncDialog dialog;
                    NetBeansProfiler.this.changeStateTo(128);
                    NetBeansProfiler.this.targetAppRunner.getAppStatusHandler().pauseLiveUpdates();
                    ProfilingPointsManager.getDefault().reset();
                    ResultsManager.getDefault().reset();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    NetBeansProfiler.this.waitDialog = NetBeansProfiler.this.targetAppRunner.getAppStatusHandler().getAsyncDialogInstance(MODIFYING_INSTRUMENTATION_MSG, true, false);
                    if (NetBeansProfiler.this.waitDialog != null) {
                        dialog = NetBeansProfiler.this.waitDialog;
                        if (EventQueue.isDispatchThread()) {
                            dialog.display();
                        } else {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    dialog.display();
                                }
                            });
                        }
                    }
                    try {
                        NetBeansProfiler.this.prepareInstrumentation(profilingSettings);
                        NetBeansProfiler.this.changeStateTo(4);
                        if (NetBeansProfiler.this.waitDialog == null) break block12;
                        dialog = NetBeansProfiler.this.waitDialog;
                    }
                    catch (Throwable throwable) {
                        if (NetBeansProfiler.this.waitDialog != null) {
                            AppStatusHandler.AsyncDialog dialog2 = NetBeansProfiler.this.waitDialog;
                            if (EventQueue.isDispatchThread()) {
                                dialog2.close();
                            } else {
                                EventQueue.invokeLater(new Runnable(dialog2){
                                    final /* synthetic */ AppStatusHandler.AsyncDialog val$dialog;
                                    {
                                        this.val$dialog = asyncDialog;
                                    }

                                    @Override
                                    public void run() {
                                        this.val$dialog.close();
                                    }
                                });
                            }
                        }
                        NetBeansProfiler.this.targetAppRunner.getAppStatusHandler().resumeLiveUpdates();
                        throw throwable;
                    }
                    if (EventQueue.isDispatchThread()) {
                        dialog.close();
                    } else {
                        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                }
                NetBeansProfiler.this.targetAppRunner.getAppStatusHandler().resumeLiveUpdates();
            }
        });
    }

    public void notifyException(int severity, Exception e) {
        switch (severity) {
            case 1: {
                profilerErrorManager.notify(1, (Throwable)e);
                return;
            }
            case 2: {
                profilerErrorManager.notify(16, (Throwable)e);
                return;
            }
            case 8: {
                profilerErrorManager.notify(4096, (Throwable)e);
                return;
            }
            case 16: {
                profilerErrorManager.notify(65536, (Throwable)e);
                return;
            }
        }
        profilerErrorManager.notify(0, (Throwable)e);
    }

    public void openJavaSource(String className, String methodName, String methodSig) {
        this.openJavaSource(this.getProfiledProject(), className, methodName, methodSig);
    }

    public void openJavaSource(final Project project, final String className, final String methodName, final String methodSig) {
        this.srcOpenerRP.post(new Runnable(){

            @Override
            public void run() {
                GoToSourceHelper.openSource(project, new JavaSourceLocation(className, methodName, methodSig));
            }
        });
    }

    public boolean processesProfilingPoints() {
        return this.processesProfilingPoints;
    }

    public boolean profileClass(final ProfilingSettings profilingSettings, final SessionSettings sessionSettings) {
        this.profilingMode = 1;
        this.lastProfilingSettings = profilingSettings;
        this.lastSessionSettings = sessionSettings;
        this.lastMode = 1;
        if (this.targetAppRunner.targetJVMIsAlive()) {
            this.targetAppRunner.terminateTargetJVM();
        }
        final ProfilerEngineSettings sharedSettings = this.targetAppRunner.getProfilerEngineSettings();
        sessionSettings.applySettings(sharedSettings);
        profilingSettings.applySettings(sharedSettings);
        sharedSettings.setRemoteHost("");
        this.printDebugMsg("Profiler.profileClass: **************************************************", false);
        this.printDebugMsg("Profiler.profileClass: profiling settings -------------------------------", false);
        this.printDebugMsg(profilingSettings.debug(), false);
        this.printDebugMsg("Profiler.profileClass: session settings ---------------------------------", false);
        this.printDebugMsg(sessionSettings.debug(), false);
        this.printDebugMsg("Profiler.profileClass: **************************************************", false);
        this.printDebugMsg("Instrumentation filter:\n" + sharedSettings.getInstrumentationFilter().debug(), false);
        this.flushDebugMsgs();
        Project owningProject = FileOwnerQuery.getOwner((FileObject)this.getProfiledSingleFile());
        GestureSubmitter.logProfileClass(owningProject, sessionSettings);
        GestureSubmitter.logConfig(profilingSettings);
        this.changeStateTo(2);
        this.cleanupBeforeProfiling(sharedSettings);
        this.setThreadsMonitoringEnabled(profilingSettings.getThreadsMonitoringEnabled());
        this.openWindowsOnProfilingStart();
        final Frame mainWindow = WindowManager.getDefault().getMainWindow();
        IDEUtils.runInProfilerRequestProcessor(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Cursor cursor = mainWindow.getCursor();
                mainWindow.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    if (!NetBeansProfiler.this.runCalibration(true, sessionSettings.getJavaExecutable(), sessionSettings.getJavaVersionString(), sessionSettings.getSystemArchitecture())) {
                        NetBeansProfiler.this.displayError(CALIBRATION_FAILED_MESSAGE);
                        NetBeansProfiler.this.changeStateTo(1);
                        return;
                    }
                    boolean success = NetBeansProfiler.this.prepareInstrumentation(profilingSettings);
                    boolean bl = success = success && NetBeansProfiler.this.targetAppRunner.startTargetVM() && NetBeansProfiler.this.targetAppRunner.initiateSession(0, false) && NetBeansProfiler.this.targetAppRunner.connectToStartedVMAndStartTA();
                    if (!success) {
                        NetBeansProfiler.this.changeStateTo(1);
                        return;
                    }
                    if (NetBeansProfiler.this.targetAppRunner.targetAppIsRunning()) {
                        NetBeansProfiler.this.getThreadsManager().setSupportsSleepingStateMonitoring(Platform.supportsThreadSleepingStateMonitoring((String)sharedSettings.getTargetJDKVersionString()));
                        IDEUtils.runInEventDispatchThread(new Runnable(){

                            @Override
                            public void run() {
                                NetBeansProfiler.this.monitor.monitorVM(NetBeansProfiler.this.targetAppRunner);
                            }
                        });
                    } else {
                        NetBeansProfiler.this.changeStateTo(1);
                    }
                }
                finally {
                    mainWindow.setCursor(cursor);
                }
            }
        });
        return true;
    }

    public boolean rerunAvailable() {
        return this.actionSupport.isActionAvailable();
    }

    public boolean modifyAvailable() {
        return this.getProfilingMode() == 0 || this.actionSupport.isActionAvailable();
    }

    public void rerunLastProfiling() {
        if (this.actionSupport.getTarget() != null) {
            NetBeansProfiler.doRunTarget(this.actionSupport.getScript(), this.actionSupport.getTarget(), this.actionSupport.getProperties());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runCalibration(boolean checkForSaved, String jvmExecutable, String jdkString, int architecture) {
        this.calibrating = true;
        ProfilerEngineSettings pes = this.targetAppRunner.getProfilerEngineSettings();
        int savedPort = pes.getPortNo();
        InstrumentationFilter savedInstrFilter = pes.getInstrumentationFilter();
        String savedJVMExeFile = pes.getTargetJVMExeFile();
        String savedJDKVersionString = pes.getTargetJDKVersionString();
        int savedArch = pes.getSystemArchitecture();
        String savedCP = pes.getMainClassPath();
        if (jvmExecutable != null) {
            pes.setTargetJVMExeFile(jvmExecutable);
            pes.setTargetJDKVersionString(jdkString);
            pes.setSystemArchitecture(architecture);
        }
        pes.setPortNo(this.ideSettings.getCalibrationPortNo());
        pes.setInstrumentationFilter(new InstrumentationFilter());
        pes.setMainClassPath("");
        boolean result = false;
        if (checkForSaved) {
            result = this.targetAppRunner.readSavedCalibrationData();
            if (!result) {
                this.displayInfoAndWait(INITIAL_CALIBRATION_MSG);
                result = this.targetAppRunner.calibrateInstrumentationCode();
            }
            boolean shouldCalibrate = false;
            this.targetAppRunner.getProfilingSessionStatus().beginTrans(false);
            try {
                shouldCalibrate = Platform.isLinux() && "jdk16".equals(pes.getTargetJDKVersionString()) && this.targetAppRunner.getProfilingSessionStatus().methodEntryExitCallTime[1] > 20000.0;
            }
            finally {
                this.targetAppRunner.getProfilingSessionStatus().endTrans();
            }
            if (shouldCalibrate) {
                result = this.targetAppRunner.calibrateInstrumentationCode();
            }
        } else {
            result = this.targetAppRunner.calibrateInstrumentationCode();
        }
        this.calibrating = false;
        pes.setPortNo(savedPort);
        pes.setInstrumentationFilter(savedInstrFilter);
        pes.setTargetJDKVersionString(savedJDKVersionString);
        pes.setSystemArchitecture(savedArch);
        pes.setTargetJVMExeFile(savedJVMExeFile);
        pes.setMainClassPath(savedCP);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAttachSettings(Project project, AttachSettings as) {
        FileLock lock = null;
        try {
            FileObject folder = IDEUtils.getProjectSettingsFolder(project, true);
            FileObject fo = folder.getFileObject(ATTACH_SETTINGS_FILENAME, "xml");
            if (fo == null) {
                fo = folder.createData(ATTACH_SETTINGS_FILENAME, "xml");
            }
            lock = fo.lock();
            BufferedOutputStream bos = new BufferedOutputStream(fo.getOutputStream(lock));
            Properties globalProps = new Properties();
            try {
                as.store((Map)globalProps);
                globalProps.storeToXML(bos, "");
            }
            finally {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        catch (Exception e) {
            ProfilerLogger.log((Exception)e);
            ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(ERROR_SAVING_ATTACH_SETTINGS_MESSAGE, e.getMessage()), 0));
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }

    public void setProfiledProject(Project project, FileObject singleFile) {
        this.profiledProject = project;
        this.profiledSingleFile = singleFile;
        ProfilerControlPanel2.getDefault().setProfiledProject(project);
    }

    public Project getProfiledProject() {
        return this.profiledProject;
    }

    public FileObject getProfiledSingleFile() {
        return this.profiledSingleFile;
    }

    public void setSilent(boolean value) {
        this.silent = value;
    }

    public boolean prepareInstrumentation(ProfilingSettings profilingSettings) {
        this.teardownDispatcher();
        this.setupDispatcher(profilingSettings);
        ClientUtils.SourceCodeSelection[] marks = MarkingEngine.getDefault().getMarkerMethods();
        profilingSettings.setInstrumentationMarkerMethods(marks);
        boolean retValue = super.prepareInstrumentation(profilingSettings);
        return retValue;
    }

    public void runTarget(FileObject buildScriptFO, String target, Properties props) {
        this.actionSupport.setAll(buildScriptFO, target, props);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((RerunAction)RerunAction.get(RerunAction.class)).updateAction();
            }
        });
        NetBeansProfiler.doRunTarget(buildScriptFO, target, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveGlobalFilters() {
        BufferedOutputStream bos;
        OutputStream os;
        FileObject fo;
        FileObject folder;
        FileLock lock = null;
        try {
            folder = IDEUtils.getSettingsFolder(true);
            fo = folder.getFileObject(GLOBAL_FILTERS_FILENAME, "xml");
            if (fo == null) {
                fo = folder.createData(GLOBAL_FILTERS_FILENAME, "xml");
            }
            lock = fo.lock();
            os = fo.getOutputStream(lock);
            bos = new BufferedOutputStream(os);
            Properties globalFiltersProps = new Properties();
            this.globalFilters.store((Map)globalFiltersProps);
            globalFiltersProps.storeToXML(bos, "");
            bos.close();
        }
        catch (Exception e) {
            ProfilerLogger.log((Exception)e);
            ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(ERROR_SAVING_PROFILING_SETTINGS_MESSAGE, e.getMessage()), 0));
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
        }
        lock = null;
        try {
            folder = IDEUtils.getSettingsFolder(true);
            fo = folder.getFileObject(DEFINED_FILTERSETS_FILENAME, "xml");
            if (fo == null) {
                fo = folder.createData(DEFINED_FILTERSETS_FILENAME, "xml");
            }
            lock = fo.lock();
            os = fo.getOutputStream(lock);
            bos = new BufferedOutputStream(os);
            Properties definedFilterSetsProps = new Properties();
            this.definedFilterSets.store((Map)definedFilterSetsProps);
            definedFilterSetsProps.storeToXML(bos, "");
            bos.close();
        }
        catch (Exception e) {
            ProfilerLogger.log((Exception)e);
            ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(ERROR_SAVING_FILTER_SETS_MESSAGE, e.getMessage()), 0));
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }

    public void shutdown() {
        this.monitor.stopUpdateThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdownBlockedAgent(String host, int port, int agentId) {
        int state = this.getAgentState(host, port, agentId);
        if (state == 2) {
            Socket clientSocket = null;
            ObjectOutputStream socketOut = null;
            ObjectInputStream socketIn = null;
            try {
                clientSocket = new Socket(host, port);
                clientSocket.setSoTimeout(100);
                clientSocket.setTcpNoDelay(true);
                socketOut = new ObjectOutputStream(clientSocket.getOutputStream());
                socketIn = new ObjectInputStream(clientSocket.getInputStream());
                WireIO wio = new WireIO(socketOut, socketIn);
                wio.sendSimpleCommand(12);
                Object o = wio.receiveCommandOrResponse();
                if (o instanceof Response && ((Response)o).isOK()) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (socketIn != null) {
                        socketIn.close();
                    }
                    if (socketOut != null) {
                        socketOut.close();
                    }
                    if (clientSocket != null) {
                        clientSocket.close();
                    }
                }
                catch (IOException e) {
                    ProfilerLogger.log((Exception)e);
                }
            }
        }
        return false;
    }

    public void stopApp() {
        this.setTransitionState();
        this.getTargetAppRunner().terminateTargetJVM();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getAgentProperties(int port) {
        File f = NetBeansProfiler.getInfoFile(port);
        if (!f.exists()) {
            return null;
        }
        BufferedInputStream bis = null;
        try {
            Properties props = new Properties();
            FileInputStream fis = new FileInputStream(f);
            bis = new BufferedInputStream(fis);
            props.load(bis);
            bis.close();
            Properties properties = props;
            return properties;
        }
        catch (IOException e) {
            Properties properties = null;
            return properties;
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static File getInfoFile(int port) {
        String homeDir = System.getProperty("user.home");
        return new File(homeDir + File.separator + ".nbprofiler" + File.separator + port);
    }

    private boolean isProfilingRunningOnPort(int port) {
        return this.profilingState == 4 && port == this.targetAppRunner.getProfilerEngineSettings().getPortNo();
    }

    private void setTransitionState() {
        this.changeStateTo(128);
    }

    private void changeStateTo(int newState) {
        if (this.profilingState == newState) {
            return;
        }
        int oldProfilingState = this.profilingState;
        this.profilingState = newState;
        this.fireProfilingStateChange(oldProfilingState, this.profilingState);
        if (newState == 1 || newState == 16) {
            this.cleanupAfterProfiling();
        }
    }

    private void cleanupAfterProfiling() {
        this.stopLoadGenerator();
        this.teardownDispatcher();
        MarkingEngine.getDefault().deconfigure();
        ClassRepository.cleanup();
    }

    private void cleanupBeforeProfiling(ProfilerEngineSettings sharedSettings) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NetBeansProfiler.this.getThreadsManager().reset();
                NetBeansProfiler.this.getVMTelemetryManager().reset();
                if (LiveResultsWindow.hasDefault()) {
                    LiveResultsWindow.getDefault().handleCleanupBeforeProfiling();
                }
            }
        });
        ProfilingPointsManager.getDefault().reset();
        ResultsManager.getDefault().reset();
        ClassRepository.clearCache();
        ClassRepository.initClassPaths((String)sharedSettings.getWorkingDir(), (String[])sharedSettings.getVMClassPaths());
    }

    private void closeWaitDialog() {
        if (this.waitDialogOpen) {
            this.waitDialog.close();
            this.waitDialogOpen = false;
        }
    }

    private void displayWaitDialog() {
        this.waitDialogOpen = true;
        this.waitDialog.display();
    }

    private void displayWarningAboutEntireAppProfiling() {
        this.displayWarning(ENTIRE_APPLICATION_PROFILING_WARNING);
    }

    private void flushDebugMsgs() {
        String msg = this.logMsgs.toString();
        if (LOGGER.isLoggable(Level.CONFIG) && !this.silent) {
            LOGGER.config(msg);
        } else {
            profilerErrorManager.log(msg);
        }
    }

    private void loadGlobalFilters() {
        try {
            FileObject folder = IDEUtils.getSettingsFolder(false);
            FileObject configFolder = FileUtil.getConfigFile((String)"NBProfiler/Config");
            FileObject filtersFO = null;
            if (folder != null && folder.isValid()) {
                filtersFO = folder.getFileObject(GLOBAL_FILTERS_FILENAME, "xml");
            }
            if (filtersFO == null && configFolder != null && configFolder.isValid()) {
                filtersFO = configFolder.getFileObject("filters-default", "xml");
            }
            if (filtersFO != null) {
                InputStream fis = filtersFO.getInputStream();
                BufferedInputStream bis = new BufferedInputStream(fis);
                Properties globalFiltersProps = new Properties();
                globalFiltersProps.loadFromXML(bis);
                this.globalFilters = new GlobalFilters();
                this.globalFilters.load((Map)globalFiltersProps);
                bis.close();
            }
            FileObject filterSetsFO = null;
            if (folder != null && folder.isValid()) {
                filterSetsFO = folder.getFileObject(DEFINED_FILTERSETS_FILENAME, "xml");
            }
            if (filterSetsFO == null && configFolder != null && configFolder.isValid()) {
                filterSetsFO = configFolder.getFileObject("filtersets-default", "xml");
            }
            if (filterSetsFO != null) {
                InputStream fis = filterSetsFO.getInputStream();
                BufferedInputStream bis = new BufferedInputStream(fis);
                Properties definedFilterSetsProps = new Properties();
                definedFilterSetsProps.loadFromXML(bis);
                this.definedFilterSets = new DefinedFilterSets();
                this.definedFilterSets.load((Map)definedFilterSetsProps);
                bis.close();
            }
        }
        catch (Exception e) {
            ProfilerLogger.log((Exception)e);
            ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(ERROR_LOADING_PROFILING_SETTINGS_MESSAGE, e.getMessage()), 0));
        }
    }

    private void openWindowsOnProfilingStart() {
        int telemetryBehavior = this.ideSettings.getTelemetryOverviewBehavior();
        int threadsBehavior = this.ideSettings.getThreadsViewBehavior();
        boolean threadsEnabled = this.lastProfilingSettings.getThreadsMonitoringEnabled();
        int type = this.lastProfilingSettings.getProfilingType();
        if (telemetryBehavior == 1 || telemetryBehavior == 2 && type == 1) {
            TelemetryOverviewPanel.getDefault().open();
            TelemetryOverviewPanel.getDefault().requestVisible();
        }
        if (threadsEnabled && (threadsBehavior == 1 || threadsBehavior == 2 && type == 1)) {
            ThreadsWindow.getDefault().open();
            ThreadsWindow.getDefault().requestVisible();
        }
        if (this.ideSettings.getDisplayLiveResultsCPU() && (type == 8 || type == 16) || this.ideSettings.getDisplayLiveResultsFragment() && type == 32 || this.ideSettings.getDisplayLiveResultsMemory() && (type == 2 || type == 4)) {
            LiveResultsWindow.getDefault().open();
            LiveResultsWindow.getDefault().requestVisible();
        }
        ProfilerControlPanel2 controlPanel2 = ProfilerControlPanel2.getDefault();
        controlPanel2.open();
        controlPanel2.requestActive();
    }

    private void printDebugMsg(String msg) {
        this.printDebugMsg(msg, true);
    }

    private void printDebugMsg(String msg, boolean flush) {
        this.logMsgs.append(msg).append('\n');
        if (flush) {
            this.flushDebugMsgs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupDispatcher(ProfilingSettings profilingSettings) {
        Object object = this.setupLock;
        synchronized (object) {
            RuntimeProfilingPoint[] points;
            Collection pmodules;
            Project project = this.getProfiledProject();
            CCTProvider cctProvider = null;
            Collection cctListeners = null;
            switch (profilingSettings.getProfilingType()) {
                case 8: 
                case 16: 
                case 32: {
                    cctProvider = (CCTProvider)Lookup.getDefault().lookup(CPUCCTProvider.class);
                    cctListeners = Lookup.getDefault().lookupAll(CPUCCTProvider.Listener.class);
                    break;
                }
                case 2: 
                case 4: {
                    cctProvider = (CCTProvider)Lookup.getDefault().lookup(MemoryCCTProvider.class);
                    cctListeners = Lookup.getDefault().lookupAll(MemoryCCTProvider.Listener.class);
                }
            }
            if (cctProvider != null && cctListeners != null && cctListeners.size() > 0) {
                for (CCTProvider.Listener cctListener : cctListeners) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Adding listener " + cctListener.getClass().getName() + " to the provider " + cctProvider.getClass().getName());
                    }
                    cctProvider.addListener(cctListener);
                }
            } else if (LOGGER.isLoggable(Level.WARNING)) {
                if (cctProvider == null) {
                    LOGGER.warning("Could not find a CCT provider in lookup!");
                } else if (cctListeners == null || cctListeners.size() == 0) {
                    LOGGER.warning("Could not find listeners in lookup!");
                }
            }
            StatisticalModuleContainer statModulesContainer = (StatisticalModuleContainer)Lookup.getDefault().lookup(StatisticalModuleContainer.class);
            Collection modules = Lookup.getDefault().lookupAll(StatisticalModule.class);
            if (statModulesContainer != null && modules != null) {
                for (StatisticalModule module : modules) {
                    if (module instanceof ProjectAwareStatisticalModule) {
                        if (!((ProjectAwareStatisticalModule)module).supportsProject(project)) continue;
                        statModulesContainer.addModule(module);
                        continue;
                    }
                    statModulesContainer.addModule(module);
                }
            }
            if ((pmodules = Lookup.getDefault().lookupAll(ProjectAwareStatisticalModule.class)) != null) {
                for (ProjectAwareStatisticalModule module : pmodules) {
                    if (!module.supportsProject(project)) continue;
                    statModulesContainer.addModule((StatisticalModule)module);
                }
            }
            ProfilerClient client = this.getTargetAppRunner().getProfilerClient();
            CCTResultsFilter filter = (CCTResultsFilter)Lookup.getDefault().lookup(CCTResultsFilter.class);
            if (filter != null) {
                filter.reset();
                filter.setEvaluators(Lookup.getDefault().lookupAll(CCTResultsFilter.EvaluatorProvider.class));
            }
            FlatProfileBuilder fpb = (FlatProfileBuilder)Lookup.getDefault().lookup(FlatProfileBuilder.class);
            TimeCollector tc = (TimeCollector)Lookup.getDefault().lookup(TimeCollector.class);
            fpb.setContext(client, tc, filter);
            Collection listeners = null;
            if (profilingSettings.getProfilingType() == 16 || profilingSettings.getProfilingType() == 8) {
                listeners = Lookup.getDefault().lookupAll(CPUProfilingResultListener.class);
                for (CPUProfilingResultListener listener : listeners) {
                    ProfilingResultsDispatcher.getDefault().addListener(listener);
                    listener.startup(this.targetAppRunner.getProfilerClient());
                }
            } else if (profilingSettings.getProfilingType() == 2 || profilingSettings.getProfilingType() == 4) {
                listeners = Lookup.getDefault().lookupAll(MemoryProfilingResultsListener.class);
                for (MemoryProfilingResultsListener listener : listeners) {
                    ProfilingResultsDispatcher.getDefault().addListener(listener);
                    listener.startup(this.targetAppRunner.getProfilerClient());
                }
            }
            if (profilingSettings.useProfilingPoints() && this.getProfiledProject() != null) {
                points = ProfilingPointsManager.getDefault().createCodeProfilingConfiguration(this.getProfiledProject(), profilingSettings);
                this.processesProfilingPoints = points.length > 0;
                this.targetAppRunner.getProfilerEngineSettings().setRuntimeProfilingPoints(points);
            } else {
                points = new RuntimeProfilingPoint[]{};
                this.processesProfilingPoints = false;
                this.targetAppRunner.getProfilerEngineSettings().setRuntimeProfilingPoints(points);
            }
            if (this.processesProfilingPoints) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!ProfilingPointsWindow.getDefault().isOpened()) {
                            ProfilingPointsWindow.getDefault().open();
                            ProfilingPointsWindow.getDefault().requestVisible();
                        }
                    }
                });
            }
            ProfilingResultsDispatcher.getDefault().startup(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shutdownAgent(String host, int port) {
        Socket clientSocket = null;
        ObjectOutputStream socketOut = null;
        ObjectInputStream socketIn = null;
        try {
            clientSocket = new Socket(host, port);
            clientSocket.setSoTimeout(100);
            clientSocket.setTcpNoDelay(true);
            socketOut = new ObjectOutputStream(clientSocket.getOutputStream());
            socketIn = new ObjectInputStream(clientSocket.getInputStream());
            WireIO wio = new WireIO(socketOut, socketIn);
            wio.sendSimpleCommand(12);
            try {
                Object o = wio.receiveCommandOrResponse();
            }
            catch (Exception e) {
                // empty catch block
            }
            ProfilerLogger.warning((String)(">>> An existing Profiler agent listening on port " + port + " was terminated to allow starting new profiling session on the same port."));
            boolean bl = true;
            return bl;
        }
        catch (SocketTimeoutException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                if (socketIn != null) {
                    socketIn.close();
                }
                if (socketOut != null) {
                    socketOut.close();
                }
                if (clientSocket != null) {
                    clientSocket.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private void stopLoadGenerator() {
        String scriptPath;
        LoadGenPlugin plugin;
        Properties profilingProperties = NetBeansProfiler.getDefaultNB().getCurrentProfilingProperties();
        if (profilingProperties != null && (plugin = (LoadGenPlugin)Lookup.getDefault().lookup(LoadGenPlugin.class)) != null && (scriptPath = profilingProperties.getProperty("profiler.loadgen.path")) != null) {
            plugin.stop(scriptPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void teardownDispatcher() {
        Object object = this.setupLock;
        synchronized (object) {
            ProfilingResultsDispatcher.getDefault().shutdown();
            StatisticalModuleContainer statModulesContainer = (StatisticalModuleContainer)Lookup.getDefault().lookup(StatisticalModuleContainer.class);
            if (statModulesContainer != null) {
                statModulesContainer.removeAllModules();
            }
            ProfilerClient client = this.getTargetAppRunner().getProfilerClient();
            client.registerFlatProfileProvider(null);
        }
    }

    private boolean waitForDeleteAgentFile(File agentFile) {
        if (agentFile.delete()) {
            return true;
        }
        for (int i = 0; i < 5; ++i) {
            if (agentFile.delete()) {
                return true;
            }
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    public static ExecutorTask doRunTarget(FileObject buildScript, String target, Properties props) {
        try {
            String oomeenabled = props.getProperty("profiler.info.oomeprotection");
            if (oomeenabled != null && oomeenabled.equals("yes")) {
                HeapDumpWatch.getDefault().monitor(props.getProperty("profiler.info.oomeprotection.dumppath"));
            }
            return ActionUtils.runTarget((FileObject)buildScript, (String[])new String[]{target}, (Properties)props);
        }
        catch (IOException e) {
            Profiler.getDefault().notifyException(8, (Exception)e);
            return null;
        }
    }

    static {
        if (LOGGER.getLevel() == null || LOGGER.getLevel().intValue() > Level.CONFIG.intValue()) {
            LOGGER.setLevel(Level.CONFIG);
        }
        CALIBRATION_FAILED_MESSAGE = NbBundle.getMessage(ProfilerModule.class, (String)"ProfilerModule_CalibrationFailedMessage");
        CALIBRATION_MISSING_MESSAGE = NbBundle.getMessage(ProfilerModule.class, (String)"NetBeansProfiler_MustCalibrateFirstMsg");
        CALIBRATION_MISSING_SHORT_MESSAGE = NbBundle.getMessage(ProfilerModule.class, (String)"NetBeansProfiler_MustCalibrateFirstShortMsg");
        PROGRESS_DIALOG_CAPTION = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_ProgressDialogCaption");
        ENTIRE_APPLICATION_PROFILING_WARNING = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_EntireApplicationProfilingWarning");
        DIRECTORY_DOES_NOT_EXIST_MESSAGE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_DirectoryDoesNotExistMessage");
        DIRECTORY_IS_WRITE_PROTECTED_MESSAGE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_DirectoryIsWriteProtectedMessage");
        ERROR_LOADING_PROFILING_SETTINGS_MESSAGE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_ErrorLoadingProfilingSettingsMessage");
        ERROR_SAVING_PROFILING_SETTINGS_MESSAGE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_ErrorSavingProfilingSettingsMessage");
        ERROR_SAVING_FILTER_SETS_MESSAGE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_ErrorSavingFilterSetsMessage");
        ERROR_SAVING_ATTACH_SETTINGS_MESSAGE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_ErrorSavingAttachSettingsMessage");
        CANNOT_FIND_LIBS_MSG = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_CannotFindLibsMsg");
        ENGINE_INIT_FAILED_MSG = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_EngineInitFailedMsg");
        INITIAL_CALIBRATION_MSG = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_InitialCalibrationMsg");
        TERMINATE_VM_ON_EXIT_MSG = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_TerminateVMOnExitMsg");
        TAKE_SNAPSHOT_ON_EXIT_MSG = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_TakeSnapshotOnExitMsg");
        TAKE_SNAPSHOT_ON_EXIT_DIALOG_TITLE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_TakeSnapshotOnExitDialogTitle");
        TARGET_APP_NOT_RESPONDING_MSG = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_TargetAppNotRespondingMsg");
        TARGET_APP_NOT_RESPONDING_DIALOG_TITLE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_TargetAppNotRespondingDialogTitle");
        MODIFYING_INSTRUMENTATION_MSG = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_ModifyingInstrumentationMsg");
        profilerErrorManager = ErrorManager.getDefault().getInstance("org.netbeans.modules.profiler");
        initialized = false;
    }

    private final class IDEAppStatusHandler
    implements AppStatusHandler {
        private IDEAppStatusHandler() {
        }

        public AppStatusHandler.AsyncDialog getAsyncDialogInstance(String message, boolean showProgress, boolean cancelAllowed) {
            return new ProgressPanel(message, showProgress, cancelAllowed);
        }

        public boolean confirmWaitForConnectionReply() {
            NotifyDescriptor.Confirmation con = new NotifyDescriptor.Confirmation((Object)TARGET_APP_NOT_RESPONDING_MSG, TARGET_APP_NOT_RESPONDING_DIALOG_TITLE, 0, 2);
            return ProfilerDialogs.notify((NotifyDescriptor)con) != ProfilerDialogs.DNSAConfirmation.YES_OPTION;
        }

        public void displayError(String msg) {
            NetBeansProfiler.this.printDebugMsg("IDEAppStatusHandler - error: " + msg);
            NetBeansProfiler.this.displayError(msg);
        }

        public void displayErrorAndWaitForConfirm(String msg) {
            NetBeansProfiler.this.printDebugMsg("IDEAppStatusHandler - errorAndWaitForConfirm: " + msg);
            NetBeansProfiler.this.displayErrorAndWait(msg);
        }

        public void displayErrorWithDetailsAndWaitForConfirm(String shortMsg, String detailsMsg) {
            NetBeansProfiler.this.displayErrorWithDetailsAndWait(shortMsg, detailsMsg);
        }

        public void displayNotification(String msg) {
            StatusDisplayer.getDefault().setStatusText(msg);
        }

        public void displayNotificationAndWaitForConfirm(String msg) {
            NetBeansProfiler.this.displayInfoAndWait(msg);
        }

        public void displayNotificationWithDetailsAndWaitForConfirm(String shortMsg, String detailsMsg) {
            NetBeansProfiler.this.displayInfoWithDetailsAndWait(shortMsg, detailsMsg);
        }

        public void displayWarning(String msg) {
            NetBeansProfiler.this.printDebugMsg("IDEAppStatusHandler - warning: " + msg);
            NetBeansProfiler.this.displayWarning(msg);
        }

        public void displayWarningAndWaitForConfirm(String msg) {
            NetBeansProfiler.this.printDebugMsg("IDEAppStatusHandler - warningAndWaitForConfirm: " + msg);
            NetBeansProfiler.this.displayWarningAndWait(msg);
        }

        public void handleShutdown() {
            if (LiveResultsWindow.hasDefault()) {
                LiveResultsWindow.getDefault().handleShutdown();
            }
            if (NetBeansProfiler.this.getTargetAppRunner().getProfilerClient().getCurrentInstrType() == 0 || !ResultsManager.getDefault().resultsAvailable()) {
                ProfilerDialogs.DNSAMessage dnsa = new ProfilerDialogs.DNSAMessage("NetBeansProfiler.handleShutdown.noResults", TERMINATE_VM_ON_EXIT_MSG, 1);
                dnsa.setDNSADefault(false);
                ProfilerDialogs.notify((NotifyDescriptor)dnsa);
            } else {
                ProfilerDialogs.DNSAConfirmation dnsa = new ProfilerDialogs.DNSAConfirmation("NetBeansProfiler.handleShutdown", (Object)TAKE_SNAPSHOT_ON_EXIT_MSG, TAKE_SNAPSHOT_ON_EXIT_DIALOG_TITLE, 0);
                dnsa.setDNSADefault(false);
                if (ProfilerDialogs.notify((NotifyDescriptor)dnsa).equals(ProfilerDialogs.DNSAConfirmation.YES_OPTION)) {
                    ResultsManager.getDefault().takeSnapshot();
                }
            }
        }

        public void pauseLiveUpdates() {
            LiveResultsWindow.setPaused(true);
        }

        public void resultsAvailable() {
            ResultsManager.getDefault().resultsBecameAvailable();
        }

        public void resumeLiveUpdates() {
            LiveResultsWindow.setPaused(false);
        }

        public void takeSnapshot() {
            IDEUtils.runInProfilerRequestProcessor(new Runnable(){

                @Override
                public void run() {
                    ResultsManager.getDefault().takeSnapshot();
                }
            });
        }
    }

    public static final class ProgressPanel
    implements AppStatusHandler.AsyncDialog {
        private static final int DEFAULT_WIDTH = 350;
        private static final int DEFAULT_HEIGHT = 100;
        private static final RequestProcessor commandQueue = new RequestProcessor("Async dialog command queue", 1);
        private Dialog dialog;
        private final Object dialogStateLock = new Object();
        private final Object dialogInitLock = new Object();
        private DialogState dialogState = DialogState.NOT_OPENED;
        private String message;
        private boolean cancelAllowed;
        private boolean cancelled = false;
        private boolean instantiated;
        private boolean showProgress;

        ProgressPanel(String message, boolean showProgress, boolean cancelAllowed) {
            this.message = message;
            this.showProgress = showProgress;
            this.cancelAllowed = cancelAllowed;
            this.dialogState = DialogState.NOT_OPENED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDisplayed() {
            Object object = this.dialogStateLock;
            synchronized (object) {
                return this.dialogState == DialogState.OPEN;
            }
        }

        public boolean cancelPressed() {
            return this.cancelled;
        }

        public synchronized void close() {
            commandQueue.post(new Runnable(){

                @Override
                public void run() {
                    ProgressPanel.this.dialogClose();
                }
            });
        }

        public synchronized void display() {
            commandQueue.post(new Runnable(){

                @Override
                public void run() {
                    ProgressPanel.this.instantiate();
                    ProgressPanel.this.dialogShow();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dialogClose() {
            Object object = this.dialogStateLock;
            synchronized (object) {
                if (this.dialogState == DialogState.OPEN) {
                    LOGGER.finest("Closing async dialog");
                    if (this.dialog.isShowing()) {
                        ProfilerDialogs.close(this.dialog);
                    }
                    this.dialogState = DialogState.CLOSED;
                } else if (this.dialogState == DialogState.NOT_OPENED) {
                    LOGGER.fine("Attempting to close async dialog without opening it first");
                    this.dialogState = DialogState.NOT_OPENED_CLOSED;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dialogShow() {
            Object object = this.dialogStateLock;
            synchronized (object) {
                if (this.dialogState == DialogState.NOT_OPENED || this.dialogState == DialogState.CLOSED) {
                    LOGGER.finest("Showing async dialog");
                    Level lvl = LOGGER.getLevel();
                    ProfilerDialogs.display(this.dialog);
                    this.dialogState = DialogState.OPEN;
                } else if (this.dialogState == DialogState.NOT_OPENED_CLOSED) {
                    LOGGER.fine("Async dialog has been closed before being opened. Setting to CLOSED");
                    this.dialogState = DialogState.CLOSED;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void instantiate() {
            Object object = this.dialogInitLock;
            synchronized (object) {
                Object[] objectArray;
                if (this.instantiated) {
                    return;
                }
                JPanel panel = new JPanel();
                panel.setLayout(new BorderLayout(10, 10));
                panel.setBorder(new EmptyBorder(15, 15, 15, 15));
                panel.add((Component)new JLabel(this.message), "North");
                Dimension ps = panel.getPreferredSize();
                ps.setSize(Math.max(ps.getWidth(), 350.0), Math.max(ps.getHeight(), this.showProgress ? 100.0 : ps.getHeight()));
                panel.setPreferredSize(ps);
                if (this.showProgress) {
                    JProgressBar progress = new JProgressBar();
                    progress.setIndeterminate(true);
                    panel.add((Component)progress, "South");
                }
                String string = PROGRESS_DIALOG_CAPTION;
                if (this.cancelAllowed) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = DialogDescriptor.CANCEL_OPTION;
                } else {
                    objectArray = new Object[]{};
                }
                this.dialog = ProfilerDialogs.createDialog(new DialogDescriptor((Object)panel, string, true, objectArray, DialogDescriptor.CANCEL_OPTION, 1, null, new ActionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ProgressPanel.this.cancelled = true;
                        Object object = ProgressPanel.this.dialogStateLock;
                        synchronized (object) {
                            assert (ProgressPanel.this.dialogState == DialogState.OPEN);
                            LOGGER.finest("Closing async dialog (cancel)");
                            ProgressPanel.this.dialogState = DialogState.CLOSED;
                        }
                    }
                }));
                this.instantiated = true;
            }
        }

        private static enum DialogState {
            CLOSED,
            NOT_OPENED,
            NOT_OPENED_CLOSED,
            OPEN;

        }
    }
}

