/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.io.File;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.HeapSummary;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.JavaFrameGCRoot;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;
import org.netbeans.lib.profiler.heap.ThreadObjectGCRoot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.heapwalk.AbstractController;
import org.netbeans.modules.profiler.heapwalk.AnalysisController;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.SummaryController;
import org.netbeans.modules.profiler.heapwalk.ui.OverviewControllerUI;
import org.netbeans.modules.profiler.utils.GoToSourceHelper;
import org.netbeans.modules.profiler.utils.JavaSourceLocation;
import org.openide.util.NbBundle;
import sun.misc.VM;

public class OverviewController
extends AbstractController {
    public static final String SHOW_SYSPROPS_URL = "file:/sysprops";
    public static final String SHOW_THREADS_URL = "file:/threads";
    private static final String OPEN_THREADS_URL = "file:/stackframe/";
    private static final String CLASS_URL_PREFIX = "file://class/";
    private static final String INSTANCE_URL_PREFIX = "file://instance/";
    private static final String THREAD_URL_PREFIX = "file://thread/";
    private static final String NOT_AVAILABLE_MSG = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_NotAvailableMsg");
    private static final String SYSTEM_PROPERTIES_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_SystemPropertiesString");
    private static final String SUMMARY_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_SummaryString");
    private static final String ENVIRONMENT_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_EnvironmentString");
    private static final String FILE_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_FileItemString");
    private static final String FILE_SIZE_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_FileSizeItemString");
    private static final String DATE_TAKEN_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_DateTakenItemString");
    private static final String TOTAL_BYTES_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_TotalBytesItemString");
    private static final String TOTAL_CLASSES_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_TotalClassesItemString");
    private static final String TOTAL_INSTANCES_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_TotalInstancesItemString");
    private static final String CLASSLOADERS_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_ClassloadersItemString");
    private static final String GCROOTS_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_GcRootsItemString");
    private static final String FINALIZERS_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_FinalizersItemString");
    private static final String OOME_LABEL_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_OOMELabelString");
    private static final String OOME_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_OOMEItemString");
    private static final String OS_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_OsItemString");
    private static final String ARCHITECTURE_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_ArchitectureItemString");
    private static final String JAVA_HOME_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_JavaHomeItemString");
    private static final String JAVA_VERSION_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_JavaVersionItemString");
    private static final String JAVA_VENDOR_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_JavaVendorItemString");
    private static final String JVM_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_JvmItemString");
    private static final String SHOW_SYSPROPS_LINK_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_ShowSysPropsLinkString");
    private static final String THREADS_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_ThreadsString");
    private static final String SHOW_THREADS_LINK_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_ShowThreadsLinkString");
    private static final String CANNOT_RESOLVE_CLASS_MSG = NbBundle.getMessage(AnalysisController.class, (String)"AnalysisController_CannotResolveClassMsg");
    private static final String CANNOT_RESOLVE_INSTANCE_MSG = NbBundle.getMessage(AnalysisController.class, (String)"AnalysisController_CannotResolveInstanceMsg");
    private HeapFragmentWalker heapFragmentWalker;
    private SummaryController summaryController;
    private boolean systemPropertiesComputed = false;
    private Properties systemProperties;
    private String stackTrace;
    private JavaClass java_lang_Class;
    private ThreadObjectGCRoot oome;

    public OverviewController(SummaryController summaryController) {
        this.summaryController = summaryController;
        this.heapFragmentWalker = summaryController.getHeapFragmentWalker();
    }

    public SummaryController getSummaryController() {
        return this.summaryController;
    }

    @Override
    protected AbstractButton createControllerPresenter() {
        return ((OverviewControllerUI)((Object)this.getPanel())).getPresenter();
    }

    @Override
    protected JPanel createControllerUI() {
        return new OverviewControllerUI(this);
    }

    void showInThreads(Instance instance) {
        ((OverviewControllerUI)((Object)this.getPanel())).showInThreads(instance);
    }

    public String computeSummary() {
        File file = this.heapFragmentWalker.getHeapDumpFile();
        Heap heap = this.heapFragmentWalker.getHeapFragment();
        HeapSummary hsummary = heap.getSummary();
        long finalizers = this.computeFinalizers(heap);
        int nclassloaders = 0;
        JavaClass cl = heap.getJavaClassByName("java.lang.ClassLoader");
        NumberFormat numberFormat = (NumberFormat)NumberFormat.getInstance().clone();
        numberFormat.setMaximumFractionDigits(1);
        this.oome = this.getOOMEThread(heap);
        if (cl != null) {
            nclassloaders = cl.getInstancesCount();
            Collection jcs = cl.getSubClasses();
            for (JavaClass jc : jcs) {
                nclassloaders += jc.getInstancesCount();
            }
        }
        String filename = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(FILE_ITEM_STRING, file != null && file.exists() ? file.getAbsolutePath() : NOT_AVAILABLE_MSG);
        String filesize = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(FILE_SIZE_ITEM_STRING, file != null && file.exists() ? numberFormat.format((double)file.length() / 1048576.0) + " MB" : NOT_AVAILABLE_MSG);
        String dateTaken = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(DATE_TAKEN_ITEM_STRING, new Date(hsummary.getTime()).toString());
        String liveBytes = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(TOTAL_BYTES_ITEM_STRING, numberFormat.format(hsummary.getTotalLiveBytes()));
        String liveClasses = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(TOTAL_CLASSES_ITEM_STRING, numberFormat.format(heap.getAllClasses().size()));
        String liveInstances = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(TOTAL_INSTANCES_ITEM_STRING, numberFormat.format(hsummary.getTotalLiveInstances()));
        String classloaders = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(CLASSLOADERS_ITEM_STRING, numberFormat.format(nclassloaders));
        String gcroots = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(GCROOTS_ITEM_STRING, numberFormat.format(heap.getGCRoots().size()));
        String finalizersInfo = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(FINALIZERS_ITEM_STRING, numberFormat.format(finalizers));
        String oomeString = "";
        if (this.oome != null) {
            Instance thread = this.oome.getInstance();
            String threadName = OverviewController.htmlize(this.getThreadName(thread));
            String threadUrl = "<a href='file://thread/" + thread.getJavaClass().getName() + "/" + thread.getInstanceId() + "'>" + threadName + "</a>";
            oomeString = "<br><br>&nbsp;&nbsp;&nbsp;&nbsp;" + OOME_LABEL_STRING + "<br>&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(OOME_ITEM_STRING, threadUrl);
        }
        return "<b><img border='0' align='bottom' src='nbresloc:/org/netbeans/modules/profiler/resources/memory.png'>&nbsp;&nbsp;" + SUMMARY_STRING + "</b><br><hr>" + dateTaken + "<br>" + filename + "<br>" + filesize + "<br><br>" + liveBytes + "<br>" + liveClasses + "<br>" + liveInstances + "<br>" + classloaders + "<br>" + gcroots + "<br>" + finalizersInfo + oomeString;
    }

    public String computeEnvironment() {
        Properties sysprops = this.getSystemProperties();
        if (sysprops == null) {
            return NOT_AVAILABLE_MSG;
        }
        String patchLevel = sysprops.getProperty("sun.os.patch.level", "");
        String os = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(OS_ITEM_STRING, sysprops.getProperty("os.name", NOT_AVAILABLE_MSG), sysprops.getProperty("os.version", ""), "unknown".equals(patchLevel) ? "" : patchLevel);
        String arch = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(ARCHITECTURE_ITEM_STRING, sysprops.getProperty("os.arch", NOT_AVAILABLE_MSG), sysprops.getProperty("sun.arch.data.model", "?") + "bit");
        String jdk = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(JAVA_HOME_ITEM_STRING, sysprops.getProperty("java.home", NOT_AVAILABLE_MSG));
        String version = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(JAVA_VERSION_ITEM_STRING, sysprops.getProperty("java.version", NOT_AVAILABLE_MSG));
        String jvm = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(JVM_ITEM_STRING, sysprops.getProperty("java.vm.name", NOT_AVAILABLE_MSG), sysprops.getProperty("java.vm.version", ""), sysprops.getProperty("java.vm.info", ""));
        String vendor = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(JAVA_VENDOR_ITEM_STRING, sysprops.getProperty("java.vendor", NOT_AVAILABLE_MSG));
        return "<b><img border='0' align='bottom' src='nbresloc:/org/netbeans/modules/profiler/heapwalk/ui/resources/sysinfo.png'>&nbsp;&nbsp;" + ENVIRONMENT_STRING + "</b><br><hr>" + os + "<br>" + arch + "<br>" + jdk + "<br>" + version + "<br>" + jvm + "<br>" + vendor;
    }

    public String computeSystemProperties(boolean showSystemProperties) {
        Properties sysprops = this.getSystemProperties();
        if (sysprops == null) {
            return NOT_AVAILABLE_MSG;
        }
        return "<b><img border='0' align='bottom' src='nbresloc:/org/netbeans/modules/profiler/heapwalk/ui/resources/properties.png'>&nbsp;&nbsp;" + SYSTEM_PROPERTIES_STRING + "</b><br><hr>" + (showSystemProperties ? this.formatSystemProperties(sysprops) : "&nbsp;&nbsp;&nbsp;&nbsp;<a href='file:/sysprops'>" + SHOW_SYSPROPS_LINK_STRING + "</a>");
    }

    public String computeThreads(boolean showThreads) {
        return "<b><img border='0' align='bottom' src='nbresloc:/org/netbeans/modules/profiler/resources/threadsWindow.png'>&nbsp;&nbsp;" + THREADS_STRING + "</b><br><hr>" + (showThreads ? this.getStackTrace() : "&nbsp;&nbsp;&nbsp;&nbsp;<a href='file:/threads'>" + SHOW_THREADS_LINK_STRING + "</a><br>&nbsp;");
    }

    public void showURL(String urls) {
        if (urls.startsWith(OPEN_THREADS_URL)) {
            urls = urls.substring(OPEN_THREADS_URL.length());
            String[] parts = urls.split("\\|");
            String className = parts[0];
            String method = parts[1];
            int linenumber = Integer.parseInt(parts[2]);
            GoToSourceHelper.openSource(this.heapFragmentWalker.getHeapDumpProject(), new JavaSourceLocation(className, method, linenumber));
        } else if (urls.startsWith(INSTANCE_URL_PREFIX)) {
            urls = urls.substring(INSTANCE_URL_PREFIX.length());
            String[] id = urls.split("/");
            long instanceId = Long.parseLong(id[2]);
            Instance i = this.heapFragmentWalker.getHeapFragment().getInstanceByID(instanceId);
            if (i != null) {
                this.heapFragmentWalker.getClassesController().showInstance(i);
            } else {
                NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(CANNOT_RESOLVE_INSTANCE_MSG, id[1], id[0]));
            }
        } else if (urls.startsWith(CLASS_URL_PREFIX)) {
            urls = urls.substring(CLASS_URL_PREFIX.length());
            String[] id = urls.split("/");
            long jclsid = Long.parseLong(id[1]);
            JavaClass c = this.heapFragmentWalker.getHeapFragment().getJavaClassByID(jclsid);
            if (c != null) {
                this.heapFragmentWalker.getClassesController().showClass(c);
            } else {
                NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(CANNOT_RESOLVE_CLASS_MSG, id[0]));
            }
        } else if (urls.startsWith(THREAD_URL_PREFIX)) {
            urls = urls.substring(THREAD_URL_PREFIX.length());
            String[] id = urls.split("/");
            long threadid = Long.parseLong(id[1]);
            this.showInThreads(this.heapFragmentWalker.getHeapFragment().getInstanceByID(threadid));
        }
    }

    private long computeFinalizers(Heap heap) {
        Long len;
        Instance queue;
        JavaClass finalizerClass = heap.getJavaClassByName("java.lang.ref.Finalizer");
        if (finalizerClass != null && (queue = (Instance)finalizerClass.getValueOfStaticField("queue")) != null && (len = (Long)queue.getValueOfField("queueLength")) != null) {
            return len;
        }
        return -1L;
    }

    private ThreadObjectGCRoot getOOMEThread(Heap heap) {
        Collection roots = heap.getGCRoots();
        for (GCRoot root : roots) {
            ThreadObjectGCRoot threadRoot;
            StackTraceElement[] stackTrace;
            if (!root.getKind().equals("thread object") || (stackTrace = (threadRoot = (ThreadObjectGCRoot)root).getStackTrace()).length < 1) continue;
            StackTraceElement ste = stackTrace[0];
            if (!OutOfMemoryError.class.getName().equals(ste.getClassName()) || !"<init>".equals(ste.getMethodName())) continue;
            return threadRoot;
        }
        return null;
    }

    private Properties getSystemProperties() {
        if (!this.systemPropertiesComputed) {
            this.systemProperties = this.heapFragmentWalker.getHeapFragment().getSystemProperties();
            this.systemPropertiesComputed = true;
        }
        return this.systemProperties;
    }

    private String formatSystemProperties(Properties properties) {
        StringBuffer text = new StringBuffer(200);
        ArrayList keys = new ArrayList();
        Enumeration<?> en = properties.propertyNames();
        while (en.hasMoreElements()) {
            keys.add(en.nextElement());
        }
        Collections.sort(keys);
        for (String key : keys) {
            String val = properties.getProperty(key);
            if ("line.separator".equals(key) && val != null) {
                val = val.replace("\n", "\\n");
                val = val.replace("\r", "\\r");
            }
            text.append("<nobr>&nbsp;&nbsp;&nbsp;&nbsp;<b>");
            text.append(key);
            text.append("</b>=");
            text.append(val);
            text.append("</nobr><br>");
        }
        return text.toString();
    }

    private synchronized String getStackTrace() {
        if (this.stackTrace == null) {
            StringBuilder sb = new StringBuilder();
            Heap h = this.heapFragmentWalker.getHeapFragment();
            Collection roots = h.getGCRoots();
            Map<ThreadObjectGCRoot, Map<Integer, List<JavaFrameGCRoot>>> javaFrameMap = this.computeJavaFrameMap(roots);
            sb.append("<pre>");
            for (GCRoot root : roots) {
                if (!root.getKind().equals("thread object")) continue;
                ThreadObjectGCRoot threadRoot = (ThreadObjectGCRoot)root;
                Instance threadInstance = threadRoot.getInstance();
                if (threadInstance != null) {
                    String threadName = this.getThreadName(threadInstance);
                    Boolean daemon = (Boolean)threadInstance.getValueOfField("daemon");
                    Integer priority = (Integer)threadInstance.getValueOfField("priority");
                    Long threadId = (Long)threadInstance.getValueOfField("tid");
                    Integer threadStatus = (Integer)threadInstance.getValueOfField("threadStatus");
                    StackTraceElement[] stack = threadRoot.getStackTrace();
                    Map<Integer, List<JavaFrameGCRoot>> localsMap = javaFrameMap.get(threadRoot);
                    String style = "";
                    if (threadRoot.equals(this.oome)) {
                        style = "style=\"color: #FF0000\"";
                    }
                    sb.append("&nbsp;&nbsp;<a name=" + threadInstance.getInstanceId() + "></a><b " + style + ">");
                    sb.append("\"" + OverviewController.htmlize(threadName) + "\"" + (daemon != false ? " daemon" : "") + " prio=" + priority);
                    if (threadId != null) {
                        sb.append(" tid=" + threadId);
                    }
                    if (threadStatus != null) {
                        Thread.State tState = VM.toThreadState((int)threadStatus);
                        sb.append(" " + (Object)((Object)tState));
                    }
                    sb.append("</b><br>");
                    if (stack != null) {
                        for (int i = 0; i < stack.length; ++i) {
                            List<JavaFrameGCRoot> locals;
                            String stackElHref;
                            StackTraceElement stackElement = stack[i];
                            String stackElementText = OverviewController.htmlize(stackElement.toString());
                            if (this.heapFragmentWalker.getHeapDumpProject() != null) {
                                String className = stackElement.getClassName();
                                String method = stackElement.getMethodName();
                                int lineNo = stackElement.getLineNumber();
                                String stackUrl = OPEN_THREADS_URL + className + "|" + method + "|" + lineNo;
                                stackElHref = "<a href=\"" + stackUrl + "\">" + stackElementText + "</a>";
                            } else {
                                stackElHref = stackElementText;
                            }
                            sb.append("\tat " + stackElHref + "<br>");
                            if (localsMap == null || (locals = localsMap.get(i)) == null) continue;
                            for (JavaFrameGCRoot localVar : locals) {
                                Instance localInstance = localVar.getInstance();
                                if (localInstance != null) {
                                    sb.append("\t   Local Variable: " + this.printInstance(localInstance) + "<br>");
                                    continue;
                                }
                                sb.append("\t   Unknown Local Variable<br>");
                            }
                        }
                    }
                } else {
                    sb.append("&nbsp;&nbsp;Unknown thread");
                }
                sb.append("<br>");
            }
            sb.append("</pre>");
            this.stackTrace = sb.toString();
        }
        return this.stackTrace;
    }

    private String getThreadName(Instance threadInstance) {
        PrimitiveArrayInstance chars = (PrimitiveArrayInstance)threadInstance.getValueOfField("name");
        List charsList = chars.getValues();
        char[] charArr = new char[charsList.size()];
        int j = 0;
        for (String ch : charsList) {
            charArr[j++] = ch.charAt(0);
        }
        return new String(charArr);
    }

    private Map<ThreadObjectGCRoot, Map<Integer, List<JavaFrameGCRoot>>> computeJavaFrameMap(Collection<GCRoot> roots) {
        HashMap<ThreadObjectGCRoot, Map<Integer, List<JavaFrameGCRoot>>> javaFrameMap = new HashMap<ThreadObjectGCRoot, Map<Integer, List<JavaFrameGCRoot>>>();
        for (GCRoot root : roots) {
            ArrayList<JavaFrameGCRoot> locals;
            if (!"Java frame".equals(root.getKind())) continue;
            JavaFrameGCRoot frameGCroot = (JavaFrameGCRoot)root;
            ThreadObjectGCRoot threadObj = frameGCroot.getThreadGCRoot();
            Integer frameNo = frameGCroot.getFrameNumber();
            HashMap<Integer, ArrayList<JavaFrameGCRoot>> stackMap = (HashMap<Integer, ArrayList<JavaFrameGCRoot>>)javaFrameMap.get(threadObj);
            if (stackMap == null) {
                stackMap = new HashMap<Integer, ArrayList<JavaFrameGCRoot>>();
                javaFrameMap.put(threadObj, stackMap);
            }
            if ((locals = (ArrayList<JavaFrameGCRoot>)stackMap.get(frameNo)) == null) {
                locals = new ArrayList<JavaFrameGCRoot>(2);
                stackMap.put(frameNo, locals);
            }
            locals.add(frameGCroot);
        }
        return javaFrameMap;
    }

    private String printInstance(Instance in) {
        JavaClass javaClass;
        JavaClass jcls = in.getJavaClass();
        if (jcls == null) {
            return "unknown instance #" + in.getInstanceId();
        }
        if (jcls.equals(this.getJavaClass()) && (javaClass = this.heapFragmentWalker.getHeapFragment().getJavaClassByID(in.getInstanceId())) != null) {
            String className = javaClass.getName();
            return "<a href='file://class/" + className + "/" + javaClass.getJavaClassId() + "'>class " + className + "</a>";
        }
        String className = jcls.getName();
        return "<a href='file://instance/" + className + "/" + in.getInstanceNumber() + "/" + in.getInstanceId() + "' name='" + in.getInstanceId() + "'>" + className + '#' + in.getInstanceNumber() + "</a>";
    }

    private JavaClass getJavaClass() {
        if (this.java_lang_Class == null) {
            this.java_lang_Class = this.heapFragmentWalker.getHeapFragment().getJavaClassByName(Class.class.getName());
        }
        return this.java_lang_Class;
    }

    private static String htmlize(String value) {
        return value.replace(">", "&gt;").replace("<", "&lt;");
    }
}

