/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.heapwalk.model.AbstractHeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.ChildrenComputer;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNodeFactory;
import org.netbeans.modules.profiler.heapwalk.model.InstanceNode;
import org.netbeans.modules.profiler.heapwalk.model.InstancesContainerNode;
import org.netbeans.modules.profiler.heapwalk.model.RootNode;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class BrowserUtils {
    private static final String OUT_OF_MEMORY_MSG = NbBundle.getMessage(BrowserUtils.class, (String)"BrowserUtils_OutOfMemoryMsg");
    private static final String TRUNCATED_STRING = NbBundle.getMessage(BrowserUtils.class, (String)"BrowserUtils_TruncatedMsg");
    public static final ImageIcon ICON_INSTANCE = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/instance.png", (boolean)false);
    public static final ImageIcon ICON_PRIMITIVE = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/primitive.png", (boolean)false);
    public static final ImageIcon ICON_ARRAY = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/array.png", (boolean)false);
    public static final ImageIcon ICON_PROGRESS = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/progress.png", (boolean)false);
    public static final ImageIcon ICON_STATIC = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/static.png", (boolean)false);
    public static final ImageIcon ICON_LOOP = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/loop.png", (boolean)false);
    public static final ImageIcon ICON_GCROOT = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/gcRoot.png", (boolean)false);
    private static final RequestProcessor requestProcessor = new RequestProcessor("HeapWalker Processor", 3);
    private static final int MAX_FULLNAME_LENGTH = 100;

    public static String getArrayItemType(String arrayTypeName) {
        int arrayBracketsIdx = arrayTypeName.lastIndexOf("[");
        return arrayBracketsIdx == -1 ? arrayTypeName : arrayTypeName.substring(0, arrayBracketsIdx);
    }

    public static String getFullNodeName(HeapWalkerNode node) {
        StringBuilder sb = new StringBuilder();
        while (!node.isRoot()) {
            int length = sb.length();
            if (length < 100) {
                String nodeName = BrowserUtils.getNodeName(node);
                sb.insert(0, "." + nodeName);
                node = node.getParent();
                continue;
            }
            sb.delete(0, TRUNCATED_STRING.length());
            sb.insert(0, TRUNCATED_STRING);
            break;
        }
        sb.insert(0, BrowserUtils.getNodeName(node));
        return sb.toString();
    }

    public static GroupingInfo getGroupingInfo(int itemsCount) {
        int childrenCount = itemsCount;
        int collapseUnitSize = 500;
        int containersCount = (int)Math.ceil((float)childrenCount / (float)collapseUnitSize);
        while (containersCount > 5000 && collapseUnitSize < 5000) {
            containersCount = (int)Math.ceil((float)childrenCount / (float)(collapseUnitSize += 500));
        }
        return new GroupingInfo(containersCount, collapseUnitSize);
    }

    public static HeapWalkerNode getRoot(HeapWalkerNode node) {
        while (node != null && !node.isRoot()) {
            node = node.getParent();
        }
        return node == null ? null : node;
    }

    public static String getSimpleType(String fullType) {
        int simpleTypeIdx = fullType.lastIndexOf(".");
        if (simpleTypeIdx == -1) {
            return fullType;
        }
        if (fullType.startsWith("<")) {
            return "<" + fullType.substring(simpleTypeIdx + 1);
        }
        return fullType.substring(simpleTypeIdx + 1);
    }

    public static boolean isStaticField(FieldValue fieldValue) {
        return fieldValue.getField().isStatic();
    }

    public static HeapWalkerNode computeChildrenToNearestGCRoot(InstanceNode instanceNode) {
        HeapWalkerNode node = instanceNode;
        Instance instance = instanceNode.getInstance();
        Instance nextInstance = instance.getNearestGCRootPointer();
        HeapWalkerNode[] children = null;
        while (!instance.equals(nextInstance)) {
            if (nextInstance == null || node == null) {
                node = null;
                break;
            }
            if (children == null) {
                if (node instanceof InstanceNode && !node.currentlyHasChildren()) {
                    InstanceNode inode = node;
                    children = inode.getChildrenComputer().computeChildren();
                    inode.setChildren(children);
                } else {
                    children = node.getChildren();
                }
            }
            for (int i = 0; i < children.length; ++i) {
                HeapWalkerNode child = children[i];
                if (child instanceof InstanceNode) {
                    if (!((InstanceNode)child).getInstance().equals(nextInstance)) continue;
                    node = child;
                    children = null;
                    break;
                }
                if (!(child instanceof InstancesContainerNode) || !((InstancesContainerNode)child).getInstances().contains(nextInstance)) continue;
                node = child;
                children = null;
                break;
            }
            instance = nextInstance;
            nextInstance = nextInstance.getNearestGCRootPointer();
        }
        return node;
    }

    public static ImageIcon createGCRootIcon(ImageIcon icon) {
        return new ImageIcon(ImageUtilities.mergeImages((Image)icon.getImage(), (Image)ICON_GCROOT.getImage(), (int)0, (int)0));
    }

    public static ImageIcon createLoopIcon(ImageIcon icon) {
        return new ImageIcon(ImageUtilities.mergeImages((Image)icon.getImage(), (Image)ICON_LOOP.getImage(), (int)0, (int)0));
    }

    public static ImageIcon createStaticIcon(ImageIcon icon) {
        return new ImageIcon(ImageUtilities.mergeImages((Image)icon.getImage(), (Image)ICON_STATIC.getImage(), (int)0, (int)0));
    }

    public static HeapWalkerNode[] lazilyCreateChildren(final HeapWalkerNode parent, final ChildrenComputer childrenComputer) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BrowserUtils.performTask(new Runnable(){

                    @Override
                    public void run() {
                        if (parent instanceof AbstractHeapWalkerNode) {
                            HeapWalkerNode[] computedChildren;
                            boolean oome = false;
                            try {
                                computedChildren = childrenComputer.computeChildren();
                            }
                            catch (OutOfMemoryError e) {
                                oome = true;
                                computedChildren = new HeapWalkerNode[]{HeapWalkerNodeFactory.createOOMNode(parent)};
                            }
                            final HeapWalkerNode[] computedChildrenF = computedChildren;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ((AbstractHeapWalkerNode)parent).changeChildren(computedChildrenF);
                                    HeapWalkerNode root = BrowserUtils.getRoot(parent);
                                    if (root instanceof RootNode) {
                                        ((RootNode)((Object)root)).refreshView();
                                    }
                                }
                            });
                            if (oome) {
                                NetBeansProfiler.getDefaultNB().displayError(OUT_OF_MEMORY_MSG);
                            }
                        }
                    }
                });
            }
        });
        return new HeapWalkerNode[]{HeapWalkerNodeFactory.createProgressNode(parent)};
    }

    public static void performTask(Runnable task) {
        requestProcessor.post(task);
    }

    private static String getNodeName(HeapWalkerNode node) {
        String name = node.getName();
        if (name.endsWith(")")) {
            name = name.substring(0, name.indexOf("(")).trim();
        }
        return name;
    }

    public static class GroupingInfo {
        public int collapseUnitSize;
        public int containersCount;

        GroupingInfo(int containersCount, int collapseUnitSize) {
            this.containersCount = containersCount;
            this.collapseUnitSize = collapseUnitSize;
        }
    }
}

