/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.utils;

import java.awt.Dialog;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.filters.FilterUtils;
import org.netbeans.lib.profiler.common.filters.SimpleFilter;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.heapwalk.HeapDumpWatch;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.spi.ProjectTypeProfiler;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.netbeans.modules.profiler.utils.AppletSupport;
import org.netbeans.modules.profiler.utils.MainClassWarning;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.MouseUtils;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.w3c.dom.Element;

@Deprecated
public final class ProjectUtilities {
    private static final Logger LOGGER = Logger.getLogger(ProjectUtilities.class.getName());
    public static final String PROFILER_NAME_SPACE = "http://www.netbeans.org/ns/profiler/1";
    private static final String UNKNOWN_PROJECT_STRING = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_UnknownProjectString");
    private static final String FAILED_CREATE_CLASSES_DIR_MSG = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_FailedCreateClassesDirMsg");
    private static final String FAILED_GENERATE_APPLET_FILE_MSG = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_FailedGenerateAppletFileMsg");
    private static final String FAILED_COPY_APPLET_FILE_MSG = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_FailedCopyAppletFileMsg");
    private static final String FAILED_CREATE_OUTPUT_FOLDER_MSG = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_FailedCreateOutputFolderMsg");
    private static final String PROFILE_PROJECT_CLASSES_STRING = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_ProfileProjectClassesString");
    private static final String PROFILE_PROJECT_SUBPROJECT_CLASSES_STRING = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_ProfileProjectSubprojectClassesString");
    private static final String PROFILER_WILL_BE_UNINTEGRATED_MSG = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_ProfilerWillBeUnintegratedMsg");
    private static final String PROFILER_ISNT_INTEGRATED_MSG = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_ProfilerIsntIntegratedMsg");
    private static final String RENAMING_BUILD_FAILED_MSG = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_RenamingBuildFailedMsg");
    private static final String REMOVING_BUILD_FAILED_MSG = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_RemovingBuildFailedMsg");
    private static final String REMOVING_DATA_FAILED_MSG = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_RemovingDataFailedMsg");
    private static final String UNINTEGRATION_ERRORS_OCCURED_MSG = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_UnintegrationErrorsOccuredMsg");
    private static final String UNINTEGRATION_SUCCESSFUL_MSG = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_UnintegrationSuccessfulMsg");
    public static final SimpleFilter FILTER_PROJECT_ONLY = new SimpleFilter(PROFILE_PROJECT_CLASSES_STRING, 2, "{$project.classes.only}");
    public static final SimpleFilter FILTER_PROJECT_SUBPROJECTS_ONLY = new SimpleFilter(PROFILE_PROJECT_SUBPROJECT_CLASSES_STRING, 2, "{$project.subprojects.classes.only}");
    private static final Pattern PROFILER_INIT = Pattern.compile("<\\s*target\\s+.*?name\\s*=\\s*\"profile-init\"", 40);

    public static Collection<? extends ProjectTypeProfiler> getAllProjectTypeProfilers() {
        Lookup.Template template;
        Lookup lookup = Lookup.getDefault();
        Lookup.Result result = lookup.lookup(template = new Lookup.Template(ProjectTypeProfiler.class));
        if (result == null) {
            return new ArrayList();
        }
        return result.allInstances();
    }

    public static ClientUtils.SourceCodeSelection[] getClassConstructors(FileObject classFile) {
        return SourceUtils.getClassConstructors((FileObject)classFile);
    }

    public static ClasspathInfo getClasspathInfo(Project project) {
        return ProjectUtilities.getClasspathInfo(project, true);
    }

    public static ClasspathInfo getClasspathInfo(Project project, boolean includeSubprojects) {
        return ProjectUtilities.getClasspathInfo(project, includeSubprojects, true, true);
    }

    public static ClasspathInfo getClasspathInfo(Project project, boolean includeSubprojects, boolean includeSources, boolean includeLibraries) {
        FileObject[] sourceRoots = ProjectUtilities.getSourceRoots(project, includeSubprojects);
        if (!(sourceRoots != null && sourceRoots.length != 0 || includeSubprojects)) {
            sourceRoots = ProjectUtilities.getSourceRoots(project, true);
        }
        if (sourceRoots == null || sourceRoots.length == 0) {
            return null;
        }
        ArrayList<URL> urlList = new ArrayList<URL>();
        ClassPath cpEmpty = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
        ClassPath cpSource = ClassPathSupport.createClassPath((FileObject[])sourceRoots);
        ClassPath cpCompile = ClassPath.getClassPath((FileObject)sourceRoots[0], (String)"classpath/compile");
        for (ClassPath.Entry entry : cpCompile.entries()) {
            SourceForBinaryQuery.Result rslt = SourceForBinaryQuery.findSourceRoots((URL)entry.getURL());
            FileObject[] roots = rslt.getRoots();
            if (roots != null && roots.length != 0) continue;
            urlList.add(entry.getURL());
        }
        cpCompile = ClassPathSupport.createClassPath((URL[])urlList.toArray(new URL[urlList.size()]));
        return ClasspathInfo.create((ClassPath)(includeLibraries ? ClassPath.getClassPath((FileObject)sourceRoots[0], (String)"classpath/boot") : cpEmpty), (ClassPath)(includeLibraries ? cpCompile : cpEmpty), (ClassPath)(includeSources ? cpSource : cpEmpty));
    }

    public static String getDefaultPackageClassNames(Project project) {
        Collection classNames = SourceUtils.getDefaultPackageClassNames((Project)project);
        StringBuffer classNamesBuf = new StringBuffer();
        for (String className : classNames) {
            classNamesBuf.append(className).append(" ");
        }
        return classNamesBuf.toString();
    }

    public static boolean isJavaProject(Project project) {
        if (project == null) {
            return false;
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        return sourceGroups.length > 0;
    }

    public static Project getMainProject() {
        return OpenProjects.getDefault().getMainProject();
    }

    public static Project[] getOpenedProjects() {
        return OpenProjects.getDefault().getOpenProjects();
    }

    public static Project[] getOpenedProjectsForAttach() {
        Project[] projects = ProjectUtilities.getOpenedProjects();
        ArrayList<Project> projectsArray = new ArrayList<Project>(projects.length);
        for (int i = 0; i < projects.length; ++i) {
            if (!ProjectUtilities.isProjectTypeSupportedForAttach(projects[i])) continue;
            projectsArray.add(projects[i]);
        }
        return projectsArray.toArray(new Project[projectsArray.size()]);
    }

    public static FileObject getOrCreateBuildFolder(Project project, String buildDirProp) {
        FileObject buildDir = FileUtil.toFileObject((File)PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)buildDirProp));
        if (buildDir == null) {
            try {
                buildDir = FileUtil.createFolder((FileObject)project.getProjectDirectory(), (String)buildDirProp);
            }
            catch (IOException e) {
                ErrorManager.getDefault().annotate((Throwable)e, MessageFormat.format(FAILED_CREATE_OUTPUT_FOLDER_MSG, e.getMessage()));
                ErrorManager.getDefault().notify(65536, (Throwable)e);
                return null;
            }
        }
        return buildDir;
    }

    public static boolean isProfilerIntegrated(Project project) {
        String buildXml = ProjectUtilities.getProjectBuildScript(project, "nbproject/build-impl.xml");
        Matcher m = PROFILER_INIT.matcher(buildXml);
        return m.find();
    }

    public static float getProfilingOverhead(ProfilingSettings settings) {
        float o = 0.0f;
        if (!Utils.isMonitorSettings(settings)) {
            if (Utils.isCPUSettings(settings)) {
                if (settings.getProfilingType() == 8) {
                    o += 0.5f;
                } else if (settings.getProfilingType() == 16) {
                    o += 0.2f;
                }
                if (FilterUtils.NONE_FILTER.equals(settings.getSelectedInstrumentationFilter())) {
                    o += 0.5f;
                }
            } else if (Utils.isMemorySettings(settings)) {
                if (settings.getProfilingType() == 2) {
                    o += 0.5f;
                } else if (settings.getProfilingType() == 4) {
                    o += 0.7f;
                }
                if (settings.getAllocStackTraceLimit() != 0) {
                    o += 0.3f;
                }
            }
        }
        return o;
    }

    public static String getProjectBuildScript(Project project) {
        return ProjectUtilities.getProjectBuildScript(project, "build.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProjectBuildScript(Project project, String buildXml) {
        FileObject buildFile = ProjectUtilities.findBuildFile(project, buildXml);
        if (buildFile == null) {
            return null;
        }
        RandomAccessFile file = null;
        byte[] data = null;
        try {
            file = new RandomAccessFile(FileUtil.toFile((FileObject)buildFile), "r");
            data = new byte[(int)buildFile.getSize()];
            file.readFully(data);
        }
        catch (FileNotFoundException e2) {
            ProfilerLogger.log((Exception)e2);
            String string = null;
            return string;
        }
        catch (IOException e2) {
            ProfilerLogger.log((Exception)e2);
            String string = null;
            return string;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException e2) {
                    ProfilerLogger.log((Exception)e2);
                }
            }
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ErrorManager.getDefault().notify(65536, (Throwable)ex);
            return null;
        }
    }

    public static FileObject findBuildFile(Project project) {
        String buildFileName;
        FileObject buildFile = null;
        Properties props = org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.getProjectProperties((Project)project);
        String string = buildFileName = props != null ? props.getProperty("buildfile") : null;
        if (buildFileName != null) {
            buildFile = ProjectUtilities.findBuildFile(project, buildFileName);
        }
        if (buildFile == null) {
            buildFile = ProjectUtilities.findBuildFile(project, "build.xml");
        }
        return buildFile;
    }

    public static FileObject findBuildFile(Project project, String buildFileName) {
        return project.getProjectDirectory().getFileObject(buildFileName);
    }

    public static List<SimpleFilter> getProjectDefaultInstrFilters(Project project) {
        ArrayList<SimpleFilter> v = new ArrayList<SimpleFilter>();
        if (ProjectUtils.getSources((Project)project).getSourceGroups("java").length > 0) {
            v.add(FILTER_PROJECT_ONLY);
        }
        if (ProjectUtilities.hasSubprojects(project)) {
            v.add(FILTER_PROJECT_SUBPROJECTS_ONLY);
        }
        return v;
    }

    public static ClientUtils.SourceCodeSelection[] getProjectDefaultRoots(Project project, String[][] projectPackagesDescr) {
        ProjectUtilities.computeProjectPackages(project, true, projectPackagesDescr);
        ClientUtils.SourceCodeSelection[] ret = new ClientUtils.SourceCodeSelection[projectPackagesDescr[1].length];
        for (int i = 0; i < projectPackagesDescr[1].length; ++i) {
            ret[i] = "".equals(projectPackagesDescr[1][i]) ? new ClientUtils.SourceCodeSelection("", "", "") : new ClientUtils.SourceCodeSelection(projectPackagesDescr[1][i] + ".", "", "");
        }
        return ret;
    }

    public static Project getProjectForBuildScript(String fileName) {
        FileObject projectFO = FileUtil.toFileObject((File)new File(fileName));
        while (projectFO != null) {
            try {
                if (projectFO.isFolder()) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Trying: " + projectFO);
                    }
                    Project p = ProjectManager.getDefault().findProject(projectFO);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Got: " + (p != null ? ProjectUtilities.getProjectName(p) : null));
                    }
                    if (p != null) {
                        return p;
                    }
                }
                projectFO = projectFO.getParent();
            }
            catch (IOException e) {
                ProfilerLogger.severe((String)("Got: IOException : " + e.getMessage()));
            }
        }
        return null;
    }

    public static Icon getProjectIcon(Project project) {
        ProjectInformation info = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
        if (info == null) {
            return new ImageIcon();
        }
        return info.getIcon();
    }

    public static String getProjectName(Project project) {
        ProjectInformation info = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
        if (info == null) {
            return UNKNOWN_PROJECT_STRING;
        }
        return info.getDisplayName();
    }

    public static String[] getProjectPackages(Project project) {
        ArrayList<String> packages = new ArrayList<String>();
        for (FileObject root : ProjectUtilities.getSourceRoots(project, true)) {
            ProjectUtilities.addSubpackages(packages, "", root);
        }
        return packages.toArray(new String[0]);
    }

    public static ProjectTypeProfiler getProjectTypeProfiler(Project project) {
        if (project == null) {
            return ProjectTypeProfiler.DEFAULT;
        }
        ProjectTypeProfiler fromProject = (ProjectTypeProfiler)project.getLookup().lookup(ProjectTypeProfiler.class);
        return fromProject != null ? (fromProject.isProfilingSupported(project) ? fromProject : ProjectTypeProfiler.DEFAULT) : ProjectTypeProfiler.DEFAULT;
    }

    public static boolean isProjectTypeSupported(Project project) {
        ProjectTypeProfiler ptp = ProjectUtilities.getProjectTypeProfiler(project);
        if (ptp.isProfilingSupported(project)) {
            return true;
        }
        return ProjectUtilities.hasAction(project, "profile");
    }

    public static boolean isProjectTypeSupportedForAttach(Project project) {
        return ProjectUtilities.getProjectTypeProfiler(project).isAttachSupported(project);
    }

    public static FileObject getRootOf(FileObject[] roots, FileObject file) {
        FileObject srcDir = null;
        for (int i = 0; i < roots.length; ++i) {
            if (!FileUtil.isParentOf((FileObject)roots[i], (FileObject)file)) continue;
            srcDir = roots[i];
            break;
        }
        return srcDir;
    }

    public static Project[] getSortedProjects(Project[] projects) {
        ArrayList<Project> projectsArray = new ArrayList<Project>(projects.length);
        for (int i = 0; i < projects.length; ++i) {
            projectsArray.add(projects[i]);
        }
        try {
            Collections.sort(projectsArray, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Project p1 = (Project)o1;
                    Project p2 = (Project)o2;
                    return ProjectUtils.getInformation((Project)p1).getDisplayName().toLowerCase().compareTo(ProjectUtils.getInformation((Project)p2).getDisplayName().toLowerCase());
                }
            });
        }
        catch (Exception e) {
            ErrorManager.getDefault().log(65536, e.getMessage());
        }
        projectsArray.toArray(projects);
        return projects;
    }

    public static FileObject[] getSourceRoots(Project project) {
        return ProjectUtilities.getSourceRoots(project, true);
    }

    public static FileObject[] getSourceRoots(Project project, boolean traverse) {
        HashSet<FileObject> set = new HashSet<FileObject>();
        HashSet<Project> projects = new HashSet<Project>();
        projects.add(project);
        ProjectUtilities.getSourceRoots(project, traverse, projects, set);
        return set.toArray(new FileObject[set.size()]);
    }

    public static boolean backupBuildScript(Project project) {
        FileObject buildFile = ProjectUtilities.findBuildFile(project);
        FileObject buildBackupFile = project.getProjectDirectory().getFileObject("build-before-profiler.xml");
        if (buildFile != null) {
            if (buildBackupFile != null) {
                try {
                    buildBackupFile.delete();
                }
                catch (IOException e) {
                    ProfilerLogger.log((Exception)e);
                    return false;
                }
            }
            try {
                buildFile.copy(project.getProjectDirectory(), "build-before-profiler", "xml");
            }
            catch (IOException e1) {
                ProfilerLogger.log((Exception)e1);
                return false;
            }
            return true;
        }
        return false;
    }

    public static SimpleFilter computeProjectOnlyInstrumentationFilter(Project project, SimpleFilter predefinedInstrFilter, String[][] projectPackagesDescr) {
        if (FILTER_PROJECT_ONLY.equals((Object)predefinedInstrFilter)) {
            ProjectUtilities.computeProjectPackages(project, false, projectPackagesDescr);
            StringBuffer projectPackages = new StringBuffer();
            for (int i = 0; i < projectPackagesDescr[0].length; ++i) {
                projectPackages.append("".equals(projectPackagesDescr[0][i]) ? ProjectUtilities.getDefaultPackageClassNames(project) : projectPackagesDescr[0][i] + ". ");
            }
            return new SimpleFilter(PROFILE_PROJECT_CLASSES_STRING, 2, projectPackages.toString().trim());
        }
        if (FILTER_PROJECT_SUBPROJECTS_ONLY.equals((Object)predefinedInstrFilter)) {
            ProjectUtilities.computeProjectPackages(project, true, projectPackagesDescr);
            StringBuffer projectPackages = new StringBuffer();
            for (int i = 0; i < projectPackagesDescr[1].length; ++i) {
                projectPackages.append("".equals(projectPackagesDescr[1][i]) ? ProjectUtilities.getDefaultPackageClassNames(project) : projectPackagesDescr[1][i] + ". ");
            }
            return new SimpleFilter(PROFILE_PROJECT_SUBPROJECT_CLASSES_STRING, 2, projectPackages.toString().trim());
        }
        return null;
    }

    public static void computeProjectPackages(Project project, boolean subprojects, String[][] storage) {
        if (storage == null || storage.length != 2) {
            throw new IllegalArgumentException("Storage must be a non-null String[2][] array");
        }
        if (storage[0] == null) {
            ArrayList<String> packages1 = new ArrayList<String>();
            for (FileObject root : ProjectUtilities.getSourceRoots(project, false)) {
                ProjectUtilities.addSubpackages(packages1, "", root);
            }
            storage[0] = packages1.toArray(new String[0]);
        }
        if (subprojects && storage[1] == null) {
            FileObject[] srcRoots2 = ProjectUtilities.getSourceRoots(project, true);
            ArrayList<String> packages2 = new ArrayList<String>();
            for (FileObject root : srcRoots2) {
                ProjectUtilities.addSubpackages(packages2, "", root);
            }
            storage[1] = packages2.toArray(new String[0]);
        }
    }

    public static URL copyAppletHTML(Project project, PropertyEvaluator props, FileObject profiledClassFile, String value) {
        try {
            String buildDirProp = props.getProperty("build.dir");
            FileObject buildFolder = ProjectUtilities.getOrCreateBuildFolder(project, buildDirProp);
            FileObject htmlFile = null;
            htmlFile = profiledClassFile.getParent().getFileObject(profiledClassFile.getName(), "html");
            if (htmlFile == null) {
                htmlFile = profiledClassFile.getParent().getFileObject(profiledClassFile.getName(), "HTML");
            }
            if (htmlFile == null) {
                return null;
            }
            FileObject existingFile = buildFolder.getFileObject(htmlFile.getName(), htmlFile.getExt());
            if (existingFile != null) {
                existingFile.delete();
            }
            htmlFile.copy(buildFolder, profiledClassFile.getName(), value).getURL();
            if (htmlFile != null) {
                return htmlFile.getURL();
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().annotate((Throwable)e, MessageFormat.format(FAILED_COPY_APPLET_FILE_MSG, e.getMessage()));
            ErrorManager.getDefault().notify(65536, (Throwable)e);
            return null;
        }
        return null;
    }

    public static void fetchSubprojects(Project project, Set<Project> projects) {
        SubprojectProvider spp = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
        if (spp != null) {
            for (Project p : spp.getSubprojects()) {
                if (p == null || !projects.add(p)) continue;
                ProjectUtilities.fetchSubprojects(p, projects);
            }
        }
    }

    public static FileObject findTestForFile(FileObject selectedFO) {
        if (selectedFO == null || !selectedFO.getExt().equalsIgnoreCase("java")) {
            return null;
        }
        ClassPath cp = ClassPath.getClassPath((FileObject)selectedFO, (String)"classpath/source");
        if (cp == null) {
            return null;
        }
        FileObject packageRoot = cp.findOwnerRoot(selectedFO);
        if (packageRoot == null) {
            return null;
        }
        URL[] testRoots = UnitTestForSourceQuery.findUnitTests((FileObject)packageRoot);
        FileObject fileToOpen = null;
        for (int j = 0; j < testRoots.length; ++j) {
            fileToOpen = ProjectUtilities.findUnitTestInTestRoot(cp, selectedFO, testRoots[j]);
            if (fileToOpen == null) continue;
            return fileToOpen;
        }
        return null;
    }

    public static URL generateAppletHTML(Project project, PropertyEvaluator props, FileObject profiledClassFile) {
        String buildDirProp = props.getProperty("build.dir");
        String classesDirProp = props.getProperty("build.classes.dir");
        String activePlatformName = props.getProperty("platform.active");
        FileObject buildFolder = ProjectUtilities.getOrCreateBuildFolder(project, buildDirProp);
        FileObject classesDir = FileUtil.toFileObject((File)PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)classesDirProp));
        if (classesDir == null) {
            try {
                classesDir = FileUtil.createFolder((FileObject)project.getProjectDirectory(), (String)classesDirProp);
            }
            catch (IOException e) {
                ErrorManager.getDefault().annotate((Throwable)e, MessageFormat.format(FAILED_CREATE_CLASSES_DIR_MSG, e.getMessage()));
                ErrorManager.getDefault().notify(65536, (Throwable)e);
                return null;
            }
        }
        try {
            return AppletSupport.generateHtmlFileURL(profiledClassFile, buildFolder, classesDir, activePlatformName);
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().annotate((Throwable)e, MessageFormat.format(FAILED_GENERATE_APPLET_FILE_MSG, e.getMessage()));
            ErrorManager.getDefault().notify(65536, (Throwable)e);
            return null;
        }
    }

    public static boolean hasAction(Project project, String actionName) {
        ActionProvider ap = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        if (ap == null) {
            return false;
        }
        String[] actions = ap.getSupportedActions();
        for (int i = 0; i < actions.length; ++i) {
            if (actions[i] == null || !actionName.equals(actions[i])) continue;
            return true;
        }
        return false;
    }

    public static void invokeAction(Project project, String s) {
        ActionProvider ap = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        if (ap == null) {
            return;
        }
        Lookup lkp = null;
        if (NetBeansProfiler.getDefaultNB().getProfiledSingleFile() != null) {
            try {
                lkp = new ProxyLookup(new Lookup[]{Lookup.getDefault(), Lookups.fixed((Object[])new Object[]{DataObject.find((FileObject)NetBeansProfiler.getDefaultNB().getProfiledSingleFile())})});
            }
            catch (DataObjectNotFoundException ex) {
                lkp = Lookup.getDefault();
            }
        } else {
            lkp = Lookup.getDefault();
        }
        ap.invokeAction(s, lkp);
    }

    public static ExecutorTask runTarget(FileObject buildScript, String target, Properties props) {
        try {
            String oomeenabled = props.getProperty("profiler.info.oomeprotection");
            if (oomeenabled != null && oomeenabled.equals("yes")) {
                HeapDumpWatch.getDefault().monitor(props.getProperty("profiler.info.oomeprotection.dumppath"));
            }
            return ActionUtils.runTarget((FileObject)buildScript, (String[])new String[]{target}, (Properties)props);
        }
        catch (IOException e) {
            Profiler.getDefault().notifyException(8, (Exception)e);
            return null;
        }
    }

    public static String selectMainClass(Project project, String mainClass, String projectName, int messageType) {
        boolean canceled;
        String message;
        final JButton okButton = new JButton(NbBundle.getMessage(MainClassWarning.class, (String)"LBL_MainClassWarning_ChooseMainClass_OK"));
        okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MainClassWarning.class, (String)"AD_MainClassWarning_ChooseMainClass_OK"));
        switch (messageType) {
            case -1: {
                message = MessageFormat.format(NbBundle.getMessage(MainClassWarning.class, (String)"LBL_MainClassNotFound"), projectName);
                break;
            }
            case -2: {
                message = MessageFormat.format(NbBundle.getMessage(MainClassWarning.class, (String)"LBL_MainClassWrong"), mainClass, projectName);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        final MainClassWarning panel = new MainClassWarning(message, ProjectUtilities.getSourceRoots(project));
        Object[] options = new Object[]{okButton, DialogDescriptor.CANCEL_OPTION};
        panel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)e.getSource()))) {
                    okButton.doClick();
                } else {
                    okButton.setEnabled(panel.getSelectedMainClass() != null);
                }
            }
        });
        okButton.setEnabled(false);
        DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage(MainClassWarning.class, (String)"CTL_MainClassWarning_Title", (Object)ProjectUtils.getInformation((Project)project).getDisplayName()), true, options, options[0], 0, null, null);
        desc.setMessageType(1);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
        dlg.setVisible(true);
        if (desc.getValue() != options[0]) {
            canceled = true;
        } else {
            mainClass = panel.getSelectedMainClass();
            canceled = false;
        }
        dlg.dispose();
        if (canceled) {
            return null;
        }
        return mainClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unintegrateProfiler(Project project) {
        String projectName = ProjectUtils.getInformation((Project)project).getDisplayName();
        if (ProjectUtilities.isProfilerIntegrated(project) ? ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)MessageFormat.format(PROFILER_WILL_BE_UNINTEGRATED_MSG, projectName), 0)) != NotifyDescriptor.YES_OPTION : ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)MessageFormat.format(PROFILER_ISNT_INTEGRATED_MSG, projectName), 0)) != NotifyDescriptor.YES_OPTION) {
            return;
        }
        boolean failed = false;
        StringBuilder exceptionsReport = new StringBuilder();
        FileLock buildBackupFileLock = null;
        Object buildBackup2FileLock = null;
        try {
            FileObject buildFile = ProjectUtilities.findBuildFile(project);
            FileObject buildBackupFile = project.getProjectDirectory().getFileObject("build-before-profiler.xml");
            if (buildFile != null && buildBackupFile != null && buildBackupFile.isValid()) {
                try {
                    buildBackupFileLock = buildBackupFile.lock();
                    if (buildFile != null && buildFile.isValid()) {
                        buildFile.delete();
                    }
                    buildBackupFile.rename(buildBackupFileLock, "build", "xml");
                }
                catch (Exception e) {
                    failed = true;
                    exceptionsReport.append(MessageFormat.format(RENAMING_BUILD_FAILED_MSG, e.getMessage()));
                    ProfilerLogger.log((Exception)e);
                }
            }
        }
        finally {
            if (buildBackupFileLock != null) {
                buildBackupFileLock.releaseLock();
            }
        }
        Object buildImplFileLock = null;
        try {
            FileObject buildImplFile = project.getProjectDirectory().getFileObject("nbproject").getFileObject("profiler-build-impl.xml");
            try {
                if (buildImplFile != null && buildImplFile.isValid()) {
                    buildImplFile.delete();
                }
            }
            catch (Exception e) {
                failed = true;
                exceptionsReport.append(MessageFormat.format(REMOVING_BUILD_FAILED_MSG, e.getMessage()));
                ProfilerLogger.log((Exception)e);
            }
        }
        finally {
            if (buildImplFileLock != null) {
                buildImplFileLock.releaseLock();
            }
        }
        ProjectUtils.getAuxiliaryConfiguration((Project)project).removeConfigurationFragment("data", PROFILER_NAME_SPACE, false);
        try {
            ProjectManager.getDefault().saveProject(project);
        }
        catch (Exception e) {
            failed = true;
            exceptionsReport.append(MessageFormat.format(REMOVING_DATA_FAILED_MSG, e.getMessage()));
            ProfilerLogger.log((Exception)e);
        }
        if (failed) {
            Profiler.getDefault().displayError(MessageFormat.format(UNINTEGRATION_ERRORS_OCCURED_MSG, exceptionsReport.toString()));
        } else {
            Profiler.getDefault().displayInfo(MessageFormat.format(UNINTEGRATION_SUCCESSFUL_MSG, projectName));
        }
    }

    private static void getSourceRoots(Project project, boolean traverse, Set<Project> projects, Set<FileObject> roots) {
        SubprojectProvider spp;
        Sources sources = ProjectUtils.getSources((Project)project);
        for (SourceGroup sg : sources.getSourceGroups("java")) {
            roots.add(sg.getRootFolder());
        }
        if (traverse && (spp = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class)) != null) {
            for (Project p : spp.getSubprojects()) {
                if (!projects.add(p)) continue;
                ProjectUtilities.getSourceRoots(p, traverse, projects, roots);
            }
        }
    }

    private static String getTestName(ClassPath cp, FileObject selectedFO) {
        String resource = cp.getResourceName(selectedFO, '/', false);
        String testName = null;
        testName = selectedFO.isFolder() ? ProjectUtilities.convertPackage2SuiteName(resource) : ProjectUtilities.convertClass2TestName(resource);
        return testName;
    }

    private static void addSubpackages(ArrayList<String> packages, String prefix, FileObject packageFO) {
        FileObject child;
        int i;
        if (!packageFO.isFolder()) {
            return;
        }
        FileObject[] children = packageFO.getChildren();
        if (!packages.contains(prefix)) {
            for (i = 0; i < children.length; ++i) {
                child = children[i];
                if (!child.getExt().equals("java")) continue;
                packages.add(prefix);
                break;
            }
        }
        for (i = 0; i < children.length; ++i) {
            child = children[i];
            if (!child.isFolder()) continue;
            if ("".equals(prefix)) {
                ProjectUtilities.addSubpackages(packages, child.getName(), child);
                continue;
            }
            ProjectUtilities.addSubpackages(packages, prefix + "." + child.getName(), child);
        }
    }

    private static String convertClass2TestName(String classFileName) {
        if (classFileName == null || "".equals(classFileName)) {
            return "";
        }
        int index = classFileName.lastIndexOf(47);
        String pkg = index > -1 ? classFileName.substring(0, index) : "";
        String clazz = index > -1 ? classFileName.substring(index + 1) : classFileName;
        clazz = clazz.substring(0, 1).toUpperCase() + clazz.substring(1);
        if (pkg.length() > 0) {
            pkg = pkg + "/";
        }
        return pkg + clazz + "Test";
    }

    private static String convertPackage2SuiteName(String packageFileName) {
        if (packageFileName == null || "".equals(packageFileName)) {
            return "";
        }
        int index = packageFileName.lastIndexOf(47);
        String pkg = index > -1 ? packageFileName.substring(index + 1) : packageFileName;
        pkg = pkg.substring(0, 1).toUpperCase() + pkg.substring(1);
        return packageFileName + "/" + pkg + "Test";
    }

    private static FileObject findUnitTestInTestRoot(ClassPath cp, FileObject selectedFO, URL testRoot) {
        ClassPath testClassPath = null;
        if (testRoot == null) {
            testClassPath = cp;
        } else {
            try {
                ArrayList<PathResourceImplementation> cpItems = new ArrayList<PathResourceImplementation>();
                cpItems.add(ClassPathSupport.createResource((URL)testRoot));
                testClassPath = ClassPathSupport.createClassPath(cpItems);
            }
            catch (IllegalArgumentException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                testClassPath = cp;
            }
        }
        String testName = ProjectUtilities.getTestName(cp, selectedFO);
        return testClassPath.findResource(testName + ".java");
    }

    private static boolean hasSubprojects(Project project) {
        SubprojectProvider spp = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
        if (spp == null) {
            return false;
        }
        return spp.getSubprojects().size() > 0;
    }

    public static final class IntegrationUpdater
    extends ProjectOpenedHook {
        private Project prj;

        public IntegrationUpdater(Project prj) {
            this.prj = prj;
        }

        protected void projectClosed() {
        }

        protected void projectOpened() {
            Element e = ProjectUtils.getAuxiliaryConfiguration((Project)this.prj).getConfigurationFragment("data", ProjectUtilities.PROFILER_NAME_SPACE, false);
            if (e != null) {
                ProjectUtilities.unintegrateProfiler(this.prj);
            }
        }
    }
}

