/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.editor.scene;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.modules.vmd.game.editor.common.NonEmptyStringTableCellEditor;
import org.netbeans.modules.vmd.game.editor.scene.BooleanTableCellRenderer;
import org.netbeans.modules.vmd.game.editor.scene.LayerTableCellRenderer;
import org.netbeans.modules.vmd.game.model.Layer;
import org.netbeans.modules.vmd.game.model.LayerDataFlavor;
import org.netbeans.modules.vmd.game.model.Scene;
import org.netbeans.modules.vmd.game.model.SceneSelectionListener;
import org.netbeans.modules.vmd.game.model.adapter.SceneLayerTableAdapter;

public class SceneLayerNavigator
extends JTable {
    public static final boolean DEBUG = false;
    public static final int PAD_X = 4;
    public static final int PAD_Y = 4;
    private static final int IMG_PREVIEW_WIDTH = 40;
    private static final int IMG_PREVIEW_HEIGHT = 30;
    private static final Logger LOG = Logger.getLogger(SceneLayerNavigator.class.getName());
    private Scene scene;

    public SceneLayerNavigator(Scene layerModel) {
        this.scene = layerModel;
        this.setModel(new SceneLayerTableAdapter(layerModel));
        this.getColumnModel().setColumnMargin(0);
        DragSource dragSource = new DragSource();
        DragGestureRecognizer dragGestureRecognizer = dragSource.createDefaultDragGestureRecognizer(this, 2, new DGL());
        DropTarget dropTarget = new DropTarget(this, new TableDropTarget());
        dropTarget.setActive(true);
        this.setDropTarget(dropTarget);
        this.getSelectionModel().addListSelectionListener(new SceneTableSelectionListener());
        this.scene.addSceneListener(new ExternalSceneSelectionListener());
        this.setRowHeight(30);
        int width = 40 + this.getColumnModel().getColumnMargin();
        TableColumn typeColumn = this.getColumnModel().getColumn(0);
        typeColumn.setPreferredWidth(width);
        typeColumn.setMaxWidth(width);
        typeColumn.setMinWidth(width);
        TableColumn indexColumn = this.getColumnModel().getColumn(1);
        indexColumn.setPreferredWidth(width);
        indexColumn.setMaxWidth(width);
        indexColumn.setMinWidth(width);
        TableColumn visibilityColumn = this.getColumnModel().getColumn(2);
        visibilityColumn.setPreferredWidth(width);
        visibilityColumn.setMaxWidth(width);
        visibilityColumn.setMinWidth(width);
        TableColumn lockColumn = this.getColumnModel().getColumn(3);
        lockColumn.setPreferredWidth(width);
        lockColumn.setMaxWidth(width);
        lockColumn.setMinWidth(width);
        this.setDefaultEditor(Boolean.class, new BooleanTableCellRenderer(4, 4));
        this.setDefaultRenderer(Boolean.class, new BooleanTableCellRenderer(4, 4));
        this.setDefaultRenderer(Layer.class, new LayerTableCellRenderer());
        this.setDefaultEditor(String.class, new NonEmptyStringTableCellEditor());
        this.setDefaultRenderer(Integer.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setHorizontalAlignment(0);
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        TableColumn posXColumn = this.getColumnModel().getColumn(5);
        posXColumn.setPreferredWidth(width + 10);
        posXColumn.setMaxWidth(width + 10);
        posXColumn.setMinWidth(width + 10);
        TableColumn posYColumn = this.getColumnModel().getColumn(6);
        posYColumn.setPreferredWidth(width + 10);
        posYColumn.setMaxWidth(width + 10);
        posYColumn.setMinWidth(width + 10);
        this.setShowVerticalLines(false);
        this.setSelectionMode(2);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return super.getPreferredSize();
    }

    private class TableDropTarget
    extends DropTargetAdapter {
        private TableDropTarget() {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Point dropPoint = dtde.getLocation();
            int dropRow = SceneLayerNavigator.this.rowAtPoint(dropPoint);
            Transferable transferable = dtde.getTransferable();
            try {
                LayerDataFlavor layerFlavor = new LayerDataFlavor();
                if (transferable.isDataFlavorSupported(layerFlavor)) {
                    dtde.acceptDrop(2);
                    Layer layer = (Layer)transferable.getTransferData(layerFlavor);
                    SceneLayerNavigator.this.scene.insert(layer, dropRow);
                    dtde.dropComplete(true);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                dtde.dropComplete(false);
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
                dtde.dropComplete(false);
            }
            catch (IOException e) {
                e.printStackTrace();
                dtde.dropComplete(false);
            }
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }
    }

    private class DGL
    extends DragSourceAdapter
    implements DragGestureListener {
        private DGL() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            Point dragOrigin = dge.getDragOrigin();
            int srcRow = SceneLayerNavigator.this.rowAtPoint(dragOrigin);
            Layer payload = SceneLayerNavigator.this.scene.getLayerAt(srcRow);
            SceneLayerNavigator.this.setRowSelectionInterval(srcRow, srcRow);
            dge.startDrag(null, payload, this);
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            super.dragDropEnd(dsde);
            if (dsde.getDropSuccess()) {
                // empty if block
            }
        }
    }

    private class ExternalSceneSelectionListener
    implements SceneSelectionListener {
        private ExternalSceneSelectionListener() {
        }

        @Override
        public void layerSelectionChanged(Scene sourceScene, Layer layer, boolean selected) {
            int index = SceneLayerNavigator.this.scene.indexOf(layer);
            if (selected) {
                SceneLayerNavigator.this.getSelectionModel().addSelectionInterval(index, index);
            } else {
                SceneLayerNavigator.this.getSelectionModel().removeSelectionInterval(index, index);
            }
        }
    }

    private class SceneTableSelectionListener
    implements ListSelectionListener {
        private SceneTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int minIndex = e.getFirstIndex();
            int maxIndex = e.getLastIndex();
            int maxToTest = Math.min(maxIndex, SceneLayerNavigator.this.scene.getLayerCount() - 1);
            for (int i = minIndex; i <= maxToTest; ++i) {
                Layer layer = SceneLayerNavigator.this.scene.getLayerAt(i);
                SceneLayerNavigator.this.scene.setLayerSelected(layer, SceneLayerNavigator.this.getSelectionModel().isSelectedIndex(i));
            }
        }
    }
}

