/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.editor.tiledlayer;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DebugGraphics;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.netbeans.modules.vmd.game.dialog.DuplicateTiledLayerDialog;
import org.netbeans.modules.vmd.game.dialog.NewSimpleTiledLayerDialog;
import org.netbeans.modules.vmd.game.model.AnimatedTile;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.Layer;
import org.netbeans.modules.vmd.game.model.Position;
import org.netbeans.modules.vmd.game.model.Tile;
import org.netbeans.modules.vmd.game.model.TileDataFlavor;
import org.netbeans.modules.vmd.game.model.TiledLayer;
import org.netbeans.modules.vmd.game.model.TiledLayerListener;
import org.netbeans.modules.vmd.game.view.ColorConstants;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class TiledLayerEditorComponent
extends JComponent
implements MouseListener,
Scrollable,
TiledLayerListener {
    public static final boolean DEBUG = false;
    public static final byte GRID_MODE_DOTS = 0;
    public static final byte GRID_MODE_LINES = 1;
    public static final byte GRID_MODE_NOGRID = 2;
    private static final Color GRID_COLOR;
    private static final Color ANIMATED_TILE_GRID_COLOR;
    private static final Color INCORRECT_TILE_GRID_COLOR;
    private static final Color HILITE_COLOR;
    private static final float ZOOM_STEP = 1.1f;
    private static final String[] ZOOM_VALUES;
    private static final int CELL_BORDER_WIDTH = 0;
    private static final int SELECTION_BORDER_WIDTH = 2;
    private byte gridMode = 1;
    private int gridWidth = 1;
    private TiledLayer tiledLayer;
    private int paintTileIndex = 0;
    private Color currentSelectedColor = Color.getHSBColor(0.0f, 1.0f, 0.0f);
    private int cellWidth;
    private int cellHeight;
    private Position cellHiLited;
    private Set<Position> cellsSelected = Collections.synchronizedSet(new HashSet());
    private Timer timer;
    RulerHorizontal rulerHorizontal;
    RulerVertical rulerVertical;
    public static final int EDIT_MODE_PAINT = 0;
    public static final int EDIT_MODE_SELECT = 1;
    public static final String PAINT_CURSOR_NAME = "CUSTOM_PAINT_CURSOR";
    private int editMode;
    private boolean autoResizable;
    private float zoom = 1.0f;
    private static Cursor paintCursor;
    private static Cursor selectionCursor;
    private Position firstDraggedCell;
    private Position lastDraggedCell;
    private GridButton gridButton = new GridButton();

    public TiledLayerEditorComponent(TiledLayer tiledLayer) {
        this.setTiledLayer(tiledLayer);
        this.tiledLayer.addTiledLayerListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(new PaintMotionListener());
        this.setAutoscrolls(true);
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new HiliteAnimator(), 0L, 100L);
        ToolTipManager.sharedInstance().registerComponent(this);
        DropTarget dropTarget = new DropTarget(this, new TiledLayerDropTargetListener());
        dropTarget.setActive(true);
        this.setDropTarget(dropTarget);
        this.rulerHorizontal = new RulerHorizontal();
        this.rulerVertical = new RulerVertical();
        this.setEditMode(0);
        this.setAutoResizable(true);
        this.putClientProperty("print.printable", Boolean.TRUE);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void setGridMode(byte gridMode) {
        this.gridMode = gridMode;
        this.gridWidth = this.gridMode == 2 ? 0 : 1;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Position cell = this.getCellAtPoint(event.getPoint());
        int index = this.tiledLayer.getTileIndexAt(cell);
        if (index < 0) {
            AnimatedTile tile = (AnimatedTile)this.tiledLayer.getTileAt(cell);
            return NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.animTile.tooltip", (Object[])new Object[]{tile.getName(), cell.getRow(), cell.getCol()});
        }
        return NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.tile.tooltip", (Object[])new Object[]{index, cell.getRow(), cell.getCol()});
    }

    @Override
    public Dimension getPreferredSize() {
        int width = this.gridWidth + (this.cellWidth + this.gridWidth) * this.tiledLayer.getColumnCount();
        int height = this.gridWidth + (this.cellHeight + this.gridWidth) * this.tiledLayer.getRowCount();
        return new Dimension(width, height);
    }

    public void setTiledLayer(TiledLayer tiledLayer) {
        this.tiledLayer = tiledLayer;
        this.updateCellSize(tiledLayer);
    }

    private void updateCellSize(TiledLayer tiledLayer) {
        this.cellWidth = (int)((float)this.tiledLayer.getTileWidth() * this.getZoom()) + 0;
        this.cellHeight = (int)((float)this.tiledLayer.getTileHeight() * this.getZoom()) + 0;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (g instanceof DebugGraphics) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        if (this.gridMode == 0) {
            this.paintGridDots(g2d);
        } else {
            this.paintGridLines(g2d);
        }
        this.paintCells(g2d);
        if (this.cellHiLited != null) {
            this.paintGridHiLite((Graphics2D)g, this.cellHiLited, ColorConstants.COLOR_OUTLINE_SELECTED);
        }
    }

    protected void setZoom(float zoomNew) {
        this.zoom = zoomNew;
        this.updateCellSize(this.tiledLayer);
        this.revalidate();
        this.repaint();
        this.rulerHorizontal.repaint();
        this.rulerVertical.repaint();
    }

    protected float getZoom() {
        return this.zoom;
    }

    private void paintGridDots(Graphics2D g) {
        g.setColor(Color.BLACK);
        for (int horizontal = 0; horizontal < this.getHeight(); horizontal += this.cellHeight + this.gridWidth) {
            for (int vertical = 0; vertical < this.getWidth(); vertical += this.cellWidth + this.gridWidth) {
                g.fillRect(vertical, horizontal, 1, 1);
            }
        }
    }

    private void paintGridLines(Graphics2D g) {
        g.setColor(GRID_COLOR);
        for (int horizontal = 0; horizontal < this.getHeight(); horizontal += this.cellHeight + this.gridWidth) {
            g.fillRect(0, horizontal, this.getWidth(), this.gridWidth);
        }
        for (int vertical = 0; vertical < this.getWidth(); vertical += this.cellWidth + this.gridWidth) {
            g.fillRect(vertical, 0, this.gridWidth, this.getHeight());
        }
    }

    private int[] getVisibleCellBounds() {
        int[] ret = new int[4];
        Rectangle rect = this.getVisibleRect();
        Position topLeft = this.getCellAtPoint(rect.getLocation());
        Position bottomRight = this.getCellAtCoordinates(rect.getLocation().x + rect.width, rect.getLocation().y + rect.height);
        ret[0] = topLeft.getRow();
        ret[1] = topLeft.getCol();
        ret[2] = bottomRight.getRow();
        ret[3] = bottomRight.getCol();
        return ret;
    }

    void paintCells(Graphics2D g) {
        Rectangle rect = g.getClipBounds();
        Position topLeft = this.getCellAtPoint(rect.getLocation());
        Position bottomRight = this.getCellAtCoordinates(rect.getLocation().x + rect.width, rect.getLocation().y + rect.height);
        boolean haveIncorrectTiles = false;
        for (int row = topLeft.getRow(); row <= bottomRight.getRow(); ++row) {
            for (int col = topLeft.getCol(); col <= bottomRight.getCol(); ++col) {
                Position cell = new Position(row, col);
                if (this.paintCellContents(g, cell)) {
                    if (this.currentSelectedColor != null && this.cellsSelected.contains(cell)) {
                        this.paintCellSelection(g, cell, this.currentSelectedColor);
                    }
                    if (this.tiledLayer.getTileAt(cell).getIndex() >= 0) continue;
                    this.paintGridHiLite(g, cell, ANIMATED_TILE_GRID_COLOR);
                    continue;
                }
                this.paintGridHiLite(g, cell, INCORRECT_TILE_GRID_COLOR);
                haveIncorrectTiles = true;
            }
        }
        if (haveIncorrectTiles) {
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.incorrectTileIndex.errorMessage"), 0));
        }
    }

    private boolean paintCellContents(Graphics2D g, Position cell) {
        Tile tile = this.tiledLayer.getTileAt(cell.getRow(), cell.getCol());
        if (tile != null) {
            Rectangle rect = this.getCellArea(cell);
            int x = rect.x + 0;
            int y = rect.y + 0;
            int width = (int)((float)tile.getWidth() * this.getZoom());
            int height = (int)((float)tile.getHeight() * this.getZoom());
            tile.paint(g, x, y, width, height);
            return true;
        }
        return false;
    }

    private void paintCellSelection(Graphics2D g, Position cell, Color color) {
        Rectangle rect = this.getCellArea(cell);
        g.setColor(color);
        g.fillRect(rect.x, rect.y, rect.width, 2);
        g.fillRect(rect.x, rect.y, 2, rect.height - this.gridWidth * 2);
        g.fillRect(rect.x + (rect.width - 2), rect.y, 2, rect.height);
        g.fillRect(rect.x, rect.y + (rect.height - 2), rect.width, 2);
    }

    private void paintGridHiLite(Graphics2D g, Position cell, Color color) {
        Rectangle rect = this.getCellArea(cell);
        g.setColor(color);
        g.fillRect(rect.x, rect.y, rect.width, this.gridWidth);
        g.fillRect(rect.x, rect.y, this.gridWidth, rect.height);
        g.fillRect(rect.x + (rect.width - this.gridWidth), rect.y, this.gridWidth, rect.height);
        g.fillRect(rect.x, rect.y + (rect.height - this.gridWidth), rect.width, this.gridWidth);
    }

    TiledLayer getTiledLayer() {
        return this.tiledLayer;
    }

    private Position getCellAtPoint(Point p) {
        return this.getCellAtCoordinates(p.x, p.y);
    }

    private Position getCellAtCoordinates(int x, int y) {
        int row = (y - this.gridWidth) / (this.cellHeight + this.gridWidth);
        int col = (x - this.gridWidth) / (this.cellWidth + this.gridWidth);
        if (x < 0) {
            --col;
        }
        if (y < 0) {
            --row;
        }
        return new Position(row, col);
    }

    private Rectangle getCellArea(Position cell) {
        return this.getCellArea(cell.getRow(), cell.getCol());
    }

    private Rectangle getCellArea(int row, int col) {
        Rectangle cellArea = new Rectangle((this.cellWidth + this.gridWidth) * col + this.gridWidth, (this.cellHeight + this.gridWidth) * row + this.gridWidth, this.cellWidth, this.cellHeight);
        return cellArea;
    }

    void setPaintTileIndex(int index) {
        this.paintTileIndex = index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectByIndex(int index) {
        Set<Position> set = this.cellsSelected;
        synchronized (set) {
            for (int r = 0; r < this.tiledLayer.getRowCount(); ++r) {
                for (int c = 0; c < this.tiledLayer.getColumnCount(); ++c) {
                    if (this.tiledLayer.getTileAt(r, c).getIndex() != index) continue;
                    this.cellsSelected.add(new Position(r, c));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectAll() {
        Set<Position> set = this.cellsSelected;
        synchronized (set) {
            for (int r = 0; r < this.tiledLayer.getRowCount(); ++r) {
                for (int c = 0; c < this.tiledLayer.getColumnCount(); ++c) {
                    this.cellsSelected.add(new Position(r, c));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invertSelection() {
        Set<Position> set = this.cellsSelected;
        synchronized (set) {
            for (int r = 0; r < this.tiledLayer.getRowCount(); ++r) {
                for (int c = 0; c < this.tiledLayer.getColumnCount(); ++c) {
                    Position p = new Position(r, c);
                    if (this.cellsSelected.contains(p)) {
                        this.cellsSelected.remove(p);
                        continue;
                    }
                    this.cellsSelected.add(p);
                }
            }
        }
        this.repaint();
    }

    public void setEditMode(int editMode) {
        this.editMode = editMode;
        this.setCursor(editMode == 0 ? paintCursor : selectionCursor);
        if (editMode == 0) {
            this.clearSelection();
            this.repaint();
        }
    }

    private boolean isPaintMode() {
        return this.editMode == 0;
    }

    private boolean isSelectMode() {
        return this.editMode == 1;
    }

    public void setAutoResizable(boolean isAutoResizable) {
        this.autoResizable = isAutoResizable;
    }

    private boolean isAutoResizable() {
        return this.autoResizable;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.handleMouseClicked(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.doPopUp(e);
        } else {
            this.handleMousePressed(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.firstDraggedCell = null;
        this.lastDraggedCell = null;
        if (e.isPopupTrigger()) {
            this.doPopUp(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        Position oldHilited = this.cellHiLited;
        this.cellHiLited = null;
        if (oldHilited != null) {
            this.repaint(this.getCellArea(oldHilited));
        }
    }

    private void handleMouseClicked(MouseEvent e) {
        this.firstDraggedCell = null;
        this.lastDraggedCell = null;
        Position cell = this.getCellAtCoordinates(e.getX(), e.getY());
        if (SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        if (this.isSelectMode()) {
            if (e.getClickCount() >= 2 && !SwingUtilities.isRightMouseButton(e)) {
                this.selectByIndex(this.tiledLayer.getTileAt(cell.getRow(), cell.getCol()).getIndex());
            }
            this.tiledLayer.getGameDesign().getMainView().requestPreview(this.tiledLayer.getTileAt(cell.getRow(), cell.getCol()));
        } else if (this.isPaintMode()) {
            // empty if block
        }
        this.repaint(this.getCellArea(cell));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMousePressed(MouseEvent e) {
        Position cell;
        if (this.isPaintMode() && !SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        this.firstDraggedCell = cell = this.getCellAtCoordinates(e.getX(), e.getY());
        this.lastDraggedCell = cell;
        if (this.isSelectMode()) {
            Set<Position> set = this.cellsSelected;
            synchronized (set) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (e.isControlDown()) {
                        if (!this.cellsSelected.remove(cell)) {
                            this.cellsSelected.add(cell);
                        }
                    } else if (e.isMetaDown() || e.isShiftDown()) {
                        this.cellsSelected.add(cell);
                    } else {
                        this.clearSelection();
                        this.cellsSelected.add(cell);
                    }
                } else if (!this.cellsSelected.contains(cell)) {
                    this.clearSelection();
                    this.cellsSelected.add(cell);
                }
            }
        } else if (this.isPaintMode()) {
            this.tiledLayer.setTileAt(this.paintTileIndex, cell.getRow(), cell.getCol());
            Set<Position> oldSelected = this.cellsSelected;
            this.cellsSelected = new HashSet<Position>();
            for (Position oldSelCel : oldSelected) {
                this.repaint(this.getCellArea(oldSelCel));
            }
            this.clearRulersSelection();
        }
        this.repaint();
        this.tiledLayer.getGameDesign().getMainView().requestPreview(this.tiledLayer.getTileAt(cell.getRow(), cell.getCol()));
    }

    private void doPopUp(MouseEvent e) {
        Position position = this.getCellAtPoint(e.getPoint());
        DuplicateTiledLayerAction dtl = new DuplicateTiledLayerAction();
        CreateFromSelectionAction cfs = new CreateFromSelectionAction();
        EraseSelectionAction es = new EraseSelectionAction();
        if (this.cellsSelected.size() < 1) {
            cfs.setEnabled(false);
            es.setEnabled(false);
        }
        SelectRowAction sr = new SelectRowAction();
        sr.putValue("PROP_POSITION", position);
        SelectColumnAction sc = new SelectColumnAction();
        sc.putValue("PROP_POSITION", position);
        SelectByIndexAction sbi = new SelectByIndexAction();
        sbi.putValue("PROP_POSITION", position);
        SelectAllAction sa = new SelectAllAction();
        InvertSelectionAction is = new InvertSelectionAction();
        PrependRowAction pr = new PrependRowAction();
        pr.putValue("PROP_POSITION", position);
        AppendRowAction ar = new AppendRowAction();
        ar.putValue("PROP_POSITION", position);
        PrependColumnAction pc = new PrependColumnAction();
        pc.putValue("PROP_POSITION", position);
        AppendColumnAction ac = new AppendColumnAction();
        ac.putValue("PROP_POSITION", position);
        DeleteRowAction dr = new DeleteRowAction();
        dr.putValue("PROP_POSITION", position);
        DeleteColumnAction dc = new DeleteColumnAction();
        dc.putValue("PROP_POSITION", position);
        TrimToSizeAction tts = new TrimToSizeAction();
        JCheckBoxMenuItem itemPaint = new JCheckBoxMenuItem(NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.menuModePaint.txt"), this.editMode == 0);
        itemPaint.addItemListener(new EditModeListener(0));
        JCheckBoxMenuItem itemSelect = new JCheckBoxMenuItem(NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.menuModeSelect.txt"), this.editMode == 1);
        itemSelect.addItemListener(new EditModeListener(1));
        JPopupMenu menu = new JPopupMenu();
        menu.add(dtl);
        List<Action> actions = this.tiledLayer.getActions();
        for (Action action : actions) {
            if (action instanceof Layer.EditLayerAction) continue;
            menu.add(action);
        }
        menu.addSeparator();
        menu.add(cfs);
        menu.add(es);
        JMenu selecttionSubMenu = new JMenu(NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.menuSelect.txt"));
        selecttionSubMenu.add(selecttionSubMenu);
        selecttionSubMenu.add(sr);
        selecttionSubMenu.add(sc);
        selecttionSubMenu.add(sbi);
        selecttionSubMenu.add(sa);
        selecttionSubMenu.add(is);
        menu.add(selecttionSubMenu);
        menu.addSeparator();
        menu.add(pr);
        menu.add(ar);
        menu.add(pc);
        menu.add(ac);
        menu.addSeparator();
        menu.add(dr);
        menu.add(dc);
        menu.addSeparator();
        menu.add(tts);
        menu.show(this, e.getX(), e.getY());
    }

    private boolean isRowSelected(int row) {
        int cols = this.tiledLayer.getColumnCount();
        for (int col = 0; col < cols; ++col) {
            if (this.cellsSelected.contains(new Position(row, col))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRowSelection(int row, boolean selected) {
        Set<Position> set = this.cellsSelected;
        synchronized (set) {
            if (selected) {
                int cols = this.tiledLayer.getColumnCount();
                for (int i = 0; i < cols; ++i) {
                    this.cellsSelected.add(new Position(row, i));
                }
                this.rulerVertical.pressRowHeader(row);
            } else {
                Iterator<Position> it = this.cellsSelected.iterator();
                while (it.hasNext()) {
                    Position position = it.next();
                    if (position.getRow() != row) continue;
                    it.remove();
                }
                this.rulerVertical.releaseRowHeader(row);
            }
        }
        this.repaint();
    }

    private boolean isColumnsSelected(int col) {
        int rows = this.tiledLayer.getRowCount();
        for (int row = 0; row < rows; ++row) {
            if (this.cellsSelected.contains(new Position(row, col))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSelection() {
        Set<Position> set = this.cellsSelected;
        synchronized (set) {
            this.cellsSelected.clear();
        }
        this.clearRulersSelection();
    }

    private void clearRulersSelection() {
        this.rulerHorizontal.clearSelection();
        this.rulerVertical.clearSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setColumnSelection(int col, boolean selected) {
        Set<Position> set = this.cellsSelected;
        synchronized (set) {
            if (selected) {
                int rows = this.tiledLayer.getRowCount();
                for (int row = 0; row < rows; ++row) {
                    this.cellsSelected.add(new Position(row, col));
                }
                this.rulerHorizontal.pressColumnHeader(col);
            } else {
                Iterator<Position> it = this.cellsSelected.iterator();
                while (it.hasNext()) {
                    Position position = it.next();
                    if (position.getCol() != col) continue;
                    it.remove();
                }
                this.rulerHorizontal.releaseColumnHeader(col);
            }
        }
        this.repaint();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return this.tiledLayer.getTileWidth();
        }
        return this.tiledLayer.getTileHeight();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return this.tiledLayer.getTileWidth();
        }
        return this.tiledLayer.getTileHeight();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    private boolean isCellVisible(Position cell) {
        return this.getVisibleRect().intersects(this.getCellArea(cell));
    }

    private void updateHiLite(Point point) {
        Position oldHilited = this.cellHiLited;
        Position cell = this.getCellAtPoint(point);
        if (cell == null) {
            return;
        }
        if (!cell.equals(oldHilited)) {
            this.cellHiLited = cell;
            if (oldHilited != null) {
                this.repaint(this.getCellArea(oldHilited));
            }
            this.repaint(this.getCellArea(this.cellHiLited));
        }
    }

    @Override
    public void tileChanged(TiledLayer tiledLayer, int row, int col) {
        this.repaint(this.getCellArea(row, col));
    }

    @Override
    public void tilesChanged(TiledLayer tiledLayer, Set positions) {
        this.revalidate();
        this.repaint();
    }

    @Override
    public void tilesStructureChanged(TiledLayer source) {
        this.revalidate();
        this.repaint();
    }

    @Override
    public void columnsInserted(TiledLayer tiledLayer, int index, int count) {
        this.shiftSelectedCellColumns(index, count);
        this.revalidate();
        this.repaint();
        this.rulerHorizontal.repaint();
    }

    @Override
    public void columnsRemoved(TiledLayer tiledLayer, int index, int count) {
        this.shiftSelectedCellColumns(index, -count);
        this.trimSelectedCellsToSize();
        this.revalidate();
        this.repaint();
        this.rulerHorizontal.repaint();
    }

    @Override
    public void rowsInserted(TiledLayer tiledLayer, int index, int count) {
        this.shiftSelectedCellRows(index, count);
        this.revalidate();
        this.repaint();
        this.rulerVertical.repaint();
    }

    @Override
    public void rowsRemoved(TiledLayer tiledLayer, int index, int count) {
        this.shiftSelectedCellRows(index, -count);
        this.trimSelectedCellsToSize();
        this.revalidate();
        this.repaint();
        this.rulerVertical.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimSelectedCellsToSize() {
        HashSet<Position> bucket = new HashSet<Position>();
        Set<Position> set = this.cellsSelected;
        synchronized (set) {
            for (Position cell : this.cellsSelected) {
                if (cell.getRow() < this.tiledLayer.getRowCount() && cell.getCol() < this.tiledLayer.getColumnCount()) continue;
                bucket.add(cell);
            }
            this.cellsSelected.removeAll(bucket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shiftSelectedCellRows(int index, int count) {
        Set<Position> set = this.cellsSelected;
        synchronized (set) {
            ArrayList<Position> bucket = new ArrayList<Position>();
            HashSet<Integer> releaseRows = new HashSet<Integer>();
            HashSet<Integer> pressRows = new HashSet<Integer>();
            Iterator<Position> it = this.cellsSelected.iterator();
            while (it.hasNext()) {
                Position position = it.next();
                int curRow = position.getRow();
                if (curRow < index) continue;
                it.remove();
                bucket.add(new Position(curRow + count, position.getCol()));
                releaseRows.add(curRow);
                pressRows.add(curRow + count);
            }
            for (Position position : bucket) {
                this.cellsSelected.add(position);
            }
            for (Integer row : releaseRows) {
                if (!pressRows.contains(row)) {
                    this.rulerVertical.releaseRowHeader(row);
                }
                this.rulerVertical.pressRowHeader(row + count);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shiftSelectedCellColumns(int index, int count) {
        Set<Position> set = this.cellsSelected;
        synchronized (set) {
            ArrayList<Position> bucket = new ArrayList<Position>();
            HashSet<Integer> releaseCols = new HashSet<Integer>();
            HashSet<Integer> pressCols = new HashSet<Integer>();
            Iterator<Position> it = this.cellsSelected.iterator();
            while (it.hasNext()) {
                Position position = it.next();
                int curCol = position.getCol();
                if (curCol < index) continue;
                it.remove();
                bucket.add(new Position(position.getRow(), curCol + count));
                releaseCols.add(curCol);
                pressCols.add(curCol + count);
            }
            for (Position position : bucket) {
                this.cellsSelected.add(position);
            }
            for (Integer col : releaseCols) {
                if (!pressCols.contains(col)) {
                    this.rulerHorizontal.releaseColumnHeader(col);
                }
                this.rulerHorizontal.pressColumnHeader(col + count);
            }
        }
    }

    public JComponent getGridButton() {
        return this.gridButton;
    }

    static {
        Image cursor;
        GRID_COLOR = ColorConstants.COLOR_OUTLINE_PLAIN;
        ANIMATED_TILE_GRID_COLOR = Color.CYAN;
        INCORRECT_TILE_GRID_COLOR = Color.RED;
        HILITE_COLOR = new Color(0, 0, 255, 20);
        ZOOM_VALUES = new String[]{"400%", "300%", "200%", "100%", "75%", "50%", "25%"};
        URL cursorUrl = TiledLayerEditorComponent.class.getResource("res/drawing_mode_mouse_16.png");
        ImageIcon cursorIcon = new ImageIcon(cursorUrl);
        Dimension d = Toolkit.getDefaultToolkit().getBestCursorSize(cursorIcon.getIconWidth(), cursorIcon.getIconHeight());
        if (d.width > cursorIcon.getIconWidth() && d.height > cursorIcon.getIconHeight()) {
            cursor = new BufferedImage(d.width, d.height, 2);
            cursor.getGraphics().drawImage(cursorIcon.getImage(), 0, 0, null);
        } else {
            cursor = cursorIcon.getImage();
        }
        paintCursor = Toolkit.getDefaultToolkit().createCustomCursor(cursor, new Point(7, 7), PAINT_CURSOR_NAME);
        cursorUrl = TiledLayerEditorComponent.class.getResource("res/select_mode_mouse_16.png");
        cursorIcon = new ImageIcon(cursorUrl);
        selectionCursor = Cursor.getDefaultCursor();
    }

    private abstract class DeleteSelectedRowsColsAction
    extends AbstractAction {
        private DeleteSelectedRowsColsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int count = this.getCount();
            int selStart = -1;
            int selCount = 0;
            boolean selected = false;
            for (int idx = 0; idx < count; ++idx) {
                selected = this.isSelected(idx);
                if (selected) {
                    if (selStart == -1) {
                        selStart = idx;
                    }
                    ++selCount;
                    this.setSelection(idx, false);
                }
                if (selected && idx != count - 1 || selCount <= 0) continue;
                this.delete(selStart, selCount);
                idx = selStart;
                count = this.getCount();
                selStart = -1;
                selCount = 0;
            }
        }

        protected abstract boolean isSelected(int var1);

        protected abstract void setSelection(int var1, boolean var2);

        protected abstract int getCount();

        protected abstract void delete(int var1, int var2);
    }

    class RulerHorizontal
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        private static final int SIZE = 14;
        private static final boolean DEBUG = false;
        private Set<Integer> pressed = new HashSet<Integer>();
        private int hilitedColumnHeader = -1;

        public RulerHorizontal() {
            ToolTipManager.sharedInstance().registerComponent(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            HorizontalRulerSelection selection = new HorizontalRulerSelection();
            this.addMouseListener(selection);
            this.addMouseMotionListener(selection);
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            return NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.horizontalRuler.tooltip", (Object)this.getColumnAtPoint(event.getPoint()));
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = TiledLayerEditorComponent.this.getPreferredSize();
            size.height = 14;
            return size;
        }

        @Override
        protected void paintComponent(Graphics graphincs) {
            int col;
            Graphics2D g = (Graphics2D)graphincs;
            Rectangle rect = g.getClipBounds();
            g.setColor(Color.WHITE);
            g.fill(rect);
            int unit = TiledLayerEditorComponent.this.gridWidth + TiledLayerEditorComponent.this.cellWidth;
            for (int x = rect.x / unit * unit; x <= rect.x + rect.width && (col = x / unit) < TiledLayerEditorComponent.this.tiledLayer.getColumnCount(); x += unit) {
                boolean raised = true;
                g.setColor(new Color(240, 238, 230));
                if (this.pressed.contains(col)) {
                    g.setColor(new Color(200, 200, 200));
                    raised = false;
                }
                g.fill3DRect(x + TiledLayerEditorComponent.this.gridWidth / 2, 0, unit, 14, raised);
                if (col != this.hilitedColumnHeader) continue;
                g.setColor(HILITE_COLOR);
                g.fill3DRect(x + TiledLayerEditorComponent.this.gridWidth / 2, 0, unit, 14, raised);
            }
        }

        protected void clearSelection() {
            if (!this.pressed.isEmpty()) {
                this.pressed.clear();
                this.repaint();
            }
        }

        private int getColumnAtPoint(Point point) {
            return this.getColumnAtCoordinates(point.x, point.y);
        }

        private int getColumnAtCoordinates(int x, int y) {
            return (x - TiledLayerEditorComponent.this.gridWidth) / (TiledLayerEditorComponent.this.cellWidth + TiledLayerEditorComponent.this.gridWidth);
        }

        private Rectangle getColumnHeaderArea(int col) {
            Rectangle area = new Rectangle((TiledLayerEditorComponent.this.cellWidth + TiledLayerEditorComponent.this.gridWidth) * col + TiledLayerEditorComponent.this.gridWidth / 2, 0, TiledLayerEditorComponent.this.cellWidth + TiledLayerEditorComponent.this.gridWidth, 14);
            return area;
        }

        private void hiliteColumnHeader(int col) {
            if (this.hilitedColumnHeader == col) {
                return;
            }
            int oldHilited = this.hilitedColumnHeader;
            this.hilitedColumnHeader = col;
            this.repaint(this.getColumnHeaderArea(col));
            this.repaint(this.getColumnHeaderArea(oldHilited));
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.hiliteColumnHeader(-1);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int col = this.getColumnAtPoint(e.getPoint());
            this.hiliteColumnHeader(col);
        }

        protected void pressColumnHeader(int col) {
            this.pressed.add(col);
            this.repaint(this.getColumnHeaderArea(col));
        }

        protected void releaseColumnHeader(int col) {
            this.pressed.remove(col);
            this.repaint(this.getColumnHeaderArea(col));
        }

        private void handlePopUp(MouseEvent e) {
            int col = this.getColumnAtPoint(e.getPoint());
            JPopupMenu menu = this.createRulerPopupMenu(col);
            menu.show(this, e.getX(), e.getY());
            this.hiliteColumnHeader(col);
        }

        private JPopupMenu createRulerPopupMenu(int col) {
            JPopupMenu menu = new JPopupMenu();
            for (Action action : this.getActions()) {
                action.putValue("COLUMN", new Integer(col));
                menu.add(action);
            }
            return menu;
        }

        public List getActions() {
            ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
            actions.add(new DeleteSelectedColsAction());
            actions.add(new PrependColAction());
            actions.add(new AppendColAction());
            return Collections.unmodifiableList(actions);
        }

        private class AppendColAction
        extends AbstractAction {
            private AppendColAction() {
                this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.horizontalRuler.actionAppendCol.txt"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int col = (Integer)this.getValue("COLUMN");
                TiledLayerEditorComponent.this.tiledLayer.insertColumns(col + 1, 1);
            }
        }

        private class PrependColAction
        extends AbstractAction {
            private PrependColAction() {
                this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.horizontalRuler.actionPrependCol.txt"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int col = (Integer)this.getValue("COLUMN");
                TiledLayerEditorComponent.this.tiledLayer.insertColumns(col, 1);
            }
        }

        private class DeleteColAction
        extends AbstractAction {
            private DeleteColAction() {
                this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.horizontalRuler.actionDeleteCol.txt"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int col = (Integer)this.getValue("COLUMN");
                TiledLayerEditorComponent.this.setColumnSelection(col, false);
                TiledLayerEditorComponent.this.tiledLayer.deleteColumns(col, 1);
            }
        }

        private class DeleteSelectedColsAction
        extends DeleteSelectedRowsColsAction {
            private DeleteSelectedColsAction() {
                this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.horizontalRuler.actionDeleteSelectedCols.txt"));
            }

            @Override
            protected boolean isSelected(int idx) {
                return TiledLayerEditorComponent.this.isColumnsSelected(idx);
            }

            @Override
            protected void setSelection(int idx, boolean selected) {
                TiledLayerEditorComponent.this.setColumnSelection(idx, selected);
            }

            @Override
            protected int getCount() {
                return TiledLayerEditorComponent.this.tiledLayer.getColumnCount();
            }

            @Override
            protected void delete(int idx, int count) {
                TiledLayerEditorComponent.this.tiledLayer.deleteColumns(idx, count);
            }
        }

        private class HorizontalRulerSelection
        extends AbstractRulerSelection {
            private HorizontalRulerSelection() {
            }

            @Override
            protected int getItemAtPoint(Point point) {
                return RulerHorizontal.this.getColumnAtPoint(point);
            }

            @Override
            protected void handlePopUp(MouseEvent e) {
                RulerHorizontal.this.handlePopUp(e);
            }

            @Override
            protected void setSelection(int idx, boolean select) {
                TiledLayerEditorComponent.this.setColumnSelection(idx, select);
            }

            @Override
            protected boolean isSelected(int idx) {
                return TiledLayerEditorComponent.this.isColumnsSelected(idx);
            }
        }
    }

    abstract class AbstractRulerSelection
    implements MouseListener,
    MouseMotionListener {
        private int firstEntered = -1;
        private int lastEntered = -1;
        private int lastExited = -1;
        private boolean selectState = true;

        AbstractRulerSelection() {
        }

        protected abstract int getItemAtPoint(Point var1);

        protected abstract void handlePopUp(MouseEvent var1);

        protected abstract void setSelection(int var1, boolean var2);

        protected abstract boolean isSelected(int var1);

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int item = this.getItemAtPoint(e.getPoint());
            if (e.isPopupTrigger()) {
                this.handlePopUp(e);
            } else if (SwingUtilities.isLeftMouseButton(e)) {
                if (!e.isControlDown()) {
                    TiledLayerEditorComponent.this.clearSelection();
                }
                this.firstEntered = item;
                this.lastEntered = item;
                this.selectState = this.reverseSelection(item);
            } else {
                boolean selected = this.isSelected(item);
                if (!selected) {
                    TiledLayerEditorComponent.this.clearSelection();
                    this.setSelection(item, true);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.handlePopUp(e);
            } else {
                this.lastEntered = -1;
                this.lastExited = -1;
                this.firstEntered = -1;
                this.selectState = true;
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int idx = this.getItemAtPoint(e.getPoint());
            if (idx == this.lastEntered || this.lastEntered == -1) {
                return;
            }
            if (this.haveMissedItems(this.lastEntered, idx)) {
                this.dragToMissedItems(this.lastEntered, idx);
            } else {
                this.processDragged(idx);
            }
        }

        private void dragToMissedItems(int prevIdx, int currIdx) {
            int sign = (int)Math.signum(currIdx - prevIdx);
            if (sign == 0) {
                return;
            }
            for (int i = prevIdx; i != currIdx; i += sign) {
                this.processDragged(i + sign);
            }
        }

        private boolean haveMissedItems(int prevIdx, int currIdx) {
            return Math.abs(prevIdx - currIdx) > 1;
        }

        private void processDragged(int idx) {
            this.lastExited = this.lastEntered;
            this.lastEntered = idx;
            if (this.isMovingFromFirst()) {
                this.setSelection(idx, this.selectState);
            } else {
                this.reverseSelection(this.lastExited);
            }
        }

        private boolean reverseSelection(int idx) {
            boolean select = !this.isSelected(idx);
            this.setSelection(idx, select);
            return select;
        }

        private boolean isMovingFromFirst() {
            if (this.lastExited == -1) {
                return false;
            }
            return Math.abs(this.lastExited - this.firstEntered) < Math.abs(this.lastEntered - this.firstEntered);
        }
    }

    class RulerVertical
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        private static final int SIZE = 14;
        private static final boolean DEBUG = false;
        private Set<Integer> pressed = new HashSet<Integer>();
        private int hilitedRowHeader = -1;

        public RulerVertical() {
            ToolTipManager.sharedInstance().registerComponent(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            VerticalRulerSelection selection = new VerticalRulerSelection();
            this.addMouseListener(selection);
            this.addMouseMotionListener(selection);
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            return NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.verticalRuler.tooltip", (Object)this.getRowAtPoint(event.getPoint()));
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = TiledLayerEditorComponent.this.getPreferredSize();
            size.width = 14;
            return size;
        }

        @Override
        protected void paintComponent(Graphics graphincs) {
            int row;
            Graphics2D g = (Graphics2D)graphincs;
            Rectangle rect = g.getClipBounds();
            g.setColor(Color.WHITE);
            g.fill(rect);
            int unit = TiledLayerEditorComponent.this.gridWidth + TiledLayerEditorComponent.this.cellHeight;
            for (int y = rect.y / unit * unit; y <= rect.y + rect.height && (row = y / unit) < TiledLayerEditorComponent.this.tiledLayer.getRowCount(); y += unit) {
                boolean raised = true;
                g.setColor(new Color(240, 238, 230));
                if (this.pressed.contains(row)) {
                    g.setColor(new Color(200, 200, 200));
                    raised = false;
                }
                g.fill3DRect(0, y + TiledLayerEditorComponent.this.gridWidth / 2, 14, unit, raised);
                if (row != this.hilitedRowHeader) continue;
                g.setColor(HILITE_COLOR);
                g.fill3DRect(0, y + TiledLayerEditorComponent.this.gridWidth / 2, 14, unit, raised);
            }
        }

        protected void clearSelection() {
            if (!this.pressed.isEmpty()) {
                this.pressed.clear();
                this.repaint();
            }
        }

        private int getRowAtPoint(Point point) {
            return this.getRowAtCoordinates(point.x, point.y);
        }

        private int getRowAtCoordinates(int x, int y) {
            return (y - TiledLayerEditorComponent.this.gridWidth) / (TiledLayerEditorComponent.this.cellHeight + TiledLayerEditorComponent.this.gridWidth);
        }

        private Rectangle getRowHeaderArea(int row) {
            Rectangle area = new Rectangle(0, (TiledLayerEditorComponent.this.cellHeight + TiledLayerEditorComponent.this.gridWidth) * row + TiledLayerEditorComponent.this.gridWidth / 2, 14, TiledLayerEditorComponent.this.cellHeight + TiledLayerEditorComponent.this.gridWidth);
            return area;
        }

        private void hiliteRowHeader(int row) {
            if (this.hilitedRowHeader == row) {
                return;
            }
            int oldHilited = this.hilitedRowHeader;
            this.hilitedRowHeader = row;
            this.repaint(this.getRowHeaderArea(row));
            this.repaint(this.getRowHeaderArea(oldHilited));
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.hiliteRowHeader(-1);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int row = this.getRowAtPoint(e.getPoint());
            this.hiliteRowHeader(row);
        }

        protected void pressRowHeader(int row) {
            this.pressed.add(row);
            this.repaint(this.getRowHeaderArea(row));
        }

        protected void releaseRowHeader(int row) {
            this.pressed.remove(row);
            this.repaint(this.getRowHeaderArea(row));
        }

        private void handlePopUp(MouseEvent e) {
            int row = this.getRowAtPoint(e.getPoint());
            JPopupMenu menu = this.createRulerPopupMenu(row);
            menu.show(this, e.getX(), e.getY());
        }

        private JPopupMenu createRulerPopupMenu(int row) {
            JPopupMenu menu = new JPopupMenu();
            for (Action action : this.getActions()) {
                action.putValue("ROW", new Integer(row));
                menu.add(action);
            }
            return menu;
        }

        public List<Action> getActions() {
            ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
            actions.add(new DeleteSelectedRowsAction());
            actions.add(new PrependRowAction());
            actions.add(new AppendRowAction());
            return Collections.unmodifiableList(actions);
        }

        private class AppendRowAction
        extends AbstractAction {
            private AppendRowAction() {
                this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.verticalRuler.actionAppendRow.txt"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = (Integer)this.getValue("ROW");
                TiledLayerEditorComponent.this.tiledLayer.insertRows(row + 1, 1);
            }
        }

        private class PrependRowAction
        extends AbstractAction {
            private PrependRowAction() {
                this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.verticalRuler.actionPrependRow.txt"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = (Integer)this.getValue("ROW");
                TiledLayerEditorComponent.this.tiledLayer.insertRows(row, 1);
            }
        }

        private class DeleteRowAction
        extends AbstractAction {
            private DeleteRowAction() {
                this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.verticalRuler.actionDeleteRow.txt"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = (Integer)this.getValue("ROW");
                TiledLayerEditorComponent.this.setRowSelection(row, false);
                TiledLayerEditorComponent.this.tiledLayer.deleteRows(row, 1);
            }
        }

        private class DeleteSelectedRowsAction
        extends DeleteSelectedRowsColsAction {
            private DeleteSelectedRowsAction() {
                this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.verticalRuler.actionDeleteSelectedRows.txt"));
            }

            @Override
            protected boolean isSelected(int idx) {
                return TiledLayerEditorComponent.this.isRowSelected(idx);
            }

            @Override
            protected void setSelection(int idx, boolean selected) {
                TiledLayerEditorComponent.this.setRowSelection(idx, selected);
            }

            @Override
            protected int getCount() {
                return TiledLayerEditorComponent.this.tiledLayer.getRowCount();
            }

            @Override
            protected void delete(int idx, int count) {
                TiledLayerEditorComponent.this.tiledLayer.deleteRows(idx, count);
            }
        }

        private class VerticalRulerSelection
        extends AbstractRulerSelection {
            private VerticalRulerSelection() {
            }

            @Override
            protected int getItemAtPoint(Point point) {
                return RulerVertical.this.getRowAtPoint(point);
            }

            @Override
            protected void handlePopUp(MouseEvent e) {
                RulerVertical.this.handlePopUp(e);
            }

            @Override
            protected void setSelection(int idx, boolean select) {
                TiledLayerEditorComponent.this.setRowSelection(idx, select);
            }

            @Override
            protected boolean isSelected(int idx) {
                return TiledLayerEditorComponent.this.isRowSelected(idx);
            }
        }
    }

    private class GridButton
    extends JComponent
    implements MouseListener {
        private static final int BORDER = 2;

        public GridButton() {
            ToolTipManager.sharedInstance().registerComponent(this);
            this.addMouseListener(this);
        }

        @Override
        public String getToolTipText() {
            return NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.GridButton.tooltip");
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(new Color(230, 230, 255));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(Color.BLACK);
            int startx = 2;
            int starty = 2;
            int x = startx;
            int y = starty;
            int w = this.getWidth() - 4;
            int h = this.getHeight() - 4;
            if (TiledLayerEditorComponent.this.gridWidth > 0) {
                if (TiledLayerEditorComponent.this.gridMode == 0) {
                    g.setColor(Color.GRAY);
                }
                int offX = w / 2;
                int offY = h / 2;
                g.drawLine(x += offX, starty, x, starty + h);
                g.drawLine(startx, y += offY, startx + w, y);
            }
            g.setColor(Color.BLACK);
            g.drawRoundRect(startx, starty, w, h, 2, 2);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            byte mode = TiledLayerEditorComponent.this.gridMode;
            if (mode == 1) {
                if (TiledLayerEditorComponent.this.gridWidth == 0) {
                    TiledLayerEditorComponent.this.setGridMode((byte)0);
                } else {
                    TiledLayerEditorComponent.this.gridWidth = 0;
                }
            } else {
                TiledLayerEditorComponent.this.setGridMode((byte)1);
                TiledLayerEditorComponent.this.gridWidth = 1;
            }
            this.repaint();
            TiledLayerEditorComponent.this.rulerHorizontal.repaint();
            TiledLayerEditorComponent.this.rulerVertical.repaint();
            TiledLayerEditorComponent.this.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private class TiledLayerDropTargetListener
    implements DropTargetListener {
        private TiledLayerDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            TiledLayerEditorComponent.this.updateHiLite(dtde.getLocation());
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Point dropPoint = dtde.getLocation();
            Transferable transferable = dtde.getTransferable();
            try {
                TileDataFlavor tileFlavor = new TileDataFlavor();
                if (transferable.isDataFlavorSupported(tileFlavor)) {
                    dtde.acceptDrop(1);
                    List tiles = (List)transferable.getTransferData(tileFlavor);
                    assert (tiles.size() > 0);
                    ImageResource imgRes = TiledLayerEditorComponent.this.tiledLayer.getImageResource();
                    Tile newTile = imgRes.getTile(((Tile)tiles.get(0)).getIndex(), TiledLayerEditorComponent.this.tiledLayer.getTileWidth(), TiledLayerEditorComponent.this.tiledLayer.getTileHeight(), false);
                    Position cell = TiledLayerEditorComponent.this.getCellAtPoint(dropPoint);
                    if (TiledLayerEditorComponent.this.cellsSelected.contains(cell)) {
                        TiledLayerEditorComponent.this.tiledLayer.setTileAtPositions(newTile.getIndex(), TiledLayerEditorComponent.this.cellsSelected);
                    } else {
                        TiledLayerEditorComponent.this.tiledLayer.setTileAt(newTile.getIndex(), cell.getRow(), cell.getCol());
                    }
                    dtde.dropComplete(true);
                } else {
                    dtde.dropComplete(false);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                dtde.dropComplete(false);
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
                dtde.dropComplete(false);
            }
            catch (IOException e) {
                e.printStackTrace();
                dtde.dropComplete(false);
            }
        }
    }

    private class HiliteAnimator
    extends TimerTask {
        private Color[] colors = new Color[]{new Color(150, 150, 150), new Color(125, 125, 125), new Color(100, 100, 100), new Color(75, 75, 75), new Color(50, 50, 50), new Color(75, 75, 75), new Color(100, 100, 100), new Color(125, 125, 125), new Color(150, 150, 150)};
        private int i = 0;

        private HiliteAnimator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Set set = TiledLayerEditorComponent.this.cellsSelected;
            synchronized (set) {
                if (++this.i >= this.colors.length) {
                    this.i = 0;
                }
                TiledLayerEditorComponent.this.currentSelectedColor = this.colors[this.i];
                int[] bounds = TiledLayerEditorComponent.this.getVisibleCellBounds();
                for (int r = bounds[0]; r <= bounds[2]; ++r) {
                    for (int c = bounds[1]; c <= bounds[3]; ++c) {
                        Position cell = new Position(r, c);
                        if (!TiledLayerEditorComponent.this.cellsSelected.contains(cell)) continue;
                        Rectangle rect = TiledLayerEditorComponent.this.getCellArea(cell);
                        TiledLayerEditorComponent.this.repaint(rect.x, rect.y, rect.width, 2);
                        TiledLayerEditorComponent.this.repaint(rect.x, rect.y, 2, rect.height - TiledLayerEditorComponent.this.gridWidth * 2);
                        TiledLayerEditorComponent.this.repaint(rect.x + (rect.width - 2), rect.y, 2, rect.height);
                        TiledLayerEditorComponent.this.repaint(rect.x, rect.y + (rect.height - 2), rect.width, 2);
                    }
                }
            }
        }
    }

    public class AppendColumnAction
    extends AbstractAction {
        public static final String PROP_POSITION = "PROP_POSITION";

        public AppendColumnAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionAppendCol.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Position p = (Position)this.getValue(PROP_POSITION);
            TiledLayerEditorComponent.this.tiledLayer.insertColumns(p.getCol() + 1, 1);
        }
    }

    public class PrependColumnAction
    extends AbstractAction {
        public static final String PROP_POSITION = "PROP_POSITION";

        public PrependColumnAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionPrependCol.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Position p = (Position)this.getValue(PROP_POSITION);
            TiledLayerEditorComponent.this.tiledLayer.insertColumns(p.getCol(), 1);
        }
    }

    public class AppendRowAction
    extends AbstractAction {
        public static final String PROP_POSITION = "PROP_POSITION";

        public AppendRowAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionAppendRow.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Position p = (Position)this.getValue(PROP_POSITION);
            TiledLayerEditorComponent.this.tiledLayer.insertRows(p.getRow() + 1, 1);
        }
    }

    public class PrependRowAction
    extends AbstractAction {
        public static final String PROP_POSITION = "PROP_POSITION";

        public PrependRowAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionPrependRow.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Position p = (Position)this.getValue(PROP_POSITION);
            TiledLayerEditorComponent.this.tiledLayer.insertRows(p.getRow(), 1);
        }
    }

    public class SelectAllAction
    extends AbstractAction {
        public SelectAllAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionSelectAll.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TiledLayerEditorComponent.this.selectAll();
        }
    }

    public class InvertSelectionAction
    extends AbstractAction {
        public InvertSelectionAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionInvertSelection.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TiledLayerEditorComponent.this.invertSelection();
        }
    }

    public class SelectByIndexAction
    extends AbstractAction {
        public static final String PROP_POSITION = "PROP_POSITION";

        public SelectByIndexAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionSelectIndex.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Position p = (Position)this.getValue(PROP_POSITION);
            TiledLayerEditorComponent.this.selectByIndex(TiledLayerEditorComponent.this.tiledLayer.getTileIndexAt(p));
        }
    }

    public class SelectRowAction
    extends AbstractAction {
        public static final String PROP_POSITION = "PROP_POSITION";

        public SelectRowAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionSelectRow.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Position p = (Position)this.getValue(PROP_POSITION);
            TiledLayerEditorComponent.this.setRowSelection(p.getRow(), true);
        }
    }

    public class SelectColumnAction
    extends AbstractAction {
        public static final String PROP_POSITION = "PROP_POSITION";

        public SelectColumnAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionSelectCol.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Position p = (Position)this.getValue(PROP_POSITION);
            TiledLayerEditorComponent.this.setColumnSelection(p.getCol(), true);
        }
    }

    public class DeleteRowAction
    extends AbstractAction {
        public static final String PROP_POSITION = "PROP_POSITION";

        public DeleteRowAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionDeleteRow.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Position p = (Position)this.getValue(PROP_POSITION);
            TiledLayerEditorComponent.this.tiledLayer.deleteRows(p.getRow(), 1);
        }
    }

    public class DeleteColumnAction
    extends AbstractAction {
        public static final String PROP_POSITION = "PROP_POSITION";

        public DeleteColumnAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionDeleteCol.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Position p = (Position)this.getValue(PROP_POSITION);
            TiledLayerEditorComponent.this.tiledLayer.deleteColumns(p.getCol(), 1);
        }
    }

    public class EraseSelectionAction
    extends AbstractAction {
        public EraseSelectionAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionEraseSelection.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TiledLayerEditorComponent.this.tiledLayer.setTileAtPositions(0, TiledLayerEditorComponent.this.cellsSelected);
        }
    }

    public class CreateFromSelectionAction
    extends AbstractAction {
        public CreateFromSelectionAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionNewFromSelection.txt"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            int[][] grid;
            int left = Integer.MAX_VALUE;
            int right = Integer.MIN_VALUE;
            int top = Integer.MAX_VALUE;
            int bottom = Integer.MIN_VALUE;
            Set set = TiledLayerEditorComponent.this.cellsSelected;
            synchronized (set) {
                if (TiledLayerEditorComponent.this.cellsSelected.size() < 2) {
                    return;
                }
                Set cells = TiledLayerEditorComponent.this.cellsSelected;
                for (Position position : cells) {
                    left = Math.min(left, position.getCol());
                    right = Math.max(right, position.getCol());
                    top = Math.min(top, position.getRow());
                    bottom = Math.max(bottom, position.getRow());
                }
                grid = new int[bottom - top + 1][right - left + 1];
                for (Position position : cells) {
                    grid[position.getRow() - top][position.getCol() - left] = TiledLayerEditorComponent.this.tiledLayer.getTileIndexAt(position);
                }
            }
            NewSimpleTiledLayerDialog dialog = new NewSimpleTiledLayerDialog(TiledLayerEditorComponent.this.tiledLayer.getImageResource(), grid, TiledLayerEditorComponent.this.tiledLayer.getTileWidth(), TiledLayerEditorComponent.this.tiledLayer.getTileHeight());
            DialogDescriptor dd = new DialogDescriptor((Object)dialog, NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionNewFromSelection.txt"));
            dd.setButtonListener((ActionListener)dialog);
            dd.setValid(false);
            dialog.setDialogDescriptor(dd);
            Dialog d = DialogDisplayer.getDefault().createDialog(dd);
            d.setVisible(true);
        }
    }

    public class TrimToSizeAction
    extends AbstractAction {
        public TrimToSizeAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionTrim.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TiledLayerEditorComponent.this.tiledLayer.trimToSize();
        }
    }

    public class DuplicateTiledLayerAction
    extends AbstractAction {
        public DuplicateTiledLayerAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionDuplicateTiledLayer.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DuplicateTiledLayerDialog dialog = new DuplicateTiledLayerDialog(TiledLayerEditorComponent.this.tiledLayer);
            DialogDescriptor dd = new DialogDescriptor((Object)dialog, NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionDuplicateTiledLayer.txt"));
            dd.setButtonListener((ActionListener)dialog);
            dd.setValid(false);
            dialog.setDialogDescriptor(dd);
            Dialog d = DialogDisplayer.getDefault().createDialog(dd);
            d.setVisible(true);
        }
    }

    private class EditModeListener
    implements ItemListener {
        private int mode;

        public EditModeListener(int mode) {
            this.mode = mode;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            TiledLayerEditorComponent.this.setEditMode(this.mode);
        }
    }

    private class PaintMotionListener
    extends MouseMotionAdapter {
        private PaintMotionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseDragged(MouseEvent e) {
            Point point = e.getPoint();
            Position cell = TiledLayerEditorComponent.this.getCellAtPoint(point);
            if (!TiledLayerEditorComponent.this.isAutoResizable()) {
                int colCount = TiledLayerEditorComponent.this.tiledLayer.getColumnCount();
                int rowCount = TiledLayerEditorComponent.this.tiledLayer.getRowCount();
                if (cell.getCol() < 0 || cell.getCol() >= colCount || cell.getRow() < 0 || cell.getRow() >= rowCount) {
                    return;
                }
            }
            if (TiledLayerEditorComponent.this.isSelectMode()) {
                if (cell.equals(TiledLayerEditorComponent.this.lastDraggedCell)) {
                    return;
                }
                Set colCount = TiledLayerEditorComponent.this.cellsSelected;
                synchronized (colCount) {
                    TiledLayerEditorComponent.this.cellsSelected.add(cell);
                }
            } else if (TiledLayerEditorComponent.this.isPaintMode()) {
                int tileIndex = TiledLayerEditorComponent.this.paintTileIndex;
                int oldTileIndex = TiledLayerEditorComponent.this.tiledLayer.getTileAt(cell.getRow(), cell.getCol()).getIndex();
                if (cell.equals(TiledLayerEditorComponent.this.lastDraggedCell) && tileIndex == oldTileIndex) {
                    return;
                }
                if (TiledLayerEditorComponent.this.lastDraggedCell != null) {
                    TiledLayerEditorComponent.this.repaint(TiledLayerEditorComponent.this.getCellArea(TiledLayerEditorComponent.this.lastDraggedCell));
                }
                TiledLayerEditorComponent.this.cellHiLited = cell;
                TiledLayerEditorComponent.this.tiledLayer.setTileAt(tileIndex, cell.getRow(), cell.getCol());
            }
            TiledLayerEditorComponent.this.repaint(TiledLayerEditorComponent.this.getCellArea(cell));
            TiledLayerEditorComponent.this.lastDraggedCell = cell;
            Rectangle r = new Rectangle(e.getX(), e.getY(), 1, 1);
            TiledLayerEditorComponent.this.scrollRectToVisible(r);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            TiledLayerEditorComponent.this.updateHiLite(e.getPoint());
        }
    }
}

