/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.model;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.vmd.game.dialog.NewSequenceDialog;
import org.netbeans.modules.vmd.game.editor.sequece.SequenceContainerEditor;
import org.netbeans.modules.vmd.game.model.Editable;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.Sequence;
import org.netbeans.modules.vmd.game.model.SequenceContainerListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public interface SequenceContainer
extends Editable {
    public static final String PROPERTY_DEFAULT_SEQUENCE = "sequencecontainer.prop.defaultsequence";

    @Override
    public void addPropertyChangeListener(PropertyChangeListener var1);

    @Override
    public void removePropertyChangeListener(PropertyChangeListener var1);

    public void addSequenceContainerListener(SequenceContainerListener var1);

    public void removeSequenceContainerListener(SequenceContainerListener var1);

    public boolean append(Sequence var1);

    public boolean insert(Sequence var1, int var2);

    public boolean remove(Sequence var1);

    public void move(Sequence var1, int var2);

    public Sequence createSequence(String var1, Sequence var2);

    public Sequence createSequence(String var1, int var2, int var3, int var4);

    public Sequence getDefaultSequence();

    public Sequence getSequenceAt(int var1);

    public Sequence getSequenceByName(String var1);

    public int getSequenceCount();

    public List<Sequence> getSequences();

    public void setDefaultSequence(Sequence var1);

    @Override
    public String getName();

    public int indexOf(Sequence var1);

    public List<Action> getActionsForSequence(Sequence var1);

    public String getNextSequenceName(String var1);

    public GlobalRepository getGameDesign();

    public static class SequenceContainerImpl
    implements SequenceContainer {
        public static final boolean DEBUG = false;
        EventListenerList listenerList;
        PropertyChangeSupport propertyChangeSupport;
        private List<Sequence> sequences;
        private Sequence defaultSequence;
        private SequenceContainer aggregator;
        private ImageResource imageResource;
        private SequenceContainerEditor editor;
        private int frameWidth;
        private int frameHeight;
        boolean zeroBasedIndex;

        public SequenceContainerImpl(SequenceContainer aggregator, EventListenerList ll, PropertyChangeSupport pcs, ImageResource imageResource, int frameWidth, int frameHeight, boolean zeroBasedIndex) {
            this.aggregator = aggregator;
            this.listenerList = ll == null ? new EventListenerList() : ll;
            this.propertyChangeSupport = pcs == null ? new PropertyChangeSupport(aggregator) : pcs;
            this.sequences = new ArrayList<Sequence>();
            this.imageResource = imageResource;
            this.frameWidth = frameWidth;
            this.frameHeight = frameHeight;
            this.zeroBasedIndex = zeroBasedIndex;
        }

        @Override
        public GlobalRepository getGameDesign() {
            return this.imageResource.getGameDesign();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.propertyChangeSupport.addPropertyChangeListener(l);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.propertyChangeSupport.removePropertyChangeListener(l);
        }

        @Override
        public void addSequenceContainerListener(SequenceContainerListener listener) {
            this.listenerList.add(SequenceContainerListener.class, listener);
        }

        @Override
        public void removeSequenceContainerListener(SequenceContainerListener listener) {
            this.listenerList.remove(SequenceContainerListener.class, listener);
        }

        protected void fireSequenceAdded(Sequence sequence, int index) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != SequenceContainerListener.class) continue;
                ((SequenceContainerListener)listeners[i + 1]).sequenceAdded(this.aggregator, sequence, index);
            }
        }

        protected void fireSequenceMoved(Sequence sequence, int oldIndex, int newIndex) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != SequenceContainerListener.class) continue;
                ((SequenceContainerListener)listeners[i + 1]).sequenceMoved(this.aggregator, sequence, oldIndex, newIndex);
            }
        }

        protected void fireSequenceRemoved(Sequence sequence, int index) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != SequenceContainerListener.class) continue;
                ((SequenceContainerListener)listeners[i + 1]).sequenceRemoved(this.aggregator, sequence, index);
            }
        }

        @Override
        public Sequence createSequence(String name, int numberFrames, int frameWidth, int frameHeight) {
            Sequence sequence = this.imageResource.createSequence(name, numberFrames, frameWidth, frameHeight, this.zeroBasedIndex);
            this.append(sequence);
            return sequence;
        }

        @Override
        public Sequence createSequence(String name, Sequence sequence) {
            Sequence newSequence = this.imageResource.createSequence(name, sequence);
            this.append(newSequence);
            return newSequence;
        }

        @Override
        public String getNextSequenceName(String prefix) {
            String nextName;
            int biggestNum = 0;
            for (Sequence at : this.getSequences()) {
                String name = at.getName();
                if (!name.startsWith(prefix)) continue;
                try {
                    int num = Integer.parseInt(name.substring(prefix.length()));
                    if (num <= biggestNum) continue;
                    biggestNum = num;
                }
                catch (NumberFormatException nfe) {}
            }
            DecimalFormat df = new DecimalFormat("000");
            do {
                nextName = prefix + df.format(++biggestNum);
            } while (!this.getGameDesign().isComponentNameAvailable(nextName));
            return nextName;
        }

        @Override
        public boolean append(Sequence sequence) {
            if (this.sequences.contains(sequence) && !this.remove(sequence)) {
                return false;
            }
            this.sequences.add(sequence);
            int index = this.sequences.indexOf(sequence);
            this.fireSequenceAdded(sequence, index);
            return true;
        }

        @Override
        public boolean insert(Sequence sequence, int index) {
            if (this.sequences.contains(sequence) && !this.remove(sequence)) {
                return false;
            }
            this.sequences.add(index, sequence);
            this.fireSequenceAdded(sequence, index);
            return true;
        }

        @Override
        public boolean remove(Sequence sequence) {
            if (this.getDefaultSequence() == sequence) {
                return false;
            }
            int index = this.sequences.indexOf(sequence);
            if (this.sequences.remove(sequence)) {
                this.fireSequenceRemoved(sequence, index);
            }
            return true;
        }

        @Override
        public void move(Sequence sequence, int newIndex) {
            int oldIndex = this.sequences.indexOf(sequence);
            if (oldIndex == -1) {
                return;
            }
            this.sequences.remove(sequence);
            this.sequences.add(newIndex, sequence);
            this.fireSequenceMoved(sequence, oldIndex, newIndex);
        }

        @Override
        public Sequence getSequenceByName(String name) {
            Sequence seq = null;
            for (Sequence tmp : this.sequences) {
                if (!tmp.getName().equals(name)) continue;
                seq = tmp;
                break;
            }
            return seq;
        }

        @Override
        public void setDefaultSequence(Sequence defaultSequence) {
            Sequence oldDef = this.defaultSequence;
            if (!this.sequences.contains(defaultSequence)) {
                this.append(defaultSequence);
            }
            this.defaultSequence = defaultSequence;
            this.propertyChangeSupport.firePropertyChange(SequenceContainer.PROPERTY_DEFAULT_SEQUENCE, oldDef, defaultSequence);
        }

        @Override
        public Sequence getDefaultSequence() {
            return this.defaultSequence;
        }

        @Override
        public int indexOf(Sequence sequence) {
            return this.sequences.indexOf(sequence);
        }

        @Override
        public Sequence getSequenceAt(int index) {
            return this.sequences.get(index);
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException("Must be overriden by aggregating class.");
        }

        @Override
        public List<Sequence> getSequences() {
            return Collections.unmodifiableList(this.sequences);
        }

        @Override
        public int getSequenceCount() {
            return this.sequences.size();
        }

        @Override
        public JComponent getEditor() {
            return this.editor == null ? (this.editor = new SequenceContainerEditor(this)) : this.editor;
        }

        @Override
        public Editable.ImageResourceInfo getImageResourceInfo() {
            return new Editable.ImageResourceInfo(this.imageResource, this.frameWidth, this.frameHeight, this.zeroBasedIndex);
        }

        @Override
        public JComponent getNavigator() {
            return null;
        }

        @Override
        public List<Action> getActions() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public List<Action> getActionsForSequence(Sequence sequence) {
            ArrayList<Action> commonActions = new ArrayList<Action>();
            CreateSequenceAction csa = new CreateSequenceAction();
            DuplicateSequenceAction dsa = new DuplicateSequenceAction(sequence);
            DefaultSequenceAction defsa = new DefaultSequenceAction(sequence);
            RemoveSequenceAction rsa = new RemoveSequenceAction(sequence);
            if (this.getDefaultSequence() == sequence) {
                rsa.setEnabled(false);
                defsa.setEnabled(false);
            }
            commonActions.add(csa);
            commonActions.add(dsa);
            commonActions.add(defsa);
            commonActions.add(rsa);
            commonActions.addAll(sequence.getActions());
            Iterator it = commonActions.iterator();
            while (it.hasNext()) {
                Action action = (Action)it.next();
                if (!(action instanceof Sequence.EditSequenceAction)) continue;
                it.remove();
            }
            return Collections.unmodifiableList(commonActions);
        }

        public class RemoveSequenceAction
        extends AbstractAction {
            private Sequence sequence;

            public RemoveSequenceAction(Sequence sequence) {
                this.sequence = sequence;
                this.putValue("Name", NbBundle.getMessage(SequenceContainer.class, (String)"SequenceContainer.RemoveSequenceAction.text"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceContainerImpl.this.remove(this.sequence);
            }
        }

        public class DefaultSequenceAction
        extends AbstractAction {
            private Sequence sequence;

            public DefaultSequenceAction(Sequence sequence) {
                this.sequence = sequence;
                this.putValue("Name", NbBundle.getMessage(SequenceContainer.class, (String)"SequenceContainer.DefaultSequenceAction.text"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceContainerImpl.this.setDefaultSequence(this.sequence);
            }
        }

        public class DuplicateSequenceAction
        extends AbstractAction {
            private Sequence sequence;

            public DuplicateSequenceAction(Sequence sequence) {
                this.sequence = sequence;
                this.putValue("Name", NbBundle.getMessage(SequenceContainer.class, (String)"SequenceContainer.DuplicateSequenceAction.text"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                NewSequenceDialog dialog = new NewSequenceDialog(SequenceContainerImpl.this, this.sequence);
                DialogDescriptor dd = new DialogDescriptor((Object)dialog, NbBundle.getMessage(SequenceContainer.class, (String)"SequenceContainer.DuplicateSequenceAction.text"));
                dd.setButtonListener((ActionListener)dialog);
                dd.setValid(false);
                dialog.setDialogDescriptor(dd);
                Dialog d = DialogDisplayer.getDefault().createDialog(dd);
                d.setVisible(true);
            }
        }

        public class CreateSequenceAction
        extends AbstractAction {
            public CreateSequenceAction() {
                this.putValue("Name", NbBundle.getMessage(SequenceContainer.class, (String)"SequenceContainer.CreateSequenceAction.text"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                NewSequenceDialog dialog = new NewSequenceDialog(SequenceContainerImpl.this, SequenceContainerImpl.this.frameWidth, SequenceContainerImpl.this.frameHeight);
                DialogDescriptor dd = new DialogDescriptor((Object)dialog, NbBundle.getMessage(SequenceContainer.class, (String)"SequenceContainer.CreateSequenceAction.text"));
                dd.setButtonListener((ActionListener)dialog);
                dd.setValid(false);
                dialog.setDialogDescriptor(dd);
                Dialog d = DialogDisplayer.getDefault().createDialog(dd);
                d.setVisible(true);
            }
        }
    }
}

