/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.model.adapter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.netbeans.modules.vmd.game.model.Editable;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.Identifiable;

public class GlobalRepositoryTableAdapter
extends DefaultTableModel {
    public static final int COL_INDEX_ICON = 0;
    public static final int COL_INDEX_NAME = 1;
    private GlobalRepository gameDesign;

    public GlobalRepositoryTableAdapter(GlobalRepository gameDesign) {
        this.gameDesign = gameDesign;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.gameDesign.getSprites().size() + this.gameDesign.getTiledLayers().size() + this.gameDesign.getScenes().size();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Editable.class;
        }
        if (columnIndex == 1) {
            return String.class;
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int row, int column) {
        List<Editable> l = this.getAll();
        if (row >= l.size() || column >= this.getColumnCount()) {
            return null;
        }
        if (column == 1) {
            return l.get(row).getName();
        }
        return l.get(row);
    }

    private List<Editable> getAll() {
        ArrayList<Identifiable> l = new ArrayList<Identifiable>();
        l.addAll(this.gameDesign.getSprites());
        l.addAll(this.gameDesign.getTiledLayers());
        l.addAll(this.gameDesign.getScenes());
        return Collections.unmodifiableList(l);
    }
}

