/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.nbdialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.vmd.game.dialog.PartialImageGridPreview;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class SelectImageForLayerDialog
extends JPanel
implements ActionListener {
    public static final boolean DEBUG = false;
    private static final Icon ICON_ERROR = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/vmd/midp/resources/error.gif", (boolean)false);
    private String path;
    private Collection<FileObject> images;
    private DialogDescriptor dd;
    private PartialImageGridPreview imagePreview = new PartialImageGridPreview();
    private FileObject imgFile;
    boolean cancelled = false;
    private ButtonGroup buttonGroupLayers;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JLabel labelError;
    private JLabel labelImageFile;
    private JLabel labelImagePreview;
    private JList listImageFileName;
    private JPanel panelCustomizer;
    private JPanel panelError;
    private JPanel panelImage;
    private JPanel panelPreview;
    private JTextArea textAreaReason;

    public SelectImageForLayerDialog(String missingImagePath, Collection<FileObject> images) {
        this.path = missingImagePath;
        this.images = images;
        this.initComponents();
        this.init();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == NotifyDescriptor.CANCEL_OPTION) {
            this.cancelled = true;
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    private void initComponents() {
        this.buttonGroupLayers = new ButtonGroup();
        this.panelCustomizer = new JPanel();
        this.labelImageFile = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.listImageFileName = new JList();
        this.panelPreview = new JPanel();
        this.labelImagePreview = new JLabel();
        this.panelImage = new JPanel();
        this.panelError = new JPanel();
        this.labelError = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jScrollPane2 = new JScrollPane();
        this.textAreaReason = new JTextArea();
        this.labelImageFile.setText(NbBundle.getMessage(SelectImageForLayerDialog.class, (String)"SelectImageForLayerDialog.labelSelectImg.txt"));
        this.listImageFileName.setModel(this.getImageListModel());
        this.listImageFileName.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.listImageFileName);
        GroupLayout panelCustomizerLayout = new GroupLayout((Container)this.panelCustomizer);
        this.panelCustomizer.setLayout((LayoutManager)panelCustomizerLayout);
        panelCustomizerLayout.setHorizontalGroup((GroupLayout.Group)panelCustomizerLayout.createParallelGroup(1).add((GroupLayout.Group)panelCustomizerLayout.createSequentialGroup().add((Component)this.labelImageFile).addContainerGap(224, Short.MAX_VALUE)).add((Component)this.jScrollPane1, -1, 305, Short.MAX_VALUE));
        panelCustomizerLayout.setVerticalGroup((GroupLayout.Group)panelCustomizerLayout.createParallelGroup(1).add((GroupLayout.Group)panelCustomizerLayout.createSequentialGroup().add((Component)this.labelImageFile).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 203, Short.MAX_VALUE)));
        this.labelImagePreview.setText(NbBundle.getMessage(SelectImageForLayerDialog.class, (String)"SelectImageForLayerDialog.labelImgPreview.txt"));
        this.panelImage.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.panelImage.add((Component)this.imagePreview, "Center");
        this.panelImage.setLayout(new BorderLayout());
        GroupLayout panelPreviewLayout = new GroupLayout((Container)this.panelPreview);
        this.panelPreview.setLayout((LayoutManager)panelPreviewLayout);
        panelPreviewLayout.setHorizontalGroup((GroupLayout.Group)panelPreviewLayout.createParallelGroup(1).add((GroupLayout.Group)panelPreviewLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)panelPreviewLayout.createParallelGroup(1).add((Component)this.panelImage, -1, 301, Short.MAX_VALUE).add((GroupLayout.Group)panelPreviewLayout.createSequentialGroup().add((Component)this.labelImagePreview).addContainerGap(207, Short.MAX_VALUE)))));
        panelPreviewLayout.setVerticalGroup((GroupLayout.Group)panelPreviewLayout.createParallelGroup(1).add((GroupLayout.Group)panelPreviewLayout.createSequentialGroup().add((Component)this.labelImagePreview).addPreferredGap(0).add((Component)this.panelImage, -1, 203, Short.MAX_VALUE)));
        this.labelError.setForeground(new Color(255, 0, 0));
        GroupLayout panelErrorLayout = new GroupLayout((Container)this.panelError);
        this.panelError.setLayout((LayoutManager)panelErrorLayout);
        panelErrorLayout.setHorizontalGroup((GroupLayout.Group)panelErrorLayout.createParallelGroup(1).add(2, (Component)this.labelError, -1, 624, Short.MAX_VALUE));
        panelErrorLayout.setVerticalGroup((GroupLayout.Group)panelErrorLayout.createParallelGroup(1).add((GroupLayout.Group)panelErrorLayout.createSequentialGroup().addContainerGap(40, Short.MAX_VALUE).add((Component)this.labelError, -2, 27, -2)));
        this.jScrollPane2.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.textAreaReason.setColumns(20);
        this.textAreaReason.setRows(3);
        this.textAreaReason.setTabSize(4);
        this.jScrollPane2.setViewportView(this.textAreaReason);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jSeparator1, -1, 624, Short.MAX_VALUE).add((Component)this.jScrollPane2, -1, 624, Short.MAX_VALUE).add(2, (Component)this.panelError, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.panelCustomizer, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.panelPreview, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane2, -2, -1, -2).addPreferredGap(0).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.panelPreview, -1, -1, Short.MAX_VALUE).add((Component)this.panelCustomizer, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.panelError, -2, -1, -2)));
    }

    public void setDialogDescriptor(DialogDescriptor dd) {
        this.dd = dd;
    }

    private void init() {
        HelpCtx.setHelpIDString((JComponent)this, (String)"org.netbeans.modules.vmd.game.nbdialog.SelectImageForLayerDialog");
        this.labelError.setText(NbBundle.getMessage(SelectImageForLayerDialog.class, (String)"SelectImageForLayerDialog.labelSelectImgDesc.txt"));
        this.textAreaReason.setBackground(this.getBackground());
        this.textAreaReason.setText(this.path);
        this.labelError.setIcon(ICON_ERROR);
        this.panelImage.add((Component)this.imagePreview, "Center");
        this.listImageFileName.addListSelectionListener(new ImageListListener());
        this.listImageFileName.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList src, Object value, int index, boolean isSelected, boolean hasfocus) {
                FileObject entry = (FileObject)value;
                return super.getListCellRendererComponent((JList<?>)src, FileUtil.getFileDisplayName((FileObject)entry), index, isSelected, hasfocus);
            }
        });
    }

    private List<FileObject> getImageList() {
        ArrayList<FileObject> list = new ArrayList<FileObject>();
        list.addAll(this.images);
        return list;
    }

    private DefaultListModel getImageListModel() {
        DefaultListModel<FileObject> dlm = new DefaultListModel<FileObject>();
        List<FileObject> images = this.getImageList();
        for (FileObject imageEntry : images) {
            dlm.addElement(imageEntry);
        }
        return dlm;
    }

    public void setOKButtonEnabled(boolean enable) {
        if (!enable) {
            this.labelError.setIcon(ICON_ERROR);
        } else {
            this.labelError.setIcon(null);
        }
        this.dd.setValid(enable);
    }

    private void loadImagePreview() throws MalformedURLException, IllegalArgumentException {
        FileObject entry = (FileObject)this.listImageFileName.getSelectedValue();
        URL imageURL = null;
        try {
            imageURL = entry.getURL();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        assert (imageURL != null);
        this.imagePreview.setImageURL(imageURL);
        this.repaint();
    }

    public FileObject getValue() {
        return this.imgFile;
    }

    private class ImageListListener
    implements ListSelectionListener {
        private ImageListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.handleImageSelectionChange();
        }

        private void handleImageSelectionChange() {
            try {
                SelectImageForLayerDialog.this.loadImagePreview();
                SelectImageForLayerDialog.this.labelError.setText(null);
                SelectImageForLayerDialog.this.setOKButtonEnabled(true);
                FileObject entry = (FileObject)SelectImageForLayerDialog.this.listImageFileName.getSelectedValue();
                SelectImageForLayerDialog.this.imgFile = entry;
            }
            catch (MalformedURLException e) {
                SelectImageForLayerDialog.this.setOKButtonEnabled(false);
                SelectImageForLayerDialog.this.labelError.setText(NbBundle.getMessage(SelectImageForLayerDialog.class, (String)"SelectImageForLayerDialog.labelInvalidImgLoc.txt"));
                e.printStackTrace();
            }
            catch (IllegalArgumentException iae) {
                SelectImageForLayerDialog.this.setOKButtonEnabled(false);
                SelectImageForLayerDialog.this.labelError.setText(NbBundle.getMessage(SelectImageForLayerDialog.class, (String)"SelectImageForLayerDialog.labelInvalidImgFomat.txt"));
                iae.printStackTrace();
            }
        }
    }
}

