/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.preview;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.vmd.game.model.Sequence;
import org.openide.util.NbBundle;

public class SequenceTimeSpinner
extends JSpinner {
    private static final int STEP = 10;
    private static final int MIN = 10;
    private Sequence sequence;

    public SequenceTimeSpinner(Sequence sequence) {
        this.sequence = sequence;
        this.sequence.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("sequence.prop.frames.ms")) {
                    SequenceTimeSpinner.this.setValue(SequenceTimeSpinner.this.sequence.getFrameMs());
                }
            }
        });
        SpinnerNumberModel model = new SpinnerNumberModel(this.sequence.getFrameMs(), 10, Integer.MAX_VALUE, 10);
        this.setModel(model);
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SpinnerModel model = SequenceTimeSpinner.this.getModel();
                if (model instanceof SpinnerNumberModel) {
                    int newMs = ((SpinnerNumberModel)model).getNumber().intValue();
                    SequenceTimeSpinner.this.sequence.setFrameMs(newMs);
                }
            }
        });
        this.setEditor(new SpinnerMSEditor(this));
    }

    public static class SpinnerMSEditor
    extends JTextField
    implements ChangeListener,
    ActionListener {
        private JSpinner spinner;

        public SpinnerMSEditor(JSpinner spinner) {
            this.spinner = spinner;
            this.spinner.addChangeListener(this);
            this.setToolTipText(NbBundle.getMessage(SequenceTimeSpinner.class, (String)"SequenceTimeSpinner.tooltip"));
            this.setText(((SpinnerNumberModel)this.spinner.getModel()).getValue() + " ms");
            this.setHorizontalAlignment(11);
            this.addActionListener(this);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.setText(((SpinnerNumberModel)this.spinner.getModel()).getValue() + " ms");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String str = this.getText();
            if (str.endsWith(" ms")) {
                str = str.substring(0, str.lastIndexOf(" ms"));
            }
            try {
                int ms = Integer.parseInt(str);
                if (ms < 10) {
                    this.setForeground(Color.RED);
                } else {
                    this.spinner.getModel().setValue(ms);
                    this.setForeground(Color.BLACK);
                }
            }
            catch (NumberFormatException nfe) {
                this.setForeground(Color.RED);
            }
        }
    }
}

