/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.view;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.Scene;
import org.netbeans.modules.vmd.game.model.Sprite;
import org.netbeans.modules.vmd.game.model.TiledLayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class GameDesignTreeNodeRenderer
implements TreeCellRenderer {
    private static ImageIcon imgGame = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/vmd/game/integration/res/gamer_16.png", (boolean)false);
    private static ImageIcon imgSprite = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/vmd/game/model/adapter/res/sprite.png", (boolean)false);
    private static ImageIcon imgTiled = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/vmd/game/model/adapter/res/tiled.png", (boolean)false);
    private static ImageIcon imgScene = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/vmd/game/model/adapter/res/scene.png", (boolean)false);

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof Scene) {
            return new SceneNodeRenderer().getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        if (value instanceof TiledLayer) {
            return new TiledLayerNodeRenderer().getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        if (value instanceof Sprite) {
            return new SpriteNodeRenderer().getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        if (value instanceof GlobalRepository) {
            return new GlobalRepositoryNodeRenderer().getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        return new DefaultTreeCellRenderer().getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
    }

    private class SpriteNodeRenderer
    extends DefaultTreeCellRenderer {
        private SpriteNodeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Sprite sprite = (Sprite)value;
            DefaultTreeCellRenderer r = (DefaultTreeCellRenderer)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            r.setText(sprite.getName());
            r.setIcon(imgSprite);
            r.setToolTipText(NbBundle.getMessage(GameDesignTreeNodeRenderer.class, (String)"GameDesignTreeNodeRenderer.SpriteNode.tooltip", (Object)sprite.getName()));
            return r;
        }
    }

    private class TiledLayerNodeRenderer
    extends DefaultTreeCellRenderer {
        private TiledLayerNodeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            TiledLayer tiledLayer = (TiledLayer)value;
            DefaultTreeCellRenderer r = (DefaultTreeCellRenderer)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            r.setText(tiledLayer.getName());
            r.setIcon(imgTiled);
            r.setToolTipText(NbBundle.getMessage(GameDesignTreeNodeRenderer.class, (String)"GameDesignTreeNodeRenderer.TiledLayerNode.tooltip", (Object)tiledLayer.getName()));
            return r;
        }
    }

    private class SceneNodeRenderer
    extends DefaultTreeCellRenderer {
        private SceneNodeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Scene scene = (Scene)value;
            DefaultTreeCellRenderer r = (DefaultTreeCellRenderer)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            r.setText(scene.getName());
            r.setIcon(imgScene);
            r.setToolTipText(NbBundle.getMessage(GameDesignTreeNodeRenderer.class, (String)"GameDesignTreeNodeRenderer.SceneNode.tooltip", (Object)scene.getName()));
            return r;
        }
    }

    private class GlobalRepositoryNodeRenderer
    extends DefaultTreeCellRenderer {
        private GlobalRepositoryNodeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            GlobalRepository gr = (GlobalRepository)value;
            DefaultTreeCellRenderer r = (DefaultTreeCellRenderer)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            r.setText(NbBundle.getMessage(GameDesignTreeNodeRenderer.class, (String)"GameDesignTreeNodeRenderer.GameDesignNode.name"));
            r.setIcon(imgGame);
            this.setToolTipText(NbBundle.getMessage(GameDesignTreeNodeRenderer.class, (String)"GameDesignTreeNodeRenderer.GameDesignNode.tooltip"));
            return r;
        }
    }
}

