/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import org.netbeans.modules.vmd.game.model.Previewable;

public class ImagePreviewComponent
extends JComponent {
    public static final boolean DEBUG = false;
    private boolean centeredH = true;
    private boolean centeredV = true;
    private Previewable previewable;

    public ImagePreviewComponent(boolean scaled, boolean centeredHor, boolean centeredVer) {
        this(scaled);
        this.centeredH = centeredHor;
        this.centeredV = centeredVer;
    }

    public ImagePreviewComponent(boolean scaled) {
        this.setDoubleBuffered(true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ImagePreviewComponent.this.repaint();
            }
        });
    }

    public void setPreviewable(Previewable previewable) {
        this.previewable = previewable;
        Dimension d = new Dimension(previewable.getWidth(), previewable.getHeight());
        this.setMinimumSize(d);
        this.setPreferredSize(d);
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int offX = 0;
        int offY = 0;
        if (this.previewable != null) {
            if (this.centeredH) {
                offX = (this.getWidth() - this.previewable.getWidth()) / 2;
            }
            if (this.centeredV) {
                offY = (this.getHeight() - this.previewable.getHeight()) / 2;
            }
            this.previewable.paint((Graphics2D)g, offX, offY);
        }
    }
}

