/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.utilities.trees;

import java.util.List;
import org.netbeans.modules.profiler.utilities.trees.NodeFilter;

public abstract class TreeDecimator<T> {
    public T decimate(T oldRoot, NodeFilter<T> filter) {
        return this.decimate(oldRoot, null, filter);
    }

    protected abstract List<T> getChildren(T var1);

    protected abstract void attachChildren(T var1, List<T> var2);

    protected abstract void detachChild(T var1, T var2);

    protected abstract void detachChildren(T var1);

    private T decimate(T oldRoot, T oldParent, NodeFilter<T> filter) {
        if (filter.match(oldRoot)) {
            if (oldParent != null) {
                this.detachChild(oldParent, oldRoot);
            }
            return oldRoot;
        }
        for (T node : this.getChildren(oldRoot)) {
            T found;
            if (!filter.maymatch(node) || (found = this.decimate(node, oldRoot, filter)) == null) continue;
            return found;
        }
        return null;
    }
}

