/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.spi.remote;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.Lookup;

public abstract class RemoteSyncFactory {
    public abstract RemoteSyncWorker createNew(ExecutionEnvironment var1, PrintWriter var2, PrintWriter var3, File var4, String var5, File ... var6);

    public abstract RemoteSyncWorker createNew(Project var1, PrintWriter var2, PrintWriter var3);

    public abstract boolean isApplicable(ExecutionEnvironment var1);

    public abstract String getDisplayName();

    public abstract String getDescription();

    public abstract String getID();

    public static RemoteSyncFactory fromID(String id) {
        assert (id != null);
        for (RemoteSyncFactory factory : RemoteSyncFactory.getFactories()) {
            if (!id.equals(factory.getID())) continue;
            return factory;
        }
        Logger log = Logger.getLogger("org.netbeans.modules.cnd.spi.remote");
        log.severe("No RemoteSyncFactory found by with ID " + id);
        return null;
    }

    public static RemoteSyncFactory[] getFactories() {
        Collection instances = Lookup.getDefault().lookupAll(RemoteSyncFactory.class);
        ArrayList result = new ArrayList(instances);
        String defaultId = System.getProperty("cnd.remote.default.sync");
        if (defaultId != null) {
            for (int i = 0; i < result.size(); ++i) {
                if (!defaultId.equals(((RemoteSyncFactory)result.get(i)).getID())) continue;
                if (i <= 0) break;
                RemoteSyncFactory oldFirst = (RemoteSyncFactory)result.get(0);
                result.set(0, result.get(i));
                result.set(i, oldFirst);
                break;
            }
        }
        return result.toArray(new RemoteSyncFactory[result.size()]);
    }

    public String toString() {
        return this.getDisplayName();
    }

    public static RemoteSyncFactory getDefault() {
        RemoteSyncFactory[] factories = RemoteSyncFactory.getFactories();
        assert (factories.length > 0);
        return factories[0];
    }

    public boolean isPathMappingCustomizable() {
        return false;
    }

    public abstract PathMap getPathMap(ExecutionEnvironment var1);
}

