/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.parsing.impl.indexing.CancelRequest;
import org.netbeans.modules.parsing.impl.indexing.Crawler;
import org.netbeans.modules.parsing.impl.indexing.FileObjectIndexable;
import org.netbeans.modules.parsing.impl.indexing.IndexableImpl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public final class FileObjectCrawler
extends Crawler {
    private static final Logger LOG = Logger.getLogger(FileObjectCrawler.class.getName());
    private static final boolean isUnix = Utilities.isUnix();
    private static final boolean isMac = Utilities.isMac();
    static Map<FileObject, LinkType> mockLinkTypes;
    private final FileObject root;
    private final ClassPath.Entry entry;
    private final FileObject[] files;

    public FileObjectCrawler(FileObject root, boolean checkTimeStamps, ClassPath.Entry entry, CancelRequest cancelRequest) throws IOException {
        super(root.getURL(), checkTimeStamps, true, true, cancelRequest);
        this.root = root;
        this.entry = entry;
        this.files = null;
    }

    public FileObjectCrawler(FileObject root, FileObject[] files, boolean checkTimeStamps, ClassPath.Entry entry, CancelRequest cancelRequest) throws IOException {
        super(root.getURL(), checkTimeStamps, false, FileObjectCrawler.supportsAllFiles(root, files), cancelRequest);
        this.root = root;
        this.entry = entry;
        this.files = files;
    }

    @Override
    protected boolean collectResources(Collection<IndexableImpl> resources, Collection<IndexableImpl> allResources) {
        Stats stats;
        boolean finished = true;
        long tm1 = System.currentTimeMillis();
        Stats stats2 = stats = LOG.isLoggable(Level.FINE) ? new Stats() : null;
        if (this.files != null) {
            StringBuilder relativePath;
            if (this.files.length > 1) {
                HashMap<FileObject, HashSet<FileObject>> clusters = new HashMap<FileObject, HashSet<FileObject>>();
                for (FileObject f : this.files) {
                    FileObject parent = f.getParent();
                    HashSet<FileObject> cluster = (HashSet<FileObject>)clusters.get(parent);
                    if (cluster == null) {
                        cluster = new HashSet<FileObject>();
                        clusters.put(parent, cluster);
                    }
                    cluster.add(f);
                }
                for (FileObject parent : clusters.keySet()) {
                    Set cluster = (Set)clusters.get(parent);
                    StringBuilder relativePath2 = this.getRelativePath(this.root, parent);
                    if (relativePath2 == null || (finished = this.collect(cluster.toArray(new FileObject[cluster.size()]), this.root, resources, allResources, stats, this.entry, null, relativePath2))) continue;
                    break;
                }
            } else if (this.files.length == 1 && (relativePath = this.getRelativePath(this.root, this.files[0].getParent())) != null) {
                finished = this.collect(this.files, this.root, resources, allResources, stats, this.entry, null, relativePath);
            }
        } else {
            finished = this.collect(this.root.getChildren(), this.root, resources, allResources, stats, this.entry, null, new StringBuilder());
        }
        long tm2 = System.currentTimeMillis();
        if (LOG.isLoggable(Level.FINE)) {
            String rootUrl;
            try {
                rootUrl = this.root.getURL().toString();
            }
            catch (FileStateInvalidException ex) {
                rootUrl = this.root.toString();
            }
            LOG.log(Level.FINE, String.format("Up-to-date check of %d files under %s took %d ms", stats.filesCount, rootUrl, tm2 - tm1));
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "File extensions histogram for {0}:", rootUrl);
                Stats.logHistogram(Level.FINER, stats.extensions);
                LOG.finer("----");
            }
            LOG.log(Level.FINE, "Symlink tests took {0}ms, {1} symlinks into root found.", new Object[]{stats.linkCheckTime, stats.linkCount});
        }
        return finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean collect(@NonNull FileObject[] fos, @NonNull FileObject root, @NonNull Collection<IndexableImpl> resources, @NonNull Collection<IndexableImpl> allResources, @NullAllowed Stats stats, @NullAllowed ClassPath.Entry entry, @NullAllowed LinkType parentLinkType, @NonNull StringBuilder relativePathBuilder) {
        int parentPathEnd = relativePathBuilder.length();
        for (FileObject fo : fos) {
            if (this.isCancelled()) {
                return false;
            }
            if (!fo.isValid() || !this.isVisible(fo)) continue;
            relativePathBuilder.append(fo.getNameExt());
            boolean folder = fo.isFolder();
            if (folder) {
                relativePathBuilder.append('/');
            }
            String relativePath = relativePathBuilder.toString();
            try {
                if (entry != null && !entry.includes(relativePath)) continue;
                if (folder) {
                    LinkType linkType = FileObjectCrawler.getLinkType(fo, root, parentLinkType, stats);
                    if (linkType == LinkType.IN || this.collect(fo.getChildren(), root, resources, allResources, stats, entry, linkType, relativePathBuilder)) continue;
                    boolean bl = false;
                    return bl;
                }
                if (stats != null) {
                    ++stats.filesCount;
                    Stats.inc(stats.extensions, fo.getExt());
                }
                FileObjectIndexable indexable = new FileObjectIndexable(root, relativePath);
                allResources.add(indexable);
                if (this.isUpToDate(fo, relativePath)) continue;
                resources.add(indexable);
            }
            finally {
                relativePathBuilder.delete(parentPathEnd, relativePathBuilder.length());
            }
        }
        return true;
    }

    private StringBuilder getRelativePath(FileObject folder, FileObject fo) {
        String rp = FileUtil.getRelativePath((FileObject)folder, (FileObject)fo);
        if (rp != null) {
            StringBuilder relativePath = new StringBuilder(rp);
            if (relativePath.length() > 0) {
                relativePath.append('/');
            }
            return relativePath;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isVisible(@NonNull FileObject fo) {
        try {
            boolean bl = VisibilityQuery.getDefault().isVisible(fo);
            return bl;
        }
        finally {
            FileObjectCrawler.setListenOnVisibility(true);
        }
    }

    private static boolean supportsAllFiles(FileObject root, FileObject ... files) {
        for (FileObject file : files) {
            if (root != file) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static LinkType getLinkType(@NonNull FileObject folder, @NonNull FileObject root, @NullAllowed LinkType parentLinkType, @NullAllowed Stats stats) {
        long st = System.currentTimeMillis();
        boolean inLink = false;
        try {
            boolean notLink;
            File canDirectory;
            if (parentLinkType == LinkType.OUT) {
                LinkType linkType = parentLinkType;
                return linkType;
            }
            if (mockLinkTypes != null) {
                LinkType linkType = mockLinkTypes.get(folder) != null ? mockLinkTypes.get(folder) : LinkType.NO;
                return linkType;
            }
            if (!isUnix && !isMac) {
                LinkType linkType = LinkType.NO;
                return linkType;
            }
            File directory = FileUtil.toFile((FileObject)folder);
            if (directory == null) {
                LinkType linkType = LinkType.NO;
                return linkType;
            }
            try {
                canDirectory = directory.getCanonicalFile();
            }
            catch (IOException ioe) {
                LinkType linkType = LinkType.NO;
                if (stats != null) {
                    if (inLink) {
                        ++stats.linkCount;
                    }
                    stats.linkCheckTime += System.currentTimeMillis() - st;
                }
                return linkType;
            }
            String dirPath = directory.getAbsolutePath();
            String canDirPath = canDirectory.getAbsolutePath();
            boolean bl = notLink = isMac ? dirPath.equalsIgnoreCase(canDirPath) : dirPath.equals(canDirPath);
            if (notLink) {
                LinkType linkType = LinkType.NO;
                return linkType;
            }
            File rootFile = FileUtil.toFile((FileObject)root);
            if (rootFile == null) {
                LinkType linkType = LinkType.OUT;
                return linkType;
            }
            if (FileObjectCrawler.isParentOf(rootFile, canDirectory)) {
                inLink = true;
                LinkType linkType = LinkType.IN;
                return linkType;
            }
            LinkType linkType = LinkType.OUT;
            return linkType;
        }
        finally {
            if (stats != null) {
                if (inLink) {
                    ++stats.linkCount;
                }
                stats.linkCheckTime += System.currentTimeMillis() - st;
            }
        }
    }

    private static boolean isParentOf(@NonNull File folder, @NonNull File file) {
        return file.getAbsolutePath().startsWith(folder.getAbsolutePath());
    }

    private static final class Stats {
        public int filesCount;
        public long linkCheckTime;
        public int linkCount;
        public Map<String, Integer> extensions = new HashMap<String, Integer>();
        public Map<String, Integer> mimeTypes = new HashMap<String, Integer>();
        private static final Comparator<Integer> REVERSE = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return -1 * o1.compareTo(o2);
            }
        };

        private Stats() {
        }

        public static void inc(Map<String, Integer> m, String k) {
            Integer i = m.get(k);
            if (i == null) {
                m.put(k, 1);
            } else {
                m.put(k, i + 1);
            }
        }

        public static void logHistogram(Level level, Map<String, Integer> data) {
            TreeMap<Integer, TreeSet<String>> sortedMap = new TreeMap<Integer, TreeSet<String>>(REVERSE);
            for (String item : data.keySet()) {
                Integer freq = data.get(item);
                TreeSet<String> items = (TreeSet<String>)sortedMap.get(freq);
                if (items == null) {
                    items = new TreeSet<String>();
                    sortedMap.put(freq, items);
                }
                items.add(item);
            }
            for (Integer freq : sortedMap.keySet()) {
                for (String item : (Set)sortedMap.get(freq)) {
                    LOG.log(level, "{0}: {1}", new Object[]{item, freq});
                }
            }
        }
    }

    static enum LinkType {
        NO,
        IN,
        OUT;

    }
}

