/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.swing.JComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class UtilityClass
extends AbstractHint
implements ElementVisitor<Boolean, CompilationInfo> {
    private boolean clazz;
    private volatile transient boolean stop;

    private UtilityClass(boolean b) {
        super(false, true, b ? AbstractHint.HintSeverity.WARNING : AbstractHint.HintSeverity.CURRENT_LINE_WARNING, new String[0]);
        this.clazz = b;
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(this.clazz ? Tree.Kind.CLASS : Tree.Kind.METHOD);
    }

    public static UtilityClass withoutConstructor() {
        return new UtilityClass(true);
    }

    public static UtilityClass withConstructor() {
        return new UtilityClass(false);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        this.stop = false;
        Element e = compilationInfo.getTrees().getElement(treePath);
        if (e == null) {
            return null;
        }
        if (this.clazz) {
            if (e.getKind() == ElementKind.ENUM) {
                return null;
            }
            if (e.getKind() == ElementKind.INTERFACE) {
                return null;
            }
            if (e.getKind() == ElementKind.ANNOTATION_TYPE) {
                return null;
            }
            if (e.getKind() == ElementKind.CLASS) {
                Name name;
                TypeMirror supr = ((TypeElement)e).getSuperclass();
                if (supr == null) {
                    return null;
                }
                Element superElem = compilationInfo.getTypes().asElement(supr);
                if (superElem instanceof TypeElement && (name = compilationInfo.getElements().getBinaryName((TypeElement)superElem)) != null && !name.contentEquals("java.lang.Object")) {
                    return null;
                }
            }
            int cnt = 0;
            for (Element element : e.getEnclosedElements()) {
                if (this.stop) {
                    return null;
                }
                if (element.accept(this, compilationInfo).booleanValue()) {
                    return null;
                }
                if (element.getKind() != ElementKind.METHOD && element.getKind() != ElementKind.FIELD) continue;
                ++cnt;
            }
            if (cnt == 0) {
                return null;
            }
        } else {
            if (e.getKind() != ElementKind.CONSTRUCTOR) {
                return null;
            }
            TypeElement jlThrowable = compilationInfo.getElements().getTypeElement("java.lang.Throwable");
            if (jlThrowable == null) {
                return null;
            }
            ExecutableElement x = (ExecutableElement)e;
            Element element = x.getEnclosingElement();
            Types t = compilationInfo.getTypes();
            if (t.isSubtype(t.erasure(element.asType()), t.erasure(jlThrowable.asType()))) {
                return null;
            }
            List<? extends Element> allElements = element.getEnclosedElements();
            ArrayList<Element> enclosedElements = new ArrayList<Element>(allElements.size());
            for (Element element2 : allElements) {
                if (element2.getKind() == ElementKind.CONSTRUCTOR) continue;
                enclosedElements.add(element2);
            }
            if (enclosedElements.isEmpty()) {
                return null;
            }
            for (Element element3 : enclosedElements) {
                if (this.stop) {
                    return null;
                }
                if (!element3.accept(this, compilationInfo).booleanValue()) continue;
                return null;
            }
            if (!x.getModifiers().contains((Object)Modifier.PROTECTED) && !x.getModifiers().contains((Object)Modifier.PUBLIC)) {
                return null;
            }
        }
        List<FixImpl> fixes = Collections.singletonList(new FixImpl(this.clazz, TreePathHandle.create((Element)e, (CompilationInfo)compilationInfo), compilationInfo.getFileObject()));
        int[] span = null;
        switch (treePath.getLeaf().getKind()) {
            case METHOD: {
                span = compilationInfo.getTreeUtilities().findNameSpan((MethodTree)treePath.getLeaf());
                break;
            }
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                span = compilationInfo.getTreeUtilities().findNameSpan((ClassTree)treePath.getLeaf());
                break;
            }
            case VARIABLE: {
                span = compilationInfo.getTreeUtilities().findNameSpan((VariableTree)treePath.getLeaf());
            }
        }
        if (span != null) {
            ErrorDescription errorDescription = ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)NbBundle.getMessage(UtilityClass.class, (String)(this.clazz ? "MSG_UtilityClass" : "MSG_PublicConstructor")), fixes, (FileObject)compilationInfo.getFileObject(), (int)span[0], (int)span[1]);
            return Collections.singletonList(errorDescription);
        }
        return null;
    }

    @Override
    public String getId() {
        return this.getClass().getName() + (this.clazz ? "_1" : "_2");
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(UtilityClass.class, (String)(this.clazz ? "MSG_UtilityClass" : "MSG_PublicConstructor"));
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(UtilityClass.class, (String)(this.clazz ? "HINT_UtilityClass" : "HINT_PublicConstructor"));
    }

    @Override
    public void cancel() {
    }

    public Preferences getPreferences() {
        return null;
    }

    @Override
    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    @Override
    public Boolean visit(Element arg0, CompilationInfo arg1) {
        return false;
    }

    @Override
    public Boolean visit(Element arg0) {
        return false;
    }

    @Override
    public Boolean visitPackage(PackageElement arg0, CompilationInfo arg1) {
        return false;
    }

    @Override
    public Boolean visitType(TypeElement arg0, CompilationInfo arg1) {
        return false;
    }

    @Override
    public Boolean visitVariable(VariableElement v, CompilationInfo arg1) {
        return !v.getModifiers().contains((Object)Modifier.STATIC);
    }

    @Override
    public Boolean visitExecutable(ExecutableElement m, CompilationInfo arg1) {
        if (this.clazz) {
            return !m.getModifiers().contains((Object)Modifier.STATIC) && !arg1.getElementUtilities().isSynthetic((Element)m);
        }
        boolean staticCtor = !m.getModifiers().contains((Object)Modifier.STATIC) && !m.getSimpleName().contentEquals("<init>");
        boolean main = m.getModifiers().contains((Object)Modifier.STATIC) && m.getSimpleName().contentEquals("main") && m.getReturnType().getKind() == TypeKind.VOID && m.getParameters().size() == 1 && ((Object)m.getParameters().get(0).asType()).toString().equals("java.lang.String[]");
        return staticCtor || main;
    }

    @Override
    public Boolean visitTypeParameter(TypeParameterElement arg0, CompilationInfo arg1) {
        return false;
    }

    @Override
    public Boolean visitUnknown(Element arg0, CompilationInfo arg1) {
        return false;
    }

    private static final class FixImpl
    implements Fix,
    Task<WorkingCopy> {
        private TreePathHandle handle;
        private FileObject file;
        private boolean clazz;

        public FixImpl(boolean clazz, TreePathHandle handle, FileObject file) {
            this.handle = handle;
            this.file = file;
            this.clazz = clazz;
        }

        public String getText() {
            return NbBundle.getMessage(UtilityClass.class, (String)(this.clazz ? "MSG_PrivateConstructor" : "MSG_MakePrivate"));
        }

        public ChangeInfo implement() throws IOException {
            ModificationResult result = JavaSource.forFileObject((FileObject)this.file).runModificationTask((Task)this);
            result.commit();
            return null;
        }

        public String toString() {
            return "FixUtilityClass";
        }

        public void run(WorkingCopy wc) throws Exception {
            wc.toPhase(JavaSource.Phase.RESOLVED);
            Element e = this.handle.resolveElement((CompilationInfo)wc);
            if (e == null) {
                return;
            }
            Tree outer = wc.getTrees().getTree(e);
            if (this.clazz) {
                if (outer == null || !TreeUtilities.CLASS_TREE_KINDS.contains((Object)outer.getKind())) {
                    return;
                }
                ClassTree cls = (ClassTree)outer;
                ModifiersTree modifiers = wc.getTreeMaker().Modifiers(Collections.singleton(Modifier.PRIVATE));
                MethodTree m = wc.getTreeMaker().Constructor(modifiers, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), wc.getTreeMaker().Block(Collections.emptyList(), false));
                wc.rewrite((Tree)cls, (Tree)wc.getTreeMaker().addClassMember(cls, (Tree)m));
            } else {
                if (outer == null || outer.getKind() != Tree.Kind.METHOD) {
                    return;
                }
                MethodTree met = (MethodTree)outer;
                ModifiersTree modifiers = wc.getTreeMaker().Modifiers(Collections.singleton(Modifier.PRIVATE), met.getModifiers().getAnnotations());
                wc.rewrite((Tree)met.getModifiers(), (Tree)modifiers);
            }
        }
    }
}

