/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.support.SelectionAwareJavaSourceTaskFactory;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.java.hints.infrastructure.CreatorBasedLazyFixList;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;
import org.netbeans.modules.java.hints.introduce.IntroduceHint;
import org.netbeans.modules.java.hints.introduce.IntroduceKind;
import org.netbeans.modules.java.hints.jackpot.impl.hints.HintsInvoker;
import org.netbeans.modules.java.hints.jackpot.impl.hints.HintsTask;
import org.netbeans.spi.editor.hints.Context;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.PositionRefresher;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JavaHintsPositionRefresher
implements PositionRefresher {
    private static final Logger LOG = Logger.getLogger(JavaHintsPositionRefresher.class.getName());

    public Map<String, List<ErrorDescription>> getErrorDescriptionsAt(final Context context, final Document doc) {
        final JavaSource js = JavaSource.forDocument((Document)doc);
        if (js == null) {
            LOG.log(Level.FINE, "No JavaSource associated to: {0}", new Object[]{doc, doc.getProperty("stream")});
            return Collections.emptyMap();
        }
        final HashMap<String, List<ErrorDescription>> eds = new HashMap<String, List<ErrorDescription>>();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    js.runUserActionTask((Task)new RefreshTask(eds, context, doc), true);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
        ProgressUtils.runOffEventDispatchThread((Runnable)r, (String)NbBundle.getMessage(JavaHintsPositionRefresher.class, (String)"Refresh_hints"), (AtomicBoolean)context.getCancel(), (boolean)false);
        return eds;
    }

    public static void hintsUpdated(Document doc, long version) {
        if (doc == null) {
            return;
        }
        JavaHintsPositionRefresher.getHolder(doc).hints = version;
    }

    public static void suggestionsUpdated(Document doc, long version, int caret) {
        if (doc == null) {
            return;
        }
        JavaHintsPositionRefresher.getHolder(doc).suggestions = version;
        JavaHintsPositionRefresher.getHolder(doc).suggestionsCaret = caret;
    }

    public static void introduceHintsUpdated(Document doc, long version, int selStart, int selEnd) {
        if (doc == null) {
            return;
        }
        JavaHintsPositionRefresher.getHolder(doc).introduce = version;
        JavaHintsPositionRefresher.getHolder(doc).introduceSelStart = selStart;
        JavaHintsPositionRefresher.getHolder(doc).introduceSelEnd = selEnd;
    }

    public static void errorsUpdated(Document doc, long version, List<ErrorDescription> errors) {
        if (doc == null) {
            return;
        }
        JavaHintsPositionRefresher.getHolder(doc).errors = version;
        JavaHintsPositionRefresher.getHolder(doc).errorsContent = errors;
    }

    private static LastUpdatedHolder getHolder(Document doc) {
        LastUpdatedHolder holder = (LastUpdatedHolder)doc.getProperty(LastUpdatedHolder.class);
        if (holder == null) {
            holder = new LastUpdatedHolder();
            doc.putProperty(LastUpdatedHolder.class, holder);
        }
        return holder;
    }

    private static final class LastUpdatedHolder {
        private long suggestions;
        private int suggestionsCaret;
        private long hints;
        private long errors;
        private long introduce;
        private long introduceSelStart;
        private long introduceSelEnd;
        private List<ErrorDescription> errorsContent;

        private LastUpdatedHolder() {
        }
    }

    private class RefreshTask
    implements Task<CompilationController> {
        private final Map<String, List<ErrorDescription>> eds;
        private final Context ctx;
        private final Document doc;

        public RefreshTask(Map<String, List<ErrorDescription>> eds, Context ctx, Document doc) {
            this.eds = eds;
            this.ctx = ctx;
            this.doc = doc;
        }

        public void run(CompilationController controller) throws Exception {
            controller.toPhase(JavaSource.Phase.RESOLVED);
            Document doc = controller.getDocument();
            if (doc == null) {
                return;
            }
            long version = DocumentUtilities.getDocumentVersion((Document)doc);
            int position = this.ctx.getPosition();
            if (this.ctx.isCanceled()) {
                return;
            }
            LastUpdatedHolder holder = JavaHintsPositionRefresher.getHolder(doc);
            if (version > 0L && holder.suggestions < version || holder.suggestionsCaret != position) {
                LOG.fine("Computing suggestions");
                this.eds.put(HintsTask.KEY_SUGGESTIONS, new HintsInvoker((CompilationInfo)controller, position, this.ctx.getCancel()).computeHints((CompilationInfo)controller));
            } else {
                LOG.fine("Suggestions already computed");
            }
            if (this.ctx.isCanceled()) {
                return;
            }
            if (version > 0L && holder.hints < version) {
                LOG.fine("Computing hints");
                int rowStart = Utilities.getRowStart((BaseDocument)((BaseDocument)doc), (int)position);
                int rowEnd = Utilities.getRowEnd((BaseDocument)((BaseDocument)doc), (int)position);
                this.eds.put(HintsTask.KEY_HINTS, new HintsInvoker((CompilationInfo)controller, rowStart, rowEnd, this.ctx.getCancel()).computeHints((CompilationInfo)controller));
            } else {
                LOG.fine("Hints already computed");
            }
            if (this.ctx.isCanceled()) {
                return;
            }
            int[] selection = SelectionAwareJavaSourceTaskFactory.getLastSelection((FileObject)controller.getFileObject());
            if (selection != null) {
                if (version > 0L && holder.introduce < version || holder.introduceSelStart != (long)selection[0] || holder.introduceSelEnd != (long)selection[1]) {
                    LOG.fine("Computing introduce hints");
                    this.eds.put(IntroduceHint.class.getName(), IntroduceHint.computeError((CompilationInfo)controller, selection[0], selection[1], new EnumMap<IntroduceKind, Fix>(IntroduceKind.class), new EnumMap<IntroduceKind, String>(IntroduceKind.class), this.ctx.getCancel()));
                } else {
                    LOG.fine("Introduce hints already computed");
                }
            } else {
                LOG.fine("No selection, not computing introduce hints");
            }
            if (this.ctx.isCanceled()) {
                return;
            }
            if (version > 0L && holder.errors < version) {
                LOG.fine("Computing errors");
                List<ErrorDescription> errors = new ErrorHintsProvider().computeErrors((CompilationInfo)controller, doc, position, "text/x-java");
                if (errors != null) {
                    for (ErrorDescription ed : errors) {
                        LazyFixList fixes = ed.getFixes();
                        if (!(fixes instanceof CreatorBasedLazyFixList)) continue;
                        ((CreatorBasedLazyFixList)ed.getFixes()).compute((CompilationInfo)controller, this.ctx.getCancel());
                    }
                    this.eds.put(ErrorHintsProvider.class.getName(), errors);
                }
            } else {
                LOG.fine("Errors already computed, computing fixes");
                for (ErrorDescription ed : holder.errorsContent) {
                    if (ed.getRange().getBegin().getOffset() > position || position > ed.getRange().getEnd().getOffset() || ed.getFixes().isComputed()) continue;
                    ((CreatorBasedLazyFixList)ed.getFixes()).compute((CompilationInfo)controller, this.ctx.getCancel());
                }
            }
        }
    }
}

