/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.lang.model.element.Modifier;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.modules.java.hints.introduce.ErrorLabel;
import org.netbeans.modules.java.hints.introduce.IntroduceFieldPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public class IntroduceMethodPanel
extends JPanel {
    public static final int INIT_METHOD = 1;
    public static final int INIT_FIELD = 2;
    public static final int INIT_CONSTRUCTORS = 4;
    private static final int ACCESS_PUBLIC = 1;
    private static final int ACCESS_PROTECTED = 2;
    private static final int ACCESS_DEFAULT = 3;
    private static final int ACCESS_PRIVATE = 4;
    private JButton btnOk;
    private JRadioButton accessDefault;
    private ButtonGroup accessGroup;
    private JRadioButton accessPrivate;
    private JRadioButton accessProtected;
    private JRadioButton accessPublic;
    private JCheckBox duplicates;
    private JLabel errorLabel;
    private ButtonGroup initilizeIn;
    private JLabel lblAccess;
    private JLabel lblName;
    private JTextField name;
    private String methodNameTest;
    private Set<Modifier> accessTest;
    private Boolean replaceOtherTest;

    public IntroduceMethodPanel(String name, int duplicatesCount) {
        this.initComponents();
        this.name.setText(name);
        if (name != null && name.trim().length() > 0) {
            this.name.setCaretPosition(name.length());
            this.name.setSelectionStart(0);
            this.name.setSelectionEnd(name.length());
        }
        Preferences pref = this.getPreferences();
        int accessModifier = pref.getInt("accessModifier", 4);
        switch (accessModifier) {
            case 1: {
                this.accessPublic.setSelected(true);
                break;
            }
            case 2: {
                this.accessProtected.setSelected(true);
                break;
            }
            case 3: {
                this.accessDefault.setSelected(true);
                break;
            }
            case 4: {
                this.accessPrivate.setSelected(true);
            }
        }
        if (duplicatesCount == 0) {
            this.duplicates.setEnabled(false);
            this.duplicates.setSelected(false);
        } else {
            this.duplicates.setEnabled(true);
            this.duplicates.setSelected(true);
            this.duplicates.setText(this.duplicates.getText() + " (" + duplicatesCount + ")");
        }
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(IntroduceFieldPanel.class).node("introduceField");
    }

    public void setOkButton(JButton btn) {
        this.btnOk = btn;
        this.btnOk.setEnabled(((ErrorLabel)this.errorLabel).isInputTextValid());
    }

    private JLabel createErrorLabel() {
        ErrorLabel.Validator validator = new ErrorLabel.Validator(){

            @Override
            public String validate(String text) {
                if (null == text || text.length() == 0) {
                    return "";
                }
                if (!Utilities.isJavaIdentifier((String)text)) {
                    return IntroduceMethodPanel.this.getDefaultErrorMessage(text);
                }
                return null;
            }
        };
        final ErrorLabel eLabel = new ErrorLabel(this.name.getDocument(), validator);
        eLabel.addPropertyChangeListener("isValid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                IntroduceMethodPanel.this.btnOk.setEnabled(eLabel.isInputTextValid());
            }
        });
        return eLabel;
    }

    String getDefaultErrorMessage(String inputText) {
        return "'" + inputText + "' is not a valid identifier";
    }

    private void initComponents() {
        this.initilizeIn = new ButtonGroup();
        this.accessGroup = new ButtonGroup();
        this.lblName = new JLabel();
        this.name = new JTextField();
        this.lblAccess = new JLabel();
        this.accessPublic = new JRadioButton();
        this.accessProtected = new JRadioButton();
        this.accessDefault = new JRadioButton();
        this.accessPrivate = new JRadioButton();
        this.errorLabel = this.createErrorLabel();
        this.duplicates = new JCheckBox();
        this.lblName.setLabelFor(this.name);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getBundle(IntroduceMethodPanel.class).getString("LBL_Name"));
        this.name.setColumns(20);
        this.lblAccess.setLabelFor(this.accessPublic);
        Mnemonics.setLocalizedText((JLabel)this.lblAccess, (String)NbBundle.getMessage(IntroduceMethodPanel.class, (String)"LBL_Access"));
        this.accessGroup.add(this.accessPublic);
        Mnemonics.setLocalizedText((AbstractButton)this.accessPublic, (String)NbBundle.getMessage(IntroduceMethodPanel.class, (String)"LBL_public"));
        this.accessPublic.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.accessPublic.setMargin(new Insets(0, 0, 0, 0));
        this.accessGroup.add(this.accessProtected);
        Mnemonics.setLocalizedText((AbstractButton)this.accessProtected, (String)NbBundle.getMessage(IntroduceMethodPanel.class, (String)"LBL_protected"));
        this.accessProtected.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.accessProtected.setMargin(new Insets(0, 0, 0, 0));
        this.accessGroup.add(this.accessDefault);
        Mnemonics.setLocalizedText((AbstractButton)this.accessDefault, (String)NbBundle.getMessage(IntroduceMethodPanel.class, (String)"LBL_Default"));
        this.accessDefault.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.accessDefault.setMargin(new Insets(0, 0, 0, 0));
        this.accessGroup.add(this.accessPrivate);
        this.accessPrivate.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.accessPrivate, (String)NbBundle.getMessage(IntroduceMethodPanel.class, (String)"LBL_private"));
        this.accessPrivate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.accessPrivate.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.duplicates, (String)NbBundle.getMessage(IntroduceMethodPanel.class, (String)"IntroduceMethodPanel.duplicates.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblAccess).addComponent(this.lblName)).addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.name, -1, 425, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.accessPublic).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.accessProtected).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.accessDefault).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.accessPrivate)))).addComponent(this.errorLabel, -1, 491, Short.MAX_VALUE).addComponent(this.duplicates)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.name, -2, -1, -2).addComponent(this.lblName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblAccess).addComponent(this.accessPublic).addComponent(this.accessProtected).addComponent(this.accessDefault).addComponent(this.accessPrivate)).addGap(18, 18, 18).addComponent(this.duplicates).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 96, Short.MAX_VALUE).addComponent(this.errorLabel).addContainerGap()));
        this.name.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AN_IntrMethod_Name"));
        this.name.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AD_IntrMethod_Name"));
        this.accessPublic.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AD_IntrMethod_Public"));
        this.accessProtected.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AD_IntrMethod_Protected"));
        this.accessDefault.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AD_IntrMethod_Default"));
        this.accessPrivate.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AD_IntrMethod_Private"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AD_IntrMethod_Dialog"));
    }

    public String getMethodName() {
        if (this.methodNameTest != null) {
            return this.methodNameTest;
        }
        return this.name.getText();
    }

    public Set<Modifier> getAccess() {
        Set<Modifier> set;
        int val;
        if (this.accessTest != null) {
            return this.accessTest;
        }
        if (this.accessPublic.isSelected()) {
            val = 1;
            set = EnumSet.of(Modifier.PUBLIC);
        } else if (this.accessProtected.isSelected()) {
            val = 2;
            set = EnumSet.of(Modifier.PROTECTED);
        } else if (this.accessDefault.isSelected()) {
            val = 3;
            set = Collections.emptySet();
        } else {
            val = 4;
            set = EnumSet.of(Modifier.PRIVATE);
        }
        this.getPreferences().putInt("accessModifier", val);
        return set;
    }

    public boolean getReplaceOther() {
        return this.replaceOtherTest != null ? this.replaceOtherTest.booleanValue() : this.duplicates.isSelected();
    }

    void setAccess(Set<Modifier> access) {
        this.accessTest = access;
    }

    void setMethodName(String methodName) {
        this.methodNameTest = methodName;
    }

    void setReplaceOther(boolean v) {
        this.replaceOtherTest = v;
    }
}

