/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.sampler;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.SwingWorker;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.core.ui.sampler.Sampler;
import org.netbeans.core.ui.sampler.SamplesOutputStream;
import org.netbeans.core.ui.sampler.SelfSampleVFS;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class SelfSamplerAction
extends AbstractAction
implements AWTEventListener {
    private static final String ACTION_NAME_START = NbBundle.getMessage(SelfSamplerAction.class, (String)"SelfSamplerAction_ActionNameStart");
    private static final String ACTION_NAME_STOP = NbBundle.getMessage(SelfSamplerAction.class, (String)"SelfSamplerAction_ActionNameStop");
    private static final String NOT_SUPPORTED = NbBundle.getMessage(SelfSamplerAction.class, (String)"SelfSamplerAction_NotSupported");
    private static final String SAVE_MSG = NbBundle.getMessage(SelfSamplerAction.class, (String)"SelfSamplerAction_SavedFile");
    private static final String DEBUG_ARG = "-Xdebug";
    private static final Logger LOGGER = Logger.getLogger(SelfSamplerAction.class.getName());
    private final AtomicReference<Sampler> RUNNING = new AtomicReference();
    private Boolean debugMode;
    private String lastReason;
    private static Class defaultDataObject;

    public SelfSamplerAction() {
        this.putValue("Name", ACTION_NAME_START);
        this.putValue("ShortDescription", ACTION_NAME_START);
        this.putValue("iconBase", "org/netbeans/core/ui/sampler/selfSampler.png");
        if (System.getProperty(SelfSamplerAction.class.getName() + ".sniff") != null) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (SamplesOutputStream.isSupported()) {
            Sampler c = new InternalSampler("Self Sampler");
            if (this.RUNNING.compareAndSet(null, c)) {
                this.putValue("Name", ACTION_NAME_STOP);
                this.putValue("ShortDescription", ACTION_NAME_STOP);
                this.putValue("iconBase", "org/netbeans/core/ui/sampler/selfSamplerRunning.png");
                c.run();
            } else {
                c = this.RUNNING.getAndSet(null);
                if (c != null) {
                    final Sampler controller = c;
                    this.setEnabled(false);
                    SwingWorker worker = new SwingWorker(){

                        protected Object doInBackground() throws Exception {
                            controller.actionPerformed(new ActionEvent(this, 0, "show"));
                            return null;
                        }

                        @Override
                        protected void done() {
                            SelfSamplerAction.this.putValue("Name", ACTION_NAME_START);
                            SelfSamplerAction.this.putValue("ShortDescription", ACTION_NAME_START);
                            SelfSamplerAction.this.putValue("iconBase", "org/netbeans/core/ui/sampler/selfSampler.png");
                            SelfSamplerAction.this.setEnabled(true);
                        }
                    };
                    worker.execute();
                }
            }
        } else {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NOT_SUPPORTED, 1);
        }
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        KeyEvent kevent = (KeyEvent)event;
        if (kevent.getID() == 402 && kevent.getKeyCode() == 65406) {
            this.actionPerformed(new ActionEvent(this, event.getID(), "shortcut"));
            kevent.consume();
        }
    }

    @Override
    public Object getValue(String key) {
        Object o = super.getValue(key);
        if (o == null && key.startsWith("logger-") && SamplesOutputStream.isSupported() && this.isRunMode()) {
            return new InternalSampler(key);
        }
        return o;
    }

    final boolean isProfileMe(Sampler c) {
        return c == this.RUNNING.get();
    }

    private synchronized boolean isDebugged() {
        if (this.debugMode == null) {
            this.debugMode = Boolean.FALSE;
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            List<String> args = runtime.getInputArguments();
            if (args.contains(DEBUG_ARG)) {
                this.debugMode = Boolean.TRUE;
            }
        }
        return this.debugMode;
    }

    private boolean isRunMode() {
        boolean runMode = true;
        String reason = null;
        if (this.isDebugged()) {
            reason = "running in debug mode";
            runMode = false;
        }
        if (runMode) {
            try {
                Class.forName("org.netbeans.lib.profiler.server.ProfilerServer", false, ClassLoader.getSystemClassLoader());
                reason = "running under profiler";
                runMode = false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (!runMode && reason != this.lastReason) {
            LOGGER.log(Level.INFO, "Slowness detector disabled - {0}", reason);
        }
        this.lastReason = reason;
        return runMode;
    }

    static {
        try {
            defaultDataObject = Class.forName("org.openide.loaders.DefaultDataObject");
        }
        catch (ClassNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static final class InternalSampler
    extends Sampler {
        private ProgressHandle progress;

        InternalSampler(String thread) {
            super(thread);
        }

        @Override
        protected void printStackTrace(Throwable ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }

        @Override
        protected void saveSnapshot(byte[] arr) throws IOException {
            File outFile = File.createTempFile("selfsampler", ".npss");
            outFile = FileUtil.normalizeFile((File)outFile);
            this.writeToFile(outFile, arr);
            File gestures = new File(new File(new File(new File(System.getProperty("netbeans.user")), "var"), "log"), "uigestures");
            SelfSampleVFS fs = gestures.exists() ? new SelfSampleVFS(new String[]{"selfsampler.npss", "selfsampler.log"}, new File[]{outFile, gestures}) : new SelfSampleVFS(new String[]{"selfsampler.npss"}, new File[]{outFile});
            FileObject fo = fs.findResource("selfsampler.npss");
            DataObject dobj = DataObject.find((FileObject)fo);
            if (defaultDataObject.isAssignableFrom(dobj.getClass())) {
                String msg = MessageFormat.format(SAVE_MSG, outFile.getAbsolutePath());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
            } else {
                ((OpenCookie)dobj.getCookie(OpenCookie.class)).open();
            }
        }

        private void writeToFile(File file, byte[] arr) {
            try {
                FileOutputStream fstream = new FileOutputStream(file);
                fstream.write(arr);
                fstream.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        @Override
        protected ThreadMXBean getThreadMXBean() {
            return ManagementFactory.getThreadMXBean();
        }

        @Override
        protected void openProgress(int steps) {
            if (EventQueue.isDispatchThread()) {
                return;
            }
            this.progress = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(SelfSamplerAction.class, (String)"Save_Progress"));
            this.progress.start(steps);
        }

        @Override
        protected void closeProgress() {
            if (EventQueue.isDispatchThread()) {
                return;
            }
            this.progress.finish();
            this.progress = null;
        }

        @Override
        protected void progress(int i) {
            if (EventQueue.isDispatchThread()) {
                return;
            }
            if (this.progress != null) {
                this.progress.progress(i);
            }
        }
    }
}

