/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.utils.APTSerializeUtils;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.cache.TinySingletonMap;
import org.openide.util.CharSequences;

public final class APTMacroMapSnapshot {
    private static final Map<CharSequence, APTMacro> NO_MACROS = Collections.unmodifiableMap(new HashMap(0));
    private Map<CharSequence, APTMacro> macros;
    final APTMacroMapSnapshot parent;
    public static final APTMacro UNDEFINED_MACRO = new UndefinedMacro();

    public APTMacroMapSnapshot(APTMacroMapSnapshot parent) {
        this.macros = this.createMacroMap(0);
        assert (parent == null || parent.parent == null || !parent.parent.isEmtpy()) : "how grand father could be empty " + parent;
        while (parent != null && parent.isEmtpy()) {
            parent = parent.parent;
        }
        this.parent = parent;
    }

    private Map<CharSequence, APTMacro> createMacroMap(int prefferedSize) {
        if (prefferedSize == 0) {
            return NO_MACROS;
        }
        if (prefferedSize == 1) {
            return new TinySingletonMap();
        }
        return new HashMap<CharSequence, APTMacro>(prefferedSize);
    }

    private void prepareMacroMapToAddMacro(CharSequence name) {
        TinySingletonMap lwMap;
        if (this.macros == NO_MACROS) {
            this.macros = this.createMacroMap(1);
        } else if (this.macros instanceof TinySingletonMap && (lwMap = (TinySingletonMap)this.macros).getKey() != null && !((CharSequence)lwMap.getKey()).equals(name)) {
            Map<CharSequence, APTMacro> map = this.createMacroMap(4);
            map.put((CharSequence)lwMap.getKey(), (APTMacro)lwMap.getValue());
            this.macros = map;
        }
    }

    final void putMacro(CharSequence name, APTMacro macro) {
        this.prepareMacroMapToAddMacro(name);
        this.macros.put(name, macro);
    }

    public final APTMacro getMacro(APTToken token) {
        return this.getMacro(token.getTextID());
    }

    final APTMacro getMacro(CharSequence key) {
        assert (CharSequences.isCompact((CharSequence)key)) : "string can't be here " + key;
        APTMacroMapSnapshot currentSnap = this;
        while (currentSnap != null) {
            APTMacro macro = currentSnap.macros.get(key);
            if (macro != null) {
                return macro;
            }
            currentSnap = currentSnap.parent;
        }
        return null;
    }

    public String toString() {
        Map<CharSequence, APTMacro> tmpMap = APTMacroMapSnapshot.addAllMacros(this, null);
        return APTUtils.macros2String(tmpMap);
    }

    public static Map<CharSequence, APTMacro> addAllMacros(APTMacroMapSnapshot snap, Map<CharSequence, APTMacro> out) {
        if (snap != null) {
            int i = 0;
            LinkedList<APTMacroMapSnapshot> stack = new LinkedList<APTMacroMapSnapshot>();
            while (snap != null) {
                i += snap.macros.size();
                stack.add(snap);
                snap = snap.parent;
            }
            if (out == null) {
                out = new HashMap<CharSequence, APTMacro>(i);
            }
            while (!stack.isEmpty()) {
                snap = (APTMacroMapSnapshot)stack.removeLast();
                for (Map.Entry<CharSequence, APTMacro> cur : snap.macros.entrySet()) {
                    if (cur.getValue() != UNDEFINED_MACRO) {
                        out.put(cur.getKey(), cur.getValue());
                        continue;
                    }
                    out.remove(cur.getKey());
                }
            }
        }
        if (out == null) {
            out = new HashMap<CharSequence, APTMacro>();
        }
        return out;
    }

    public static int getMacroSize(APTMacroMapSnapshot snap) {
        int size = 0;
        while (snap != null) {
            size += snap.macros.size();
            snap = snap.parent;
        }
        return size;
    }

    public boolean isEmtpy() {
        return this.macros.isEmpty();
    }

    public void write(RepositoryDataOutput output) throws IOException {
        APTSerializeUtils.writeSnapshot(this.parent, output);
        APTSerializeUtils.writeStringToMacroMap(this.macros, output);
    }

    public APTMacroMapSnapshot(RepositoryDataInput input) throws IOException {
        this.parent = APTSerializeUtils.readSnapshot(input);
        int collSize = input.readInt();
        this.macros = this.createMacroMap(collSize);
        APTSerializeUtils.readStringToMacroMap(collSize, this.macros, input);
    }

    private static final class UndefinedMacro
    implements APTMacro {
        private UndefinedMacro() {
        }

        public String toString() {
            return "Macro undefined";
        }

        @Override
        public CharSequence getFile() {
            return CharSequences.empty();
        }

        @Override
        public APTMacro.Kind getKind() {
            return APTMacro.Kind.USER_SPECIFIED;
        }

        @Override
        public boolean isFunctionLike() {
            throw new UnsupportedOperationException("Not supported in fake impl");
        }

        @Override
        public APTToken getName() {
            throw new UnsupportedOperationException("Not supported in fake impl");
        }

        @Override
        public Collection<APTToken> getParams() {
            throw new UnsupportedOperationException("Not supported in fake impl");
        }

        @Override
        public TokenStream getBody() {
            throw new UnsupportedOperationException("Not supported in fake impl");
        }

        @Override
        public APTDefine getDefineNode() {
            throw new UnsupportedOperationException("Not supported in fake impl.");
        }
    }
}

